/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.FilterSortSupport;
import org.graalvm.visualvm.lib.jfluid.results.ResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.StringCache;
import org.graalvm.visualvm.lib.jfluid.results.memory.JMethodIdTable;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeMemoryCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeObjAllocTermCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeObjLivenessTermCCTNode;

public class JdbcResultsSnapshot
extends ResultsSnapshot {
    private JMethodIdTable table;
    String[] selectNames;
    long[] invocationsPerSelectId;
    long[] timePerSelectId;
    int[] typeForSelectId;
    int[] commandTypeForSelectId;
    String[][] tablesForSelectId;
    private RuntimeMemoryCCTNode[] stacksForSelects;
    int nProfiledSelects;

    public JdbcResultsSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcResultsSnapshot(long beginTime, long timeTaken, JdbcCCTProvider provider, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken);
        provider.beginTrans(false);
        try {
            this.performInit(client, provider);
        }
        finally {
            provider.endTrans();
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.debugValues();
            }
        }
    }

    public String getSelectName(int selectId) {
        return this.selectNames[selectId];
    }

    public String[] getSelectNames() {
        return this.selectNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return this.table;
    }

    public int getNProfiledSelects() {
        return this.nProfiledSelects;
    }

    public long[] getInvocationsPerSelectId() {
        return this.invocationsPerSelectId;
    }

    public long[] getTimePerSelectId() {
        return this.timePerSelectId;
    }

    public int[] getTypeForSelectId() {
        return this.typeForSelectId;
    }

    public int[] getCommandTypeForSelectId() {
        return this.commandTypeForSelectId;
    }

    public String[][] getTablesForSelectId() {
        return this.tablesForSelectId;
    }

    public boolean containsStacks() {
        return this.stacksForSelects != null;
    }

    public void filterReverse(String filter, int filterType, int sortBy, boolean sortOrder, PresoObjAllocCCTNode root, int selectId, boolean dontShowZeroLiveObjAllocPaths) {
        PresoObjAllocCCTNode rev = this.createPresentationCCT(selectId, dontShowZeroLiveObjAllocPaths);
        this.filter(filter, filterType, rev);
        root.children = rev.children;
        if (root.children != null) {
            for (PresoObjAllocCCTNode ch : root.children) {
                ch.parent = root;
            }
            root.sortChildren(sortBy, sortOrder);
        }
        if (!FilterSortSupport.passesFilter(filter, filterType, root.getNodeName())) {
            // empty if block
        }
    }

    private void filter(String filter, int filterType, PresoObjAllocCCTNode node) {
        if (node.children != null) {
            PresoObjAllocCCTNode filtered = null;
            ArrayList<PresoObjAllocCCTNode> ch = new ArrayList<PresoObjAllocCCTNode>();
            for (PresoObjAllocCCTNode n : node.children) {
                PresoObjAllocCCTNode nn = n;
                if (FilterSortSupport.passesFilter(filter, filterType, nn.getNodeName())) {
                    int i = ch.indexOf(nn);
                    if (i == -1) {
                        ch.add(nn);
                        continue;
                    }
                    ((PresoObjAllocCCTNode)ch.get(i)).merge(nn);
                    continue;
                }
                if (filtered == null) {
                    filtered = nn;
                    ch.add(nn);
                    continue;
                }
                filtered.merge(nn);
            }
            if (ch.isEmpty()) {
                node.children = null;
            } else if (node.isFiltered() && filtered != null && ch.size() == 1) {
                PresoObjAllocCCTNode n = (PresoObjAllocCCTNode)ch.get(0);
                this.filter(filter, filterType, n);
                node.children = n.children;
            } else {
                node.children = ch.toArray(new PresoObjAllocCCTNode[0]);
            }
            if (node.children != null) {
                for (PresoObjAllocCCTNode n : node.children) {
                    this.filter(filter, filterType, n);
                }
            }
        }
    }

    public PresoObjAllocCCTNode createPresentationCCT(int selectId, boolean dontShowZeroLiveObjAllocPaths) {
        if (this.stacksForSelects == null) {
            return null;
        }
        RuntimeMemoryCCTNode rootNode = this.stacksForSelects[selectId];
        if (rootNode == null) {
            return null;
        }
        return this.createPresentationCCT(rootNode, selectId, dontShowZeroLiveObjAllocPaths);
    }

    public JdbcResultsSnapshot createDiff(JdbcResultsSnapshot snapshot) {
        if (!(snapshot instanceof JdbcResultsSnapshot)) {
            return null;
        }
        return new JdbcResultsDiff(this, snapshot);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        StringCache strings = new StringCache();
        this.nProfiledSelects = in.readInt();
        this.selectNames = new String[this.nProfiledSelects];
        this.invocationsPerSelectId = new long[this.nProfiledSelects];
        this.timePerSelectId = new long[this.nProfiledSelects];
        this.typeForSelectId = new int[this.nProfiledSelects];
        this.commandTypeForSelectId = new int[this.nProfiledSelects];
        this.tablesForSelectId = new String[this.nProfiledSelects][];
        for (int i = 1; i < this.nProfiledSelects; ++i) {
            this.selectNames[i] = in.readUTF();
            this.invocationsPerSelectId[i] = in.readLong();
            this.timePerSelectId[i] = in.readLong();
            this.typeForSelectId[i] = in.readInt();
            this.commandTypeForSelectId[i] = in.readInt();
            this.tablesForSelectId[i] = new String[in.readInt()];
            for (int j = 0; j < this.tablesForSelectId[i].length; ++j) {
                this.tablesForSelectId[i][j] = strings.intern(in.readUTF());
            }
        }
        if (in.readBoolean()) {
            int len = in.readInt();
            this.stacksForSelects = new RuntimeMemoryCCTNode[len];
            for (int i = 0; i < len; ++i) {
                int type = in.readInt();
                if (type == 0) continue;
                this.stacksForSelects[i] = RuntimeMemoryCCTNode.create(type);
                this.stacksForSelects[i].readFromStream(in);
            }
            if (in.readBoolean()) {
                this.table = new JMethodIdTable();
                this.table.readFromStream(in);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeInt(this.nProfiledSelects);
        for (int i = 1; i < this.nProfiledSelects; ++i) {
            out.writeUTF(this.selectNames[i]);
            out.writeLong(this.invocationsPerSelectId[i]);
            out.writeLong(this.timePerSelectId[i]);
            out.writeInt(this.typeForSelectId[i]);
            out.writeInt(this.commandTypeForSelectId[i]);
            out.writeInt(this.tablesForSelectId[i].length);
            String[] stringArray = this.tablesForSelectId[i];
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String item = stringArray[j];
                out.writeUTF(item);
            }
        }
        out.writeBoolean(this.stacksForSelects != null);
        if (this.stacksForSelects != null) {
            out.writeInt(this.stacksForSelects.length);
            for (RuntimeMemoryCCTNode stacksForSelect : this.stacksForSelects) {
                if (stacksForSelect == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(stacksForSelect.getType());
                stacksForSelect.writeToStream(out);
            }
            out.writeBoolean(this.table != null);
            if (this.table != null) {
                this.table.writeToStream(out);
            }
        }
    }

    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int selectId, boolean dontShowZeroLiveObjAllocPaths) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this.getJMethodIdTable(), rootNode, this.getSelectName(selectId));
    }

    protected void performInit(ProfilerClient client, JdbcCCTProvider provider) throws ClientUtils.TargetAppOrVMTerminated {
        FlatProfileContainer fpc = provider.createFlatProfile();
        if (fpc != null) {
            this.nProfiledSelects = fpc.getNRows() + 1;
            this.invocationsPerSelectId = new long[this.nProfiledSelects];
            this.timePerSelectId = new long[this.nProfiledSelects];
            this.typeForSelectId = new int[this.nProfiledSelects];
            this.commandTypeForSelectId = new int[this.nProfiledSelects];
            this.tablesForSelectId = new String[this.nProfiledSelects][];
            this.selectNames = new String[this.nProfiledSelects];
            for (int i = 0; i < fpc.getNRows(); ++i) {
                int selectId = fpc.getMethodIdAtRow(i);
                this.selectNames[selectId] = fpc.getMethodNameAtRow(i);
                this.invocationsPerSelectId[selectId] = fpc.getNInvocationsAtRow(i);
                this.timePerSelectId[selectId] = fpc.getTotalTimeInMcs0AtRow(i);
                this.typeForSelectId[selectId] = provider.getCommandType(selectId);
                this.commandTypeForSelectId[selectId] = provider.getSQLCommand(selectId);
                this.tablesForSelectId[selectId] = provider.getTables(selectId);
            }
            RuntimeMemoryCCTNode[] stacks = provider.getStacksForSelects();
            if (stacks != null && this.checkContainsStacks(stacks)) {
                this.stacksForSelects = new RuntimeMemoryCCTNode[stacks.length];
                PresoObjAllocCCTNode.getNamesForMethodIdsFromVM(client, stacks);
                for (int i = 0; i < this.nProfiledSelects; ++i) {
                    if (stacks[i] == null) continue;
                    this.stacksForSelects[i] = (RuntimeMemoryCCTNode)stacks[i].clone();
                    this.updateTime(this.stacksForSelects[i], this.timePerSelectId[i] / this.invocationsPerSelectId[i]);
                }
                this.table = new JMethodIdTable(client.getJMethodIdTable());
            }
        } else {
            this.selectNames = new String[0];
        }
    }

    private boolean checkContainsStacks(RuntimeMemoryCCTNode[] stacksForSelects) {
        for (RuntimeMemoryCCTNode stacksForSelect : stacksForSelects) {
            if (stacksForSelect == null || stacksForSelect instanceof RuntimeObjAllocTermCCTNode || stacksForSelect instanceof RuntimeObjLivenessTermCCTNode) continue;
            return true;
        }
        return false;
    }

    void debugValues() {
        LOGGER.finest("nProfiledSelects: " + this.nProfiledSelects);
        LOGGER.finest("stacksForSelects.length: " + this.debugLength(this.stacksForSelects));
        LOGGER.finest("invocationsPerSelectId.length: " + this.debugLength(this.invocationsPerSelectId));
        LOGGER.finest("timePerSelectId.length: " + this.debugLength(this.timePerSelectId));
        LOGGER.finest("typeForSelectId.length: " + this.debugLength(this.typeForSelectId));
        LOGGER.finest("commandTypeForSelectId.length: " + this.debugLength(this.commandTypeForSelectId));
        LOGGER.finest("tablesForSelectId.length: " + this.debugLength(this.tablesForSelectId));
        LOGGER.finest("selectNames.length: " + this.debugLength(this.selectNames));
        LOGGER.finest("table: " + (this.table == null ? "null" : this.table.debug()));
    }

    private void updateTime(RuntimeMemoryCCTNode stacksForSelect, long l) {
        Stack<Object> nodes = new Stack<Object>();
        nodes.add(stacksForSelect);
        while (!nodes.empty()) {
            RuntimeMemoryCCTNode[] ar;
            RuntimeMemoryCCTNode n = (RuntimeMemoryCCTNode)nodes.pop();
            if (n instanceof RuntimeObjAllocTermCCTNode) {
                RuntimeObjAllocTermCCTNode node = (RuntimeObjAllocTermCCTNode)n;
                node.totalObjSize = l * node.nCalls;
            }
            if (n.children == null) continue;
            if (n.children instanceof RuntimeMemoryCCTNode) {
                nodes.push(n.children);
                continue;
            }
            for (RuntimeMemoryCCTNode ar1 : ar = (RuntimeMemoryCCTNode[])n.children) {
                nodes.push(ar1);
            }
        }
    }
}

