/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.types;

import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.antlr.semantic.SemanticAnalysisException;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchDataType;
import org.opensearch.sql.legacy.antlr.visitor.Reducible;
import org.opensearch.sql.legacy.utils.StringUtils;

public interface Type
extends Reducible {
    @Override
    default public <T extends Reducible> T reduce(List<T> others) {
        List<Type> actualArgTypes = others;
        Type result = this.construct(actualArgTypes);
        if (result != OpenSearchDataType.TYPE_ERROR) {
            return (T)result;
        }
        String actualArgTypesStr = actualArgTypes.isEmpty() ? "<None>" : actualArgTypes.stream().map(Type::usage).collect(Collectors.joining(", "));
        throw new SemanticAnalysisException(StringUtils.format("%s cannot work with [%s]. Usage: %s", this, actualArgTypesStr, this.usage()));
    }

    public String getName();

    default public boolean isCompatible(Type other) {
        return other == OpenSearchDataType.UNKNOWN || this == other;
    }

    public Type construct(List<Type> var1);

    public String usage();
}

