/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    private Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    private boolean tabsOverlapBorder;
    private boolean tabsOpaque = true;
    private boolean contentOpaque = true;
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector<View> htmlViews;
    private Hashtable<Integer, Integer> mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    private TabContainer tabContainer;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int focusIndex;
    private Handler handler;
    private int rolloverTabIndex;
    private boolean isRunsDirty;
    private boolean calculatedBaseline;
    private int baseline;
    private static int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private static int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("navigateNext"));
        lazyActionMap.put(new Actions("navigatePrevious"));
        lazyActionMap.put(new Actions("navigateRight"));
        lazyActionMap.put(new Actions("navigateLeft"));
        lazyActionMap.put(new Actions("navigateUp"));
        lazyActionMap.put(new Actions("navigateDown"));
        lazyActionMap.put(new Actions("navigatePageUp"));
        lazyActionMap.put(new Actions("navigatePageDown"));
        lazyActionMap.put(new Actions("requestFocus"));
        lazyActionMap.put(new Actions("requestFocusForVisibleComponent"));
        lazyActionMap.put(new Actions("setSelectedIndex"));
        lazyActionMap.put(new Actions("selectTabWithFocus"));
        lazyActionMap.put(new Actions("scrollTabsForwardAction"));
        lazyActionMap.put(new Actions("scrollTabsBackwardAction"));
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        this.calculatedBaseline = false;
        this.rolloverTabIndex = -1;
        this.focusIndex = -1;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
        this.installTabContainer();
    }

    private void installTabContainer() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component component = this.tabPane.getTabComponentAt(i);
            if (component == null) continue;
            if (this.tabContainer == null) {
                this.tabContainer = new TabContainer();
            }
            this.tabContainer.add(component);
        }
        if (this.tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.add(this.tabContainer);
        } else {
            this.tabPane.add(this.tabContainer);
        }
    }

    protected JButton createScrollButton(int n) {
        if (n != 5 && n != 1 && n != 3 && n != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(n);
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (this.tabContainer == null) {
            return;
        }
        this.tabContainer.notifyTabbedPane = false;
        this.tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabContainer.remove(this.tabScroller.croppedEdge);
            this.tabScroller.tabPanel.remove(this.tabContainer);
        } else {
            this.tabPane.remove(this.tabContainer);
        }
        this.tabContainer = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        Object object = UIManager.get("TabbedPane.opaque");
        if (object == null) {
            object = Boolean.FALSE;
        }
        LookAndFeel.installProperty(this.tabPane, "opaque", object);
        if (this.tabInsets == null) {
            this.tabInsets = new Insets(0, 4, 1, 4);
        }
        if (this.selectedTabPadInsets == null) {
            this.selectedTabPadInsets = new Insets(2, 2, 2, 1);
        }
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(3, 2, 0, 2);
        }
        if (this.contentBorderInsets == null) {
            this.contentBorderInsets = new Insets(2, 2, 3, 3);
        }
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabPane.addMouseListener(this.mouseListener);
        }
        this.tabPane.addMouseMotionListener(this.getHandler());
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        this.tabPane.addContainerListener(this.getHandler());
        if (this.tabPane.getTabCount() > 0) {
            this.htmlViews = this.createHTMLVector();
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        this.tabPane.removeMouseMotionListener(this.getHandler());
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.tabPane.removeContainerListener(this.getHandler());
        if (this.htmlViews != null) {
            this.htmlViews.removeAllElements();
            this.htmlViews = null;
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.handler = null;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ChangeListener createChangeListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tabPane, BasicTabbedPaneUI.class, "TabbedPane.actionMap");
        this.updateMnemonics();
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.focusInputMap");
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, null);
        this.mnemonicToIndexMap = null;
        this.mnemonicInputMap = null;
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int i = this.tabPane.getTabCount() - 1; i >= 0; --i) {
            int n = this.tabPane.getMnemonicAt(i);
            if (n <= 0) continue;
            this.addMnemonic(i, n);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n, int n2) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, BasicLookAndFeel.getFocusAcceleratorKeyMask()), "setSelectedIndex");
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, SwingUtilities2.setAltGraphMask(BasicLookAndFeel.getFocusAcceleratorKeyMask())), "setSelectedIndex");
        this.mnemonicToIndexMap.put(n2, n);
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    private void setRolloverTab(int n, int n2) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, n, n2, false));
    }

    protected void setRolloverTab(int n) {
        this.rolloverTabIndex = n;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        int n3 = this.calculateBaselineIfNecessary();
        if (n3 != -1) {
            int n4 = this.tabPane.getTabPlacement();
            Insets insets = this.tabPane.getInsets();
            Insets insets2 = this.getTabAreaInsets(n4);
            switch (n4) {
                case 1: {
                    return n3 += insets.top + insets2.top;
                }
                case 3: {
                    n3 = n2 - insets.bottom - insets2.bottom - this.maxTabHeight + n3;
                    return n3;
                }
                case 2: 
                case 4: {
                    return n3 += insets.top + insets2.top;
                }
            }
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 2: 
            case 4: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    protected int getBaseline(int n) {
        if (this.tabPane.getTabComponentAt(n) != null) {
            int n2 = this.getBaselineOffset();
            if (n2 != 0) {
                return -1;
            }
            Component component = this.tabPane.getTabComponentAt(n);
            Dimension dimension = component.getPreferredSize();
            Insets insets = this.getTabInsets(this.tabPane.getTabPlacement(), n);
            int n3 = this.maxTabHeight - insets.top - insets.bottom;
            return component.getBaseline(dimension.width, dimension.height) + (n3 - dimension.height) / 2 + insets.top;
        }
        Object object = this.getTextViewForTab(n);
        if (object != null) {
            int n4 = (int)((View)object).getPreferredSpan(1);
            int n5 = BasicHTML.getHTMLBaseline((View)object, (int)((View)object).getPreferredSpan(0), n4);
            if (n5 >= 0) {
                return this.maxTabHeight / 2 - n4 / 2 + n5 + this.getBaselineOffset();
            }
            return -1;
        }
        object = this.getFontMetrics();
        int n6 = ((FontMetrics)object).getHeight();
        int n7 = ((FontMetrics)object).getAscent();
        return this.maxTabHeight / 2 - n6 / 2 + n7 + this.getBaselineOffset();
    }

    protected int getBaselineOffset() {
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                if (this.tabPane.getTabCount() > 1) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (this.tabPane.getTabCount() > 1) {
                    return -1;
                }
                return 1;
            }
        }
        return this.maxTabHeight % 2;
    }

    private int calculateBaselineIfNecessary() {
        if (!this.calculatedBaseline) {
            this.calculatedBaseline = true;
            this.baseline = -1;
            if (this.tabPane.getTabCount() > 0) {
                this.calculateBaseline();
            }
        }
        return this.baseline;
    }

    private void calculateBaseline() {
        int n = this.tabPane.getTabCount();
        int n2 = this.tabPane.getTabPlacement();
        this.maxTabHeight = this.calculateMaxTabHeight(n2);
        this.baseline = this.getBaseline(0);
        if (this.isHorizontalTabPlacement()) {
            for (int i = 1; i < n; ++i) {
                if (this.getBaseline(i) == this.baseline) continue;
                this.baseline = -1;
                break;
            }
        } else {
            FontMetrics fontMetrics = this.getFontMetrics();
            int n3 = fontMetrics.getHeight();
            int n4 = this.calculateTabHeight(n2, 0, n3);
            for (int i = 1; i < n; ++i) {
                int n5 = this.calculateTabHeight(n2, i, n3);
                if (n4 == n5) continue;
                this.baseline = -1;
                break;
            }
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(graphics, n2, n);
        }
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n2, n);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(graphics, n2, n);
        }
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int n4 = this.tabRuns[i];
            int n5 = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int n6 = n5 != 0 ? n5 - 1 : n3 - 1;
            for (int j = n4; j <= n6; ++j) {
                if (j == n2 || !this.rects[j].intersects(rectangle3)) continue;
                this.paintTab(graphics, n, this.rects, j, rectangle, rectangle2);
            }
        }
        if (n2 >= 0 && this.rects[n2].intersects(rectangle3)) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl2 = bl = n3 == n2;
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        }
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        String string = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.tabPane, graphics, font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        if (this.tabPane.getTabComponentAt(n2) == null) {
            String string2 = string;
            if (this.scrollableTabLayoutEnabled() && this.tabScroller.croppedEdge.isParamsSet() && this.tabScroller.croppedEdge.getTabIndex() == n2 && this.isHorizontalTabPlacement()) {
                int n4 = this.tabScroller.croppedEdge.getCropline() - (rectangle2.x - rectangle3.x) - this.tabScroller.croppedEdge.getCroppedSideWidth();
                string2 = SwingUtilities2.clipStringIfNecessary(null, fontMetrics, string, n4);
            } else if (!this.scrollableTabLayoutEnabled() && this.isHorizontalTabPlacement()) {
                string2 = SwingUtilities2.clipStringIfNecessary(null, fontMetrics, string, rectangle2.width);
            }
            this.paintText(graphics, n, font, fontMetrics, n2, string2, rectangle2, bl);
            this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    private boolean isHorizontalTabPlacement() {
        return this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3;
    }

    private static Polygon createCroppedTabShape(int n, Rectangle rectangle, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        switch (n) {
            case 2: 
            case 4: {
                n6 = rectangle.width;
                n5 = rectangle.x;
                n4 = rectangle.x + rectangle.width;
                n3 = rectangle.y + rectangle.height;
                break;
            }
            default: {
                n6 = rectangle.height;
                n5 = rectangle.y;
                n4 = rectangle.y + rectangle.height;
                n3 = rectangle.x + rectangle.width;
            }
        }
        int n7 = n6 / 12;
        if (n6 % 12 > 0) {
            ++n7;
        }
        int n8 = 2 + n7 * 8;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = 0;
        nArray[n9] = n3;
        nArray2[n9++] = n4;
        nArray[n9] = n3;
        nArray2[n9++] = n5;
        block3: for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < xCropLen.length; ++j) {
                nArray[n9] = n2 - xCropLen[j];
                nArray2[n9] = n5 + i * 12 + yCropLen[j];
                if (nArray2[n9] >= n4) {
                    nArray2[n9] = n4;
                    ++n9;
                    continue block3;
                }
                ++n9;
            }
        }
        if (n == 1 || n == 3) {
            return new Polygon(nArray, nArray2, n9);
        }
        return new Polygon(nArray2, nArray, n9);
    }

    private void paintCroppedTabEdge(Graphics graphics) {
        int n = this.tabScroller.croppedEdge.getTabIndex();
        int n2 = this.tabScroller.croppedEdge.getCropline();
        switch (this.tabPane.getTabPlacement()) {
            case 2: 
            case 4: {
                int n3 = this.rects[n].x;
                int n4 = n2;
                graphics.setColor(this.shadow);
                for (int i = n3; i <= n3 + this.rects[n].width; i += 12) {
                    for (int j = 0; j < xCropLen.length; j += 2) {
                        graphics.drawLine(i + yCropLen[j], n4 - xCropLen[j], i + yCropLen[j + 1] - 1, n4 - xCropLen[j + 1]);
                    }
                }
                break;
            }
            default: {
                int n5;
                int n6 = n2;
                graphics.setColor(this.shadow);
                for (int i = n5 = this.rects[n].y; i <= n5 + this.rects[n].height; i += 12) {
                    for (int j = 0; j < xCropLen.length; j += 2) {
                        graphics.drawLine(n6 - xCropLen[j], i + yCropLen[j], n6 - xCropLen[j + 1], i + yCropLen[j + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                Color color;
                Color color2 = this.tabPane.getForegroundAt(n2);
                if (bl && color2 instanceof UIResource && (color = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    color2 = color;
                }
                graphics.setColor(color2);
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        String string = bl ? "selectedLabelShift" : "labelShift";
        int n3 = DefaultLookup.getInt(this.tabPane, this, "TabbedPane." + string, 1);
        switch (n) {
            case 2: {
                return n3;
            }
            case 4: {
                return -n3;
            }
        }
        return rectangle.width % 2;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = bl ? DefaultLookup.getInt(this.tabPane, this, "TabbedPane.selectedLabelShift", -1) : DefaultLookup.getInt(this.tabPane, this, "TabbedPane.labelShift", 1);
        switch (n) {
            case 3: {
                return -n3;
            }
            case 2: 
            case 4: {
                return rectangle.height % 2;
            }
        }
        return n3;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(this.lightHighlight);
        switch (n) {
            case 2: {
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 1, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + 1, n4 + n6 - 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4 + n6 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                break;
            }
            default: {
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                graphics.drawLine(n3 + 2, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 1);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(!bl || this.selectedColor == null ? this.tabPane.getBackgroundAt(n2) : this.selectedColor);
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 3, n6 - 1);
                break;
            }
            default: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n);
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    n5 -= insets2.right;
                }
                n7 -= n5 - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                n7 += insets2.left;
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                n8 += insets2.top;
                break;
            }
            default: {
                n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    n6 -= insets2.bottom;
                }
                n8 -= n6 - insets.top;
            }
        }
        if (this.tabPane.getTabCount() > 0 && (this.contentOpaque || this.tabPane.isOpaque())) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            if (color != null) {
                graphics.setColor(color);
            } else if (this.selectedColor == null || n2 == -1) {
                graphics.setColor(this.tabPane.getBackground());
            } else {
                graphics.setColor(this.selectedColor);
            }
            graphics.fillRect(n5, n6, n7, n8);
        }
        this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
        } else {
            graphics.drawLine(n3, n4, rectangle.x - 1, n4);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 2);
        } else {
            graphics.drawLine(n3, n4, n3, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.drawLine(n3, rectangle.y + rectangle.height, n3, n4 + n6 - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.shadow);
        if (n != 3 || n2 < 0 || rectangle.y - 1 > n6 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + 1, n4 + n6 - 2, rectangle.x - 1, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
            if (rectangle.x + rectangle.width < n3 + n5 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        graphics.setColor(this.shadow);
        if (n != 4 || n2 < 0 || rectangle.x - 1 > n5 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + n6 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, rectangle.y - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n4 + n6 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, rectangle.y + rectangle.height, n3 + n5 - 2, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n, rectangle);
    }

    @Override
    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        return this.tabForCoordinate(jTabbedPane, n, n2, true);
    }

    private int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2, boolean bl) {
        if (bl) {
            this.ensureCurrentLayout();
        }
        if (this.isRunsDirty) {
            return -1;
        }
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
            Rectangle rectangle = this.tabScroller.viewport.getViewRect();
            if (!rectangle.contains(point)) {
                return -1;
            }
        }
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(point.x, point.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x + point.x - point2.x;
            rectangle.y = this.rects[n].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n].x;
            rectangle.y = this.rects[n].y;
        }
        return rectangle;
    }

    private int getClosestTab(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n7 = this.tabPane.getTabPlacement();
        boolean bl = n7 == 1 || n7 == 3;
        int n8 = n3 = bl ? n : n2;
        while (n5 != n6) {
            int n9;
            int n10;
            int n11 = (n6 + n5) / 2;
            if (bl) {
                n10 = this.rects[n11].x;
                n9 = n10 + this.rects[n11].width;
            } else {
                n10 = this.rects[n11].y;
                n9 = n10 + this.rects[n11].height;
            }
            if (n3 < n10) {
                n6 = n11;
                if (n5 != n6) continue;
                return Math.max(0, n11 - 1);
            }
            if (n3 >= n9) {
                n5 = n11;
                if (n6 - n5 > 1) continue;
                return Math.max(n11 + 1, n4 - 1);
            }
            return n11;
        }
        return n5;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n - point2.x + point3.x;
        point.y = n2 - point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane && this.visibleComponent.isVisible()) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        int n2 = this.rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n2, n));
            this.rects = rectangleArray;
            for (int i = n2; i < n; ++i) {
                this.rects[i] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this.tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n, int n2) {
        for (int i = 0; i < this.runCount; ++i) {
            int n3 = this.tabRuns[i];
            int n4 = this.lastTabInRun(n, i);
            if (n2 < n3 || n2 > n4) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            return n - 1;
        }
        int n4 = n3 = n2 == this.runCount - 1 ? 0 : n2 + 1;
        if (this.tabRuns[n3] == 0) {
            return n - 1;
        }
        return this.tabRuns[n3] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n) ? this.tabPane.getDisabledIconAt(n) : this.tabPane.getIconAt(n);
    }

    protected View getTextViewForTab(int n) {
        if (this.htmlViews != null) {
            return this.htmlViews.elementAt(n);
        }
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        Object object;
        int n4 = 0;
        Component component = this.tabPane.getTabComponentAt(n2);
        if (component != null) {
            n4 = component.getPreferredSize().height;
        } else {
            object = this.getTextViewForTab(n2);
            n4 = object != null ? (n4 += (int)((View)object).getPreferredSpan(1)) : (n4 += n3);
            Icon icon = this.getIconForTab(n2);
            if (icon != null) {
                n4 = Math.max(n4, icon.getIconHeight());
            }
        }
        object = this.getTabInsets(n, n2);
        return n4 += ((Insets)object).top + ((Insets)object).bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        for (int i = 0; i < n2; ++i) {
            n3 = Math.max(this.calculateTabHeight(n, i, n4), n3);
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right + 3;
        Component component = this.tabPane.getTabComponentAt(n2);
        if (component != null) {
            n3 += component.getPreferredSize().width;
        } else {
            View view;
            Icon icon = this.getIconForTab(n2);
            if (icon != null) {
                n3 += icon.getIconWidth() + this.textIconGap;
            }
            if ((view = this.getTextViewForTab(n2)) != null) {
                n3 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.tabPane.getTitleAt(n2);
                n3 += SwingUtilities2.stringWidth(this.tabPane, fontMetrics, string);
            }
        }
        return n3;
    }

    protected int calculateMaxTabWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = Math.max(this.calculateTabWidth(n, i, fontMetrics), n3);
        }
        return n3;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = this.getTabRunOverlay(n);
        return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n, int n2) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n) {
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true) ? this.tabPane.getSelectedIndex() : this.getFocusIndex();
        int n4 = this.tabPane.getTabCount();
        boolean bl = BasicGraphicsUtils.isLeftToRight(this.tabPane);
        if (n4 <= 0) {
            return;
        }
        block0 : switch (n2) {
            case 2: 
            case 4: {
                switch (n) {
                    case 12: {
                        this.selectNextTab(n3);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(n3);
                        break block0;
                    }
                    case 1: {
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n5);
                        break block0;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n6);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n) {
                    case 12: {
                        this.selectNextTab(n3);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(n3);
                        break block0;
                    }
                    case 1: {
                        int n7 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n7);
                        break block0;
                    }
                    case 5: {
                        int n8 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n8);
                        break block0;
                    }
                    case 3: {
                        if (bl) {
                            this.selectNextTabInRun(n3);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        if (bl) {
                            this.selectPreviousTabInRun(n3);
                            break block0;
                        }
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getNextTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndexInRun(n2, n3);
        }
        this.navigateTo(n3);
    }

    protected void selectPreviousTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getPreviousTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndexInRun(n2, n3);
        }
        this.navigateTo(n3);
    }

    protected void selectNextTab(int n) {
        int n2 = this.getNextTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getNextTabIndex(n2);
        }
        this.navigateTo(n2);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.getPreviousTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getPreviousTabIndex(n2);
        }
        this.navigateTo(n2);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.tabForCoordinate(this.tabPane, rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n4 = this.tabForCoordinate(this.tabPane, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
            }
        }
        if (n4 != -1) {
            while (!this.tabPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(n4);
            }
            this.navigateTo(n4);
        }
    }

    private void navigateTo(int n) {
        if (DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true)) {
            this.tabPane.setSelectedIndex(n);
        } else {
            this.setFocusIndex(n, true);
        }
    }

    void setFocusIndex(int n, boolean bl) {
        if (bl && !this.isRunsDirty) {
            this.repaintTab(this.focusIndex);
            this.focusIndex = n;
            this.repaintTab(this.focusIndex);
        } else {
            this.focusIndex = n;
        }
    }

    private void repaintTab(int n) {
        if (!this.isRunsDirty && n >= 0 && n < this.tabPane.getTabCount()) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, n));
        }
    }

    private void validateFocusIndex() {
        if (this.focusIndex >= this.tabPane.getTabCount()) {
            this.setFocusIndex(this.tabPane.getSelectedIndex(), false);
        }
    }

    protected int getFocusIndex() {
        return this.focusIndex;
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n4 = bl ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n5 == this.runCount - 1 ? (bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n4;
    }

    protected int getPreviousTabIndex(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.tabPane.getTabCount() - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabIndex(int n) {
        return (n + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this.tabRuns[this.getNextTabRun(n3)]) {
            return this.tabRuns[n3];
        }
        return n4;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        if (n2 == this.tabRuns[n3]) {
            int n4 = this.tabRuns[this.getNextTabRun(n3)] - 1;
            return n4 != -1 ? n4 : n - 1;
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.runCount - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabRun(int n) {
        return (n + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        return SwingUtilities2.tabbedPaneChangeFocusTo(this.getVisibleComponent());
    }

    private Vector<View> createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n = this.tabPane.getTabCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    private class CroppedEdge
    extends JPanel
    implements UIResource {
        private Shape shape;
        private int tabIndex;
        private int cropline;
        private int cropx;
        private int cropy;

        public CroppedEdge() {
            this.setOpaque(false);
        }

        public void setParams(int n, int n2, int n3, int n4) {
            this.tabIndex = n;
            this.cropline = n2;
            this.cropx = n3;
            this.cropy = n4;
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n];
            this.setBounds(rectangle);
            this.shape = BasicTabbedPaneUI.createCroppedTabShape(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), rectangle, n2);
            if (this.getParent() == null && BasicTabbedPaneUI.this.tabContainer != null) {
                BasicTabbedPaneUI.this.tabContainer.add((Component)this, 0);
            }
        }

        public void resetParams() {
            this.shape = null;
            if (this.getParent() == BasicTabbedPaneUI.this.tabContainer && BasicTabbedPaneUI.this.tabContainer != null) {
                BasicTabbedPaneUI.this.tabContainer.remove(this);
            }
        }

        public boolean isParamsSet() {
            return this.shape != null;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getCropline() {
            return this.cropline;
        }

        public int getCroppedSideWidth() {
            return 3;
        }

        private Color getBgColor() {
            Color color;
            Container container = BasicTabbedPaneUI.this.tabPane.getParent();
            if (container != null && (color = container.getBackground()) != null) {
                return color;
            }
            return UIManager.getColor("control");
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isParamsSet() && graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.clipRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setColor(this.getBgColor());
                graphics2D.translate(this.cropx, this.cropy);
                graphics2D.fill(this.shape);
                BasicTabbedPaneUI.this.paintCroppedTabEdge(graphics);
                graphics2D.translate(-this.cropx, -this.cropy);
            }
        }
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane;

        public TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component component) {
            int n = BasicTabbedPaneUI.this.tabPane.indexOfTabComponent(component);
            super.remove(component);
            if (this.notifyTabbedPane && n != -1) {
                BasicTabbedPaneUI.this.tabPane.setTabComponentAt(n, null);
            }
        }

        private void removeUnusedTabComponents() {
            for (Component component : this.getComponents()) {
                int n;
                if (component instanceof UIResource || (n = BasicTabbedPaneUI.this.tabPane.indexOfTabComponent(component)) != -1) continue;
                super.remove(component);
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return BasicTabbedPaneUI.this.tabScroller != null && !((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.isParamsSet();
        }

        @Override
        public void doLayout() {
            if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.repaint();
                BasicTabbedPaneUI.this.tabScroller.updateView();
            } else {
                BasicTabbedPaneUI.this.tabPane.repaint(this.getBounds());
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicTabbedPaneUI.this.getHandler().focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicTabbedPaneUI.this.getHandler().focusLost(focusEvent);
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.getHandler().mousePressed(mouseEvent);
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            BasicTabbedPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTabbedPaneUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    private class Handler
    implements ChangeListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            boolean bl = BasicTabbedPaneUI.this.scrollableTabLayoutEnabled();
            if (string == "mnemonicAt") {
                BasicTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if (string == "displayedMnemonicIndexAt") {
                jTabbedPane.repaint();
            } else if (string == "indexForTitle") {
                BasicTabbedPaneUI.this.calculatedBaseline = false;
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                if (BasicTabbedPaneUI.this.htmlViews != null) {
                    BasicTabbedPaneUI.this.htmlViews.removeElementAt(n);
                }
                this.updateHtmlViews(n);
            } else if (string == "tabLayoutPolicy") {
                BasicTabbedPaneUI.this.uninstallUI(jTabbedPane);
                BasicTabbedPaneUI.this.installUI(jTabbedPane);
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            } else if (string == "tabPlacement") {
                if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BasicTabbedPaneUI.this.tabScroller.createButtons();
                }
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            } else if (string == "opaque" && bl) {
                boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setOpaque(bl2);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport.setOpaque(bl2);
            } else if (string == "background" && bl) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setBackground(color);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport.setBackground(color);
                Color color2 = BasicTabbedPaneUI.this.selectedColor == null ? color : BasicTabbedPaneUI.this.selectedColor;
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton.setBackground(color2);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollBackwardButton.setBackground(color2);
            } else if (string == "indexForTabComponent") {
                Component component;
                if (BasicTabbedPaneUI.this.tabContainer != null) {
                    BasicTabbedPaneUI.this.tabContainer.removeUnusedTabComponents();
                }
                if ((component = BasicTabbedPaneUI.this.tabPane.getTabComponentAt((Integer)propertyChangeEvent.getNewValue())) != null) {
                    if (BasicTabbedPaneUI.this.tabContainer == null) {
                        BasicTabbedPaneUI.this.installTabContainer();
                    } else {
                        BasicTabbedPaneUI.this.tabContainer.add(component);
                    }
                }
                BasicTabbedPaneUI.this.tabPane.revalidate();
                BasicTabbedPaneUI.this.tabPane.repaint();
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            } else if (string == "indexForNullComponent") {
                BasicTabbedPaneUI.this.isRunsDirty = true;
                this.updateHtmlViews((Integer)propertyChangeEvent.getNewValue());
            } else if (string == "font") {
                BasicTabbedPaneUI.this.calculatedBaseline = false;
            }
        }

        private void updateHtmlViews(int n) {
            String string = BasicTabbedPaneUI.this.tabPane.getTitleAt(n);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(BasicTabbedPaneUI.this.tabPane, string);
                    BasicTabbedPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(null, n);
            }
            BasicTabbedPaneUI.this.updateMnemonics();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            BasicTabbedPaneUI.this.setFocusIndex(jTabbedPane.getSelectedIndex(), false);
            if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicTabbedPaneUI.this.ensureCurrentLayout();
                int n = jTabbedPane.getSelectedIndex();
                if (n < BasicTabbedPaneUI.this.rects.length && n != -1) {
                    ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible((Rectangle)BasicTabbedPaneUI.this.rects[n].clone());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n != BasicTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                } else if (BasicTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicTabbedPaneUI.this.setFocusIndex(BasicTabbedPaneUI.this.tabPane.getSelectedIndex(), true);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicTabbedPaneUI.this.repaintTab(BasicTabbedPaneUI.this.focusIndex);
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            BasicTabbedPaneUI.this.isRunsDirty = true;
            this.updateHtmlViews(jTabbedPane.indexOfComponent(component));
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n != null) {
                int n2 = n;
                if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() > n2) {
                    BasicTabbedPaneUI.this.htmlViews.removeElementAt(n2);
                }
                jTabbedPane.putClientProperty("__index_to_remove__", null);
            }
            BasicTabbedPaneUI.this.isRunsDirty = true;
            BasicTabbedPaneUI.this.updateMnemonics();
            BasicTabbedPaneUI.this.validateFocusIndex();
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n) {
            super(n, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            super(null);
            this.setOpaque(BasicTabbedPaneUI.this.tabPane.isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = BasicTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(color);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BasicTabbedPaneUI.this.paintTabArea(graphics, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            if (((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.isParamsSet() && BasicTabbedPaneUI.this.tabContainer == null) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.getTabIndex()];
                graphics.translate(rectangle.x, rectangle.y);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.paintComponent(graphics);
                graphics.translate(-rectangle.x, -rectangle.y);
            }
        }

        @Override
        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component component = this.getComponent(0);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(BasicTabbedPaneUI.this.tabPane.isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = BasicTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(color);
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public CroppedEdge croppedEdge;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.croppedEdge = new CroppedEdge();
            this.createButtons();
        }

        void createButtons() {
            int n;
            if (this.scrollForwardButton != null) {
                BasicTabbedPaneUI.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                BasicTabbedPaneUI.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            if ((n = BasicTabbedPaneUI.this.tabPane.getTabPlacement()) == 1 || n == 3) {
                this.scrollForwardButton = BasicTabbedPaneUI.this.createScrollButton(3);
                this.scrollBackwardButton = BasicTabbedPaneUI.this.createScrollButton(7);
            } else {
                this.scrollForwardButton = BasicTabbedPaneUI.this.createScrollButton(5);
                this.scrollBackwardButton = BasicTabbedPaneUI.this.createScrollButton(1);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            BasicTabbedPaneUI.this.tabPane.add(this.scrollForwardButton);
            BasicTabbedPaneUI.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateView();
        }

        private void updateView() {
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n2);
            Rectangle rectangle = this.viewport.getBounds();
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle2 = this.viewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n2) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Action action;
            ActionMap actionMap = BasicTabbedPaneUI.this.tabPane.getActionMap();
            if (actionMap != null && (action = actionMap.get(string = actionEvent.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(BasicTabbedPaneUI.this.tabPane, 1001, null, actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\nviewport.viewRectangle=" + this.viewport.getViewRect() + "\nleadingTabIndex=" + this.leadingTabIndex + "\ntabViewPosition=" + this.tabViewPosition;
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int n, int n2) {
            return BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        @Override
        protected int preferredTabAreaWidth(int n, int n2) {
            return BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        @Override
        public void layoutContainer(Container container) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n3 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component component2 = null;
            if (n3 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n3);
            }
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.resetParams();
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton.setVisible(false);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollBackwardButton.setVisible(false);
                return;
            }
            boolean bl = false;
            if (component2 != null) {
                if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                    bl = true;
                }
                BasicTabbedPaneUI.this.setVisibleComponent(component2);
            }
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
            Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
            int n4 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
            if (n4 > 0) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                switch (n) {
                    case 2: {
                        n12 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        n11 = rectangle.height - insets.top - insets.bottom;
                        n10 = insets.left;
                        n9 = insets.top;
                        n8 = n10 + n12 + insets2.left;
                        n7 = n9 + insets2.top;
                        n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                        n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                        break;
                    }
                    case 4: {
                        n12 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        n11 = rectangle.height - insets.top - insets.bottom;
                        n10 = rectangle.width - insets.right - n12;
                        n9 = insets.top;
                        n8 = insets.left + insets2.left;
                        n7 = insets.top + insets2.top;
                        n6 = rectangle.width - insets.left - insets.right - n12 - insets2.left - insets2.right;
                        n5 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                        break;
                    }
                    case 3: {
                        n12 = rectangle.width - insets.left - insets.right;
                        n11 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        n10 = insets.left;
                        n9 = rectangle.height - insets.bottom - n11;
                        n8 = insets.left + insets2.left;
                        n7 = insets.top + insets2.top;
                        n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                        n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                        break;
                    }
                    default: {
                        n12 = rectangle.width - insets.left - insets.right;
                        n11 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        n10 = insets.left;
                        n9 = insets.top;
                        n8 = n10 + insets2.left;
                        n7 = n9 + n11 + insets2.top;
                        n6 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                        n5 = rectangle.height - insets.top - insets.bottom - n11 - insets2.top - insets2.bottom;
                    }
                }
                for (int i = 0; i < n4; ++i) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    Cloneable cloneable;
                    Component component3;
                    Component component4 = BasicTabbedPaneUI.this.tabPane.getComponent(i);
                    if (BasicTabbedPaneUI.this.tabScroller != null && component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport) {
                        component3 = (JViewport)component4;
                        cloneable = ((JViewport)component3).getViewRect();
                        n16 = n12;
                        n15 = n11;
                        Dimension dimension = ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton.getPreferredSize();
                        switch (n) {
                            case 2: 
                            case 4: {
                                n14 = BasicTabbedPaneUI.this.rects[n2 - 1].y + BasicTabbedPaneUI.this.rects[n2 - 1].height;
                                if (n14 <= n11) break;
                                int n17 = n15 = n11 > 2 * dimension.height ? n11 - 2 * dimension.height : 0;
                                if (n14 - cloneable.y > n15) break;
                                n15 = n14 - cloneable.y;
                                break;
                            }
                            default: {
                                n13 = BasicTabbedPaneUI.this.rects[n2 - 1].x + BasicTabbedPaneUI.this.rects[n2 - 1].width;
                                if (n13 <= n12) break;
                                int n18 = n16 = n12 > 2 * dimension.width ? n12 - 2 * dimension.width : 0;
                                if (n13 - cloneable.x > n16) break;
                                n16 = n13 - cloneable.x;
                            }
                        }
                        component4.setBounds(n10, n9, n16, n15);
                        continue;
                    }
                    if (BasicTabbedPaneUI.this.tabScroller != null && (component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton || component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollBackwardButton)) {
                        component3 = component4;
                        cloneable = component3.getPreferredSize();
                        n16 = 0;
                        n15 = 0;
                        int n19 = ((Dimension)cloneable).width;
                        n14 = ((Dimension)cloneable).height;
                        n13 = 0;
                        switch (n) {
                            case 2: 
                            case 4: {
                                int n20 = BasicTabbedPaneUI.this.rects[n2 - 1].y + BasicTabbedPaneUI.this.rects[n2 - 1].height;
                                if (n20 <= n11) break;
                                n13 = 1;
                                n16 = n == 2 ? n10 + n12 - ((Dimension)cloneable).width : n10;
                                n15 = component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                break;
                            }
                            default: {
                                int n21 = BasicTabbedPaneUI.this.rects[n2 - 1].x + BasicTabbedPaneUI.this.rects[n2 - 1].width;
                                if (n21 <= n12) break;
                                n13 = 1;
                                n16 = component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                n15 = n == 1 ? n9 + n11 - ((Dimension)cloneable).height : n9;
                            }
                        }
                        component4.setVisible(n13 != 0);
                        if (n13 == 0) continue;
                        component4.setBounds(n16, n15, n19, n14);
                        continue;
                    }
                    component4.setBounds(n8, n7, n6, n5);
                }
                ((TabbedPaneLayout)this).layoutTabComponents();
                this.layoutCroppedEdge();
                if (bl && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        private void layoutCroppedEdge() {
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.resetParams();
            Rectangle rectangle = ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport.getViewRect();
            block3: for (int i = 0; i < BasicTabbedPaneUI.this.rects.length; ++i) {
                Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[i];
                switch (BasicTabbedPaneUI.this.tabPane.getTabPlacement()) {
                    case 2: 
                    case 4: {
                        int n = rectangle.y + rectangle.height;
                        if (rectangle2.y >= n || rectangle2.y + rectangle2.height <= n) continue block3;
                        ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.setParams(i, n - rectangle2.y - 1, -((BasicTabbedPaneUI)BasicTabbedPaneUI.this).currentTabAreaInsets.left, 0);
                        continue block3;
                    }
                    default: {
                        int n = rectangle.x + rectangle.width;
                        if (rectangle2.x >= n - 1 || rectangle2.x + rectangle2.width <= n) continue block3;
                        ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.croppedEdge.setParams(i, n - rectangle2.x - 1, 0, -((BasicTabbedPaneUI)BasicTabbedPaneUI.this).currentTabAreaInsets.top);
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            int n3;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            int n4 = fontMetrics.getHeight();
            int n5 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            int n6 = insets2.left;
            int n7 = insets2.top;
            int n8 = 0;
            int n9 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                }
            }
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            BasicTabbedPaneUI.this.selectedRun = 0;
            BasicTabbedPaneUI.this.runCount = 1;
            for (n3 = 0; n3 < n2; ++n3) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
                if (!bl) {
                    if (n3 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        n9 += BasicTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n6;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
                    n8 = rectangle.x + rectangle.width;
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n7;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (n3 > 0) {
                    rectangle.y = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                } else {
                    BasicTabbedPaneUI.this.tabRuns[0] = 0;
                    BasicTabbedPaneUI.this.maxTabHeight = 0;
                    n8 = BasicTabbedPaneUI.this.maxTabWidth;
                    rectangle.y = n7;
                }
                rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n, n3, n4);
                n9 = rectangle.y + rectangle.height;
                BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                rectangle.x = n6;
                rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
            }
            if (BasicTabbedPaneUI.this.tabsOverlapBorder) {
                this.padSelectedTab(n, n5);
            }
            if (!bl2 && !bl) {
                int n10 = dimension.width - (insets.right + insets2.right);
                for (n3 = 0; n3 < n2; ++n3) {
                    BasicTabbedPaneUI.this.rects[n3].x = n10 - BasicTabbedPaneUI.this.rects[n3].x - BasicTabbedPaneUI.this.rects[n3].width;
                }
            }
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n8, n9));
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.invalidate();
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl) {
            int n;
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
            Insets insets3 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            Dimension dimension = new Dimension(0, 0);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n = 0; n < BasicTabbedPaneUI.this.tabPane.getTabCount(); ++n) {
                Dimension dimension2;
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n);
                if (component == null) continue;
                Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 == null) continue;
                n6 = Math.max(dimension2.height, n6);
                n5 = Math.max(dimension2.width, n5);
            }
            n4 += n5;
            n3 += n6;
            switch (n2) {
                case 2: 
                case 4: {
                    n3 = Math.max(n3, BasicTabbedPaneUI.this.calculateMaxTabHeight(n2));
                    n = this.preferredTabAreaWidth(n2, n3 - insets3.top - insets3.bottom);
                    n4 += n;
                    break;
                }
                default: {
                    n4 = Math.max(n4, BasicTabbedPaneUI.this.calculateMaxTabWidth(n2));
                    n = this.preferredTabAreaHeight(n2, n4 - insets3.left - insets3.right);
                    n3 += n;
                }
            }
            return new Dimension(n4 + insets.left + insets.right + insets2.left + insets2.right, n3 + insets.bottom + insets.top + insets2.top + insets2.bottom);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                for (int i = 0; i < n3; ++i) {
                    int n8 = BasicTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                    if (n6 != 0 && n6 + n8 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n8;
                }
                n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, n5, n7);
            }
            return n4;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = fontMetrics.getHeight();
                BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                for (int i = 0; i < n3; ++i) {
                    int n8 = BasicTabbedPaneUI.this.calculateTabHeight(n, i, n7);
                    if (n6 != 0 && n6 + n8 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n8;
                }
                n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, n5, BasicTabbedPaneUI.this.maxTabWidth);
            }
            return n4;
        }

        @Override
        public void layoutContainer(Container container) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n2 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component component2 = null;
            if (n2 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n2);
            }
            int n3 = 0;
            int n4 = 0;
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n);
            boolean bl = false;
            if (component2 != null) {
                if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                    bl = true;
                }
                BasicTabbedPaneUI.this.setVisibleComponent(component2);
            }
            Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
            int n5 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
            if (n5 > 0) {
                int n6;
                int n7;
                switch (n) {
                    case 2: {
                        n3 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        n7 = insets.left + n3 + insets2.left;
                        n6 = insets.top + insets2.top;
                        break;
                    }
                    case 4: {
                        n3 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        n7 = insets.left + insets2.left;
                        n6 = insets.top + insets2.top;
                        break;
                    }
                    case 3: {
                        n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        n7 = insets.left + insets2.left;
                        n6 = insets.top + insets2.top;
                        break;
                    }
                    default: {
                        n4 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        n7 = insets.left + insets2.left;
                        n6 = insets.top + n4 + insets2.top;
                    }
                }
                int n8 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                int n9 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                for (int i = 0; i < n5; ++i) {
                    Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(i);
                    if (component3 == BasicTabbedPaneUI.this.tabContainer) {
                        int n10 = n3 == 0 ? rectangle.width : n3 + insets.left + insets.right + insets2.left + insets2.right;
                        int n11 = n4 == 0 ? rectangle.height : n4 + insets.top + insets.bottom + insets2.top + insets2.bottom;
                        int n12 = 0;
                        int n13 = 0;
                        if (n == 3) {
                            n13 = rectangle.height - n11;
                        } else if (n == 4) {
                            n12 = rectangle.width - n10;
                        }
                        component3.setBounds(n12, n13, n10, n11);
                        continue;
                    }
                    component3.setBounds(n7, n6, n8, n9);
                }
            }
            this.layoutTabComponents();
            if (bl && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                BasicTabbedPaneUI.this.tabPane.requestFocus();
            }
        }

        public void calculateLayoutInfo() {
            int n = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n);
            BasicTabbedPaneUI.this.isRunsDirty = false;
        }

        private void layoutTabComponents() {
            if (BasicTabbedPaneUI.this.tabContainer == null) {
                return;
            }
            Rectangle rectangle = new Rectangle();
            Point point = new Point(-BasicTabbedPaneUI.this.tabContainer.getX(), -BasicTabbedPaneUI.this.tabContainer.getY());
            if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicTabbedPaneUI.this.translatePointToTabPanel(0, 0, point);
            }
            for (int i = 0; i < BasicTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Component component = BasicTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                if (component == null) continue;
                BasicTabbedPaneUI.this.getTabBounds(i, rectangle);
                Dimension dimension = component.getPreferredSize();
                Insets insets = BasicTabbedPaneUI.this.getTabInsets(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                int n = rectangle.x + insets.left + point.x;
                int n2 = rectangle.y + insets.top + point.y;
                int n3 = rectangle.width - insets.left - insets.right;
                int n4 = rectangle.height - insets.top - insets.bottom;
                int n5 = n + (n3 - dimension.width) / 2;
                int n6 = n2 + (n4 - dimension.height) / 2;
                int n7 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
                boolean bl = i == BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
                component.setBounds(n5 + BasicTabbedPaneUI.this.getTabLabelShiftX(n7, i, bl), n6 + BasicTabbedPaneUI.this.getTabLabelShiftY(n7, i, bl), dimension.width, dimension.height);
            }
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            int n7;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            int n8 = fontMetrics.getHeight();
            int n9 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            switch (n) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = dimension.width - insets.right - insets2.right - BasicTabbedPaneUI.this.maxTabWidth;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = dimension.height - insets.bottom - insets2.bottom - BasicTabbedPaneUI.this.maxTabHeight;
                    n5 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n10 = BasicTabbedPaneUI.this.getTabRunOverlay(n);
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                rectangle = BasicTabbedPaneUI.this.rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n4 - 1].x + BasicTabbedPaneUI.this.rects[n4 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n7;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n, n4, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != n7 && rectangle.x + rectangle.width > n5) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n4;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n7;
                    }
                    rectangle.y = n6;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n4 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n4 - 1].y + BasicTabbedPaneUI.this.rects[n4 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n6;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n, n4, n8);
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != n6 && rectangle.y + rectangle.height > n5) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n4;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n6;
                    }
                    rectangle.x = n7;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                if (n4 != n9) continue;
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n6 : n7, n5);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n2, n9);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            for (n4 = BasicTabbedPaneUI.this.runCount - 1; n4 >= 0; --n4) {
                int n11;
                int n12;
                n3 = BasicTabbedPaneUI.this.tabRuns[n4];
                int n13 = BasicTabbedPaneUI.this.tabRuns[n4 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n4 + 1];
                int n14 = n12 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (!bl) {
                    for (n11 = n3; n11 <= n12; ++n11) {
                        rectangle = BasicTabbedPaneUI.this.rects[n11];
                        rectangle.y = n6;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n, n4);
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                        this.padTabRun(n, n3, n12, n5);
                    }
                    if (n == 3) {
                        n6 -= BasicTabbedPaneUI.this.maxTabHeight - n10;
                        continue;
                    }
                    n6 += BasicTabbedPaneUI.this.maxTabHeight - n10;
                    continue;
                }
                for (n11 = n3; n11 <= n12; ++n11) {
                    rectangle = BasicTabbedPaneUI.this.rects[n11];
                    rectangle.x = n7;
                    rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n, n4);
                }
                if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                    this.padTabRun(n, n3, n12, n5);
                }
                if (n == 4) {
                    n7 -= BasicTabbedPaneUI.this.maxTabWidth - n10;
                    continue;
                }
                n7 += BasicTabbedPaneUI.this.maxTabWidth - n10;
            }
            this.padSelectedTab(n, n9);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n2; ++n4) {
                    BasicTabbedPaneUI.this.rects[n4].x = n3 - BasicTabbedPaneUI.this.rects[n4].x - BasicTabbedPaneUI.this.rects[n4].width;
                }
            }
        }

        protected void rotateTabRuns(int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                int n3 = BasicTabbedPaneUI.this.tabRuns[0];
                for (int j = 1; j < BasicTabbedPaneUI.this.runCount; ++j) {
                    BasicTabbedPaneUI.this.tabRuns[j - 1] = BasicTabbedPaneUI.this.tabRuns[j];
                }
                BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount - 1] = n3;
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            boolean bl = n == 2 || n == 4;
            int n5 = BasicTabbedPaneUI.this.runCount - 1;
            boolean bl2 = true;
            double d = 1.25;
            while (bl2) {
                int n6;
                int n7;
                int n8 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5);
                int n9 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5 - 1);
                if (!bl) {
                    n7 = BasicTabbedPaneUI.this.rects[n8].x + BasicTabbedPaneUI.this.rects[n8].width;
                    n6 = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * d);
                } else {
                    n7 = BasicTabbedPaneUI.this.rects[n8].y + BasicTabbedPaneUI.this.rects[n8].height;
                    n6 = (int)((double)BasicTabbedPaneUI.this.maxTabHeight * d * 2.0);
                }
                if (n4 - n7 > n6) {
                    BasicTabbedPaneUI.this.tabRuns[n5] = n9;
                    if (!bl) {
                        BasicTabbedPaneUI.this.rects[n9].x = n3;
                    } else {
                        BasicTabbedPaneUI.this.rects[n9].y = n3;
                    }
                    for (int i = n9 + 1; i <= n8; ++i) {
                        if (!bl) {
                            BasicTabbedPaneUI.this.rects[i].x = BasicTabbedPaneUI.this.rects[i - 1].x + BasicTabbedPaneUI.this.rects[i - 1].width;
                            continue;
                        }
                        BasicTabbedPaneUI.this.rects[i].y = BasicTabbedPaneUI.this.rects[i - 1].y + BasicTabbedPaneUI.this.rects[i - 1].height;
                    }
                } else if (n5 == BasicTabbedPaneUI.this.runCount - 1) {
                    bl2 = false;
                }
                if (n5 - 1 > 0) {
                    --n5;
                    continue;
                }
                n5 = BasicTabbedPaneUI.this.runCount - 1;
                d += 0.25;
            }
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
            if (n == 1 || n == 3) {
                int n5 = rectangle.x + rectangle.width - BasicTabbedPaneUI.this.rects[n2].x;
                int n6 = n4 - (rectangle.x + rectangle.width);
                float f = (float)n6 / (float)n5;
                for (int i = n2; i <= n3; ++i) {
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[i];
                    if (i > n2) {
                        rectangle2.x = BasicTabbedPaneUI.this.rects[i - 1].x + BasicTabbedPaneUI.this.rects[i - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f);
                }
                rectangle.width = n4 - rectangle.x;
            } else {
                int n7 = rectangle.y + rectangle.height - BasicTabbedPaneUI.this.rects[n2].y;
                int n8 = n4 - (rectangle.y + rectangle.height);
                float f = (float)n8 / (float)n7;
                for (int i = n2; i <= n3; ++i) {
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[i];
                    if (i > n2) {
                        rectangle3.y = BasicTabbedPaneUI.this.rects[i - 1].y + BasicTabbedPaneUI.this.rects[i - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f);
                }
                rectangle.height = n4 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n, int n2) {
            if (n2 >= 0) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n2];
                Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
                if (!BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
                    Insets insets2 = BasicTabbedPaneUI.this.tabPane.getInsets();
                    if (n == 2 || n == 4) {
                        int n3;
                        int n4 = insets2.top - rectangle.y;
                        if (n4 > 0) {
                            rectangle.y += n4;
                            rectangle.height -= n4;
                        }
                        if ((n3 = rectangle.y + rectangle.height + insets2.bottom - dimension.height) > 0) {
                            rectangle.height -= n3;
                        }
                    } else {
                        int n5;
                        int n6 = insets2.left - rectangle.x;
                        if (n6 > 0) {
                            rectangle.x += n6;
                            rectangle.width -= n6;
                        }
                        if ((n5 = rectangle.x + rectangle.width + insets2.right - dimension.width) > 0) {
                            rectangle.width -= n5;
                        }
                    }
                }
            }
        }
    }

    private static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        static final String SET_SELECTED = "setSelectedIndex";
        static final String SELECT_FOCUSED = "selectTabWithFocus";
        static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)BasicLookAndFeel.getUIOfType(jTabbedPane.getUI(), BasicTabbedPaneUI.class);
            if (basicTabbedPaneUI == null) {
                return;
            }
            if (string == NEXT) {
                basicTabbedPaneUI.navigateSelectedTab(12);
            } else if (string == PREVIOUS) {
                basicTabbedPaneUI.navigateSelectedTab(13);
            } else if (string == RIGHT) {
                basicTabbedPaneUI.navigateSelectedTab(3);
            } else if (string == LEFT) {
                basicTabbedPaneUI.navigateSelectedTab(7);
            } else if (string == UP) {
                basicTabbedPaneUI.navigateSelectedTab(1);
            } else if (string == DOWN) {
                basicTabbedPaneUI.navigateSelectedTab(5);
            } else if (string == PAGE_UP) {
                int n = jTabbedPane.getTabPlacement();
                if (n == 1 || n == 3) {
                    basicTabbedPaneUI.navigateSelectedTab(7);
                } else {
                    basicTabbedPaneUI.navigateSelectedTab(1);
                }
            } else if (string == PAGE_DOWN) {
                int n = jTabbedPane.getTabPlacement();
                if (n == 1 || n == 3) {
                    basicTabbedPaneUI.navigateSelectedTab(3);
                } else {
                    basicTabbedPaneUI.navigateSelectedTab(5);
                }
            } else if (string == REQUEST_FOCUS) {
                jTabbedPane.requestFocus();
            } else if (string == REQUEST_FOCUS_FOR_VISIBLE) {
                basicTabbedPaneUI.requestFocusForVisibleComponent();
            } else if (string == SET_SELECTED) {
                String string2 = actionEvent.getActionCommand();
                if (string2 != null && string2.length() > 0) {
                    Integer n;
                    int n2 = actionEvent.getActionCommand().charAt(0);
                    if (n2 >= 97 && n2 <= 122) {
                        n2 -= 32;
                    }
                    if ((n = (Integer)basicTabbedPaneUI.mnemonicToIndexMap.get(n2)) != null && jTabbedPane.isEnabledAt(n)) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
            } else if (string == SELECT_FOCUSED) {
                int n = basicTabbedPaneUI.getFocusIndex();
                if (n != -1) {
                    jTabbedPane.setSelectedIndex(n);
                }
            } else if (string == SCROLL_FORWARD) {
                if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                    basicTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
                }
            } else if (string == SCROLL_BACKWARD && basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }
}

