/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.XmlReader;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MXParser
implements XmlPullParser {
    private boolean allStringsInterned;
    private boolean processNamespaces;
    private boolean roundtripSupported;
    private String location;
    private int lineNumber;
    private int columnNumber;
    private boolean seenRoot;
    private boolean reachedEnd;
    private int eventType;
    private boolean emptyElementTag;
    private int depth;
    private char[][] elRawName;
    private int[] elRawNameEnd;
    private int[] elRawNameLine;
    private String[] elName;
    private String[] elPrefix;
    private String[] elUri;
    private int[] elNamespaceCount;
    private String fileEncoding = null;
    private int attributeCount;
    private String[] attributeName;
    private int[] attributeNameHash;
    private String[] attributePrefix;
    private String[] attributeUri;
    private String[] attributeValue;
    private int namespaceEnd;
    private String[] namespacePrefix;
    private int[] namespacePrefixHash;
    private String[] namespaceUri;
    private int entityEnd;
    private String[] entityName;
    private char[][] entityNameBuf;
    private String[] entityReplacement;
    private char[][] entityReplacementBuf;
    private int[] entityNameHash;
    private final EntityReplacementMap replacementMapTemplate;
    private Reader reader;
    private String inputEncoding;
    private int bufLoadFactor = 95;
    private float bufferLoadFactor = (float)this.bufLoadFactor / 100.0f;
    private char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256];
    private int bufSoftLimit = (int)(this.bufferLoadFactor * (float)this.buf.length);
    private boolean preventBufferCompaction;
    private int bufAbsoluteStart;
    private int bufStart;
    private int bufEnd;
    private int pos;
    private int posStart;
    private int posEnd;
    private char[] pc = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 64];
    private int pcStart;
    private int pcEnd;
    private boolean usePC;
    private boolean seenStartTag;
    private boolean seenEndTag;
    private boolean pastEndTag;
    private boolean seenAmpersand;
    private boolean seenMarkup;
    private boolean seenDocdecl;
    private boolean tokenize;
    private String text;
    private String entityRefName;
    private String xmlDeclVersion;
    private Boolean xmlDeclStandalone;
    private String xmlDeclContent;
    private static final char[] BUF_NOT_RESOLVED;
    private static final char[] BUF_LT;
    private static final char[] BUF_AMP;
    private static final char[] BUF_GT;
    private static final char[] BUF_APO;
    private static final char[] BUF_QUOT;
    private char[] resolvedEntityRefCharBuf = BUF_NOT_RESOLVED;
    private static final char[] VERSION;
    private static final char[] NCODING;
    private static final char[] TANDALONE;
    private static final char[] YES;
    private static final char[] NO;
    private static final boolean[] lookupNameStartChar;
    private static final boolean[] lookupNameChar;

    private void resetStringCache() {
    }

    private String newString(char[] cbuf, int off, int len) {
        return new String(cbuf, off, len);
    }

    private String newStringIntern(char[] cbuf, int off, int len) {
        return new String(cbuf, off, len).intern();
    }

    private void ensureElementsCapacity() {
        int elStackSize;
        int n = elStackSize = this.elName != null ? this.elName.length : 0;
        if (this.depth + 1 >= elStackSize) {
            int newSize = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
            boolean needsCopying = elStackSize > 0;
            String[] arr = null;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elName, 0, arr, 0, elStackSize);
            }
            this.elName = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elPrefix, 0, arr, 0, elStackSize);
            }
            this.elPrefix = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elUri, 0, arr, 0, elStackSize);
            }
            this.elUri = arr;
            int[] iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elNamespaceCount, 0, iarr, 0, elStackSize);
            } else {
                iarr[0] = 0;
            }
            this.elNamespaceCount = iarr;
            iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elRawNameEnd, 0, iarr, 0, elStackSize);
            }
            this.elRawNameEnd = iarr;
            iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elRawNameLine, 0, iarr, 0, elStackSize);
            }
            this.elRawNameLine = iarr;
            char[][] carr = new char[newSize][];
            if (needsCopying) {
                System.arraycopy(this.elRawName, 0, carr, 0, elStackSize);
            }
            this.elRawName = carr;
        }
    }

    private void ensureAttributesCapacity(int size) {
        int attrPosSize;
        int n = attrPosSize = this.attributeName != null ? this.attributeName.length : 0;
        if (size >= attrPosSize) {
            int newSize = size > 7 ? 2 * size : 8;
            boolean needsCopying = attrPosSize > 0;
            String[] arr = null;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeName, 0, arr, 0, attrPosSize);
            }
            this.attributeName = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributePrefix, 0, arr, 0, attrPosSize);
            }
            this.attributePrefix = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeUri, 0, arr, 0, attrPosSize);
            }
            this.attributeUri = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeValue, 0, arr, 0, attrPosSize);
            }
            this.attributeValue = arr;
            if (!this.allStringsInterned) {
                int[] iarr = new int[newSize];
                if (needsCopying) {
                    System.arraycopy(this.attributeNameHash, 0, iarr, 0, attrPosSize);
                }
                this.attributeNameHash = iarr;
            }
            arr = null;
        }
    }

    private void ensureNamespacesCapacity(int size) {
        int namespaceSize;
        int n = namespaceSize = this.namespacePrefix != null ? this.namespacePrefix.length : 0;
        if (size >= namespaceSize) {
            int newSize = size > 7 ? 2 * size : 8;
            String[] newNamespacePrefix = new String[newSize];
            String[] newNamespaceUri = new String[newSize];
            if (this.namespacePrefix != null) {
                System.arraycopy(this.namespacePrefix, 0, newNamespacePrefix, 0, this.namespaceEnd);
                System.arraycopy(this.namespaceUri, 0, newNamespaceUri, 0, this.namespaceEnd);
            }
            this.namespacePrefix = newNamespacePrefix;
            this.namespaceUri = newNamespaceUri;
            if (!this.allStringsInterned) {
                int[] newNamespacePrefixHash = new int[newSize];
                if (this.namespacePrefixHash != null) {
                    System.arraycopy(this.namespacePrefixHash, 0, newNamespacePrefixHash, 0, this.namespaceEnd);
                }
                this.namespacePrefixHash = newNamespacePrefixHash;
            }
        }
    }

    private static final int fastHash(char[] ch, int off, int len) {
        if (len == 0) {
            return 0;
        }
        int hash = ch[off];
        hash = (hash << 7) + ch[off + len - 1];
        if (len > 16) {
            hash = (hash << 7) + ch[off + len / 4];
        }
        if (len > 8) {
            hash = (hash << 7) + ch[off + len / 2];
        }
        return hash;
    }

    private void reset() {
        this.location = null;
        this.lineNumber = 1;
        this.columnNumber = 1;
        this.seenRoot = false;
        this.reachedEnd = false;
        this.eventType = 0;
        this.emptyElementTag = false;
        this.depth = 0;
        this.attributeCount = 0;
        this.namespaceEnd = 0;
        this.entityEnd = 0;
        this.setupFromTemplate();
        this.reader = null;
        this.inputEncoding = null;
        this.preventBufferCompaction = false;
        this.bufAbsoluteStart = 0;
        this.bufStart = 0;
        this.bufEnd = 0;
        this.posEnd = 0;
        this.posStart = 0;
        this.pos = 0;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        this.seenStartTag = false;
        this.seenEndTag = false;
        this.pastEndTag = false;
        this.seenAmpersand = false;
        this.seenMarkup = false;
        this.seenDocdecl = false;
        this.xmlDeclVersion = null;
        this.xmlDeclStandalone = null;
        this.xmlDeclContent = null;
        this.resetStringCache();
    }

    public MXParser() {
        this.replacementMapTemplate = null;
    }

    public MXParser(EntityReplacementMap entityReplacementMap) {
        this.replacementMapTemplate = entityReplacementMap;
    }

    public void setupFromTemplate() {
        if (this.replacementMapTemplate != null) {
            int length = this.replacementMapTemplate.entityEnd;
            this.entityName = this.replacementMapTemplate.entityName;
            this.entityNameBuf = this.replacementMapTemplate.entityNameBuf;
            this.entityReplacement = this.replacementMapTemplate.entityReplacement;
            this.entityReplacementBuf = this.replacementMapTemplate.entityReplacementBuf;
            this.entityNameHash = this.replacementMapTemplate.entityNameHash;
            this.entityEnd = length;
        }
    }

    @Override
    public void setInput(Reader in) throws XmlPullParserException {
        InputStreamReader isr;
        this.reset();
        this.reader = in;
        if (this.reader instanceof XmlReader) {
            XmlReader xsr = (XmlReader)this.reader;
            this.fileEncoding = xsr.getEncoding();
        } else if (this.reader instanceof InputStreamReader && (isr = (InputStreamReader)this.reader).getEncoding() != null) {
            this.fileEncoding = isr.getEncoding().toUpperCase();
        }
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getNamespace(String prefix) {
        if (prefix != null) {
            for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                if (!prefix.equals(this.namespacePrefix[i])) continue;
                return this.namespaceUri[i];
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(prefix)) {
                return "http://www.w3.org/2000/xmlns/";
            }
        } else {
            for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                if (this.namespacePrefix[i] != null) continue;
                return this.namespaceUri[i];
            }
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    private static int findFragment(int bufMinPos, char[] b, int start, int end) {
        char c;
        if (start < bufMinPos) {
            start = bufMinPos;
            if (start > end) {
                start = end;
            }
            return start;
        }
        if (end - start > 65) {
            start = end - 10;
        }
        int i = start + 1;
        while (--i > bufMinPos && end - i <= 65 && ((c = b[i]) != '<' || start - i <= 10)) {
        }
        return i;
    }

    @Override
    public String getPositionDescription() {
        String fragment = null;
        if (this.posStart <= this.pos) {
            int start = MXParser.findFragment(0, this.buf, this.posStart, this.pos);
            if (start < this.pos) {
                fragment = new String(this.buf, start, this.pos - start);
            }
            if (this.bufAbsoluteStart > 0 || start > 0) {
                fragment = "..." + fragment;
            }
        }
        return " " + TYPES[this.eventType] + (fragment != null ? " seen " + MXParser.printable(fragment) + "..." : "") + " " + (this.location != null ? this.location : "") + "@" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.eventType == 4 || this.eventType == 5) {
            if (this.usePC) {
                for (int i = this.pcStart; i < this.pcEnd; ++i) {
                    if (MXParser.isS(this.pc[i])) continue;
                    return false;
                }
                return true;
            }
            for (int i = this.posStart; i < this.posEnd; ++i) {
                if (MXParser.isS(this.buf[i])) continue;
                return false;
            }
            return true;
        }
        if (this.eventType == 7) {
            return true;
        }
        throw new XmlPullParserException("no content available to check for whitespaces");
    }

    @Override
    public String getText() {
        if (this.eventType == 0 || this.eventType == 1) {
            return null;
        }
        if (this.eventType == 6) {
            return this.text;
        }
        if (this.text == null) {
            this.text = !this.usePC || this.eventType == 2 || this.eventType == 3 ? new String(this.buf, this.posStart, this.posEnd - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
        }
        return this.text;
    }

    public String getNamespace() {
        if (this.eventType == 2) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        if (this.eventType == 3) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.eventType == 2) {
            return this.elName[this.depth];
        }
        if (this.eventType == 3) {
            return this.elName[this.depth];
        }
        if (this.eventType == 6) {
            if (this.entityRefName == null) {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            }
            return this.entityRefName;
        }
        return null;
    }

    @Override
    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to check for empty element", this, null);
        }
        return this.emptyElementTag;
    }

    @Override
    public int getAttributeCount() {
        if (this.eventType != 2) {
            return -1;
        }
        return this.attributeCount;
    }

    @Override
    public String getAttributeName(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeName[index];
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeValue[index];
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes" + this.getPositionDescription());
        }
        if (name == null) {
            throw new IllegalArgumentException("attribute name can not be null");
        }
        if (this.processNamespaces) {
            if (namespace == null) {
                namespace = "";
            }
            for (int i = 0; i < this.attributeCount; ++i) {
                if (namespace != this.attributeUri[i] && !namespace.equals(this.attributeUri[i]) || !name.equals(this.attributeName[i])) continue;
                return this.attributeValue[i];
            }
        } else {
            if (namespace != null && namespace.length() == 0) {
                namespace = null;
            }
            if (namespace != null) {
                throw new IllegalArgumentException("when namespaces processing is disabled attribute namespace must be null");
            }
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!name.equals(this.attributeName[i])) continue;
                return this.attributeValue[i];
            }
        }
        return null;
    }

    @Override
    public int getEventType() throws XmlPullParserException {
        return this.eventType;
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (!this.processNamespaces && namespace != null) {
            throw new XmlPullParserException("processing namespaces must be enabled on parser (or factory) to have possible namespaces declared on elements" + " (position:" + this.getPositionDescription() + ")");
        }
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected event " + TYPES[type] + (name != null ? " with name '" + name + "'" : "") + (namespace != null && name != null ? " and" : "") + (namespace != null ? " with namespace '" + namespace + "'" : "") + " but got" + (type != this.getEventType() ? " " + TYPES[this.getEventType()] : "") + (name != null && this.getName() != null && !name.equals(this.getName()) ? " name '" + this.getName() + "'" : "") + (namespace != null && name != null && this.getName() != null && !name.equals(this.getName()) && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " and" : "") + (namespace != null && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " namespace '" + this.getNamespace() + "'" : "") + " (position:" + this.getPositionDescription() + ")");
        }
    }

    public void skipSubTree() throws XmlPullParserException, IOException {
        this.require(2, null, null);
        int level = 1;
        while (level > 0) {
            int eventType = this.next();
            if (eventType == 3) {
                --level;
                continue;
            }
            if (eventType != 2) continue;
            ++level;
        }
    }

    @Override
    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", this, null);
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException("TEXT must be immediately followed by END_TAG and not " + TYPES[this.getEventType()], this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", this, null);
    }

    @Override
    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.eventType == 4 && this.isWhitespace()) {
            this.next();
        }
        if (this.eventType != 2 && this.eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + TYPES[this.getEventType()], this, null);
        }
        return this.eventType;
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        this.tokenize = false;
        return this.nextImpl();
    }

    /*
     * Unable to fully structure code
     */
    private int nextImpl() throws XmlPullParserException, IOException {
        block53: {
            this.text = null;
            this.pcStart = 0;
            this.pcEnd = 0;
            this.usePC = false;
            this.bufStart = this.posEnd;
            if (this.pastEndTag) {
                this.pastEndTag = false;
                --this.depth;
                this.namespaceEnd = this.elNamespaceCount[this.depth];
            }
            if (this.emptyElementTag) {
                this.emptyElementTag = false;
                this.pastEndTag = true;
                this.eventType = 3;
                return 3;
            }
            if (this.depth <= 0) break block53;
            if (this.seenStartTag) {
                this.seenStartTag = false;
                this.eventType = this.parseStartTag();
                return this.eventType;
            }
            if (this.seenEndTag) {
                this.seenEndTag = false;
                this.eventType = this.parseEndTag();
                return this.eventType;
            }
            if (this.seenMarkup) {
                this.seenMarkup = false;
                ch = '<';
            } else if (this.seenAmpersand) {
                this.seenAmpersand = false;
                ch = '&';
            } else {
                ch = this.more();
            }
            this.posStart = this.pos - 1;
            hadCharData = false;
            needsMerging = false;
            while (true) {
                block56: {
                    block54: {
                        block57: {
                            block55: {
                                if (ch != 60) ** GOTO lbl98
                                if (hadCharData && this.tokenize) {
                                    this.seenMarkup = true;
                                    this.eventType = 4;
                                    return 4;
                                }
                                ch = this.more();
                                if (ch == '/') {
                                    if (!this.tokenize && hadCharData) {
                                        this.seenEndTag = true;
                                        this.eventType = 4;
                                        return 4;
                                    }
                                    this.eventType = this.parseEndTag();
                                    return this.eventType;
                                }
                                if (ch != 33) break block54;
                                ch = this.more();
                                if (ch != 45) break block55;
                                this.parseComment();
                                if (this.tokenize) {
                                    this.eventType = 9;
                                    return 9;
                                }
                                if (!this.usePC && hadCharData) {
                                    needsMerging = true;
                                } else {
                                    this.posStart = this.pos;
                                }
                                break block56;
                            }
                            if (ch != 91) break block57;
                            this.parseCDSect(hadCharData);
                            if (this.tokenize) {
                                this.eventType = 5;
                                return 5;
                            }
                            cdEnd = this.posEnd;
                            cdStart = this.posStart;
                            cdLen = cdEnd - cdStart;
                            if (cdLen <= 0) break block56;
                            hadCharData = true;
                            if (this.usePC) break block56;
                            needsMerging = true;
                            break block56;
                        }
                        throw new XmlPullParserException("unexpected character in markup " + MXParser.printable(ch), this, null);
                    }
                    if (ch == '?') {
                        this.parsePI();
                        if (this.tokenize) {
                            this.eventType = 8;
                            return 8;
                        }
                        if (!this.usePC && hadCharData) {
                            needsMerging = true;
                        } else {
                            this.posStart = this.pos;
                        }
                    } else {
                        if (MXParser.isNameStartChar(ch)) {
                            if (!this.tokenize && hadCharData) {
                                this.seenStartTag = true;
                                this.eventType = 4;
                                return 4;
                            }
                            this.eventType = this.parseStartTag();
                            return this.eventType;
                        }
                        throw new XmlPullParserException("unexpected character in markup " + MXParser.printable(ch), this, null);
lbl98:
                        // 1 sources

                        if (ch == '&') {
                            if (this.tokenize && hadCharData) {
                                this.seenAmpersand = true;
                                this.eventType = 4;
                                return 4;
                            }
                            oldStart = this.posStart + this.bufAbsoluteStart;
                            oldEnd = this.posEnd + this.bufAbsoluteStart;
                            this.parseEntityRef();
                            if (this.tokenize) {
                                this.eventType = 6;
                                return 6;
                            }
                            if (this.resolvedEntityRefCharBuf == MXParser.BUF_NOT_RESOLVED) {
                                if (this.entityRefName == null) {
                                    this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                                }
                                throw new XmlPullParserException("could not resolve entity named '" + MXParser.printable(this.entityRefName) + "'", this, null);
                            }
                            this.posStart = oldStart - this.bufAbsoluteStart;
                            this.posEnd = oldEnd - this.bufAbsoluteStart;
                            if (!this.usePC) {
                                if (hadCharData) {
                                    this.joinPC();
                                    needsMerging = false;
                                } else {
                                    this.usePC = true;
                                    this.pcEnd = 0;
                                    this.pcStart = 0;
                                }
                            }
                            for (char aResolvedEntity : this.resolvedEntityRefCharBuf) {
                                if (this.pcEnd >= this.pc.length) {
                                    this.ensurePC(this.pcEnd);
                                }
                                this.pc[this.pcEnd++] = aResolvedEntity;
                            }
                            hadCharData = true;
                        } else {
                            if (needsMerging) {
                                this.joinPC();
                                needsMerging = false;
                            }
                            hadCharData = true;
                            normalizedCR = false;
                            normalizeInput = this.tokenize == false || this.roundtripSupported == false;
                            seenBracket = false;
                            seenBracketBracket = false;
                            do {
                                if (ch == ']') {
                                    if (seenBracket) {
                                        seenBracketBracket = true;
                                    } else {
                                        seenBracket = true;
                                    }
                                } else {
                                    if (seenBracketBracket && ch == '>') {
                                        throw new XmlPullParserException("characters ]]> are not allowed in content", this, null);
                                    }
                                    if (seenBracket) {
                                        seenBracket = false;
                                        seenBracketBracket = false;
                                    }
                                }
                                if (!normalizeInput) continue;
                                if (ch == '\r') {
                                    normalizedCR = true;
                                    this.posEnd = this.pos - 1;
                                    if (!this.usePC) {
                                        if (this.posEnd > this.posStart) {
                                            this.joinPC();
                                        } else {
                                            this.usePC = true;
                                            this.pcEnd = 0;
                                            this.pcStart = 0;
                                        }
                                    }
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = 10;
                                    continue;
                                }
                                if (ch == '\n') {
                                    if (!normalizedCR && this.usePC) {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = 10;
                                    }
                                    normalizedCR = false;
                                    continue;
                                }
                                if (this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = ch;
                                }
                                normalizedCR = false;
                            } while ((ch = this.more()) != '<' && ch != 38);
                            this.posEnd = this.pos - 1;
                            continue;
                        }
                    }
                }
                ch = this.more();
            }
        }
        if (this.seenRoot) {
            return this.parseEpilog();
        }
        return this.parseProlog();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseProlog() throws XmlPullParserException, IOException {
        char ch = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
        if (this.eventType == 0) {
            if (ch == '\ufffe') {
                throw new XmlPullParserException("first character in input was UNICODE noncharacter (0xFFFE)- input requires int swapping", this, null);
            }
            if (ch == '\ufeff') {
                ch = this.more();
            } else if (ch == '\ufffd' && (ch = this.more()) == '\ufffd') {
                throw new XmlPullParserException("UTF-16 BOM in a UTF-8 encoded file is incompatible", this, null);
            }
        }
        this.seenMarkup = false;
        boolean gotS = false;
        this.posStart = this.pos - 1;
        boolean normalizeIgnorableWS = this.tokenize && !this.roundtripSupported;
        boolean normalizedCR = false;
        while (true) {
            block33: {
                block34: {
                    block35: {
                        if (ch != '<') break block34;
                        if (gotS && this.tokenize) {
                            this.posEnd = this.pos - 1;
                            this.seenMarkup = true;
                            this.eventType = 7;
                            return 7;
                        }
                        ch = this.more();
                        if (ch != '?') break block35;
                        boolean isXMLDecl = this.parsePI();
                        if (this.tokenize) {
                            if (isXMLDecl) {
                                this.eventType = 0;
                                return 0;
                            }
                            this.eventType = 8;
                            return 8;
                        }
                        break block33;
                    }
                    if (ch == '!') {
                        ch = this.more();
                        if (ch == 'D') {
                            if (this.seenDocdecl) {
                                throw new XmlPullParserException("only one docdecl allowed in XML document", this, null);
                            }
                            this.seenDocdecl = true;
                            this.parseDocdecl();
                            if (this.tokenize) {
                                this.eventType = 10;
                                return 10;
                            }
                            break block33;
                        } else {
                            if (ch != '-') {
                                throw new XmlPullParserException("unexpected markup <!" + MXParser.printable(ch), this, null);
                            }
                            this.parseComment();
                            if (this.tokenize) {
                                this.eventType = 9;
                                return 9;
                            }
                        }
                        break block33;
                    } else {
                        if (ch == '/') {
                            throw new XmlPullParserException("expected start tag name and not " + MXParser.printable(ch), this, null);
                        }
                        if (MXParser.isNameStartChar(ch)) {
                            this.seenRoot = true;
                            return this.parseStartTag();
                        }
                        throw new XmlPullParserException("expected start tag name and not " + MXParser.printable(ch), this, null);
                    }
                }
                if (!MXParser.isS(ch)) {
                    throw new XmlPullParserException("only whitespace content allowed before start tag and not " + MXParser.printable(ch), this, null);
                }
                gotS = true;
                if (normalizeIgnorableWS) {
                    if (ch == '\r') {
                        normalizedCR = true;
                        if (!this.usePC) {
                            this.posEnd = this.pos - 1;
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    } else if (ch == '\n') {
                        if (!normalizedCR && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        normalizedCR = false;
                    } else {
                        if (this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = ch;
                        }
                        normalizedCR = false;
                    }
                }
            }
            ch = this.more();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int parseEpilog() throws XmlPullParserException, IOException {
        boolean gotS;
        block31: {
            if (this.eventType == 1) {
                throw new XmlPullParserException("already reached end of XML input", this, null);
            }
            if (this.reachedEnd) {
                this.eventType = 1;
                return 1;
            }
            gotS = false;
            boolean normalizeIgnorableWS = this.tokenize && !this.roundtripSupported;
            boolean normalizedCR = false;
            try {
                char ch = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
                this.seenMarkup = false;
                this.posStart = this.pos - 1;
                if (this.reachedEnd) break block31;
                do {
                    block32: {
                        block33: {
                            block34: {
                                if (ch != '<') break block33;
                                if (gotS && this.tokenize) {
                                    this.posEnd = this.pos - 1;
                                    this.seenMarkup = true;
                                    this.eventType = 7;
                                    return 7;
                                }
                                ch = this.more();
                                if (this.reachedEnd) break block31;
                                if (ch != '?') break block34;
                                this.parsePI();
                                if (this.tokenize) {
                                    this.eventType = 8;
                                    return 8;
                                }
                                break block32;
                            }
                            if (ch == '!') {
                                ch = this.more();
                                if (this.reachedEnd) break block31;
                                if (ch == 'D') {
                                    this.parseDocdecl();
                                    if (this.tokenize) {
                                        this.eventType = 10;
                                        return 10;
                                    }
                                    break block32;
                                } else {
                                    if (ch != '-') {
                                        throw new XmlPullParserException("unexpected markup <!" + MXParser.printable(ch), this, null);
                                    }
                                    this.parseComment();
                                    if (this.tokenize) {
                                        this.eventType = 9;
                                        return 9;
                                    }
                                }
                                break block32;
                            } else {
                                if (ch == '/') {
                                    throw new XmlPullParserException("end tag not allowed in epilog but got " + MXParser.printable(ch), this, null);
                                }
                                if (MXParser.isNameStartChar(ch)) {
                                    throw new XmlPullParserException("start tag not allowed in epilog but got " + MXParser.printable(ch), this, null);
                                }
                                throw new XmlPullParserException("in epilog expected ignorable content and not " + MXParser.printable(ch), this, null);
                            }
                        }
                        if (!MXParser.isS(ch)) {
                            throw new XmlPullParserException("in epilog non whitespace content is not allowed but got " + MXParser.printable(ch), this, null);
                        }
                        gotS = true;
                        if (normalizeIgnorableWS) {
                            if (ch == '\r') {
                                normalizedCR = true;
                                if (!this.usePC) {
                                    this.posEnd = this.pos - 1;
                                    if (this.posEnd > this.posStart) {
                                        this.joinPC();
                                    } else {
                                        this.usePC = true;
                                        this.pcEnd = 0;
                                        this.pcStart = 0;
                                    }
                                }
                                if (this.pcEnd >= this.pc.length) {
                                    this.ensurePC(this.pcEnd);
                                }
                                this.pc[this.pcEnd++] = 10;
                            } else if (ch == '\n') {
                                if (!normalizedCR && this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = 10;
                                }
                                normalizedCR = false;
                            } else {
                                if (this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = ch;
                                }
                                normalizedCR = false;
                            }
                        }
                    }
                    ch = this.more();
                } while (!this.reachedEnd);
            }
            catch (EOFException ex) {
                this.reachedEnd = true;
            }
        }
        if (this.tokenize && gotS) {
            this.posEnd = this.pos;
            this.eventType = 7;
            return 7;
        }
        this.eventType = 1;
        return 1;
    }

    public int parseEndTag() throws XmlPullParserException, IOException {
        char ch = this.more();
        if (!MXParser.isNameStartChar(ch)) {
            throw new XmlPullParserException("expected name start and not " + MXParser.printable(ch), this, null);
        }
        this.posStart = this.pos - 3;
        int nameStart = this.pos - 1 + this.bufAbsoluteStart;
        while (MXParser.isNameChar(ch = this.more())) {
        }
        int off = nameStart - this.bufAbsoluteStart;
        int len = this.pos - 1 - off;
        char[] cbuf = this.elRawName[this.depth];
        if (this.elRawNameEnd[this.depth] != len) {
            String startname = new String(cbuf, 0, this.elRawNameEnd[this.depth]);
            String endname = new String(this.buf, off, len);
            throw new XmlPullParserException("end tag name </" + endname + "> must match start tag name <" + startname + "> from line " + this.elRawNameLine[this.depth], this, null);
        }
        for (int i = 0; i < len; ++i) {
            if (this.buf[off++] == cbuf[i]) continue;
            String startname = new String(cbuf, 0, len);
            String endname = new String(this.buf, off - i - 1, len);
            throw new XmlPullParserException("end tag name </" + endname + "> must be the same as start tag <" + startname + "> from line " + this.elRawNameLine[this.depth], this, null);
        }
        while (MXParser.isS(ch)) {
            ch = this.more();
        }
        if (ch != '>') {
            throw new XmlPullParserException("expected > to finsh end tag not " + MXParser.printable(ch) + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        this.posEnd = this.pos;
        this.pastEndTag = true;
        this.eventType = 3;
        return 3;
    }

    public int parseStartTag() throws XmlPullParserException, IOException {
        String prefix;
        block27: {
            ++this.depth;
            this.posStart = this.pos - 2;
            this.emptyElementTag = false;
            this.attributeCount = 0;
            int nameStart = this.pos - 1 + this.bufAbsoluteStart;
            int colonPos = -1;
            char ch = this.buf[this.pos - 1];
            if (ch == ':' && this.processNamespaces) {
                throw new XmlPullParserException("when namespaces processing enabled colon can not be at element name start", this, null);
            }
            while (MXParser.isNameChar(ch = this.more())) {
                if (ch != ':' || !this.processNamespaces) continue;
                if (colonPos != -1) {
                    throw new XmlPullParserException("only one colon is allowed in name of element when namespaces are enabled", this, null);
                }
                colonPos = this.pos - 1 + this.bufAbsoluteStart;
            }
            this.ensureElementsCapacity();
            int elLen = this.pos - 1 - (nameStart - this.bufAbsoluteStart);
            if (this.elRawName[this.depth] == null || this.elRawName[this.depth].length < elLen) {
                this.elRawName[this.depth] = new char[2 * elLen];
            }
            System.arraycopy(this.buf, nameStart - this.bufAbsoluteStart, this.elRawName[this.depth], 0, elLen);
            this.elRawNameEnd[this.depth] = elLen;
            this.elRawNameLine[this.depth] = this.lineNumber;
            String name = null;
            prefix = null;
            if (this.processNamespaces) {
                if (colonPos != -1) {
                    prefix = this.elPrefix[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, colonPos - nameStart);
                    name = this.elName[this.depth] = this.newString(this.buf, colonPos + 1 - this.bufAbsoluteStart, this.pos - 2 - (colonPos - this.bufAbsoluteStart));
                } else {
                    this.elPrefix[this.depth] = null;
                    prefix = null;
                    name = this.elName[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, elLen);
                }
            } else {
                name = this.elName[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, elLen);
            }
            while (true) {
                if (MXParser.isS(ch)) {
                    ch = this.more();
                    continue;
                }
                if (ch == '>') break block27;
                if (ch == '/') {
                    if (this.emptyElementTag) {
                        throw new XmlPullParserException("repeated / in tag declaration", this, null);
                    }
                    this.emptyElementTag = true;
                    ch = this.more();
                    if (ch != '>') {
                        throw new XmlPullParserException("expected > to end empty tag not " + MXParser.printable(ch), this, null);
                    }
                    break block27;
                }
                if (!MXParser.isNameStartChar(ch)) break;
                ch = this.parseAttribute();
                ch = this.more();
            }
            throw new XmlPullParserException("start tag unexpected character " + MXParser.printable(ch), this, null);
        }
        if (this.processNamespaces) {
            int i;
            String uri = this.getNamespace(prefix);
            if (uri == null) {
                if (prefix == null) {
                    uri = "";
                } else {
                    throw new XmlPullParserException("could not determine namespace bound to element prefix " + prefix, this, null);
                }
            }
            this.elUri[this.depth] = uri;
            for (i = 0; i < this.attributeCount; ++i) {
                String attrPrefix = this.attributePrefix[i];
                if (attrPrefix != null) {
                    String attrUri = this.getNamespace(attrPrefix);
                    if (attrUri == null) {
                        throw new XmlPullParserException("could not determine namespace bound to attribute prefix " + attrPrefix, this, null);
                    }
                    this.attributeUri[i] = attrUri;
                    continue;
                }
                this.attributeUri[i] = "";
            }
            for (i = 1; i < this.attributeCount; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (this.attributeUri[j] != this.attributeUri[i] || (!this.allStringsInterned || !this.attributeName[j].equals(this.attributeName[i])) && (this.allStringsInterned || this.attributeNameHash[j] != this.attributeNameHash[i] || !this.attributeName[j].equals(this.attributeName[i]))) continue;
                    String attr1 = this.attributeName[j];
                    if (this.attributeUri[j] != null) {
                        attr1 = this.attributeUri[j] + ":" + attr1;
                    }
                    String attr2 = this.attributeName[i];
                    if (this.attributeUri[i] != null) {
                        attr2 = this.attributeUri[i] + ":" + attr2;
                    }
                    throw new XmlPullParserException("duplicated attributes " + attr1 + " and " + attr2, this, null);
                }
            }
        } else {
            for (int i = 1; i < this.attributeCount; ++i) {
                for (int j = 0; j < i; ++j) {
                    if ((!this.allStringsInterned || !this.attributeName[j].equals(this.attributeName[i])) && (this.allStringsInterned || this.attributeNameHash[j] != this.attributeNameHash[i] || !this.attributeName[j].equals(this.attributeName[i]))) continue;
                    String attr1 = this.attributeName[j];
                    String attr2 = this.attributeName[i];
                    throw new XmlPullParserException("duplicated attributes " + attr1 + " and " + attr2, this, null);
                }
            }
        }
        this.elNamespaceCount[this.depth] = this.namespaceEnd;
        this.posEnd = this.pos;
        this.eventType = 2;
        return 2;
    }

    private char parseAttribute() throws XmlPullParserException, IOException {
        int prevPosStart = this.posStart + this.bufAbsoluteStart;
        int nameStart = this.pos - 1 + this.bufAbsoluteStart;
        int colonPos = -1;
        char ch = this.buf[this.pos - 1];
        if (ch == ':' && this.processNamespaces) {
            throw new XmlPullParserException("when namespaces processing enabled colon can not be at attribute name start", this, null);
        }
        boolean startsWithXmlns = this.processNamespaces && ch == 'x';
        int xmlnsPos = 0;
        ch = this.more();
        while (MXParser.isNameChar(ch)) {
            if (this.processNamespaces) {
                if (startsWithXmlns && xmlnsPos < 5) {
                    if (++xmlnsPos == 1) {
                        if (ch != 'm') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 2) {
                        if (ch != 'l') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 3) {
                        if (ch != 'n') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 4) {
                        if (ch != 's') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 5 && ch != ':') {
                        throw new XmlPullParserException("after xmlns in attribute name must be colonwhen namespaces are enabled", this, null);
                    }
                }
                if (ch == ':') {
                    if (colonPos != -1) {
                        throw new XmlPullParserException("only one colon is allowed in attribute name when namespaces are enabled", this, null);
                    }
                    colonPos = this.pos - 1 + this.bufAbsoluteStart;
                }
            }
            ch = this.more();
        }
        this.ensureAttributesCapacity(this.attributeCount);
        String name = null;
        String prefix = null;
        if (this.processNamespaces) {
            if (xmlnsPos < 4) {
                startsWithXmlns = false;
            }
            if (startsWithXmlns) {
                if (colonPos != -1) {
                    int nameLen = this.pos - 2 - (colonPos - this.bufAbsoluteStart);
                    if (nameLen == 0) {
                        throw new XmlPullParserException("namespace prefix is required after xmlns:  when namespaces are enabled", this, null);
                    }
                    name = this.newString(this.buf, colonPos - this.bufAbsoluteStart + 1, nameLen);
                }
            } else {
                if (colonPos != -1) {
                    int prefixLen = colonPos - nameStart;
                    prefix = this.attributePrefix[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, prefixLen);
                    int nameLen = this.pos - 2 - (colonPos - this.bufAbsoluteStart);
                    name = this.attributeName[this.attributeCount] = this.newString(this.buf, colonPos - this.bufAbsoluteStart + 1, nameLen);
                } else {
                    this.attributePrefix[this.attributeCount] = null;
                    prefix = null;
                    name = this.attributeName[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, this.pos - 1 - (nameStart - this.bufAbsoluteStart));
                }
                if (!this.allStringsInterned) {
                    this.attributeNameHash[this.attributeCount] = name.hashCode();
                }
            }
        } else {
            name = this.attributeName[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, this.pos - 1 - (nameStart - this.bufAbsoluteStart));
            if (!this.allStringsInterned) {
                this.attributeNameHash[this.attributeCount] = name.hashCode();
            }
        }
        while (MXParser.isS(ch)) {
            ch = this.more();
        }
        if (ch != '=') {
            throw new XmlPullParserException("expected = after attribute name", this, null);
        }
        ch = this.more();
        while (MXParser.isS(ch)) {
            ch = this.more();
        }
        char delimit = ch;
        if (delimit != '\"' && delimit != '\'') {
            throw new XmlPullParserException("attribute value must start with quotation or apostrophe not " + MXParser.printable(delimit), this, null);
        }
        boolean normalizedCR = false;
        this.usePC = false;
        this.pcStart = this.pcEnd;
        this.posStart = this.pos;
        while ((ch = this.more()) != delimit) {
            if (ch == '<') {
                throw new XmlPullParserException("markup not allowed inside attribute value - illegal < ", this, null);
            }
            if (ch == '&') {
                this.extractEntityRef();
            } else if (ch == '\t' || ch == '\n' || ch == '\r') {
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcStart = 0;
                        this.pcEnd = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                if (ch != '\n' || !normalizedCR) {
                    this.pc[this.pcEnd++] = 32;
                }
            } else if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = ch;
            }
            normalizedCR = ch == '\r';
        }
        if (this.processNamespaces && startsWithXmlns) {
            String ns = null;
            ns = !this.usePC ? this.newStringIntern(this.buf, this.posStart, this.pos - 1 - this.posStart) : this.newStringIntern(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            this.ensureNamespacesCapacity(this.namespaceEnd);
            int prefixHash = -1;
            if (colonPos != -1) {
                if (ns.length() == 0) {
                    throw new XmlPullParserException("non-default namespace can not be declared to be empty string", this, null);
                }
                this.namespacePrefix[this.namespaceEnd] = name;
                if (!this.allStringsInterned) {
                    prefixHash = this.namespacePrefixHash[this.namespaceEnd] = name.hashCode();
                }
            } else {
                this.namespacePrefix[this.namespaceEnd] = null;
                if (!this.allStringsInterned) {
                    this.namespacePrefixHash[this.namespaceEnd] = -1;
                    prefixHash = -1;
                }
            }
            this.namespaceUri[this.namespaceEnd] = ns;
            int startNs = this.elNamespaceCount[this.depth - 1];
            for (int i = this.namespaceEnd - 1; i >= startNs; --i) {
                if ((!this.allStringsInterned && name != null || this.namespacePrefix[i] != name) && (this.allStringsInterned || name == null || this.namespacePrefixHash[i] != prefixHash || !name.equals(this.namespacePrefix[i]))) continue;
                String s = name == null ? "default" : "'" + name + "'";
                throw new XmlPullParserException("duplicated namespace declaration for " + s + " prefix", this, null);
            }
            ++this.namespaceEnd;
        } else {
            this.attributeValue[this.attributeCount] = !this.usePC ? new String(this.buf, this.posStart, this.pos - 1 - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            ++this.attributeCount;
        }
        this.posStart = prevPosStart - this.bufAbsoluteStart;
        return ch;
    }

    private int parseCharOrPredefinedEntityRef() throws XmlPullParserException, IOException {
        this.entityRefName = null;
        this.posStart = this.pos;
        int len = 0;
        this.resolvedEntityRefCharBuf = BUF_NOT_RESOLVED;
        char ch = this.more();
        if (ch == '#') {
            boolean isHex;
            int charRef = 0;
            ch = this.more();
            StringBuilder sb = new StringBuilder();
            boolean bl = isHex = ch == 'x';
            if (isHex) {
                while (true) {
                    if ((ch = this.more()) >= '0' && ch <= '9') {
                        charRef = (char)(charRef * 16 + (ch - 48));
                        sb.append(ch);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        charRef = (char)(charRef * 16 + (ch - 87));
                        sb.append(ch);
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') break;
                    charRef = (char)(charRef * 16 + (ch - 55));
                    sb.append(ch);
                }
                if (ch != ';') {
                    throw new XmlPullParserException("character reference (with hex value) may not contain " + MXParser.printable(ch), this, null);
                }
            } else {
                while (true) {
                    if (ch < '0' || ch > '9') {
                        if (ch == ';') break;
                        throw new XmlPullParserException("character reference (with decimal value) may not contain " + MXParser.printable(ch), this, null);
                    }
                    charRef = (char)(charRef * 10 + (ch - 48));
                    sb.append(ch);
                    ch = this.more();
                }
            }
            boolean isValidCodePoint = true;
            try {
                int codePoint = Integer.parseInt(sb.toString(), isHex ? 16 : 10);
                isValidCodePoint = MXParser.isValidCodePoint(codePoint);
                if (isValidCodePoint) {
                    this.resolvedEntityRefCharBuf = Character.toChars(codePoint);
                }
            }
            catch (IllegalArgumentException e) {
                isValidCodePoint = false;
            }
            if (!isValidCodePoint) {
                throw new XmlPullParserException("character reference (with " + (isHex ? "hex" : "decimal") + " value " + sb.toString() + ") is invalid", this, null);
            }
            if (this.tokenize) {
                this.text = this.newString(this.resolvedEntityRefCharBuf, 0, this.resolvedEntityRefCharBuf.length);
            }
            len = this.resolvedEntityRefCharBuf.length;
        } else {
            if (!MXParser.isNameStartChar(ch)) {
                throw new XmlPullParserException("entity reference names can not start with character '" + MXParser.printable(ch) + "'", this, null);
            }
            while ((ch = this.more()) != ';') {
                if (MXParser.isNameChar(ch)) continue;
                throw new XmlPullParserException("entity reference name can not contain character " + MXParser.printable(ch) + "'", this, null);
            }
            len = this.pos - 1 - this.posStart;
            if (len == 2 && this.buf[this.posStart] == 'l' && this.buf[this.posStart + 1] == 't') {
                if (this.tokenize) {
                    this.text = "<";
                }
                this.resolvedEntityRefCharBuf = BUF_LT;
            } else if (len == 3 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'm' && this.buf[this.posStart + 2] == 'p') {
                if (this.tokenize) {
                    this.text = "&";
                }
                this.resolvedEntityRefCharBuf = BUF_AMP;
            } else if (len == 2 && this.buf[this.posStart] == 'g' && this.buf[this.posStart + 1] == 't') {
                if (this.tokenize) {
                    this.text = ">";
                }
                this.resolvedEntityRefCharBuf = BUF_GT;
            } else if (len == 4 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'p' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 's') {
                if (this.tokenize) {
                    this.text = "'";
                }
                this.resolvedEntityRefCharBuf = BUF_APO;
            } else if (len == 4 && this.buf[this.posStart] == 'q' && this.buf[this.posStart + 1] == 'u' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 't') {
                if (this.tokenize) {
                    this.text = "\"";
                }
                this.resolvedEntityRefCharBuf = BUF_QUOT;
            }
        }
        this.posEnd = this.pos;
        return len;
    }

    private void parseEntityRefInDocDecl() throws XmlPullParserException, IOException {
        this.parseCharOrPredefinedEntityRef();
        if (this.usePC) {
            --this.posStart;
            this.joinPC();
        }
        if (this.resolvedEntityRefCharBuf != BUF_NOT_RESOLVED) {
            return;
        }
        if (this.tokenize) {
            this.text = null;
        }
    }

    private void parseEntityRef() throws XmlPullParserException, IOException {
        int len = this.parseCharOrPredefinedEntityRef();
        --this.posEnd;
        if (this.resolvedEntityRefCharBuf != BUF_NOT_RESOLVED) {
            return;
        }
        this.resolvedEntityRefCharBuf = this.lookuEntityReplacement(len);
        if (this.resolvedEntityRefCharBuf != BUF_NOT_RESOLVED) {
            return;
        }
        if (this.tokenize) {
            this.text = null;
        }
    }

    private static boolean isValidCodePoint(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || 32 <= codePoint && codePoint <= 55295 || 57344 <= codePoint && codePoint <= 65533 || 65536 <= codePoint && codePoint <= 0x10FFFF;
    }

    private char[] lookuEntityReplacement(int entityNameLen) {
        if (!this.allStringsInterned) {
            int hash = MXParser.fastHash(this.buf, this.posStart, this.posEnd - this.posStart);
            block0: for (int i = this.entityEnd - 1; i >= 0; --i) {
                if (hash != this.entityNameHash[i] || entityNameLen != this.entityNameBuf[i].length) continue;
                char[] entityBuf = this.entityNameBuf[i];
                for (int j = 0; j < entityNameLen; ++j) {
                    if (this.buf[this.posStart + j] != entityBuf[j]) continue block0;
                }
                if (this.tokenize) {
                    this.text = this.entityReplacement[i];
                }
                return this.entityReplacementBuf[i];
            }
        } else {
            this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            for (int i = this.entityEnd - 1; i >= 0; --i) {
                if (this.entityRefName != this.entityName[i]) continue;
                if (this.tokenize) {
                    this.text = this.entityReplacement[i];
                }
                return this.entityReplacementBuf[i];
            }
        }
        return BUF_NOT_RESOLVED;
    }

    private void parseComment() throws XmlPullParserException, IOException {
        int cch = this.more();
        if (cch != 45) {
            throw new XmlPullParserException("expected <!-- for comment start", this, null);
        }
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber - 4;
        try {
            boolean normalizeIgnorableWS = this.tokenize && !this.roundtripSupported;
            boolean normalizedCR = false;
            boolean seenDash = false;
            boolean seenDashDash = false;
            while (true) {
                int ch;
                char cch2;
                if (Character.isHighSurrogate((char)(cch = this.more()))) {
                    cch2 = this.more();
                    ch = Character.toCodePoint((char)cch, cch2);
                } else {
                    cch2 = '\u0000';
                    ch = cch;
                }
                if (seenDashDash && ch != 62) {
                    throw new XmlPullParserException("in comment after two dashes (--) next character must be > not " + MXParser.printable(ch), this, null);
                }
                if (ch == 45) {
                    if (!seenDash) {
                        seenDash = true;
                    } else {
                        seenDashDash = true;
                    }
                } else if (ch == 62) {
                    if (seenDashDash) break;
                    seenDash = false;
                } else if (MXParser.isValidCodePoint(ch)) {
                    seenDash = false;
                } else {
                    throw new XmlPullParserException("Illegal character 0x" + Integer.toHexString(ch) + " found in comment", this, null);
                }
                if (!normalizeIgnorableWS) continue;
                if (ch == 13) {
                    normalizedCR = true;
                    if (!this.usePC) {
                        this.posEnd = this.pos - 1;
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                    continue;
                }
                if (ch == 10) {
                    if (!normalizedCR && this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    }
                    normalizedCR = false;
                    continue;
                }
                if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = cch;
                    if (cch2 != '\u0000') {
                        this.pc[this.pcEnd++] = cch2;
                    }
                }
                normalizedCR = false;
            }
        }
        catch (EOFException ex) {
            throw new XmlPullParserException("comment started on line " + curLine + " and column " + curColumn + " was not closed", this, ex);
        }
        if (this.tokenize) {
            this.posEnd = this.pos - 3;
            if (this.usePC) {
                this.pcEnd -= 2;
            }
        }
    }

    private boolean parsePI() throws XmlPullParserException, IOException {
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber - 2;
        int piTargetStart = this.pos;
        int piTargetEnd = -1;
        boolean normalizeIgnorableWS = this.tokenize && !this.roundtripSupported;
        boolean normalizedCR = false;
        try {
            boolean seenPITarget = false;
            boolean seenInnerTag = false;
            boolean seenQ = false;
            char ch = this.more();
            if (MXParser.isS(ch)) {
                throw new XmlPullParserException("processing instruction PITarget must be exactly after <? and not white space character", this, null);
            }
            while (true) {
                if (ch == '?') {
                    if (!seenPITarget) {
                        throw new XmlPullParserException("processing instruction PITarget name not found", this, null);
                    }
                    seenQ = true;
                } else if (ch == '>') {
                    if (seenQ) break;
                    if (!seenPITarget) {
                        throw new XmlPullParserException("processing instruction PITarget name not found", this, null);
                    }
                    if (!seenInnerTag) {
                        throw new XmlPullParserException("processing instruction started on line " + curLine + " and column " + curColumn + " was not closed", this, null);
                    }
                    seenInnerTag = false;
                } else if (ch == '<') {
                    seenInnerTag = true;
                } else {
                    if (!(piTargetEnd != -1 || !MXParser.isS(ch) || (piTargetEnd = this.pos - 1) - piTargetStart < 3 || this.buf[piTargetStart] != 'x' && this.buf[piTargetStart] != 'X' || this.buf[piTargetStart + 1] != 'm' && this.buf[piTargetStart + 1] != 'M' || this.buf[piTargetStart + 2] != 'l' && this.buf[piTargetStart + 2] != 'L')) {
                        if (piTargetStart > 3) {
                            throw new XmlPullParserException("processing instruction can not have PITarget with reserved xml name", this, null);
                        }
                        if (this.buf[piTargetStart] != 'x' && this.buf[piTargetStart + 1] != 'm' && this.buf[piTargetStart + 2] != 'l') {
                            throw new XmlPullParserException("XMLDecl must have xml name in lowercase", this, null);
                        }
                        this.parseXmlDecl(ch);
                        if (this.tokenize) {
                            this.posEnd = this.pos - 2;
                        }
                        int off = piTargetStart + 3;
                        int len = this.pos - 2 - off;
                        this.xmlDeclContent = this.newString(this.buf, off, len);
                        return false;
                    }
                    seenQ = false;
                }
                if (normalizeIgnorableWS) {
                    if (ch == '\r') {
                        normalizedCR = true;
                        if (!this.usePC) {
                            this.posEnd = this.pos - 1;
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    } else if (ch == '\n') {
                        if (!normalizedCR && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        normalizedCR = false;
                    } else {
                        if (this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = ch;
                        }
                        normalizedCR = false;
                    }
                }
                seenPITarget = true;
                ch = this.more();
            }
        }
        catch (EOFException ex) {
            throw new XmlPullParserException("processing instruction started on line " + curLine + " and column " + curColumn + " was not closed", this, ex);
        }
        if (piTargetEnd == -1) {
            piTargetEnd = this.pos - 2 + this.bufAbsoluteStart;
        }
        if (this.tokenize) {
            this.posEnd = this.pos - 2;
            if (normalizeIgnorableWS) {
                --this.pcEnd;
            }
        }
        return true;
    }

    private void parseXmlDecl(char ch) throws XmlPullParserException, IOException {
        this.preventBufferCompaction = true;
        this.bufStart = 0;
        ch = this.skipS(ch);
        ch = this.requireInput(ch, VERSION);
        if ((ch = this.skipS(ch)) != '=') {
            throw new XmlPullParserException("expected equals sign (=) after version and not " + MXParser.printable(ch), this, null);
        }
        ch = this.more();
        if ((ch = this.skipS(ch)) != '\'' && ch != '\"') {
            throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after version and not " + MXParser.printable(ch), this, null);
        }
        char quotChar = ch;
        int versionStart = this.pos;
        ch = this.more();
        while (ch != quotChar) {
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == ':' || ch == '-')) {
                throw new XmlPullParserException("<?xml version value expected to be in ([a-zA-Z0-9_.:] | '-') not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
        }
        int versionEnd = this.pos - 1;
        this.parseXmlDeclWithVersion(versionStart, versionEnd);
        this.preventBufferCompaction = false;
    }

    private void parseXmlDeclWithVersion(int versionStart, int versionEnd) throws XmlPullParserException, IOException {
        char quotChar;
        char ch;
        if (versionEnd - versionStart != 3 || this.buf[versionStart] != '1' || this.buf[versionStart + 1] != '.' || this.buf[versionStart + 2] != '0') {
            throw new XmlPullParserException("only 1.0 is supported as <?xml version not '" + MXParser.printable(new String(this.buf, versionStart, versionEnd - versionStart)) + "'", this, null);
        }
        this.xmlDeclVersion = this.newString(this.buf, versionStart, versionEnd - versionStart);
        String lastParsedAttr = "version";
        char prevCh = ch = this.more();
        if ((ch = this.skipS(ch)) != 'e' && ch != 's' && ch != '?' && ch != '>') {
            throw new XmlPullParserException("unexpected character " + MXParser.printable(ch), this, null);
        }
        if (ch == 'e') {
            if (!MXParser.isS(prevCh)) {
                throw new XmlPullParserException("expected a space after " + lastParsedAttr + " and not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
            ch = this.requireInput(ch, NCODING);
            if ((ch = this.skipS(ch)) != '=') {
                throw new XmlPullParserException("expected equals sign (=) after encoding and not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
            if ((ch = this.skipS(ch)) != '\'' && ch != '\"') {
                throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after encoding and not " + MXParser.printable(ch), this, null);
            }
            quotChar = ch;
            int encodingStart = this.pos;
            ch = this.more();
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                throw new XmlPullParserException("<?xml encoding name expected to start with [A-Za-z] not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
            while (ch != quotChar) {
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '_' || ch == '-')) {
                    throw new XmlPullParserException("<?xml encoding value expected to be in ([A-Za-z0-9._] | '-') not " + MXParser.printable(ch), this, null);
                }
                ch = this.more();
            }
            int encodingEnd = this.pos - 1;
            this.inputEncoding = this.newString(this.buf, encodingStart, encodingEnd - encodingStart);
            if ("UTF8".equals(this.fileEncoding) && this.inputEncoding.toUpperCase().startsWith("ISO-")) {
                throw new XmlPullParserException("UTF-8 BOM plus xml decl of " + this.inputEncoding + " is incompatible", this, null);
            }
            if ("UTF-16".equals(this.fileEncoding) && this.inputEncoding.equalsIgnoreCase("UTF-8")) {
                throw new XmlPullParserException("UTF-16 BOM plus xml decl of " + this.inputEncoding + " is incompatible", this, null);
            }
            lastParsedAttr = "encoding";
            prevCh = ch = this.more();
            ch = this.skipS(ch);
        }
        if (ch == 's') {
            if (!MXParser.isS(prevCh)) {
                throw new XmlPullParserException("expected a space after " + lastParsedAttr + " and not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
            ch = this.requireInput(ch, TANDALONE);
            if ((ch = this.skipS(ch)) != '=') {
                throw new XmlPullParserException("expected equals sign (=) after standalone and not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
            if ((ch = this.skipS(ch)) != '\'' && ch != '\"') {
                throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after standalone and not " + MXParser.printable(ch), this, null);
            }
            quotChar = ch;
            ch = this.more();
            if (ch == 'y') {
                ch = this.requireInput(ch, YES);
                this.xmlDeclStandalone = true;
            } else if (ch == 'n') {
                ch = this.requireInput(ch, NO);
                this.xmlDeclStandalone = false;
            } else {
                throw new XmlPullParserException("expected 'yes' or 'no' after standalone and not " + MXParser.printable(ch), this, null);
            }
            if (ch != quotChar) {
                throw new XmlPullParserException("expected " + quotChar + " after standalone value not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
            ch = this.skipS(ch);
        }
        if (ch != '?') {
            throw new XmlPullParserException("expected ?> as last part of <?xml not " + MXParser.printable(ch), this, null);
        }
        ch = this.more();
        if (ch != '>') {
            throw new XmlPullParserException("expected ?> as last part of <?xml not " + MXParser.printable(ch), this, null);
        }
    }

    private void parseDocdecl() throws XmlPullParserException, IOException {
        char ch = this.more();
        if (ch != 'O') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        ch = this.more();
        if (ch != 'C') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        ch = this.more();
        if (ch != 'T') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        ch = this.more();
        if (ch != 'Y') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        ch = this.more();
        if (ch != 'P') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        ch = this.more();
        if (ch != 'E') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        this.posStart = this.pos;
        int bracketLevel = 0;
        boolean normalizeIgnorableWS = this.tokenize && !this.roundtripSupported;
        boolean normalizedCR = false;
        while (true) {
            if ((ch = this.more()) == '[') {
                ++bracketLevel;
            } else if (ch == ']') {
                --bracketLevel;
            } else {
                if (ch == '>' && bracketLevel == 0) break;
                if (ch == '&') {
                    this.extractEntityRefInDocDecl();
                    continue;
                }
            }
            if (!normalizeIgnorableWS) continue;
            if (ch == '\r') {
                normalizedCR = true;
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcEnd = 0;
                        this.pcStart = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = 10;
                continue;
            }
            if (ch == '\n') {
                if (!normalizedCR && this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                }
                normalizedCR = false;
                continue;
            }
            if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = ch;
            }
            normalizedCR = false;
        }
        this.posEnd = this.pos - 1;
        this.text = null;
    }

    private void extractEntityRefInDocDecl() throws XmlPullParserException, IOException {
        this.posEnd = this.pos - 1;
        int prevPosStart = this.posStart;
        this.parseEntityRefInDocDecl();
        this.posStart = prevPosStart;
    }

    private void extractEntityRef() throws XmlPullParserException, IOException {
        this.posEnd = this.pos - 1;
        if (!this.usePC) {
            boolean hadCharData;
            boolean bl = hadCharData = this.posEnd > this.posStart;
            if (hadCharData) {
                this.joinPC();
            } else {
                this.usePC = true;
                this.pcEnd = 0;
                this.pcStart = 0;
            }
        }
        this.parseEntityRef();
        if (this.resolvedEntityRefCharBuf == BUF_NOT_RESOLVED) {
            if (this.entityRefName == null) {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            }
            throw new XmlPullParserException("could not resolve entity named '" + MXParser.printable(this.entityRefName) + "'", this, null);
        }
        for (char aResolvedEntity : this.resolvedEntityRefCharBuf) {
            if (this.pcEnd >= this.pc.length) {
                this.ensurePC(this.pcEnd);
            }
            this.pc[this.pcEnd++] = aResolvedEntity;
        }
    }

    private void parseCDSect(boolean hadCharData) throws XmlPullParserException, IOException {
        char ch = this.more();
        if (ch != 'C') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        ch = this.more();
        if (ch != 'D') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        ch = this.more();
        if (ch != 'A') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        ch = this.more();
        if (ch != 'T') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        ch = this.more();
        if (ch != 'A') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        ch = this.more();
        if (ch != '[') {
            throw new XmlPullParserException("expected <![CDATA[ for comment start", this, null);
        }
        int cdStart = this.pos + this.bufAbsoluteStart;
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber;
        boolean normalizeInput = !this.tokenize || !this.roundtripSupported;
        try {
            if (normalizeInput && hadCharData && !this.usePC) {
                if (this.posEnd > this.posStart) {
                    this.joinPC();
                } else {
                    this.usePC = true;
                    this.pcEnd = 0;
                    this.pcStart = 0;
                }
            }
            boolean seenBracket = false;
            boolean seenBracketBracket = false;
            boolean normalizedCR = false;
            while (true) {
                if ((ch = this.more()) == ']') {
                    if (!seenBracket) {
                        seenBracket = true;
                    } else {
                        seenBracketBracket = true;
                    }
                } else if (ch == '>') {
                    if (seenBracket && seenBracketBracket) break;
                    seenBracketBracket = false;
                    seenBracket = false;
                } else if (seenBracket) {
                    seenBracket = false;
                }
                if (!normalizeInput) continue;
                if (ch == '\r') {
                    normalizedCR = true;
                    this.posStart = cdStart - this.bufAbsoluteStart;
                    this.posEnd = this.pos - 1;
                    if (!this.usePC) {
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                    continue;
                }
                if (ch == '\n') {
                    if (!normalizedCR && this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    }
                    normalizedCR = false;
                    continue;
                }
                if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = ch;
                }
                normalizedCR = false;
            }
        }
        catch (EOFException ex) {
            throw new XmlPullParserException("CDATA section started on line " + curLine + " and column " + curColumn + " was not closed", this, ex);
        }
        if (normalizeInput && this.usePC) {
            this.pcEnd -= 2;
        }
        this.posStart = cdStart - this.bufAbsoluteStart;
        this.posEnd = this.pos - 3;
    }

    private void fillBuf() throws IOException, XmlPullParserException {
        int len;
        int ret;
        if (this.reader == null) {
            throw new XmlPullParserException("reader must be set before parsing is started");
        }
        if (this.bufEnd > this.bufSoftLimit) {
            boolean compact;
            boolean bl = compact = !this.preventBufferCompaction && (this.bufStart > this.bufSoftLimit || this.bufStart >= this.buf.length / 2);
            if (compact) {
                System.arraycopy(this.buf, this.bufStart, this.buf, 0, this.bufEnd - this.bufStart);
            } else {
                int newSize = 2 * this.buf.length;
                char[] newBuf = new char[newSize];
                System.arraycopy(this.buf, this.bufStart, newBuf, 0, this.bufEnd - this.bufStart);
                this.buf = newBuf;
                if (this.bufLoadFactor > 0) {
                    this.bufSoftLimit = (int)(this.bufferLoadFactor * (float)this.buf.length);
                }
            }
            this.bufEnd -= this.bufStart;
            this.pos -= this.bufStart;
            this.posStart -= this.bufStart;
            this.posEnd -= this.bufStart;
            this.bufAbsoluteStart += this.bufStart;
            this.bufStart = 0;
        }
        if ((ret = this.reader.read(this.buf, this.bufEnd, len = Math.min(this.buf.length - this.bufEnd, 8192))) > 0) {
            this.bufEnd += ret;
            return;
        }
        if (ret == -1) {
            if (this.bufAbsoluteStart == 0 && this.pos == 0) {
                throw new EOFException("input contained no data");
            }
            if (this.seenRoot && this.depth == 0) {
                this.reachedEnd = true;
                return;
            }
            StringBuilder expectedTagStack = new StringBuilder();
            if (this.depth > 0) {
                if (this.elRawName == null || this.elRawName[this.depth] == null) {
                    String tagName = new String(this.buf, this.posStart + 1, this.pos - this.posStart - 1);
                    expectedTagStack.append(" - expected the opening tag <").append(tagName).append("...>");
                } else {
                    String tagName;
                    int i;
                    expectedTagStack.append(" - expected end tag");
                    if (this.depth > 1) {
                        expectedTagStack.append("s");
                    }
                    expectedTagStack.append(" ");
                    for (i = this.depth; i > 0; --i) {
                        if (this.elRawName == null || this.elRawName[i] == null) {
                            tagName = new String(this.buf, this.posStart + 1, this.pos - this.posStart - 1);
                            expectedTagStack.append(" - expected the opening tag <").append(tagName).append("...>");
                            continue;
                        }
                        tagName = new String(this.elRawName[i], 0, this.elRawNameEnd[i]);
                        expectedTagStack.append("</").append(tagName).append('>');
                    }
                    expectedTagStack.append(" to close");
                    for (i = this.depth; i > 0; --i) {
                        if (i != this.depth) {
                            expectedTagStack.append(" and");
                        }
                        if (this.elRawName == null || this.elRawName[i] == null) {
                            tagName = new String(this.buf, this.posStart + 1, this.pos - this.posStart - 1);
                            expectedTagStack.append(" start tag <").append(tagName).append(">");
                            expectedTagStack.append(" from line ").append(this.elRawNameLine[i]);
                            continue;
                        }
                        tagName = new String(this.elRawName[i], 0, this.elRawNameEnd[i]);
                        expectedTagStack.append(" start tag <").append(tagName).append(">");
                        expectedTagStack.append(" from line ").append(this.elRawNameLine[i]);
                    }
                    expectedTagStack.append(", parser stopped on");
                }
            }
            throw new EOFException("no more data available" + expectedTagStack.toString() + this.getPositionDescription());
        }
        throw new IOException("error reading input, returned " + ret);
    }

    private char more() throws IOException, XmlPullParserException {
        char ch;
        if (this.pos >= this.bufEnd) {
            this.fillBuf();
            if (this.reachedEnd) {
                throw new EOFException("no more data available" + this.getPositionDescription());
            }
        }
        if ((ch = this.buf[this.pos++]) == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        return ch;
    }

    private void ensurePC(int end) {
        int newSize = end > 8192 ? 2 * end : 16384;
        char[] newPC = new char[newSize];
        System.arraycopy(this.pc, 0, newPC, 0, this.pcEnd);
        this.pc = newPC;
    }

    private void joinPC() {
        int len = this.posEnd - this.posStart;
        int newEnd = this.pcEnd + len + 1;
        if (newEnd >= this.pc.length) {
            this.ensurePC(newEnd);
        }
        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
        this.pcEnd += len;
        this.usePC = true;
    }

    private char requireInput(char ch, char[] input) throws XmlPullParserException, IOException {
        for (char anInput : input) {
            if (ch != anInput) {
                throw new XmlPullParserException("expected " + MXParser.printable(anInput) + " in " + new String(input) + " and not " + MXParser.printable(ch), this, null);
            }
            ch = this.more();
        }
        return ch;
    }

    private char skipS(char ch) throws XmlPullParserException, IOException {
        while (MXParser.isS(ch)) {
            ch = this.more();
        }
        return ch;
    }

    private static void setName(char ch) {
        MXParser.lookupNameChar[ch] = true;
    }

    private static void setNameStart(char ch) {
        MXParser.lookupNameStartChar[ch] = true;
        MXParser.setName(ch);
    }

    private static boolean isNameStartChar(char ch) {
        return ch < '\u0400' ? lookupNameStartChar[ch] : ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    private static boolean isNameChar(char ch) {
        return ch < '\u0400' ? lookupNameChar[ch] : ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    private static boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    private static String printable(int ch) {
        if (ch == 10) {
            return "\\n";
        }
        if (ch == 13) {
            return "\\r";
        }
        if (ch == 9) {
            return "\\t";
        }
        if (ch == 39) {
            return "\\'";
        }
        if (ch > 127 || ch < 32) {
            return "\\u" + Integer.toHexString(ch);
        }
        if (Character.isBmpCodePoint(ch)) {
            return Character.toString((char)ch);
        }
        return new String(new char[]{Character.highSurrogate(ch), Character.lowSurrogate(ch)});
    }

    private static String printable(String s) {
        if (s == null) {
            return null;
        }
        int sLen = s.codePointCount(0, s.length());
        StringBuilder buf = new StringBuilder(sLen + 10);
        for (int i = 0; i < sLen; ++i) {
            buf.append(MXParser.printable(s.codePointAt(i)));
        }
        s = buf.toString();
        return s;
    }

    static {
        char ch;
        BUF_NOT_RESOLVED = new char[0];
        BUF_LT = new char[]{'<'};
        BUF_AMP = new char[]{'&'};
        BUF_GT = new char[]{'>'};
        BUF_APO = new char[]{'\''};
        BUF_QUOT = new char[]{'\"'};
        VERSION = "version".toCharArray();
        NCODING = "ncoding".toCharArray();
        TANDALONE = "tandalone".toCharArray();
        YES = "yes".toCharArray();
        NO = "no".toCharArray();
        lookupNameStartChar = new boolean[1024];
        lookupNameChar = new boolean[1024];
        MXParser.setNameStart(':');
        for (ch = 'A'; ch <= 'Z'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        MXParser.setNameStart('_');
        for (ch = 'a'; ch <= 'z'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        for (ch = '\u00c0'; ch <= '\u02ff'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        for (ch = '\u0370'; ch <= '\u037d'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        for (ch = '\u037f'; ch < '\u0400'; ch = (char)((char)(ch + '\u0001'))) {
            MXParser.setNameStart(ch);
        }
        MXParser.setName('-');
        MXParser.setName('.');
        for (ch = '0'; ch <= '9'; ch = (char)((char)(ch + 1))) {
            MXParser.setName(ch);
        }
        MXParser.setName('\u00b7');
        for (ch = '\u0300'; ch <= '\u036f'; ch = (char)(ch + '\u0001')) {
            MXParser.setName(ch);
        }
    }
}

