/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferTypeParameterType;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.ConeAtomWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConeLambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateTraversalKt;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeParameterBasedTypeVariable;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaParameterType;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsAnalyzerKt;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeFixVariableConstraintPosition;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.components.PostponedArgumentInputTypesResolver;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDependencyInformationProvider;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.NotEnoughInformationForTypeParameter;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedAtomWithRevisableExpectedType;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ:\u0010\u001d\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J:\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J*\u0010#\u001a\u00020$*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010%\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0002J8\u0010)\u001a\u00020$*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0015H\u0002J8\u0010*\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0015H\u0002J\"\u0010+\u001a\u00020\u000f*\u00020\u00112\u0006\u0010,\u001a\u00020-2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J \u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0015*\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "variableFixationFinder", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "postponedArgumentsInputTypesResolver", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/PostponedArgumentInputTypesResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "complete", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionContext;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "topLevelAtoms", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "candidateReturnType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "analyzer", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter$PostponedAtomAnalyzer;", "runCompletion", "topLevelType", "findFirstVariableForFixation", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$VariableForFixation;", "postponedArguments", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConePostponedResolvedAtom;", "tryToCompleteWithPCLA", "", "transformToAtomWithNewFunctionExpectedType", "resolutionContext", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedAtomWithRevisableExpectedType;", "fixNextReadyVariable", "reportNotEnoughTypeInformation", "processVariableWhenNotEnoughInformation", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getOrderedAllTypeVariables", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "fixVariable", "PostponedAtomAnalyzer", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nConstraintSystemCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintSystemCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,485:1\n808#2,11:486\n808#2,11:497\n1374#2:509\n1460#2,5:510\n774#2:515\n865#2,2:516\n1625#2:518\n1869#2:519\n1870#2:521\n1626#2:522\n1#3:508\n1#3:520\n*S KotlinDebug\n*F\n+ 1 ConstraintSystemCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter\n*L\n106#1:486,11\n223#1:497,11\n227#1:509\n227#1:510,5\n227#1:515\n227#1:516,2\n352#1:518\n352#1:519\n352#1:521\n352#1:522\n352#1:520\n*E\n"})
public final class ConstraintSystemCompleter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InferenceComponents inferenceComponents;
    @NotNull
    private final VariableFixationFinder variableFixationFinder;
    @NotNull
    private final PostponedArgumentInputTypesResolver postponedArgumentsInputTypesResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public ConstraintSystemCompleter(@NotNull BodyResolveComponents components) {
        Intrinsics.checkNotNullParameter(components, "components");
        this.inferenceComponents = InferenceComponentsKt.getInferenceComponents(components.getSession());
        this.variableFixationFinder = this.inferenceComponents.getVariableFixationFinder();
        this.postponedArgumentsInputTypesResolver = this.inferenceComponents.getPostponedArgumentInputTypesResolver();
        this.languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(components.getSession());
    }

    public final void complete(@NotNull ConstraintSystemCompletionContext c, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull List<? extends ConeResolutionAtom> topLevelAtoms, @NotNull ConeKotlinType candidateReturnType, @NotNull ResolutionContext context, @NotNull PostponedAtomAnalyzer analyzer2) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter((Object)completionMode, "completionMode");
        Intrinsics.checkNotNullParameter(topLevelAtoms, "topLevelAtoms");
        Intrinsics.checkNotNullParameter(candidateReturnType, "candidateReturnType");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(analyzer2, "analyzer");
        this.runCompletion(c, completionMode, topLevelAtoms, candidateReturnType, context, analyzer2);
    }

    private final void runCompletion(ConstraintSystemCompletionContext $this$runCompletion, ConstraintSystemCompletionMode completionMode, List<? extends ConeResolutionAtom> topLevelAtoms, ConeKotlinType topLevelType, ResolutionContext context, PostponedAtomAnalyzer analyzer2) {
        Set<TypeVariableTypeConstructorMarker> topLevelTypeVariables = $this$runCompletion.extractTypeVariables(topLevelType);
        block0: while (true) {
            boolean areThereAppearedProperConstraintsForSomeVariable;
            Iterator $this$filterIsInstanceTo$iv$iv;
            boolean isThereAnyReadyForFixationVariable;
            if (completionMode.getShouldForkPointConstraintsBeResolved()) {
                $this$runCompletion.resolveForkPointsConstraints();
            }
            List postponedArguments = ConstraintSystemCompleter.Companion.getOrderedNotAnalyzedPostponedArguments(topLevelAtoms);
            if (completionMode == ConstraintSystemCompletionMode.UNTIL_FIRST_LAMBDA && $this$runCompletion.hasLambdaToAnalyze(this.languageVersionSettings, postponedArguments)) {
                return;
            }
            if ($this$runCompletion.analyzeArgumentWithFixedParameterTypes(this.languageVersionSettings, postponedArguments, arg_0 -> ConstraintSystemCompleter.runCompletion$lambda$0(analyzer2, arg_0))) continue;
            boolean bl = isThereAnyReadyForFixationVariable = this.findFirstVariableForFixation($this$runCompletion, topLevelAtoms, postponedArguments, completionMode, topLevelType) != null;
            if (postponedArguments.isEmpty() && !isThereAnyReadyForFixationVariable) break;
            Iterable $this$filterIsInstance$iv = postponedArguments;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof PostponedAtomWithRevisableExpectedType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List postponedArgumentsWithRevisableType = (List)destination$iv$iv;
            TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider($this$runCompletion.getNotFixedTypeVariables(), postponedArguments, topLevelType, $this$runCompletion, this.languageVersionSettings);
            boolean wasBuiltNewExpectedTypeForSomeArgument = this.postponedArgumentsInputTypesResolver.collectParameterTypesAndBuildNewExpectedTypes($this$runCompletion, postponedArgumentsWithRevisableType, completionMode, dependencyProvider, topLevelTypeVariables);
            if (wasBuiltNewExpectedTypeForSomeArgument) continue;
            if (completionMode.getAllLambdasShouldBeAnalyzed()) {
                PostponedResolvedAtomMarker argument;
                $this$filterIsInstanceTo$iv$iv = postponedArguments.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    argument = (ConePostponedResolvedAtom)$this$filterIsInstanceTo$iv$iv.next();
                    boolean variableWasFixed = this.postponedArgumentsInputTypesResolver.fixNextReadyVariableForParameterTypeIfNeeded($this$runCompletion, argument, postponedArguments, topLevelType, dependencyProvider, ConstraintSystemCompleter::runCompletion$lambda$1);
                    if (!variableWasFixed) continue;
                    continue block0;
                }
                $this$filterIsInstanceTo$iv$iv = postponedArgumentsWithRevisableType.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    argument = (PostponedAtomWithRevisableExpectedType)$this$filterIsInstanceTo$iv$iv.next();
                    boolean argumentWasTransformed = this.transformToAtomWithNewFunctionExpectedType($this$runCompletion, context, (PostponedAtomWithRevisableExpectedType)argument);
                    if (!argumentWasTransformed) continue;
                    continue block0;
                }
            }
            if ($this$runCompletion.analyzeNextReadyPostponedArgument(this.languageVersionSettings, postponedArguments, completionMode, arg_0 -> ConstraintSystemCompleter.runCompletion$lambda$2(analyzer2, arg_0)) || this.fixNextReadyVariable($this$runCompletion, completionMode, topLevelAtoms, topLevelType, postponedArguments) || (areThereAppearedProperConstraintsForSomeVariable = this.tryToCompleteWithPCLA($this$runCompletion, completionMode, postponedArguments, analyzer2))) continue;
            if (completionMode.getFixNotInferredTypeVariablesToErrorType()) {
                this.reportNotEnoughTypeInformation($this$runCompletion, completionMode, topLevelAtoms, topLevelType, postponedArguments);
            }
            if (!completionMode.getAllLambdasShouldBeAnalyzed() || !$this$runCompletion.analyzeRemainingNotAnalyzedPostponedArgument(postponedArguments, arg_0 -> ConstraintSystemCompleter.runCompletion$lambda$3(analyzer2, arg_0))) break;
        }
    }

    private final VariableFixationFinder.VariableForFixation findFirstVariableForFixation(ConstraintSystemCompletionContext $this$findFirstVariableForFixation, List<? extends ConeResolutionAtom> topLevelAtoms, List<? extends ConePostponedResolvedAtom> postponedArguments, ConstraintSystemCompletionMode completionMode, ConeKotlinType topLevelType) {
        List<TypeConstructorMarker> allTypeVariables = this.getOrderedAllTypeVariables($this$findFirstVariableForFixation, topLevelAtoms);
        return this.variableFixationFinder.findFirstVariableForFixation($this$findFirstVariableForFixation, allTypeVariables, postponedArguments, completionMode, topLevelType);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryToCompleteWithPCLA(ConstraintSystemCompletionContext $this$tryToCompleteWithPCLA, ConstraintSystemCompletionMode completionMode, List<? extends ConePostponedResolvedAtom> postponedArguments, PostponedAtomAnalyzer analyzer2) {
        void $this$filterIsInstanceTo$iv$iv;
        if (!completionMode.getAllLambdasShouldBeAnalyzed()) {
            return false;
        }
        Iterable $this$filterIsInstance$iv = postponedArguments;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConeResolvedLambdaAtom)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        List it = list;
        boolean bl = false;
        Object object = !((Collection)it).isEmpty() ? list : null;
        if (object == null) {
            return false;
        }
        List lambdaArguments = object;
        boolean anyAnalyzed = false;
        for (ConeResolvedLambdaAtom argument : lambdaArguments) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object it2;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = argument.getInputTypes();
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it2 = (ConeKotlinType)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = $this$tryToCompleteWithPCLA.extractTypeVariables((KotlinTypeMarker)it2);
                kotlin.collections.CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (TypeVariableTypeConstructorMarker)element$iv$iv;
                boolean bl3 = false;
                if (!(!$this$tryToCompleteWithPCLA.getFixedTypeVariables().containsKey(it2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List notFixedInputTypeVariables = (List)destination$iv$iv2;
            if (notFixedInputTypeVariables.isEmpty()) continue;
            analyzer2.analyze(argument, true);
            anyAnalyzed = true;
        }
        return anyAnalyzed;
    }

    private final boolean transformToAtomWithNewFunctionExpectedType(ConstraintSystemCompletionContext c, ResolutionContext resolutionContext, PostponedAtomWithRevisableExpectedType argument) {
        KotlinTypeMarker kotlinTypeMarker;
        ConstraintSystemCompletionContext $this$transformToAtomWithNewFunctionExpectedType_u24lambda_u248 = c;
        boolean bl = false;
        KotlinTypeMarker kotlinTypeMarker2 = argument.getRevisedExpectedType();
        if (kotlinTypeMarker2 != null) {
            KotlinTypeMarker kotlinTypeMarker3;
            KotlinTypeMarker it = kotlinTypeMarker3 = kotlinTypeMarker2;
            boolean bl2 = false;
            kotlinTypeMarker = $this$transformToAtomWithNewFunctionExpectedType_u24lambda_u248.isFunctionOrKFunctionWithAnySuspendability(it) ? kotlinTypeMarker3 : null;
        } else {
            kotlinTypeMarker = null;
        }
        ConeKotlinType coneKotlinType = (ConeKotlinType)kotlinTypeMarker;
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType revisedExpectedType = coneKotlinType;
        PostponedAtomWithRevisableExpectedType postponedAtomWithRevisableExpectedType = argument;
        if (postponedAtomWithRevisableExpectedType instanceof ConeResolvedCallableReferenceAtom) {
            if (!((ConeResolvedCallableReferenceAtom)argument).getNeedsResolution()) {
                return false;
            }
            ((ConeResolvedCallableReferenceAtom)argument).reviseExpectedType(revisedExpectedType);
        } else if (postponedAtomWithRevisableExpectedType instanceof ConeLambdaWithTypeVariableAsExpectedTypeAtom) {
            PostponedArgumentsAnalyzerKt.transformToResolvedLambda$default((ConeLambdaWithTypeVariableAsExpectedTypeAtom)argument, c.getBuilder(), resolutionContext, revisedExpectedType, null, 8, null);
        } else {
            throw new IllegalStateException("Unsupported postponed argument type of " + argument);
        }
        return true;
    }

    private final boolean fixNextReadyVariable(ConstraintSystemCompletionContext $this$fixNextReadyVariable, ConstraintSystemCompletionMode completionMode, List<? extends ConeResolutionAtom> topLevelAtoms, ConeKotlinType topLevelType, List<? extends ConePostponedResolvedAtom> postponedArguments) {
        VariableFixationFinder.VariableForFixation variableForFixation = this.findFirstVariableForFixation($this$fixNextReadyVariable, topLevelAtoms, postponedArguments, completionMode, topLevelType);
        if (variableForFixation == null) {
            return false;
        }
        VariableFixationFinder.VariableForFixation variableForFixation2 = variableForFixation;
        VariableWithConstraints variableWithConstraints = MapsKt.getValue($this$fixNextReadyVariable.getNotFixedTypeVariables(), variableForFixation2.getVariable());
        if (!variableForFixation2.isReady()) {
            return false;
        }
        this.fixVariable($this$fixNextReadyVariable, variableWithConstraints);
        return true;
    }

    private final void reportNotEnoughTypeInformation(ConstraintSystemCompletionContext $this$reportNotEnoughTypeInformation, ConstraintSystemCompletionMode completionMode, List<? extends ConeResolutionAtom> topLevelAtoms, ConeKotlinType topLevelType, List<? extends ConePostponedResolvedAtom> postponedArguments) {
        while (this.findFirstVariableForFixation($this$reportNotEnoughTypeInformation, topLevelAtoms, postponedArguments, completionMode, topLevelType) != null) {
            VariableFixationFinder.VariableForFixation variableForFixation;
            boolean bl;
            boolean bl2 = bl = !variableForFixation.isReady();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "At this stage there should be no remaining variables with proper constraints";
                throw new AssertionError((Object)string2);
            }
            VariableWithConstraints variableWithConstraints = MapsKt.getValue($this$reportNotEnoughTypeInformation.getNotFixedTypeVariables(), variableForFixation.getVariable());
            this.processVariableWhenNotEnoughInformation($this$reportNotEnoughTypeInformation, variableWithConstraints, topLevelAtoms);
        }
    }

    private final void processVariableWhenNotEnoughInformation(ConstraintSystemCompletionContext $this$processVariableWhenNotEnoughInformation, VariableWithConstraints variableWithConstraints, List<? extends ConeResolutionAtom> topLevelAtoms) {
        TypeVariableMarker typeVariableMarker;
        FirStatement resolvedAtom;
        TypeVariableMarker typeVariable = variableWithConstraints.getTypeVariable();
        FirStatement firStatement = ConstraintSystemCompleter.Companion.findStatementOfFirstAtomWithVariable(typeVariable, topLevelAtoms);
        if (firStatement == null) {
            ConeResolutionAtom coneResolutionAtom = kotlin.collections.CollectionsKt.firstOrNull(topLevelAtoms);
            firStatement = coneResolutionAtom != null ? coneResolutionAtom.getExpression() : null;
        }
        if ((resolvedAtom = firStatement) != null) {
            $this$processVariableWhenNotEnoughInformation.addError(new NotEnoughInformationForTypeParameter<FirStatement>(typeVariable, resolvedAtom, $this$processVariableWhenNotEnoughInformation.couldBeResolvedWithUnrestrictedBuilderInference()));
        }
        ConeErrorType resultErrorType = (typeVariableMarker = typeVariable) instanceof ConeTypeParameterBasedTypeVariable ? ConstraintSystemCompleter.Companion.createCannotInferErrorType(((ConeTypeParameterBasedTypeVariable)typeVariable).getTypeParameterSymbol(), "Cannot infer argument for type parameter " + ((ConeTypeParameterBasedTypeVariable)typeVariable).getTypeParameterSymbol().getName(), true) : (typeVariableMarker instanceof ConeTypeVariableForLambdaParameterType ? org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter$Companion.createCannotInferErrorType$default(Companion, null, "Cannot infer lambda parameter type", false, 4, null) : org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter$Companion.createCannotInferErrorType$default(Companion, null, "Cannot infer type variable " + typeVariable, false, 4, null));
        $this$processVariableWhenNotEnoughInformation.fixVariable(typeVariable, resultErrorType, new ConeFixVariableConstraintPosition(typeVariable));
    }

    private final List<TypeConstructorMarker> getOrderedAllTypeVariables(ConstraintSystemCompletionContext $this$getOrderedAllTypeVariables, List<? extends ConeResolutionAtom> topLevelAtoms) {
        LinkedHashSet<TypeConstructorMarker> result2 = new LinkedHashSet<TypeConstructorMarker>($this$getOrderedAllTypeVariables.getNotFixedTypeVariables().size());
        for (ConeResolutionAtom coneResolutionAtom : topLevelAtoms) {
            ConstraintSystemCompleter.getOrderedAllTypeVariables$collectAllTypeVariables(coneResolutionAtom, result2, $this$getOrderedAllTypeVariables);
        }
        return kotlin.collections.CollectionsKt.toList((Iterable)result2);
    }

    private final void fixVariable(ConstraintSystemCompletionContext c, VariableWithConstraints variableWithConstraints) {
        KotlinTypeMarker resultType = this.inferenceComponents.getResultTypeResolver().findResultType(c, variableWithConstraints, TypeVariableDirectionCalculator.ResolveDirection.UNKNOWN);
        TypeVariableMarker variable = variableWithConstraints.getTypeVariable();
        c.fixVariable(variable, resultType, new ConeFixVariableConstraintPosition(variable));
    }

    private static final Unit runCompletion$lambda$0(PostponedAtomAnalyzer $analyzer, ConePostponedResolvedAtom it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $analyzer.analyze(it, false);
        return Unit.INSTANCE;
    }

    private static final Object runCompletion$lambda$1(TypeVariableMarker it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return null;
    }

    private static final Unit runCompletion$lambda$2(PostponedAtomAnalyzer $analyzer, ConePostponedResolvedAtom it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $analyzer.analyze(it, false);
        return Unit.INSTANCE;
    }

    private static final Unit runCompletion$lambda$3(PostponedAtomAnalyzer $analyzer, ConePostponedResolvedAtom it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $analyzer.analyze(it, false);
        return Unit.INSTANCE;
    }

    private static final TypeConstructorMarker getOrderedAllTypeVariables$toTypeConstructor(ConeTypeVariable $this$getOrderedAllTypeVariables_u24toTypeConstructor, ConstraintSystemCompletionContext $this_getOrderedAllTypeVariables) {
        Object object;
        Object object2 = $this$getOrderedAllTypeVariables_u24toTypeConstructor;
        if (object2 != null && (object2 = ((ConeTypeVariable)object2).getTypeConstructor()) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            object = $this_getOrderedAllTypeVariables.getNotFixedTypeVariables().keySet().contains(it) ? object3 : null;
        } else {
            object = null;
        }
        return (TypeConstructorMarker)object;
    }

    private static final void getOrderedAllTypeVariables$collectNotFixedVariables(PostponedAtomWithRevisableExpectedType $this$getOrderedAllTypeVariables_u24collectNotFixedVariables, ConstraintSystemCompletionContext $this_getOrderedAllTypeVariables, LinkedHashSet<TypeConstructorMarker> result2) {
        block1: {
            Object object = $this$getOrderedAllTypeVariables_u24collectNotFixedVariables.getRevisedExpectedType();
            if (object == null || (object = $this_getOrderedAllTypeVariables.lowerBoundIfFlexible((KotlinTypeMarker)object)) == null || (object = $this_getOrderedAllTypeVariables.asArgumentList((RigidTypeMarker)object)) == null) break block1;
            Object typeArgumentList = object;
            boolean bl = false;
            Iterator<TypeArgumentMarker> iterator2 = $this_getOrderedAllTypeVariables.iterator((TypeArgumentListMarker)typeArgumentList);
            while (iterator2.hasNext()) {
                TypeArgumentMarker typeArgument = iterator2.next();
                Object object2 = $this_getOrderedAllTypeVariables.getType(typeArgument);
                if (object2 == null || (object2 = $this_getOrderedAllTypeVariables.typeConstructor((KotlinTypeMarker)object2)) == null) continue;
                Object constructor = object2;
                if (!$this_getOrderedAllTypeVariables.getNotFixedTypeVariables().containsKey(constructor)) continue;
                result2.add((TypeConstructorMarker)constructor);
            }
        }
    }

    private static final Unit getOrderedAllTypeVariables$collectAllTypeVariables$lambda$13(LinkedHashSet $result, ConstraintSystemCompletionContext $this_getOrderedAllTypeVariables, Candidate candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Iterable $this$mapNotNullTo$iv = candidate2.getFreshVariables();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeConstructorMarker it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            ConeTypeVariable typeVariable = (ConeTypeVariable)element$iv;
            boolean bl2 = false;
            if (ConstraintSystemCompleter.getOrderedAllTypeVariables$toTypeConstructor(typeVariable, $this_getOrderedAllTypeVariables) == null) continue;
            boolean bl3 = false;
            ((Collection)$result).add(it$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getOrderedAllTypeVariables$collectAllTypeVariables$lambda$14(LinkedHashSet $result, ConstraintSystemCompletionContext $this_getOrderedAllTypeVariables, ConePostponedResolvedAtom postponedAtom) {
        Intrinsics.checkNotNullParameter(postponedAtom, "postponedAtom");
        ConePostponedResolvedAtom conePostponedResolvedAtom = postponedAtom;
        if (conePostponedResolvedAtom instanceof ConeResolvedLambdaAtom) {
            CollectionsKt.addIfNotNull($result, ConstraintSystemCompleter.getOrderedAllTypeVariables$toTypeConstructor(((ConeResolvedLambdaAtom)postponedAtom).getTypeVariableForLambdaReturnType(), $this_getOrderedAllTypeVariables));
        } else if (conePostponedResolvedAtom instanceof ConeLambdaWithTypeVariableAsExpectedTypeAtom) {
            ConstraintSystemCompleter.getOrderedAllTypeVariables$collectNotFixedVariables((PostponedAtomWithRevisableExpectedType)((Object)postponedAtom), $this_getOrderedAllTypeVariables, $result);
        } else if (conePostponedResolvedAtom instanceof ConeResolvedCallableReferenceAtom) {
            if (((ConeResolvedCallableReferenceAtom)postponedAtom).getNeedsResolution()) {
                ConstraintSystemCompleter.getOrderedAllTypeVariables$collectNotFixedVariables((PostponedAtomWithRevisableExpectedType)((Object)postponedAtom), $this_getOrderedAllTypeVariables, $result);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final void getOrderedAllTypeVariables$collectAllTypeVariables(ConeResolutionAtom $this$getOrderedAllTypeVariables_u24collectAllTypeVariables, LinkedHashSet<TypeConstructorMarker> result2, ConstraintSystemCompletionContext $this_getOrderedAllTypeVariables) {
        CandidateTraversalKt.processCandidatesAndPostponedAtoms($this$getOrderedAllTypeVariables_u24collectAllTypeVariables, arg_0 -> ConstraintSystemCompleter.getOrderedAllTypeVariables$collectAllTypeVariables$lambda$13(result2, $this_getOrderedAllTypeVariables, arg_0), arg_0 -> ConstraintSystemCompleter.getOrderedAllTypeVariables$collectAllTypeVariables$lambda$14(result2, $this_getOrderedAllTypeVariables, arg_0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J$\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter$Companion;", "", "<init>", "()V", "getOrderedNotAnalyzedPostponedArguments", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConePostponedResolvedAtom;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "getOrderedNotAnalyzedPostponedArguments$resolve", "topLevelAtoms", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "findStatementOfFirstAtomWithVariable", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "createCannotInferErrorType", "Lorg/jetbrains/kotlin/fir/types/ConeErrorType;", "typeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "message", "", "isUninferredParameter", "", "resolve"})
    @SourceDebugExtension(value={"SMAP\nConstraintSystemCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintSystemCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,485:1\n231#2:486\n1740#3,3:487\n1#4:490\n*S KotlinDebug\n*F\n+ 1 ConstraintSystemCompleter.kt\norg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter$Companion\n*L\n403#1:486\n421#1:487,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ConePostponedResolvedAtom> getOrderedNotAnalyzedPostponedArguments$resolve(@NotNull Candidate candidate2) {
            Intrinsics.checkNotNullParameter(candidate2, "candidate");
            FirElement firElement = candidate2.getCallInfo().getCallSite();
            Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
            FirExpression callSite = (FirExpression)firElement;
            return this.getOrderedNotAnalyzedPostponedArguments(kotlin.collections.CollectionsKt.listOf(new ConeAtomWithCandidate(callSite, candidate2)));
        }

        /*
         * Enabled aggressive block sorting
         */
        private final List<ConePostponedResolvedAtom> getOrderedNotAnalyzedPostponedArguments(List<? extends ConeResolutionAtom> topLevelAtoms) {
            boolean bl;
            ArrayList notAnalyzedArguments = new ArrayList();
            Iterator<? extends ConeResolutionAtom> iterator2 = topLevelAtoms.iterator();
            do {
                block13: {
                    block12: {
                        boolean bl2;
                        block11: {
                            Map map;
                            if (!iterator2.hasNext()) {
                                return notAnalyzedArguments;
                            }
                            ConeResolutionAtom coneResolutionAtom = iterator2.next();
                            boolean condition$iv = AbstractTypeChecker.RUN_SLOW_ASSERTIONS;
                            boolean $i$f$runIf = false;
                            if (condition$iv) {
                                boolean bl3 = false;
                                map = new LinkedHashMap();
                            } else {
                                map = null;
                            }
                            Map isPostponedAtomFoundForAssertion = map;
                            CandidateTraversalKt.processCandidatesAndPostponedAtoms(coneResolutionAtom, arg_0 -> Companion.getOrderedNotAnalyzedPostponedArguments$lambda$3(isPostponedAtomFoundForAssertion, arg_0), arg_0 -> Companion.getOrderedNotAnalyzedPostponedArguments$lambda$5(notAnalyzedArguments, isPostponedAtomFoundForAssertion, arg_0));
                            if (isPostponedAtomFoundForAssertion == null) break block12;
                            Iterable $this$all$iv = isPostponedAtomFoundForAssertion.values();
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    boolean it = (Boolean)element$iv;
                                    boolean bl4 = false;
                                    if (it) continue;
                                    bl2 = false;
                                    break block11;
                                }
                                bl2 = true;
                            }
                        }
                        if (!bl2) break block13;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            } while (bl);
            boolean bl5 = false;
            String string2 = "Some postponed atoms were not collected.";
            throw new IllegalStateException(string2.toString());
        }

        private final FirStatement findStatementOfFirstAtomWithVariable(TypeVariableMarker typeVariable, List<? extends ConeResolutionAtom> topLevelAtoms) {
            FirStatement firStatement;
            block1: {
                for (ConeResolutionAtom p0 : (Iterable)topLevelAtoms) {
                    boolean bl = false;
                    FirStatement firStatement2 = org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter$Companion.findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable(p0, typeVariable);
                    if (firStatement2 == null) continue;
                    firStatement = firStatement2;
                    break block1;
                }
                firStatement = null;
            }
            return firStatement;
        }

        private final ConeErrorType createCannotInferErrorType(FirTypeParameterSymbol typeParameterSymbol, String message, boolean isUninferredParameter) {
            ConeDiagnostic diagnostic = typeParameterSymbol == null ? (ConeDiagnostic)new ConeSimpleDiagnostic(message, DiagnosticKind.CannotInferParameterType) : (ConeDiagnostic)new ConeCannotInferTypeParameterType(typeParameterSymbol, message);
            return new ConeErrorType(diagnostic, isUninferredParameter, null, null, null, 28, null);
        }

        static /* synthetic */ ConeErrorType createCannotInferErrorType$default(Companion companion, FirTypeParameterSymbol firTypeParameterSymbol, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.createCannotInferErrorType(firTypeParameterSymbol, string2, bl);
        }

        private static final Boolean getOrderedNotAnalyzedPostponedArguments$lambda$3$lambda$1(ConePostponedResolvedAtom it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return false;
        }

        private static final Boolean getOrderedNotAnalyzedPostponedArguments$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit getOrderedNotAnalyzedPostponedArguments$lambda$3(Map $isPostponedAtomFoundForAssertion, Candidate candidate2) {
            Intrinsics.checkNotNullParameter(candidate2, "candidate");
            if ($isPostponedAtomFoundForAssertion != null) {
                for (ConePostponedResolvedAtom atom : candidate2.getPostponedAtoms()) {
                    $isPostponedAtomFoundForAssertion.computeIfAbsent(atom, arg_0 -> Companion.getOrderedNotAnalyzedPostponedArguments$lambda$3$lambda$2(Companion::getOrderedNotAnalyzedPostponedArguments$lambda$3$lambda$1, arg_0));
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit getOrderedNotAnalyzedPostponedArguments$lambda$5(ArrayList $notAnalyzedArguments, Map $isPostponedAtomFoundForAssertion, ConePostponedResolvedAtom atom) {
            block0: {
                void it;
                ConePostponedResolvedAtom conePostponedResolvedAtom;
                Intrinsics.checkNotNullParameter(atom, "atom");
                ConePostponedResolvedAtom conePostponedResolvedAtom2 = conePostponedResolvedAtom = atom;
                Collection collection = $notAnalyzedArguments;
                boolean bl = false;
                boolean bl2 = it.getAnalyzed();
                CollectionsKt.addIfNotNull(collection, !bl2 ? conePostponedResolvedAtom : null);
                Map map = $isPostponedAtomFoundForAssertion;
                if (map == null) break block0;
                map.put(atom, true);
            }
            return Unit.INSTANCE;
        }

        private static final void findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$suggestElement(Ref.ObjectRef<FirStatement> result2, FirElement element) {
            if (result2.element == null && element instanceof FirStatement) {
                result2.element = element;
            }
        }

        private static final Unit findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$lambda$8(TypeVariableMarker $typeVariable, Ref.ObjectRef $result, Candidate candidate2) {
            Intrinsics.checkNotNullParameter(candidate2, "candidate");
            if (kotlin.collections.CollectionsKt.contains((Iterable)candidate2.getFreshVariables(), $typeVariable)) {
                org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter$Companion.findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$suggestElement($result, candidate2.getCallInfo().getCallSite());
            }
            return Unit.INSTANCE;
        }

        private static final Unit findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$lambda$9(TypeVariableMarker $typeVariable, Ref.ObjectRef $result, ConePostponedResolvedAtom postponedAtom) {
            Intrinsics.checkNotNullParameter(postponedAtom, "postponedAtom");
            if (postponedAtom instanceof ConeResolvedLambdaAtom && Intrinsics.areEqual(((ConeResolvedLambdaAtom)postponedAtom).getTypeVariableForLambdaReturnType(), $typeVariable)) {
                org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter$Companion.findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$suggestElement($result, ((ConeResolvedLambdaAtom)postponedAtom).getAnonymousFunction());
            }
            return Unit.INSTANCE;
        }

        private static final FirStatement findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable(ConeResolutionAtom $this$findStatementOfFirstAtomWithVariable_u24findFirstStatementContainingVariable, TypeVariableMarker $typeVariable) {
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            CandidateTraversalKt.processCandidatesAndPostponedAtoms($this$findStatementOfFirstAtomWithVariable_u24findFirstStatementContainingVariable, arg_0 -> Companion.findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$lambda$8($typeVariable, result2, arg_0), arg_0 -> Companion.findStatementOfFirstAtomWithVariable$findFirstStatementContainingVariable$lambda$9($typeVariable, result2, arg_0));
            return (FirStatement)result2.element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter$PostponedAtomAnalyzer;", "", "analyze", "", "postponedResolvedAtom", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConePostponedResolvedAtom;", "withPCLASession", "", "resolve"})
    public static interface PostponedAtomAnalyzer {
        public void analyze(@NotNull ConePostponedResolvedAtom var1, boolean var2);
    }
}

