"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../src/utils");
const vscode_languageserver_1 = require("vscode-languageserver");
const assert = __importStar(require("assert"));
describe('utils', () => {
    describe('#isBeforeOrEqualToPosition', () => {
        it('is before position (line, character lower)', () => {
            const result = (0, utils_1.isBeforeOrEqualToPosition)(vscode_languageserver_1.Position.create(1, 1), vscode_languageserver_1.Position.create(0, 0));
            assert.equal(result, true);
        });
        it('is before position (line lower, character higher)', () => {
            const result = (0, utils_1.isBeforeOrEqualToPosition)(vscode_languageserver_1.Position.create(1, 1), vscode_languageserver_1.Position.create(0, 2));
            assert.equal(result, true);
        });
        it('is equal to position', () => {
            const result = (0, utils_1.isBeforeOrEqualToPosition)(vscode_languageserver_1.Position.create(1, 1), vscode_languageserver_1.Position.create(1, 1));
            assert.equal(result, true);
        });
        it('is after position (line, character higher)', () => {
            const result = (0, utils_1.isBeforeOrEqualToPosition)(vscode_languageserver_1.Position.create(1, 1), vscode_languageserver_1.Position.create(2, 2));
            assert.equal(result, false);
        });
        it('is after position (line lower, character higher)', () => {
            const result = (0, utils_1.isBeforeOrEqualToPosition)(vscode_languageserver_1.Position.create(1, 1), vscode_languageserver_1.Position.create(2, 0));
            assert.equal(result, false);
        });
    });
    describe('#regexLastIndexOf', () => {
        it('should work #1', () => {
            assert.equal((0, utils_1.regexLastIndexOf)('1 2 3', /\s/g), 3);
        });
        it('should work #2', () => {
            assert.equal((0, utils_1.regexLastIndexOf)('1_2:- 3', /\W/g), 5);
        });
        it('should work #3', () => {
            assert.equal((0, utils_1.regexLastIndexOf)('<bla blubb={() => hello', /[\W\s]/g), 17);
        });
    });
    describe('#modifyLines', () => {
        it('should work', () => {
            assert.equal((0, utils_1.modifyLines)('a\nb\r\nc\nd', (line) => 1 + line), '1a\n1b\r\n1c\n1d');
        });
        it('should pass correct line numbers', () => {
            const idxs = [];
            (0, utils_1.modifyLines)('a\nb\r\nc\nd', (_, idx) => {
                idxs.push(idx);
                return _;
            });
            assert.deepStrictEqual(idxs, [0, 1, 2, 3]);
        });
    });
});
//# sourceMappingURL=utils.test.js.map