/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.catalina.Container;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.juli.WebappProperties;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstrumentableClassLoader;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.ToStringUtil;
import org.apache.tomcat.util.collections.ConcurrentLruCache;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PermissionCheck;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public abstract class WebappClassLoaderBase
extends URLClassLoader
implements Lifecycle,
InstrumentableClassLoader,
WebappProperties,
PermissionCheck {
    private static final Log log = LogFactory.getLog(WebappClassLoaderBase.class);
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final String JVM_THREAD_GROUP_SYSTEM = "system";
    private static final String CLASS_FILE_SUFFIX = ".class";
    protected static final StringManager sm;
    protected WebResourceRoot resources = null;
    protected final Map<String, ResourceEntry> resourceEntries = new ConcurrentHashMap<String, ResourceEntry>();
    protected boolean delegate = false;
    private final Map<String, Long> jarModificationTimes = new HashMap<String, Long>();
    protected final ArrayList<Permission> permissionList = new ArrayList();
    protected final HashMap<String, PermissionCollection> loaderPC = new HashMap();
    protected final SecurityManager securityManager;
    protected final ClassLoader parent;
    private ClassLoader javaseClassLoader;
    private boolean clearReferencesRmiTargets = true;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesLogFactoryRelease = true;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private boolean clearReferencesObjectStreamClassCaches = true;
    private boolean clearReferencesThreadLocals = true;
    private boolean skipMemoryLeakChecksOnJvmShutdown = false;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private boolean hasExternalRepositories = false;
    private List<URL> localRepositories = new ArrayList<URL>();
    private volatile LifecycleState state = LifecycleState.NEW;
    private final ConcurrentLruCache<String> notFoundClassResources = new ConcurrentLruCache(1000);

    protected WebappClassLoaderBase() {
        super(new URL[0]);
        ClassLoader classLoader = this.getParent();
        if (classLoader == null) {
            classLoader = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = classLoader;
        ClassLoader classLoader2 = String.class.getClassLoader();
        if (classLoader2 == null) {
            classLoader2 = WebappClassLoaderBase.getSystemClassLoader();
            while (classLoader2.getParent() != null) {
                classLoader2 = classLoader2.getParent();
            }
        }
        this.javaseClassLoader = classLoader2;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    protected WebappClassLoaderBase(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        ClassLoader classLoader2 = this.getParent();
        if (classLoader2 == null) {
            classLoader2 = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = classLoader2;
        ClassLoader classLoader3 = String.class.getClassLoader();
        if (classLoader3 == null) {
            classLoader3 = WebappClassLoaderBase.getSystemClassLoader();
            while (classLoader3.getParent() != null) {
                classLoader3 = classLoader3.getParent();
            }
        }
        this.javaseClassLoader = classLoader3;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public void setNotFoundClassResourceCacheSize(int n) {
        this.notFoundClassResources.setLimit(n);
    }

    public int getNotFoundClassResourceCacheSize() {
        return this.notFoundClassResources.getLimit();
    }

    public void setResources(WebResourceRoot webResourceRoot) {
        this.resources = webResourceRoot;
    }

    public String getContextName() {
        if (this.resources == null) {
            return "Unknown";
        }
        return this.resources.getContext().getBaseName();
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        this.delegate = bl;
    }

    void addPermission(URL uRL) {
        if (uRL == null) {
            return;
        }
        if (this.securityManager != null) {
            String string = uRL.getProtocol();
            if ("file".equalsIgnoreCase(string)) {
                String string2;
                File file;
                try {
                    URI uRI = uRL.toURI();
                    file = new File(uRI);
                    string2 = file.getCanonicalPath();
                }
                catch (IOException | URISyntaxException exception) {
                    log.warn((Object)sm.getString("webappClassLoader.addPermissionNoCanonicalFile", new Object[]{uRL.toExternalForm()}));
                    return;
                }
                if (file.isFile()) {
                    this.addPermission(new FilePermission(string2, "read"));
                } else if (file.isDirectory()) {
                    this.addPermission(new FilePermission(string2, "read"));
                    this.addPermission(new FilePermission(string2 + File.separator + "-", "read"));
                }
            } else {
                log.warn((Object)sm.getString("webappClassLoader.addPermissionNoProtocol", new Object[]{string, uRL.toExternalForm()}));
            }
        }
    }

    void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public boolean getClearReferencesRmiTargets() {
        return this.clearReferencesRmiTargets;
    }

    public void setClearReferencesRmiTargets(boolean bl) {
        this.clearReferencesRmiTargets = bl;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean bl) {
        this.clearReferencesStopThreads = bl;
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean bl) {
        this.clearReferencesStopTimerThreads = bl;
    }

    public boolean getClearReferencesLogFactoryRelease() {
        return this.clearReferencesLogFactoryRelease;
    }

    public void setClearReferencesLogFactoryRelease(boolean bl) {
        this.clearReferencesLogFactoryRelease = bl;
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean bl) {
        this.clearReferencesHttpClientKeepAliveThread = bl;
    }

    public boolean getClearReferencesObjectStreamClassCaches() {
        return this.clearReferencesObjectStreamClassCaches;
    }

    public void setClearReferencesObjectStreamClassCaches(boolean bl) {
        this.clearReferencesObjectStreamClassCaches = bl;
    }

    public boolean getClearReferencesThreadLocals() {
        return this.clearReferencesThreadLocals;
    }

    public void setClearReferencesThreadLocals(boolean bl) {
        this.clearReferencesThreadLocals = bl;
    }

    public boolean getSkipMemoryLeakChecksOnJvmShutdown() {
        return this.skipMemoryLeakChecksOnJvmShutdown;
    }

    public void setSkipMemoryLeakChecksOnJvmShutdown(boolean bl) {
        this.skipMemoryLeakChecksOnJvmShutdown = bl;
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.addTransformer.illegalArgument", new Object[]{this.getContextName()}));
        }
        if (this.transformers.contains(classFileTransformer)) {
            log.warn((Object)sm.getString("webappClassLoader.addTransformer.duplicate", new Object[]{classFileTransformer, this.getContextName()}));
            return;
        }
        this.transformers.add(classFileTransformer);
        log.info((Object)sm.getString("webappClassLoader.addTransformer", new Object[]{classFileTransformer, this.getContextName()}));
    }

    public void removeTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            return;
        }
        if (this.transformers.remove(classFileTransformer)) {
            log.info((Object)sm.getString("webappClassLoader.removeTransformer", new Object[]{classFileTransformer, this.getContextName()}));
        }
    }

    protected void copyStateWithoutTransformers(WebappClassLoaderBase webappClassLoaderBase) {
        webappClassLoaderBase.resources = this.resources;
        webappClassLoaderBase.delegate = this.delegate;
        webappClassLoaderBase.state = LifecycleState.NEW;
        webappClassLoaderBase.clearReferencesStopThreads = this.clearReferencesStopThreads;
        webappClassLoaderBase.clearReferencesStopTimerThreads = this.clearReferencesStopTimerThreads;
        webappClassLoaderBase.clearReferencesLogFactoryRelease = this.clearReferencesLogFactoryRelease;
        webappClassLoaderBase.clearReferencesHttpClientKeepAliveThread = this.clearReferencesHttpClientKeepAliveThread;
        webappClassLoaderBase.jarModificationTimes.putAll(this.jarModificationTimes);
        webappClassLoaderBase.permissionList.addAll(this.permissionList);
        webappClassLoaderBase.loaderPC.putAll(this.loaderPC);
    }

    public boolean modified() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"modified()");
        }
        for (Map.Entry<String, ResourceEntry> entry : this.resourceEntries.entrySet()) {
            long l = entry.getValue().lastModified;
            long l2 = this.resources.getClassLoaderResource(entry.getKey()).getLastModified();
            if (l2 == l) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappClassLoader.resourceModified", new Object[]{entry.getKey(), new Date(l), new Date(l2)}));
            }
            return true;
        }
        WebResource[] webResourceArray = this.resources.listResources("/WEB-INF/lib");
        int n = 0;
        for (WebResource webResource : webResourceArray) {
            if (!webResource.getName().endsWith(".jar") || !webResource.isFile() || !webResource.canRead()) continue;
            ++n;
            Long l = this.jarModificationTimes.get(webResource.getName());
            if (l == null) {
                log.info((Object)sm.getString("webappClassLoader.jarsAdded", new Object[]{this.resources.getContext().getName()}));
                return true;
            }
            if (l.longValue() == webResource.getLastModified()) continue;
            log.info((Object)sm.getString("webappClassLoader.jarsModified", new Object[]{this.resources.getContext().getName()}));
            return true;
        }
        if (n < this.jarModificationTimes.size()) {
            log.info((Object)sm.getString("webappClassLoader.jarsRemoved", new Object[]{this.resources.getContext().getName()}));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("\r\n  context: ");
        stringBuilder.append(this.getContextName());
        stringBuilder.append("\r\n  delegate: ");
        stringBuilder.append(this.delegate);
        stringBuilder.append("\r\n");
        if (this.parent != null) {
            stringBuilder.append("----------> Parent Classloader:\r\n");
            stringBuilder.append(this.parent.toString());
            stringBuilder.append("\r\n");
        }
        if (this.transformers.size() > 0) {
            stringBuilder.append("----------> Class file transformers:\r\n");
            for (ClassFileTransformer classFileTransformer : this.transformers) {
                stringBuilder.append(classFileTransformer).append("\r\n");
            }
        }
        return stringBuilder.toString();
    }

    protected final Class<?> doDefineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) {
        return super.defineClass(string, byArray, n, n2, protectionDomain);
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        Object object;
        Class<?> clazz;
        String string2;
        block25: {
            int n;
            if (log.isTraceEnabled()) {
                log.trace((Object)("    findClass(" + string + ")"));
            }
            this.checkStateForClassLoading(string);
            if (string == null) {
                throw new ClassNotFoundException("null");
            }
            string2 = this.binaryNameToPath(string, true);
            if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      securityManager.checkPackageDefinition");
                    }
                    this.securityManager.checkPackageDefinition(string.substring(0, n));
                }
                catch (Exception exception) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->Exception-->ClassNotFoundException", (Throwable)exception);
                    }
                    throw new ClassNotFoundException(string, exception);
                }
            }
            clazz = null;
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("      findClassInternal(" + string + ")"));
                }
                if (this.notFoundClassResources.contains((Object)string2)) break block25;
                try {
                    if (this.securityManager != null) {
                        object = new PrivilegedFindClassByName(string);
                        clazz = (Class<?>)AccessController.doPrivileged(object);
                    } else {
                        clazz = this.findClassInternal(string);
                    }
                }
                catch (AccessControlException accessControlException) {
                    log.warn((Object)sm.getString("webappClassLoader.securityException", new Object[]{string, accessControlException.getMessage()}), (Throwable)accessControlException);
                    throw new ClassNotFoundException(string, accessControlException);
                }
                catch (RuntimeException runtimeException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
                if (clazz != null || !this.hasExternalRepositories) break block25;
                try {
                    clazz = super.findClass(string);
                }
                catch (AccessControlException accessControlException) {
                    log.warn((Object)sm.getString("webappClassLoader.securityException", new Object[]{string, accessControlException.getMessage()}), (Throwable)accessControlException);
                    throw new ClassNotFoundException(string, accessControlException);
                }
                catch (RuntimeException runtimeException) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)runtimeException);
                    }
                    throw runtimeException;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"    --> Passing on ClassNotFoundException");
                }
                this.notFoundClassResources.add((Object)string2);
                throw classNotFoundException;
            }
        }
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"    --> Returning ClassNotFoundException");
            }
            this.notFoundClassResources.add((Object)string2);
            throw new ClassNotFoundException(string);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("      Returning class " + String.valueOf(clazz)));
        }
        if (log.isTraceEnabled()) {
            object = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            log.trace((Object)("      Loaded by " + object.toString()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String string) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("    findResource(" + string + ")"));
        }
        this.checkStateForResourceLoading(string);
        URL uRL = null;
        String string2 = this.nameToPath(string);
        if (!this.notFoundClassResources.contains((Object)string2)) {
            WebResource webResource = this.resources.getClassLoaderResource(string2);
            if (webResource.exists()) {
                uRL = webResource.getURL();
                this.trackLastModified(string2, webResource);
            }
            if (uRL == null && this.hasExternalRepositories) {
                uRL = super.findResource(string);
            }
            if (uRL == null) {
                this.notFoundClassResources.add((Object)string2);
            }
        }
        if (log.isTraceEnabled()) {
            if (uRL != null) {
                log.trace((Object)("    --> Returning '" + uRL.toString() + "'"));
            } else {
                log.trace((Object)"    --> Resource not found, returning null");
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackLastModified(String string, WebResource webResource) {
        if (this.resourceEntries.containsKey(string)) {
            return;
        }
        ResourceEntry resourceEntry = new ResourceEntry();
        resourceEntry.lastModified = webResource.getLastModified();
        Map<String, ResourceEntry> map = this.resourceEntries;
        synchronized (map) {
            this.resourceEntries.putIfAbsent(string, resourceEntry);
        }
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("    findResources(" + string + ")"));
        }
        this.checkStateForResourceLoading(string);
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        String string2 = this.nameToPath(string);
        WebResource[] webResourceArray = this.resources.getClassLoaderResources(string2);
        for (WebResource webResource : webResourceArray) {
            if (!webResource.exists()) continue;
            linkedHashSet.add(webResource.getURL());
        }
        if (this.hasExternalRepositories) {
            Enumeration<URL> enumeration = super.findResources(string);
            while (enumeration.hasMoreElements()) {
                linkedHashSet.add((URL)enumeration.nextElement());
            }
        }
        return Collections.enumeration(linkedHashSet);
    }

    @Override
    public URL getResource(String string) {
        boolean bl;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResource(" + string + ")"));
        }
        this.checkStateForResourceLoading(string);
        URL uRL = null;
        boolean bl2 = bl = this.delegate || this.filter(string, false);
        if (bl) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Delegating to parent classloader " + String.valueOf(this.parent)));
            }
            if ((uRL = this.parent.getResource(string)) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  --> Returning '" + uRL.toString() + "'"));
                }
                return uRL;
            }
        }
        if ((uRL = this.findResource(string)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("  --> Returning '" + uRL.toString() + "'"));
            }
            return uRL;
        }
        if (!bl && (uRL = this.parent.getResource(string)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("  --> Returning '" + uRL.toString() + "'"));
            }
            return uRL;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        boolean bl;
        Enumeration<URL> enumeration = this.parent.getResources(string);
        Enumeration<URL> enumeration2 = this.findResources(string);
        boolean bl2 = bl = this.delegate || this.filter(string, false);
        if (bl) {
            return new CombinedEnumeration(enumeration, enumeration2);
        }
        return new CombinedEnumeration(enumeration2, enumeration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String string) {
        String string2;
        boolean bl;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResourceAsStream(" + string + ")"));
        }
        this.checkStateForResourceLoading(string);
        InputStream inputStream = null;
        boolean bl2 = bl = this.delegate || this.filter(string, false);
        if (bl) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Delegating to parent classloader " + String.valueOf(this.parent)));
            }
            if ((inputStream = this.parent.getResourceAsStream(string)) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Searching local repositories");
        }
        if (!this.notFoundClassResources.contains((Object)(string2 = this.nameToPath(string)))) {
            Object object;
            WebResource webResource = this.resources.getClassLoaderResource(string2);
            if (webResource.exists()) {
                inputStream = webResource.getInputStream();
                if (string.endsWith(CLASS_FILE_SUFFIX) && this.transformers.size() > 0) {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[8192];
                    try {
                        int n;
                        while ((n = inputStream.read(byArray)) >= 0) {
                            ((ByteArrayOutputStream)object).write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        log.error((Object)sm.getString("webappClassLoader.transformError", new Object[]{string}), (Throwable)iOException);
                        InputStream inputStream2 = null;
                        return inputStream2;
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                    String string3 = string2.substring(1, string2.length() - CLASS_FILE_SUFFIX.length());
                    for (ClassFileTransformer classFileTransformer : this.transformers) {
                        try {
                            byte[] byArray3 = classFileTransformer.transform(this, string3, null, null, byArray2);
                            if (byArray3 == null) continue;
                            byArray2 = byArray3;
                        }
                        catch (IllegalClassFormatException illegalClassFormatException) {
                            log.error((Object)sm.getString("webappClassLoader.transformError", new Object[]{string}), (Throwable)illegalClassFormatException);
                            return null;
                        }
                    }
                    inputStream = new ByteArrayInputStream(byArray2);
                }
                this.trackLastModified(string2, webResource);
            }
            try {
                if (this.hasExternalRepositories && inputStream == null && (object = super.findResource(string)) != null) {
                    inputStream = ((URL)object).openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  --> Returning stream from local");
                }
                return inputStream;
            }
            this.notFoundClassResources.add((Object)string2);
        }
        if (!bl) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Delegating to parent classloader unconditionally " + String.valueOf(this.parent)));
            }
            if ((inputStream = this.parent.getResourceAsStream(string)) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        WebappClassLoaderBase webappClassLoaderBase = JreCompat.isGraalAvailable() ? this : this.getClassLoadingLock(string);
        synchronized (webappClassLoaderBase) {
            boolean bl2;
            int n;
            boolean bl3;
            if (log.isTraceEnabled()) {
                log.trace((Object)("loadClass(" + string + ", " + bl + ")"));
            }
            Class<?> clazz = null;
            this.checkStateForClassLoading(string);
            clazz = this.findLoadedClass0(string);
            if (clazz != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  Returning class from cache");
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            Class<?> clazz2 = clazz = JreCompat.isGraalAvailable() ? null : this.findLoadedClass(string);
            if (clazz != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  Returning class from cache");
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            String string2 = this.binaryNameToPath(string, false);
            ClassLoader classLoader = this.getJavaseClassLoader();
            try {
                URL uRL;
                if (this.securityManager != null) {
                    PrivilegedJavaseGetResource privilegedJavaseGetResource = new PrivilegedJavaseGetResource(string2);
                    uRL = AccessController.doPrivileged(privilegedJavaseGetResource);
                } else {
                    uRL = classLoader.getResource(string2);
                }
                bl3 = uRL != null;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                bl3 = true;
            }
            if (bl3) {
                try {
                    clazz = classLoader.loadClass(string);
                    if (clazz != null) {
                        if (bl) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                try {
                    this.securityManager.checkPackageAccess(string.substring(0, n));
                }
                catch (SecurityException securityException) {
                    String string3 = sm.getString("webappClassLoader.restrictedPackage", new Object[]{string});
                    log.info((Object)string3, (Throwable)securityException);
                    throw new ClassNotFoundException(string3, securityException);
                }
            }
            boolean bl4 = bl2 = this.delegate || this.filter(string, true);
            if (bl2) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  Delegating to parent classloader1 " + String.valueOf(this.parent)));
                }
                try {
                    clazz = Class.forName(string, false, this.parent);
                    if (clazz != null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"  Loading class from parent");
                        }
                        if (bl) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Searching local repositories");
            }
            try {
                clazz = this.findClass(string);
                if (clazz != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"  Loading class from local repository");
                    }
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!bl2) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  Delegating to parent classloader at end: " + String.valueOf(this.parent)));
                }
                try {
                    clazz = Class.forName(string, false, this.parent);
                    if (clazz != null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"  Loading class from parent");
                        }
                        if (bl) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)ToStringUtil.classPathForCNFE((ClassLoader)this));
        }
        throw new ClassNotFoundException(string);
    }

    protected void checkStateForClassLoading(String string) throws ClassNotFoundException {
        try {
            this.checkStateForResourceLoading(string);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ClassNotFoundException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    protected void checkStateForResourceLoading(String string) throws IllegalStateException {
        if (!this.state.isAvailable()) {
            String string2 = sm.getString("webappClassLoader.stopped", new Object[]{string});
            IllegalStateException illegalStateException = new IllegalStateException(string2);
            log.info((Object)string2, (Throwable)illegalStateException);
            throw illegalStateException;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String string = codeSource.getLocation().toString();
        PermissionCollection permissionCollection = this.loaderPC.get(string);
        if (permissionCollection == null && (permissionCollection = super.getPermissions(codeSource)) != null) {
            for (Permission permission : this.permissionList) {
                permissionCollection.add(permission);
            }
            this.loaderPC.put(string, permissionCollection);
        }
        return permissionCollection;
    }

    public boolean check(Permission permission) {
        URL uRL;
        CodeSource codeSource;
        PermissionCollection permissionCollection;
        if (!Globals.IS_SECURITY_ENABLED) {
            return true;
        }
        Policy policy = Policy.getPolicy();
        return policy != null && (permissionCollection = policy.getPermissions(codeSource = new CodeSource(uRL = this.resources.getResource("/").getCodeBase(), (Certificate[])null))).implies(permission);
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(this.localRepositories);
        arrayList.addAll(Arrays.asList(super.getURLs()));
        return arrayList.toArray(new URL[0]);
    }

    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
    }

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    @Override
    public void init() {
        this.state = LifecycleState.INITIALIZED;
    }

    @Override
    public void start() throws LifecycleException {
        WebResource[] webResourceArray;
        this.state = LifecycleState.STARTING_PREP;
        WebResource[] webResourceArray2 = webResourceArray = this.resources.getResources("/WEB-INF/classes");
        int n = webResourceArray2.length;
        for (int i = 0; i < n; ++i) {
            WebResource webResource = webResourceArray2[i];
            if (!webResource.isDirectory() || !webResource.canRead()) continue;
            this.localRepositories.add(webResource.getURL());
        }
        for (WebResource webResource : webResourceArray2 = this.resources.listResources("/WEB-INF/lib")) {
            if (!webResource.getName().endsWith(".jar") || !webResource.isFile() || !webResource.canRead()) continue;
            this.localRepositories.add(webResource.getURL());
            this.jarModificationTimes.put(webResource.getName(), webResource.getLastModified());
        }
        this.state = LifecycleState.STARTED;
    }

    @Override
    public void stop() throws LifecycleException {
        this.state = LifecycleState.STOPPING_PREP;
        this.clearReferences();
        this.state = LifecycleState.STOPPING;
        this.resourceEntries.clear();
        this.notFoundClassResources.clear();
        this.jarModificationTimes.clear();
        this.resources = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        this.state = LifecycleState.STOPPED;
    }

    @Override
    public void destroy() {
        this.state = LifecycleState.DESTROYING;
        try {
            super.close();
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("webappClassLoader.superCloseFail"), (Throwable)iOException);
        }
        this.state = LifecycleState.DESTROYED;
    }

    protected ClassLoader getJavaseClassLoader() {
        return this.javaseClassLoader;
    }

    protected void setJavaseClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.javaseClassLoaderNull"));
        }
        this.javaseClassLoader = classLoader;
    }

    protected void clearReferences() {
        if (this.skipMemoryLeakChecksOnJvmShutdown && !this.resources.getContext().getParent().getState().isAvailable()) {
            try {
                Thread thread = new Thread();
                Runtime.getRuntime().addShutdownHook(thread);
                Runtime.getRuntime().removeShutdownHook(thread);
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        if (!JreCompat.isGraalAvailable()) {
            this.clearReferencesJdbc();
        }
        this.clearReferencesThreads();
        if (this.clearReferencesObjectStreamClassCaches && !JreCompat.isGraalAvailable()) {
            this.clearReferencesObjectStreamClassCaches();
        }
        if (this.clearReferencesThreadLocals && !JreCompat.isGraalAvailable()) {
            this.checkThreadLocalsForLeaks();
        }
        if (this.clearReferencesRmiTargets) {
            this.clearReferencesRmiTargets();
        }
        IntrospectionUtils.clear();
        if (this.clearReferencesLogFactoryRelease) {
            LogFactory.release((ClassLoader)this);
        }
        Introspector.flushCaches();
        TomcatURLStreamHandlerFactory.release(this);
    }

    private void clearReferencesJdbc() {
        Object object = new byte[2048];
        int n = 0;
        try (InputStream inputStream = this.getResourceAsStream("org/apache/catalina/loader/JdbcLeakPrevention.class");){
            Object object2;
            int n2 = inputStream.read((byte[])object, n, ((byte[])object).length - n);
            while (n2 > -1) {
                if ((n += n2) == ((byte[])object).length) {
                    object2 = new byte[((byte[])object).length * 2];
                    System.arraycopy(object, 0, object2, 0, ((byte[])object).length);
                    object = object2;
                }
                n2 = inputStream.read((byte[])object, n, ((byte[])object).length - n);
            }
            object2 = this.defineClass("org.apache.catalina.loader.JdbcLeakPrevention", (byte[])object, 0, n, this.getClass().getProtectionDomain());
            Object obj = ((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
            List list = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
            for (String string : list) {
                log.warn((Object)sm.getString("webappClassLoader.clearJdbc", new Object[]{this.getContextName(), string}));
            }
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)exception);
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveFailed", new Object[]{this.getContextName()}), throwable);
        }
    }

    private void clearReferencesThreads() {
        Thread[] threadArray = this.getThreads();
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (Thread thread : threadArray) {
            ClassLoader classLoader;
            if (thread == null || (classLoader = thread.getContextClassLoader()) != this || thread == Thread.currentThread()) continue;
            String string = thread.getName();
            ThreadGroup threadGroup = thread.getThreadGroup();
            if (threadGroup != null && JVM_THREAD_GROUP_NAMES.contains(threadGroup.getName())) {
                if (!this.clearReferencesHttpClientKeepAliveThread || !string.equals("Keep-Alive-Timer")) continue;
                thread.setContextClassLoader(this.parent);
                log.debug((Object)sm.getString("webappClassLoader.checkThreadsHttpClient"));
                continue;
            }
            if (!thread.isAlive()) continue;
            if (thread.getClass().getName().startsWith("java.util.Timer") && this.clearReferencesStopTimerThreads) {
                this.clearReferencesStopTimerThread(thread);
                continue;
            }
            if (this.isRequestThread(thread)) {
                log.warn((Object)sm.getString("webappClassLoader.stackTraceRequestThread", new Object[]{this.getContextName(), string, this.getStackTrace(thread)}));
            } else {
                log.warn((Object)sm.getString("webappClassLoader.stackTrace", new Object[]{this.getContextName(), string, this.getStackTrace(thread)}));
            }
            if (!this.clearReferencesStopThreads) continue;
            boolean bl = false;
            try {
                Object object = JreCompat.getInstance().getExecutor(thread);
                if (object instanceof ThreadPoolExecutor) {
                    ((ThreadPoolExecutor)object).shutdownNow();
                    bl = true;
                } else if (object instanceof java.util.concurrent.ThreadPoolExecutor) {
                    ((java.util.concurrent.ThreadPoolExecutor)object).shutdownNow();
                    bl = true;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InaccessibleObjectException exception) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", new Object[]{thread.getName(), this.getContextName()}), (Throwable)exception);
            }
            if (!bl && !thread.isInterrupted()) {
                thread.interrupt();
            }
            arrayList.add(thread);
        }
        int n = 0;
        for (Thread thread : arrayList) {
            while (thread.isAlive() && n < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                ++n;
            }
            if (!thread.isAlive()) continue;
            thread.stop();
        }
    }

    private boolean isRequestThread(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - (i + 1)];
            if (!"org.apache.catalina.connector.CoyoteAdapter".equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) {
        try {
            try {
                Field field = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
                field.setAccessible(true);
                Field field2 = thread.getClass().getDeclaredField("queue");
                field2.setAccessible(true);
                Object object = field2.get(thread);
                Method method = object.getClass().getDeclaredMethod("clear", new Class[0]);
                method.setAccessible(true);
                Object object2 = object;
                synchronized (object2) {
                    field.setBoolean(thread, false);
                    method.invoke(object, new Object[0]);
                    object.notifyAll();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Method method = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
                Thread thread2 = thread;
                synchronized (thread2) {
                    method.setAccessible(true);
                    method.invoke((Object)thread, new Object[0]);
                }
            }
            log.warn((Object)sm.getString("webappClassLoader.warnTimerThread", new Object[]{this.getContextName(), thread.getName()}));
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)exception);
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("webappClassLoader.stopTimerThreadFail", new Object[]{thread.getName(), this.getContextName()}), throwable);
        }
    }

    private void checkThreadLocalsForLeaks() {
        Thread[] threadArray = this.getThreads();
        try {
            Field field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
            Field field2 = Thread.class.getDeclaredField("inheritableThreadLocals");
            field2.setAccessible(true);
            Class<?> clazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field field3 = clazz.getDeclaredField("table");
            field3.setAccessible(true);
            Method method = clazz.getDeclaredMethod("expungeStaleEntries", new Class[0]);
            method.setAccessible(true);
            for (Thread thread : threadArray) {
                if (thread == null) continue;
                Object object = field.get(thread);
                if (null != object) {
                    method.invoke(object, new Object[0]);
                    this.checkThreadLocalMapForLeaks(object, field3);
                }
                if (null == (object = field2.get(thread))) continue;
                method.invoke(object, new Object[0]);
                this.checkThreadLocalMapForLeaks(object, field3);
            }
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            log.warn((Object)sm.getString("webappClassLoader.addExportsThreadLocal", new Object[]{this.getCurrentModuleName()}));
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", new Object[]{this.getContextName()}), throwable);
        }
    }

    private void checkThreadLocalMapForLeaks(Object object, Field field) throws IllegalAccessException, NoSuchFieldException {
        Object[] objectArray;
        if (object != null && (objectArray = (Object[])field.get(object)) != null) {
            for (Object object2 : objectArray) {
                if (object2 == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                Object t = ((Reference)object2).get();
                if (this.equals(t) || this.loadedByThisOrChild(t)) {
                    bl = true;
                }
                Field field2 = object2.getClass().getDeclaredField("value");
                field2.setAccessible(true);
                Object object3 = field2.get(object2);
                if (this.equals(object3) || this.loadedByThisOrChild(object3)) {
                    bl2 = true;
                }
                if (!bl && !bl2) continue;
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = this.getContextName();
                if (t != null) {
                    objectArray2[1] = this.getPrettyClassName(t.getClass());
                    try {
                        objectArray2[2] = t.toString();
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badKey", new Object[]{objectArray2[1]}), (Throwable)exception);
                        objectArray2[2] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (object3 != null) {
                    objectArray2[3] = this.getPrettyClassName(object3.getClass());
                    try {
                        objectArray2[4] = object3.toString();
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badValue", new Object[]{objectArray2[3]}), (Throwable)exception);
                        objectArray2[4] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (bl2) {
                    log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks", objectArray2));
                    continue;
                }
                if (object3 == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksNull", objectArray2));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksNone", objectArray2));
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String string = clazz.getCanonicalName();
        if (string == null) {
            string = clazz.getName();
        }
        return string;
    }

    private String getStackTrace(Thread thread) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            stringBuilder.append("\n ").append(stackTraceElement);
        }
        return stringBuilder.toString();
    }

    private boolean loadedByThisOrChild(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        for (ClassLoader classLoader = clazz.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (classLoader != this) continue;
            return true;
        }
        if (object instanceof Collection) {
            try {
                for (Object e : (Collection)object) {
                    if (!this.loadedByThisOrChild(e)) continue;
                    return true;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                log.warn((Object)sm.getString("webappClassLoader.loadedByThisOrChildFail", new Object[]{clazz.getName(), this.getContextName()}), (Throwable)concurrentModificationException);
            }
        }
        return false;
    }

    private Thread[] getThreads() {
        Thread[] threadArray;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        try {
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
        }
        catch (SecurityException securityException) {
            threadArray = sm.getString("webappClassLoader.getThreadGroupError", new Object[]{threadGroup.getName()});
            if (log.isDebugEnabled()) {
                log.debug((Object)threadArray, (Throwable)securityException);
            }
            log.warn((Object)threadArray);
        }
        int n = threadGroup.activeCount() + 50;
        threadArray = new Thread[n];
        int n2 = threadGroup.enumerate(threadArray);
        while (n2 == n) {
            threadArray = new Thread[n *= 2];
            n2 = threadGroup.enumerate(threadArray);
        }
        return threadArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesRmiTargets() {
        try {
            Object object;
            Class<?> clazz = Class.forName("sun.rmi.transport.Target");
            Field field = clazz.getDeclaredField("ccl");
            field.setAccessible(true);
            Field field2 = clazz.getDeclaredField("stub");
            field2.setAccessible(true);
            Class<?> clazz2 = Class.forName("sun.rmi.transport.ObjectTable");
            Field field3 = clazz2.getDeclaredField("objTable");
            field3.setAccessible(true);
            Object object2 = field3.get(null);
            if (object2 == null) {
                return;
            }
            Field field4 = clazz2.getDeclaredField("tableLock");
            field4.setAccessible(true);
            Object object3 = object = field4.get(null);
            synchronized (object3) {
                Object object4;
                Iterator iterator;
                Object object5;
                Object object6;
                if (object2 instanceof Map) {
                    object6 = ((Map)object2).values().iterator();
                    while (object6.hasNext()) {
                        object5 = object6.next();
                        iterator = field.get(object5);
                        if (this != iterator) continue;
                        object6.remove();
                        object4 = field2.get(object5);
                        log.error((Object)sm.getString("webappClassLoader.clearRmi", new Object[]{object4.getClass().getName(), object4}));
                    }
                }
                object6 = clazz2.getDeclaredField("implTable");
                ((Field)object6).setAccessible(true);
                object5 = ((Field)object6).get(null);
                if (object5 == null) {
                    return;
                }
                if (object5 instanceof Map) {
                    iterator = ((Map)object5).values().iterator();
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        Object object7 = field.get(object4);
                        if (this != object7) continue;
                        iterator.remove();
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.info((Object)sm.getString("webappClassLoader.clearRmiInfo", new Object[]{this.getContextName()}), (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", new Object[]{this.getContextName()}), (Throwable)exception);
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            log.warn((Object)sm.getString("webappClassLoader.addExportsRmi", new Object[]{this.getCurrentModuleName()}));
        }
    }

    private void clearReferencesObjectStreamClassCaches() {
        if (JreCompat.isJre19Available()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("java.io.ObjectStreamClass$Caches");
            this.clearCache(clazz, "localDescs");
            this.clearCache(clazz, "reflectors");
        }
        catch (ClassCastException | ReflectiveOperationException | SecurityException exception) {
            log.warn((Object)sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", new Object[]{this.getContextName()}), (Throwable)exception);
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            log.warn((Object)sm.getString("webappClassLoader.addExportsJavaIo", new Object[]{this.getCurrentModuleName()}));
        }
    }

    private String getCurrentModuleName() {
        String string = this.getClass().getModule().getName();
        if (string == null) {
            string = "ALL-UNNAMED";
        }
        return string;
    }

    private void clearCache(Class<?> clazz, String string) throws ReflectiveOperationException, SecurityException, ClassCastException {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        Object object = field.get(null);
        if (object instanceof Map) {
            Iterator iterator = ((Map)object).keySet().iterator();
            while (iterator.hasNext()) {
                Object t;
                Object k = iterator.next();
                if (!(k instanceof Reference) || !this.loadedByThisOrChild(t = ((Reference)k).get())) continue;
                iterator.remove();
            }
        }
    }

    protected Class<?> findClassInternal(String string) {
        this.checkStateForResourceLoading(string);
        if (string == null) {
            return null;
        }
        String string2 = this.binaryNameToPath(string, true);
        return this.findClassInternal(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Class<?> findClassInternal(String string, String string2) {
        Object object;
        Class<?> clazz;
        Object object2 = this.resourceEntries.get(string2);
        WebResource webResource = null;
        if (object2 == null) {
            webResource = this.resources.getClassLoaderResource(string2);
            if (!webResource.exists()) {
                return null;
            }
            object2 = new ResourceEntry();
            ((ResourceEntry)object2).lastModified = webResource.getLastModified();
            clazz = this.resourceEntries;
            synchronized (clazz) {
                object = this.resourceEntries.get(string2);
                if (object == null) {
                    this.resourceEntries.put(string2, (ResourceEntry)object2);
                } else {
                    object2 = object;
                }
            }
        }
        if ((clazz = ((ResourceEntry)object2).loadedClass) != null) {
            return clazz;
        }
        object = JreCompat.isGraalAvailable() ? this : this.getClassLoadingLock(string);
        synchronized (object) {
            block34: {
                void var13_19;
                Package package_;
                String string3;
                clazz = ((ResourceEntry)object2).loadedClass;
                if (clazz != null) {
                    return clazz;
                }
                if (webResource == null) {
                    webResource = this.resources.getClassLoaderResource(string2);
                }
                if (!webResource.exists()) {
                    return null;
                }
                byte[] byArray = webResource.getContent();
                if (byArray == null) {
                    return null;
                }
                Manifest manifest = webResource.getManifest();
                URL uRL = webResource.getCodeBase();
                Certificate[] certificateArray = webResource.getCertificates();
                if (this.transformers.size() > 0) {
                    string3 = string2.substring(1, string2.length() - CLASS_FILE_SUFFIX.length());
                    for (ClassFileTransformer object32 : this.transformers) {
                        try {
                            byte[] unsupportedClassVersionError = object32.transform(this, string3, null, null, byArray);
                            if (unsupportedClassVersionError == null) continue;
                            byArray = unsupportedClassVersionError;
                        }
                        catch (IllegalClassFormatException linkageError) {
                            log.error((Object)sm.getString("webappClassLoader.transformError", new Object[]{string}), (Throwable)linkageError);
                            return null;
                        }
                    }
                }
                string3 = null;
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    string3 = string.substring(0, n);
                }
                Object var13_16 = null;
                if (string3 != null && (package_ = this.getPackage(string3)) == null) {
                    try {
                        if (manifest == null) {
                            this.definePackage(string3, null, null, null, null, null, null, null);
                        } else {
                            this.definePackage(string3, manifest, uRL);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    Package package_2 = this.getPackage(string3);
                }
                if (this.securityManager != null && var13_19 != null) {
                    boolean bl = true;
                    if (var13_19.isSealed()) {
                        bl = var13_19.isSealed(uRL);
                    } else {
                        boolean bl2 = bl = manifest == null || !this.isPackageSealed(string3, manifest);
                    }
                    if (!bl) {
                        throw new SecurityException("Sealing violation loading " + string + " : Package " + string3 + " is sealed.");
                    }
                }
                try {
                    clazz = this.defineClass(string, byArray, 0, byArray.length, new CodeSource(uRL, certificateArray));
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    throw new UnsupportedClassVersionError(unsupportedClassVersionError.getLocalizedMessage() + " " + sm.getString("webappClassLoader.wrongVersion", new Object[]{string}));
                }
                catch (LinkageError linkageError) {
                    try {
                        clazz = this.findLoadedClass0(string);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        throw linkageError;
                    }
                    if (clazz != null) break block34;
                    throw linkageError;
                }
            }
            ((ResourceEntry)object2).loadedClass = clazz;
        }
        return clazz;
    }

    private String binaryNameToPath(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(7 + string.length());
        if (bl) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string.replace('.', '/'));
        stringBuilder.append(CLASS_FILE_SUFFIX);
        return stringBuilder.toString();
    }

    private String nameToPath(String string) {
        if (string.startsWith("/")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(1 + string.length());
        stringBuilder.append('/');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected boolean isPackageSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/') + "/";
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected Class<?> findLoadedClass0(String string) {
        String string2 = this.binaryNameToPath(string, true);
        ResourceEntry resourceEntry = this.resourceEntries.get(string2);
        if (resourceEntry != null) {
            return resourceEntry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("jakarta")) {
            if (string.length() == 7) {
                return false;
            }
            char c = string.charAt(7);
            if (bl && c == '.') {
                if (string.startsWith("servlet.jsp.jstl.", 8)) {
                    return false;
                }
                if (string.startsWith("annotation.", 8) || string.startsWith("el.", 8) || string.startsWith("servlet.", 8) || string.startsWith("websocket.", 8) || string.startsWith("security.auth.message.", 8)) {
                    return true;
                }
            } else if (!bl && c == '/') {
                if (string.startsWith("servlet/jsp/jstl/", 8)) {
                    return false;
                }
                if (string.startsWith("annotation/", 8) || string.startsWith("el/", 8) || string.startsWith("servlet/", 8) || string.startsWith("websocket/", 8) || string.startsWith("security/auth/message/", 8)) {
                    return true;
                }
            }
        } else if (string.startsWith("javax")) {
            if (string.length() == 5) {
                return false;
            }
            char c = string.charAt(5);
            if (bl && c == '.' ? string.startsWith("websocket.", 6) : !bl && c == '/' && string.startsWith("websocket/", 6)) {
                return true;
            }
        } else if (string.startsWith("org")) {
            if (string.length() == 3) {
                return false;
            }
            char c = string.charAt(3);
            if (bl && c == '.') {
                if (string.startsWith("apache.", 4)) {
                    if (string.startsWith("tomcat.jdbc.", 11)) {
                        return false;
                    }
                    if (string.startsWith("el.", 11) || string.startsWith("catalina.", 11) || string.startsWith("jasper.", 11) || string.startsWith("juli.", 11) || string.startsWith("tomcat.", 11) || string.startsWith("naming.", 11) || string.startsWith("coyote.", 11)) {
                        return true;
                    }
                }
            } else if (!bl && c == '/' && string.startsWith("apache/", 4)) {
                if (string.startsWith("tomcat/jdbc/", 11)) {
                    return false;
                }
                if (string.startsWith("el/", 11) || string.startsWith("catalina/", 11) || string.startsWith("jasper/", 11) || string.startsWith("juli/", 11) || string.startsWith("tomcat/", 11) || string.startsWith("naming/", 11) || string.startsWith("coyote/", 11)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void addURL(URL uRL) {
        super.addURL(uRL);
        this.hasExternalRepositories = true;
    }

    public String getWebappName() {
        return this.getContextName();
    }

    public String getHostName() {
        Container container;
        if (this.resources != null && (container = this.resources.getContext().getParent()) != null) {
            return container.getName();
        }
        return null;
    }

    public String getServiceName() {
        Container container;
        Container container2;
        if (this.resources != null && (container2 = this.resources.getContext().getParent()) != null && (container = container2.getParent()) != null) {
            return container.getName();
        }
        return null;
    }

    public boolean hasLoggingConfig() {
        if (Globals.IS_SECURITY_ENABLED) {
            Boolean bl = AccessController.doPrivileged(new PrivilegedHasLoggingConfig());
            return bl;
        }
        return this.findResource("logging.properties") != null;
    }

    static {
        if (!JreCompat.isGraalAvailable()) {
            WebappClassLoaderBase.registerAsParallelCapable();
        }
        JVM_THREAD_GROUP_NAMES.add(JVM_THREAD_GROUP_SYSTEM);
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        sm = StringManager.getManager(WebappClassLoaderBase.class);
    }

    protected class PrivilegedFindClassByName
    implements PrivilegedAction<Class<?>> {
        private final String name;

        PrivilegedFindClassByName(String string) {
            this.name = string;
        }

        @Override
        public Class<?> run() {
            return WebappClassLoaderBase.this.findClassInternal(this.name);
        }
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    private static class CombinedEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] sources;
        private int index = 0;

        CombinedEnumeration(Enumeration<URL> enumeration, Enumeration<URL> enumeration2) {
            Enumeration[] enumerationArray = new Enumeration[]{enumeration, enumeration2};
            this.sources = enumerationArray;
        }

        @Override
        public boolean hasMoreElements() {
            return this.inc();
        }

        @Override
        public URL nextElement() {
            if (this.inc()) {
                return this.sources[this.index].nextElement();
            }
            throw new NoSuchElementException();
        }

        private boolean inc() {
            while (this.index < this.sources.length) {
                if (this.sources[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }
    }

    protected final class PrivilegedJavaseGetResource
    implements PrivilegedAction<URL> {
        private final String name;

        public PrivilegedJavaseGetResource(String string) {
            this.name = string;
        }

        @Override
        public URL run() {
            return WebappClassLoaderBase.this.javaseClassLoader.getResource(this.name);
        }
    }

    private class PrivilegedHasLoggingConfig
    implements PrivilegedAction<Boolean> {
        private PrivilegedHasLoggingConfig() {
        }

        @Override
        public Boolean run() {
            return WebappClassLoaderBase.this.findResource("logging.properties") != null;
        }
    }
}

