/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.AsyncDispatcher;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationRequest;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.core.StandardWrapper;
import org.apache.coyote.BadRequestException;
import org.apache.coyote.CloseNowException;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

final class ApplicationDispatcher
implements AsyncDispatcher,
RequestDispatcher {
    static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    static final boolean WRAP_SAME_OBJECT;
    private final Context context;
    private final String name;
    private final String pathInfo;
    private final String queryString;
    private final String requestURI;
    private final String servletPath;
    private final HttpServletMapping mapping;
    private static final StringManager sm;
    private final Wrapper wrapper;

    ApplicationDispatcher(Wrapper wrapper, String string, String string2, String string3, String string4, HttpServletMapping httpServletMapping, String string5) {
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.requestURI = string;
        this.servletPath = string2;
        this.pathInfo = string3;
        this.queryString = string4;
        this.mapping = httpServletMapping;
        this.name = string5;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedForward privilegedForward = new PrivilegedForward(servletRequest, servletResponse);
                AccessController.doPrivileged(privilegedForward);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                throw (IOException)exception;
            }
        } else {
            this.doForward(servletRequest, servletResponse);
        }
    }

    private void doForward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest;
        Object object;
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        servletResponse.resetBuffer();
        State state = new State(servletRequest, servletResponse, false);
        if (WRAP_SAME_OBJECT) {
            this.checkSameObjects(servletRequest, servletResponse);
        }
        this.wrapResponse(state);
        if (this.servletPath == null && this.pathInfo == null) {
            object = (ApplicationHttpRequest)this.wrapRequest(state);
            httpServletRequest = state.hrequest;
            ((ApplicationHttpRequest)((Object)object)).setRequestURI(httpServletRequest.getRequestURI());
            ((ApplicationHttpRequest)((Object)object)).setContextPath(httpServletRequest.getContextPath());
            ((ApplicationHttpRequest)((Object)object)).setServletPath(httpServletRequest.getServletPath());
            ((ApplicationHttpRequest)((Object)object)).setPathInfo(httpServletRequest.getPathInfo());
            ((ApplicationHttpRequest)((Object)object)).setQueryString(httpServletRequest.getQueryString());
            this.processRequest(servletRequest, servletResponse, state);
        } else {
            object = (ApplicationHttpRequest)this.wrapRequest(state);
            httpServletRequest = state.hrequest;
            if (httpServletRequest.getAttribute("javax.servlet.forward.request_uri") == null) {
                ((ApplicationHttpRequest)((Object)object)).setAttribute("javax.servlet.forward.request_uri", httpServletRequest.getRequestURI());
                ((ApplicationHttpRequest)((Object)object)).setAttribute("javax.servlet.forward.context_path", httpServletRequest.getContextPath());
                ((ApplicationHttpRequest)((Object)object)).setAttribute("javax.servlet.forward.servlet_path", httpServletRequest.getServletPath());
                ((ApplicationHttpRequest)((Object)object)).setAttribute("javax.servlet.forward.path_info", httpServletRequest.getPathInfo());
                ((ApplicationHttpRequest)((Object)object)).setAttribute("javax.servlet.forward.query_string", httpServletRequest.getQueryString());
                ((ApplicationHttpRequest)((Object)object)).setAttribute("javax.servlet.forward.mapping", httpServletRequest.getHttpServletMapping());
            }
            ((ApplicationHttpRequest)((Object)object)).setContextPath(this.context.getEncodedPath());
            ((ApplicationHttpRequest)((Object)object)).setRequestURI(this.requestURI);
            ((ApplicationHttpRequest)((Object)object)).setServletPath(this.servletPath);
            ((ApplicationHttpRequest)((Object)object)).setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                ((ApplicationHttpRequest)((Object)object)).setQueryString(this.queryString);
                ((ApplicationHttpRequest)((Object)object)).setQueryParams(this.queryString);
            }
            ((ApplicationHttpRequest)((Object)object)).setMapping(this.mapping);
            this.processRequest(servletRequest, servletResponse, state);
        }
        if (servletRequest.isAsyncStarted()) {
            return;
        }
        if (this.wrapper.getLogger().isTraceEnabled()) {
            this.wrapper.getLogger().trace((Object)" Disabling the response for further output");
        }
        if (servletResponse instanceof ResponseFacade) {
            ((ResponseFacade)servletResponse).finish();
        } else {
            if (this.wrapper.getLogger().isTraceEnabled()) {
                this.wrapper.getLogger().trace((Object)(" The Response is vehiculed using a wrapper: " + servletResponse.getClass().getName()));
            }
            try {
                object = servletResponse.getWriter();
                ((PrintWriter)object).close();
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    httpServletRequest = servletResponse.getOutputStream();
                    httpServletRequest.close();
                }
                catch (IOException | IllegalStateException exception) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processRequest(ServletRequest servletRequest, ServletResponse servletResponse, State state) throws IOException, ServletException {
        DispatcherType dispatcherType = (DispatcherType)servletRequest.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        if (dispatcherType != null) {
            boolean bl = true;
            if (this.context.getFireRequestListenersOnForwards() && !this.context.fireRequestInitEvent(servletRequest)) {
                bl = false;
            }
            if (bl) {
                if (dispatcherType != DispatcherType.ERROR) {
                    state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)this.getCombinedPath());
                    state.outerRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.FORWARD);
                    this.invoke(state.outerRequest, servletResponse, state);
                } else {
                    this.invoke(state.outerRequest, servletResponse, state);
                }
                if (this.context.getFireRequestListenersOnForwards()) {
                    this.context.fireRequestDestroyEvent(servletRequest);
                }
            }
        }
    }

    private String getCombinedPath() {
        if (this.servletPath == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return this.servletPath;
        }
        return this.servletPath + this.pathInfo;
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedInclude privilegedInclude = new PrivilegedInclude(servletRequest, servletResponse);
                AccessController.doPrivileged(privilegedInclude);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                throw (IOException)exception;
            }
        } else {
            this.doInclude(servletRequest, servletResponse);
        }
    }

    private void doInclude(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        State state = new State(servletRequest, servletResponse, true);
        if (WRAP_SAME_OBJECT) {
            this.checkSameObjects(servletRequest, servletResponse);
        }
        this.wrapResponse(state);
        if (this.name != null) {
            ApplicationHttpRequest applicationHttpRequest = (ApplicationHttpRequest)this.wrapRequest(state);
            applicationHttpRequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                applicationHttpRequest.setServletPath(this.servletPath);
            }
            applicationHttpRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.INCLUDE);
            applicationHttpRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            this.invoke(state.outerRequest, state.outerResponse, state);
        } else {
            ApplicationHttpRequest applicationHttpRequest = (ApplicationHttpRequest)this.wrapRequest(state);
            String string = this.context.getPath();
            if (this.requestURI != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.request_uri", this.requestURI);
            }
            if (string != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.context_path", string);
            }
            if (this.servletPath != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                applicationHttpRequest.setQueryParams(this.queryString);
            }
            if (this.mapping != null) {
                applicationHttpRequest.setAttribute("javax.servlet.include.mapping", this.mapping);
            }
            applicationHttpRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.INCLUDE);
            applicationHttpRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
            this.invoke(state.outerRequest, state.outerResponse, state);
        }
    }

    @Override
    public void dispatch(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                PrivilegedDispatch privilegedDispatch = new PrivilegedDispatch(servletRequest, servletResponse);
                AccessController.doPrivileged(privilegedDispatch);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                throw (IOException)exception;
            }
        } else {
            this.doDispatch(servletRequest, servletResponse);
        }
    }

    private void doDispatch(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        State state = new State(servletRequest, servletResponse, false);
        this.wrapResponse(state);
        ApplicationHttpRequest applicationHttpRequest = (ApplicationHttpRequest)this.wrapRequest(state);
        HttpServletRequest httpServletRequest = state.hrequest;
        applicationHttpRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
        applicationHttpRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", this.getCombinedPath());
        applicationHttpRequest.setAttribute("javax.servlet.async.mapping", httpServletRequest.getHttpServletMapping());
        applicationHttpRequest.setContextPath(this.context.getEncodedPath());
        applicationHttpRequest.setRequestURI(this.requestURI);
        applicationHttpRequest.setServletPath(this.servletPath);
        applicationHttpRequest.setPathInfo(this.pathInfo);
        if (this.queryString != null) {
            applicationHttpRequest.setQueryString(this.queryString);
            applicationHttpRequest.setQueryParams(this.queryString);
        }
        if (!Globals.STRICT_SERVLET_COMPLIANCE) {
            applicationHttpRequest.setMapping(this.mapping);
        }
        this.invoke(state.outerRequest, state.outerResponse, state);
    }

    private void invoke(ServletRequest servletRequest, ServletResponse servletResponse, State state) throws IOException, ServletException {
        ClassLoader classLoader = this.context.bind(false, null);
        HttpServletResponse httpServletResponse = state.hresponse;
        Servlet servlet = null;
        Throwable throwable = null;
        Throwable throwable2 = null;
        RuntimeException runtimeException = null;
        boolean bl = false;
        if (this.wrapper.isUnavailable()) {
            this.wrapper.getLogger().warn((Object)sm.getString("applicationDispatcher.isUnavailable", new Object[]{this.wrapper.getName()}));
            long l = this.wrapper.getAvailable();
            if (l > 0L && l < Long.MAX_VALUE) {
                httpServletResponse.setDateHeader("Retry-After", l);
            }
            httpServletResponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", new Object[]{this.wrapper.getName()}));
            bl = true;
        }
        try {
            if (!bl) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException servletException) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.allocateException", new Object[]{this.wrapper.getName()}), StandardWrapper.getRootCause(servletException));
            throwable2 = servletException;
        }
        catch (Throwable throwable3) {
            ExceptionUtils.handleThrowable((Throwable)throwable3);
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.allocateException", new Object[]{this.wrapper.getName()}), throwable3);
            throwable2 = new ServletException(sm.getString("applicationDispatcher.allocateException", new Object[]{this.wrapper.getName()}), throwable3);
            servlet = null;
        }
        ApplicationFilterChain applicationFilterChain = ApplicationFilterFactory.createFilterChain(servletRequest, this.wrapper, servlet);
        try {
            if (servlet != null && applicationFilterChain != null) {
                applicationFilterChain.doFilter(servletRequest, servletResponse);
            }
        }
        catch (BadRequestException | CloseNowException throwable4) {
            throwable = throwable4;
        }
        catch (IOException iOException) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", new Object[]{this.wrapper.getName()}), (Throwable)iOException);
            throwable = iOException;
        }
        catch (UnavailableException unavailableException) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", new Object[]{this.wrapper.getName()}), (Throwable)unavailableException);
            throwable2 = unavailableException;
            this.wrapper.unavailable(unavailableException);
        }
        catch (ServletException servletException) {
            Throwable throwable5 = StandardWrapper.getRootCause(servletException);
            if (!(throwable5 instanceof BadRequestException)) {
                this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", new Object[]{this.wrapper.getName()}), throwable5);
            }
            throwable2 = servletException;
        }
        catch (RuntimeException runtimeException2) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.serviceException", new Object[]{this.wrapper.getName()}), (Throwable)runtimeException2);
            runtimeException = runtimeException2;
        }
        if (applicationFilterChain != null) {
            applicationFilterChain.release();
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException servletException) {
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.deallocateException", new Object[]{this.wrapper.getName()}), (Throwable)servletException);
            throwable2 = servletException;
        }
        catch (Throwable throwable6) {
            ExceptionUtils.handleThrowable((Throwable)throwable6);
            this.wrapper.getLogger().error((Object)sm.getString("applicationDispatcher.deallocateException", new Object[]{this.wrapper.getName()}), throwable6);
            throwable2 = new ServletException(sm.getString("applicationDispatcher.deallocateException", new Object[]{this.wrapper.getName()}), throwable6);
        }
        this.context.unbind(false, classLoader);
        this.unwrapRequest(state);
        this.unwrapResponse(state);
        this.recycleRequestWrapper(state);
        if (throwable != null) {
            throw throwable;
        }
        if (throwable2 != null) {
            throw throwable2;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void unwrapRequest(State state) {
        if (state.wrapRequest == null) {
            return;
        }
        if (state.outerRequest.isAsyncStarted() && !state.outerRequest.getAsyncContext().hasOriginalRequestAndResponse()) {
            return;
        }
        ServletRequest servletRequest = null;
        ServletRequest servletRequest2 = state.outerRequest;
        while (servletRequest2 != null && !(servletRequest2 instanceof Request) && !(servletRequest2 instanceof RequestFacade)) {
            if (servletRequest2 == state.wrapRequest) {
                ServletRequest servletRequest3 = ((ServletRequestWrapper)servletRequest2).getRequest();
                if (servletRequest == null) {
                    state.outerRequest = servletRequest3;
                    break;
                }
                ((ServletRequestWrapper)servletRequest).setRequest(servletRequest3);
                break;
            }
            servletRequest = servletRequest2;
            servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
        }
    }

    private void unwrapResponse(State state) {
        if (state.wrapResponse == null) {
            return;
        }
        if (state.outerRequest.isAsyncStarted() && !state.outerRequest.getAsyncContext().hasOriginalRequestAndResponse()) {
            return;
        }
        ServletResponse servletResponse = null;
        ServletResponse servletResponse2 = state.outerResponse;
        while (servletResponse2 != null && !(servletResponse2 instanceof Response) && !(servletResponse2 instanceof ResponseFacade)) {
            if (servletResponse2 == state.wrapResponse) {
                ServletResponse servletResponse3 = ((ServletResponseWrapper)servletResponse2).getResponse();
                if (servletResponse == null) {
                    state.outerResponse = servletResponse3;
                    break;
                }
                ((ServletResponseWrapper)servletResponse).setResponse(servletResponse3);
                break;
            }
            servletResponse = servletResponse2;
            servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
        }
    }

    private ServletRequest wrapRequest(State state) {
        ServletRequest servletRequest = null;
        ServletRequest servletRequest2 = state.outerRequest;
        while (servletRequest2 != null) {
            if (state.hrequest == null && servletRequest2 instanceof HttpServletRequest) {
                state.hrequest = (HttpServletRequest)servletRequest2;
            }
            if (!(servletRequest2 instanceof ServletRequestWrapper) || servletRequest2 instanceof ApplicationHttpRequest || servletRequest2 instanceof ApplicationRequest) break;
            servletRequest = servletRequest2;
            servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
        }
        Object object = null;
        if (servletRequest2 instanceof ApplicationHttpRequest || servletRequest2 instanceof Request || servletRequest2 instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest2;
            boolean bl = false;
            if (state.outerRequest instanceof ApplicationHttpRequest || state.outerRequest instanceof Request || state.outerRequest instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest2 = (HttpServletRequest)state.outerRequest;
                Object object2 = httpServletRequest2.getAttribute("javax.servlet.include.context_path");
                if (object2 == null) {
                    object2 = httpServletRequest2.getContextPath();
                }
                bl = !this.context.getPath().equals(object2);
            }
            object = new ApplicationHttpRequest(httpServletRequest, this.context, bl);
        } else {
            object = new ApplicationRequest(servletRequest2);
        }
        if (servletRequest == null) {
            state.outerRequest = object;
        } else {
            ((ServletRequestWrapper)servletRequest).setRequest((ServletRequest)object);
        }
        state.wrapRequest = object;
        return object;
    }

    private ServletResponse wrapResponse(State state) {
        ServletResponse servletResponse = null;
        ServletResponse servletResponse2 = state.outerResponse;
        while (servletResponse2 != null) {
            if (state.hresponse == null && servletResponse2 instanceof HttpServletResponse) {
                state.hresponse = (HttpServletResponse)servletResponse2;
                if (!state.including) {
                    return null;
                }
            }
            if (!(servletResponse2 instanceof ServletResponseWrapper) || servletResponse2 instanceof ApplicationHttpResponse || servletResponse2 instanceof ApplicationResponse) break;
            servletResponse = servletResponse2;
            servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
        }
        Object object = null;
        object = servletResponse2 instanceof ApplicationHttpResponse || servletResponse2 instanceof Response || servletResponse2 instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)servletResponse2, state.including) : new ApplicationResponse(servletResponse2, state.including);
        if (servletResponse == null) {
            state.outerResponse = object;
        } else {
            ((ServletResponseWrapper)servletResponse).setResponse((ServletResponse)object);
        }
        state.wrapResponse = object;
        return object;
    }

    private void checkSameObjects(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException {
        ServletRequest servletRequest2 = ApplicationFilterChain.getLastServicedRequest();
        ServletResponse servletResponse2 = ApplicationFilterChain.getLastServicedResponse();
        if (servletRequest2 == null || servletResponse2 == null) {
            return;
        }
        boolean bl = false;
        ServletRequest servletRequest3 = servletRequest;
        while (servletRequest2 instanceof ServletRequestWrapper && ((ServletRequestWrapper)servletRequest2).getRequest() != null) {
            servletRequest2 = ((ServletRequestWrapper)servletRequest2).getRequest();
        }
        while (!bl) {
            if (servletRequest2.equals(servletRequest3)) {
                bl = true;
            }
            if (bl || !(servletRequest3 instanceof ServletRequestWrapper)) break;
            servletRequest3 = ((ServletRequestWrapper)servletRequest3).getRequest();
        }
        if (!bl) {
            throw new ServletException(sm.getString("applicationDispatcher.specViolation.request"));
        }
        bl = false;
        ServletResponse servletResponse3 = servletResponse;
        while (servletResponse2 instanceof ServletResponseWrapper && ((ServletResponseWrapper)servletResponse2).getResponse() != null) {
            servletResponse2 = ((ServletResponseWrapper)servletResponse2).getResponse();
        }
        while (!bl) {
            if (servletResponse2.equals(servletResponse3)) {
                bl = true;
            }
            if (bl || !(servletResponse3 instanceof ServletResponseWrapper)) break;
            servletResponse3 = ((ServletResponseWrapper)servletResponse3).getResponse();
        }
        if (!bl) {
            throw new ServletException(sm.getString("applicationDispatcher.specViolation.response"));
        }
    }

    private void recycleRequestWrapper(State state) {
        if (state.wrapRequest instanceof ApplicationHttpRequest) {
            ((ApplicationHttpRequest)state.wrapRequest).recycle();
        }
    }

    static {
        String string = System.getProperty("org.apache.catalina.core.ApplicationDispatcher.WRAP_SAME_OBJECT");
        WRAP_SAME_OBJECT = string == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string);
        sm = StringManager.getManager(ApplicationDispatcher.class);
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedForward(ServletRequest servletRequest, ServletResponse servletResponse) {
            this.request = servletRequest;
            this.response = servletResponse;
        }

        @Override
        public Void run() throws Exception {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }

    private static class State {
        ServletRequest outerRequest = null;
        ServletResponse outerResponse = null;
        ServletRequest wrapRequest = null;
        ServletResponse wrapResponse = null;
        boolean including = false;
        HttpServletRequest hrequest = null;
        HttpServletResponse hresponse = null;

        State(ServletRequest servletRequest, ServletResponse servletResponse, boolean bl) {
            this.outerRequest = servletRequest;
            this.outerResponse = servletResponse;
            this.including = bl;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedInclude(ServletRequest servletRequest, ServletResponse servletResponse) {
            this.request = servletRequest;
            this.response = servletResponse;
        }

        @Override
        public Void run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedDispatch
    implements PrivilegedExceptionAction<Void> {
        private final ServletRequest request;
        private final ServletResponse response;

        PrivilegedDispatch(ServletRequest servletRequest, ServletResponse servletResponse) {
            this.request = servletRequest;
            this.response = servletResponse;
        }

        @Override
        public Void run() throws ServletException, IOException {
            ApplicationDispatcher.this.doDispatch(this.request, this.response);
            return null;
        }
    }
}

