/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceLinkRef;
import org.apache.naming.StringManager;

public class ResourceLinkFactory
implements ObjectFactory {
    protected static final StringManager sm = StringManager.getManager(ResourceLinkFactory.class);
    private static Context globalContext = null;
    private static Map<ClassLoader, Map<String, String>> globalResourceRegistrations = new ConcurrentHashMap<ClassLoader, Map<String, String>>();

    public static void setGlobalContext(Context context) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission(ResourceLinkFactory.class.getName() + ".setGlobalContext"));
        }
        globalContext = context;
    }

    public static void registerGlobalResourceAccess(Context context, String string, String string2) {
        ResourceLinkFactory.validateGlobalContext(context);
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        globalResourceRegistrations.computeIfAbsent(classLoader2, classLoader -> new HashMap()).put(string, string2);
    }

    public static void deregisterGlobalResourceAccess(Context context, String string) {
        ResourceLinkFactory.validateGlobalContext(context);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map<String, String> map = globalResourceRegistrations.get(classLoader);
        if (map != null) {
            map.remove(string);
        }
    }

    public static void deregisterGlobalResourceAccess(Context context) {
        ResourceLinkFactory.validateGlobalContext(context);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        globalResourceRegistrations.remove(classLoader);
    }

    private static void validateGlobalContext(Context context) {
        if (globalContext != null && globalContext != context) {
            throw new SecurityException(sm.getString("resourceLinkFactory.invalidGlobalContext"));
        }
    }

    private static boolean validateGlobalResourceAccess(String string) {
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            Map<String, String> map = globalResourceRegistrations.get(classLoader);
            if (map == null || !map.containsValue(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        if (!(object instanceof ResourceLinkRef)) {
            return null;
        }
        Reference reference = (Reference)object;
        String string = null;
        RefAddr refAddr = reference.get("globalName");
        if (refAddr != null) {
            string = refAddr.getContent().toString();
            if (!ResourceLinkFactory.validateGlobalResourceAccess(string)) {
                return null;
            }
            Object object2 = null;
            object2 = globalContext.lookup(string);
            String string2 = reference.getClassName();
            if (string2 == null) {
                throw new IllegalArgumentException(sm.getString("resourceLinkFactory.nullType", name, string));
            }
            try {
                Class<?> clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                if (!clazz.isAssignableFrom(object2.getClass())) {
                    throw new IllegalArgumentException(sm.getString("resourceLinkFactory.wrongType", name, string, string2, object2.getClass().getName()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(sm.getString("resourceLinkFactory.unknownType", name, string, string2), classNotFoundException);
            }
            return object2;
        }
        return null;
    }
}

