"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateGetImplementation = void 0;
const utils_1 = require("../utils");
function decorateGetImplementation(ls, snapshotManager, logger) {
    const getImplementationAtPosition = ls.getImplementationAtPosition;
    ls.getImplementationAtPosition = (fileName, position) => {
        const implementation = getImplementationAtPosition(fileName, position);
        return implementation
            ?.map((impl) => {
            if (!(0, utils_1.isSvelteFilePath)(impl.fileName)) {
                return impl;
            }
            const textSpan = snapshotManager
                .get(impl.fileName)
                ?.getOriginalTextSpan(impl.textSpan);
            if (!textSpan) {
                return undefined;
            }
            return {
                ...impl,
                textSpan,
                // Spare the work for now
                contextSpan: undefined,
                originalTextSpan: undefined,
                originalContextSpan: undefined
            };
        })
            .filter(utils_1.isNotNullOrUndefined);
    };
}
exports.decorateGetImplementation = decorateGetImplementation;
//# sourceMappingURL=implementation.js.map