/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.h3;

import org.opensearch.geospatial.h3.Constants;
import org.opensearch.geospatial.h3.CoordIJK;
import org.opensearch.geospatial.h3.H3Index;

final class Iterator {
    public static final long H3_NULL = 0L;
    private static final int H3_PER_DIGIT_OFFSET = 3;

    Iterator() {
    }

    private static IterCellsChildren nullIter() {
        return new IterCellsChildren(0L, -1, -1);
    }

    public static IterCellsChildren iterInitParent(long h, int childRes) {
        int parentRes = H3Index.H3_get_resolution(h);
        if (childRes < parentRes || childRes > Constants.MAX_H3_RES || h == 0L) {
            return Iterator.nullIter();
        }
        long newH = Iterator.zeroIndexDigits(h, parentRes + 1, childRes);
        int _skipDigit = H3Index.H3_is_pentagon(newH = H3Index.H3_set_resolution(newH, childRes)) ? childRes : -1;
        return new IterCellsChildren(newH, parentRes, _skipDigit);
    }

    public static void iterStepChild(IterCellsChildren it) {
        if (it.h == 0L) {
            return;
        }
        int childRes = H3Index.H3_get_resolution(it.h);
        Iterator.incrementResDigit(it, childRes);
        for (int i = childRes; i >= it._parentRes; --i) {
            if (i == it._parentRes) {
                it.h = 0L;
                return;
            }
            if (i == it._skipDigit && Iterator.getResDigit(it, i) == CoordIJK.Direction.PENTAGON_SKIPPED_DIGIT.digit()) {
                Iterator.incrementResDigit(it, i);
                --it._skipDigit;
                return;
            }
            if (Iterator.getResDigit(it, i) != CoordIJK.Direction.INVALID_DIGIT.digit()) break;
            Iterator.incrementResDigit(it, i);
        }
    }

    private static int getResDigit(IterCellsChildren it, int res) {
        return H3Index.H3_get_index_digit(it.h, res);
    }

    private static long zeroIndexDigits(long h, int start, int end) {
        if (start > end) {
            return h;
        }
        long m = 0L;
        m ^= 0xFFFFFFFFFFFFFFFFL;
        m <<= 3 * (end - start + 1);
        m ^= 0xFFFFFFFFFFFFFFFFL;
        m <<= 3 * (Constants.MAX_H3_RES - end);
        return h & (m ^= 0xFFFFFFFFFFFFFFFFL);
    }

    private static void incrementResDigit(IterCellsChildren it, int res) {
        long val = 1L;
        it.h += (val <<= 3 * (Constants.MAX_H3_RES - res));
    }

    static class IterCellsChildren {
        long h;
        int _parentRes;
        int _skipDigit;

        IterCellsChildren(long h, int _parentRes, int _skipDigit) {
            this.h = h;
            this._parentRes = _parentRes;
            this._skipDigit = _skipDigit;
        }
    }
}

