/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyResponse;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\bH\u0016R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t \n*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/resthandler/RestIndexPolicyAction;", "Lorg/opensearch/rest/BaseRestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getName", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-index-management"})
public final class RestIndexPolicyAction
extends BaseRestHandler {
    @NotNull
    private final ClusterService clusterService;
    private volatile List<String> allowList;

    public RestIndexPolicyAction(@NotNull Settings settings, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.clusterService = clusterService;
        this.allowList = (List)ManagedIndexSettings.Companion.getALLOW_LIST().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getALLOW_LIST(), arg_0 -> RestIndexPolicyAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_ism/policies", RestRequest.Method.PUT, "/_opendistro/_ism/policies"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_ism/policies/{policyID}", RestRequest.Method.PUT, "/_opendistro/_ism/policies/{policyID}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "index_policy_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String id2 = request.param("policyID", "");
        if (Intrinsics.areEqual((Object)"", (Object)id2)) {
            throw new IllegalArgumentException("Missing policy ID");
        }
        XContentParser xcp = request.contentParser();
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"id");
        Policy policy2 = (Policy)OpenSearchExtensionsKt.parseWithType$default(xcp, id2, 0L, 0L, (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

            @NotNull
            public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
            }
        }, 6, null);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        Policy policy3 = Policy.copy$default(policy2, null, 0L, 0L, null, 0L, instant, null, null, null, null, null, 2015, null);
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        List<String> list = this.allowList;
        Intrinsics.checkNotNullExpressionValue(list, (String)"allowList");
        List<String> disallowedActions = policy3.getDisallowedActions(list);
        if (!((Collection)disallowedActions).isEmpty()) {
            return arg_0 -> RestIndexPolicyAction.prepareRequest$lambda$1(disallowedActions, arg_0);
        }
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"refreshPolicy");
        IndexPolicyRequest indexPolicyRequest = new IndexPolicyRequest(id2, policy3, seqNo, primaryTerm, refreshPolicy);
        return arg_0 -> RestIndexPolicyAction.prepareRequest$lambda$2(client, indexPolicyRequest, arg_0);
    }

    private static final void _init_$lambda$0(RestIndexPolicyAction this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.allowList = it;
    }

    private static final void prepareRequest$lambda$1(List $disallowedActions, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$disallowedActions, (String)"$disallowedActions");
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "You have actions that are not allowed in your policy " + $disallowedActions));
    }

    private static final void prepareRequest$lambda$2(NodeClient $client, IndexPolicyRequest $indexPolicyRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$indexPolicyRequest), (String)"$indexPolicyRequest");
        $client.execute((ActionType)IndexPolicyAction.Companion.getINSTANCE(), (ActionRequest)$indexPolicyRequest, (ActionListener)new RestResponseListener<IndexPolicyResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            @NotNull
            public RestResponse buildResponse(@NotNull IndexPolicyResponse response2) {
                Intrinsics.checkNotNullParameter((Object)((Object)response2), (String)"response");
                RestStatus restStatus = response2.getStatus();
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"channel.newBuilder()");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(restStatus, response2.toXContent(xContentBuilder, params));
                if (response2.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_ism/policies/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        });
    }
}

