/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableSpaceRackFaultTolerantBlockPlacementPolicy
extends BlockPlacementPolicyRackFaultTolerant {
    private static final Logger LOG = LoggerFactory.getLogger(AvailableSpaceRackFaultTolerantBlockPlacementPolicy.class);
    private static final Random RAND = new Random();
    private int balancedPreference = 60;
    private int balancedSpaceTolerance = 5;

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        super.initialize(conf, stats, clusterMap, host2datanodeMap);
        float balancedPreferencePercent = conf.getFloat("dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-preference-fraction", 0.6f);
        this.balancedSpaceTolerance = conf.getInt("dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-tolerance", 5);
        LOG.info("Available space rack fault tolerant block placement policy initialized: dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-preference-fraction = " + balancedPreferencePercent);
        if ((double)balancedPreferencePercent > 1.0) {
            LOG.warn("The value of dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-preference-fraction is greater than 1.0 but should be in the range 0.0 - 1.0");
        }
        if ((double)balancedPreferencePercent < 0.5) {
            LOG.warn("The value of dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-preference-fraction is less than 0.5 so datanodes with more used percent will receive  more block allocations.");
        }
        if (this.balancedSpaceTolerance > 20 || this.balancedSpaceTolerance < 0) {
            LOG.warn("The value of dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-tolerance is invalid, Current value is " + this.balancedSpaceTolerance + ", Default value " + 5 + " will be used instead.");
            this.balancedSpaceTolerance = 5;
        }
        this.balancedPreference = (int)(100.0f * balancedPreferencePercent);
    }

    @Override
    protected DatanodeDescriptor chooseDataNode(String scope, Collection<Node> excludedNode, StorageType type) {
        Preconditions.checkArgument((boolean)(this.clusterMap instanceof DFSNetworkTopology));
        DFSNetworkTopology dfsClusterMap = (DFSNetworkTopology)this.clusterMap;
        DatanodeDescriptor a = (DatanodeDescriptor)dfsClusterMap.chooseRandomWithStorageTypeTwoTrial(scope, excludedNode, type);
        DatanodeDescriptor b = (DatanodeDescriptor)dfsClusterMap.chooseRandomWithStorageTypeTwoTrial(scope, excludedNode, type);
        return this.select(a, b);
    }

    @Override
    protected DatanodeDescriptor chooseDataNode(String scope, Collection<Node> excludedNode) {
        DatanodeDescriptor a = (DatanodeDescriptor)this.clusterMap.chooseRandom(scope, excludedNode);
        DatanodeDescriptor b = (DatanodeDescriptor)this.clusterMap.chooseRandom(scope, excludedNode);
        return this.select(a, b);
    }

    private DatanodeDescriptor select(DatanodeDescriptor a, DatanodeDescriptor b) {
        if (a != null && b != null) {
            int ret = this.compareDataNode(a, b);
            if (ret == 0) {
                return a;
            }
            if (ret < 0) {
                return RAND.nextInt(100) < this.balancedPreference ? a : b;
            }
            return RAND.nextInt(100) < this.balancedPreference ? b : a;
        }
        return a == null ? b : a;
    }

    protected int compareDataNode(DatanodeDescriptor a, DatanodeDescriptor b) {
        if (a.equals((Object)b) || Math.abs(a.getDfsUsedPercent() - b.getDfsUsedPercent()) < (float)this.balancedSpaceTolerance) {
            return 0;
        }
        return a.getDfsUsedPercent() < b.getDfsUsedPercent() ? -1 : 1;
    }
}

