/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class PDEncryptionManager {
    private static Map handlerMap = Collections.synchronizedMap(new HashMap());

    private PDEncryptionManager() {
    }

    public static void registerSecurityHandler(String filterName, Class handlerClass) {
        handlerMap.put(COSName.getPDFName(filterName), handlerClass);
    }

    public static PDEncryptionDictionary getEncryptionDictionary(COSDictionary dictionary) throws IOException {
        Object retval = null;
        if (dictionary != null) {
            COSName filter = (COSName)dictionary.getDictionaryObject(COSName.FILTER);
            Class handlerClass = (Class)handlerMap.get(filter);
            if (handlerClass == null) {
                throw new IOException("No handler for security handler '" + filter.getName() + "'");
            }
            try {
                Constructor ctor = handlerClass.getDeclaredConstructor(COSDictionary.class);
                retval = ctor.newInstance(dictionary);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.getMessage());
            }
        }
        return retval;
    }

    static {
        PDEncryptionManager.registerSecurityHandler("Standard", PDStandardEncryption.class);
    }
}

