/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.TestURL;
import io.mola.galimatias.URL;
import io.mola.galimatias.canonicalize.DecodeUnreservedCanonicalizer;
import org.fest.assertions.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class DecodeUnreservedCanonicalizerTest {
    @Test
    public void test() throws GalimatiasParseException {
        DecodeUnreservedCanonicalizer canon = new DecodeUnreservedCanonicalizer();
        for (String[] pair : new String[][]{{"http://%41%5A%61%7A%30%39%2D%2E%5F%7E@example.com/", "http://AZaz09-._~@example.com/"}, {"http://:%41%5A%61%7A%30%39%2D%2E%5F%7E@example.com/", "http://:AZaz09-._~@example.com/"}, {"http://example.com/%41%5A%61%7A%30%39%2D%2E%5F%7E", "http://example.com/AZaz09-._~"}, {"http://example.com/?%41%5A%61%7A%30%39%2D%2E%5F%7E", "http://example.com/?AZaz09-._~"}, {"http://example.com/#%41%5A%61%7A%30%39%2D%2E%5F%7E", "http://example.com/#AZaz09-._~"}}) {
            Assertions.assertThat((String)canon.canonicalize(URL.parse(pair[0])).toString()).isEqualTo((Object)URL.parse(pair[1]).toString());
        }
    }

    @Theory
    public void idempotence(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        DecodeUnreservedCanonicalizer canon = new DecodeUnreservedCanonicalizer();
        URL roundOne = canon.canonicalize(testURL.parsedURL);
        URL roundTwo = canon.canonicalize(roundOne);
        Assertions.assertThat((Object)roundOne).isEqualTo((Object)roundTwo);
        URL reparse = URL.parse(roundTwo.toString());
        Assertions.assertThat((Object)reparse).isEqualTo((Object)roundTwo);
    }
}

