/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.targets.SiteTracker;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ConstantLookupSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantLookupSite.class);
    private final String name;
    private final boolean publicOnly;
    private final boolean callConstMissing;
    private volatile RubySymbol symbolicName;
    private final SiteTracker tracker = new SiteTracker();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(ConstantLookupSite.class), "constLookup", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE, Integer.TYPE), false);
    private MethodHandle _SMFC;
    private MethodHandle _noCacheSMFC;
    private MethodHandle _ISC;
    private MethodHandle _noCacheISC;

    public ConstantLookupSite(MethodType type2, String name2, boolean publicOnly, boolean callConstMissing) {
        super(type2);
        this.name = name2;
        this.publicOnly = publicOnly;
        this.callConstMissing = callConstMissing;
    }

    public static CallSite constLookup(MethodHandles.Lookup lookup, String searchType, MethodType type2, String constName, int publicOnly, int callConstMissing) {
        ConstantLookupSite site = new ConstantLookupSite(type2, constName, publicOnly != 0, callConstMissing != 0);
        MethodHandle handle = Binder.from(lookup, type2).insert(0, site).invokeVirtualQuiet(lookup, searchType);
        site.setTarget(handle);
        return site;
    }

    private RubySymbol getSymbolicName(ThreadContext context) {
        RubySymbol symbolicName = this.symbolicName;
        if (symbolicName != null) {
            return symbolicName;
        }
        this.symbolicName = context.runtime.fastNewSymbol(this.name);
        return this.symbolicName;
    }

    public IRubyObject searchConst(ThreadContext context, StaticScope staticScope) {
        Ruby runtime2 = context.getRuntime();
        RubyClass object = runtime2.getObject();
        SwitchPoint switchPoint = this.getSwitchPointForConstant(runtime2);
        IRubyObject constant = staticScope == null ? object.getConstant(this.name) : staticScope.getConstantInner(this.name);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        }
        if (constant == null) {
            if (this.callConstMissing) {
                return module.callMethod(context, "const_missing", (IRubyObject)this.getSymbolicName(context));
            }
            return UndefinedValue.UNDEFINED;
        }
        MethodHandle target2 = Binder.from(this.type()).drop(0, 2).constant(constant);
        MethodHandle fallback = Binder.from(this.type()).insert(0, this).invokeVirtualQuiet(LOOKUP, "searchConst");
        this.setTarget(switchPoint.guardWithTest(target2, fallback));
        if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from scope (searchConst) " + staticScope.getIRScope(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject searchModuleForConst(ThreadContext context, IRubyObject cmVal) throws Throwable {
        IRubyObject constant;
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        if (this.checkForBailout(module)) {
            return this.bail(context, cmVal, this.noCacheSMFC());
        }
        Ruby runtime2 = context.getRuntime();
        SwitchPoint switchPoint = this.getSwitchPointForConstant(runtime2);
        IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        if (constant == null) {
            if (this.callConstMissing) {
                return module.callMethod(context, "const_missing", (IRubyObject)this.getSymbolicName(context));
            }
            return UndefinedValue.UNDEFINED;
        }
        this.bind(runtime2, module, switchPoint, constant, this.SMFC());
        if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from module (searchModuleForConst) " + cmVal.getMetaClass(), new Object[0]);
        }
        return constant;
    }

    private SwitchPoint getSwitchPointForConstant(Ruby runtime2) {
        return (SwitchPoint)runtime2.getConstantInvalidator(this.name).getData();
    }

    public IRubyObject noCacheSearchModuleForConst(ThreadContext context, IRubyObject cmVal) {
        IRubyObject constant;
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)this.getSymbolicName(context));
        }
        return constant;
    }

    public IRubyObject inheritanceSearchConst(ThreadContext context, IRubyObject cmVal) throws Throwable {
        Ruby runtime2 = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime2.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        if (this.checkForBailout(module)) {
            return this.bail(context, cmVal, this.noCacheISC());
        }
        SwitchPoint switchPoint = this.getSwitchPointForConstant(runtime2);
        IRubyObject constant = module.getConstantNoConstMissingSkipAutoload(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        this.bind(runtime2, module, switchPoint, constant, this.ISC());
        this.tracker.addType(module.id);
        if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
            LOG.info(this.name + "\tconstant cached from type (inheritanceSearchConst) " + cmVal.getMetaClass(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject noCacheInheritanceSearchConst(ThreadContext context, IRubyObject cmVal) {
        Ruby runtime2 = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime2.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject constant = module.getConstantNoConstMissingSkipAutoload(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    private MethodHandle getFallback(RubyModule module, MethodHandle cachingFallback) {
        MethodHandle fallback;
        if (this.tracker.seenTypesCount() > 0 && !this.tracker.hasSeenType(module.id)) {
            if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
                LOG.info(this.name + "\tconstant added to PIC", new Object[0]);
            }
            fallback = this.getTarget();
        } else {
            if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
                LOG.info(this.name + "\tconstant " + (this.tracker.seenTypesCount() > 0 ? "rebound" : "bound"), new Object[0]);
            }
            fallback = cachingFallback;
            this.tracker.clearTypes();
        }
        return fallback;
    }

    private boolean checkForBailout(RubyModule module) {
        if (this.tracker.clearCount() > Options.INVOKEDYNAMIC_MAXFAIL.load()) {
            if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
                LOG.info(this.name + "\tinvalidated more than " + Options.INVOKEDYNAMIC_MAXFAIL.load() + " times ", new Object[0]);
            }
            return true;
        }
        if (!this.tracker.hasSeenType(module.id) && this.tracker.seenTypesCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
                LOG.info(this.name + "\tencountered more than " + Options.INVOKEDYNAMIC_MAXPOLY.load() + " types ", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private IRubyObject bail(ThreadContext context, IRubyObject cmVal, MethodHandle noncachingFallback) throws Throwable {
        this.setTarget(noncachingFallback);
        return noncachingFallback.invokeExact(context, cmVal);
    }

    private void bind(Ruby runtime2, RubyModule module, SwitchPoint switchPoint, IRubyObject constant, MethodHandle cachingFallback) {
        MethodHandle target2 = Binder.from(this.type()).drop(0, 2).constant(constant);
        MethodHandle fallback = this.getFallback(module, cachingFallback);
        target2 = MethodHandles.guardWithTest(module.getIdTest(), target2, fallback);
        target2 = switchPoint.guardWithTest(target2, fallback);
        this.setTarget(target2);
    }

    public IRubyObject lexicalSearchConst(ThreadContext context, StaticScope scope) {
        Ruby runtime2 = context.runtime;
        SwitchPoint switchPoint = this.getSwitchPointForConstant(runtime2);
        IRubyObject constant = scope.getConstantDefined(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        MethodHandle target2 = Binder.from(this.type()).drop(0, 2).constant(constant);
        MethodHandle fallback = Binder.from(this.type()).insert(0, this).invokeVirtualQuiet(LOOKUP, "lexicalSearchConst");
        this.setTarget(switchPoint.guardWithTest(target2, fallback));
        if (Options.INVOKEDYNAMIC_LOG_CONSTANTS.load().booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from scope (lexicalSearchConst) " + scope.getIRScope(), new Object[0]);
        }
        return constant;
    }

    private MethodHandle SMFC() {
        if (this._SMFC != null) {
            return this._SMFC;
        }
        this._SMFC = Binder.from(this.type()).insert(0, this).invokeVirtualQuiet(LOOKUP, "searchModuleForConst");
        return this._SMFC;
    }

    private MethodHandle noCacheSMFC() {
        if (this._noCacheSMFC != null) {
            return this._noCacheSMFC;
        }
        this._noCacheSMFC = Binder.from(this.type()).insert(0, this).invokeVirtualQuiet(LOOKUP, "noCacheSearchModuleForConst");
        return this._noCacheSMFC;
    }

    private MethodHandle ISC() {
        if (this._ISC != null) {
            return this._ISC;
        }
        this._ISC = Binder.from(this.type()).insert(0, this).invokeVirtualQuiet(LOOKUP, "inheritanceSearchConst");
        return this._ISC;
    }

    private MethodHandle noCacheISC() {
        if (this._noCacheISC != null) {
            return this._noCacheISC;
        }
        this._noCacheISC = Binder.from(this.type()).insert(0, this).invokeVirtualQuiet(LOOKUP, "noCacheInheritanceSearchConst");
        return this._noCacheISC;
    }
}

