/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.context;

import java.util.Timer;
import java.util.TimerTask;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;

public class ContextRefreshThread
extends TimerTask {
    private static final long PERIOD = 500L;
    private final Timer timer = new Timer("Context Refresh Thread", true);
    private final GraphModel graphModel;
    private final Runnable listener;
    private int previousVersion = -1;

    public ContextRefreshThread(GraphModel graphModel, Runnable listener) {
        this.graphModel = graphModel;
        this.listener = listener;
        this.timer.schedule((TimerTask)this, 500L, 500L);
    }

    @Override
    public void run() {
        Graph graph = this.graphModel.getGraphVisible();
        int graphVersion = graph.getVersion();
        if (graphVersion != this.previousVersion) {
            this.listener.run();
        }
        this.previousVersion = graphVersion;
    }

    public void shutdown() {
        this.timer.cancel();
    }
}

