/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.deferred;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;

public class RealizedChanged<T>
implements DeferredChanged<T> {
    private final Optional<T> value;

    public RealizedChanged(T value) {
        this.value = Optional.ofNullable(value);
    }

    public RealizedChanged(Optional<T> value) {
        this.value = value;
    }

    @Override
    public void ifPresent(Consumer<T> consumer) {
        this.value.ifPresent(consumer);
    }

    @Override
    public void whenSet(Consumer<Optional<T>> consumer) {
        consumer.accept(this.value);
    }

    public static <T> RealizedChanged<T> empty() {
        return new RealizedChanged(Optional.empty());
    }

    @Override
    public boolean isPresent() {
        return this.value.isPresent();
    }

    @Override
    public boolean isValueSet() {
        return true;
    }

    @Override
    public T get() {
        return this.value.get();
    }

    @Override
    public <Q> DeferredChanged<Q> map(Function<Optional<T>, Q> function) {
        return new RealizedChanged<Q>(function.apply(this.value));
    }

    @Override
    public <Q> DeferredChanged<Q> mapOptional(Function<Optional<T>, Optional<Q>> consumer) {
        return new RealizedChanged<Q>(consumer.apply(this.value));
    }

    @Override
    public <Q> DeferredChanged<Q> flatMap(Function<Optional<T>, DeferredChanged<Q>> function) {
        return function.apply(this.value);
    }

    public String toString() {
        return "RealizedChanged{value=" + this.value + '}';
    }
}

