/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFXMLParserException;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParserException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFXMLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Override
    @Nonnull
    public String getName() {
        return "RDFXMLParser";
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new RDFXMLDocumentFormatFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        InputSource is = null;
        try {
            final RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
            RDFParser parser = new RDFParser(){

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    assert (prefix != null);
                    assert (uri != null);
                    super.startPrefixMapping(prefix, uri);
                    format.setPrefix(prefix, uri);
                }
            };
            OWLRDFConsumer consumer = new OWLRDFConsumer(ontology, configuration);
            consumer.setIRIProvider(parser);
            consumer.setOntologyFormat(format);
            is = this.getInputSource(documentSource, configuration);
            parser.parse(is, consumer);
            RDFXMLDocumentFormat rDFXMLDocumentFormat = format;
            return rDFXMLDocumentFormat;
        }
        catch (RDFParserException e) {
            throw new OWLRDFXMLParserException(e);
        }
        catch (SAXException e) {
            throw new OWLRDFXMLParserException(e);
        }
        finally {
            block33: {
                if (is != null) {
                    try (InputStream in = is.getByteStream();){
                        Reader r = is.getCharacterStream();
                        Throwable throwable = null;
                        if (r == null) break block33;
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
        }
    }
}

