/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.AbstractIncludeExcludeRule;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.util.extendable.ExtendableItem;

public class BundleInfoAdapter {
    public static final Configuration CONF_DEFAULT = new Configuration("default");
    public static final Configuration CONF_OPTIONAL = new Configuration("optional", Configuration.Visibility.PUBLIC, "Optional dependencies", new String[]{"default"}, true, null);
    public static final Configuration CONF_TRANSITIVE_OPTIONAL = new Configuration("transitive-optional", Configuration.Visibility.PUBLIC, "Optional dependencies", new String[]{"optional"}, true, null);

    public static DefaultModuleDescriptor toModuleDescriptor(ModuleDescriptorParser object, URI object22, BundleInfo stringArray, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) throws ProfileNotFoundException {
        String[] stringArray2;
        Object object32;
        object = new DefaultModuleDescriptor((ModuleDescriptorParser)object, null);
        ((DefaultModuleDescriptor)object).addExtraAttributeNamespace("o", Ivy.getIvyHomeURL() + "osgi");
        ModuleRevisionId moduleRevisionId = BundleInfoAdapter.asMrid("bundle", stringArray.getSymbolicName(), stringArray.getVersion());
        ((DefaultModuleDescriptor)object).setResolvedPublicationDate(new Date());
        ((DefaultModuleDescriptor)object).setModuleRevisionId(moduleRevisionId);
        ((DefaultModuleDescriptor)object).addConfiguration(CONF_DEFAULT);
        ((DefaultModuleDescriptor)object).addConfiguration(CONF_OPTIONAL);
        ((DefaultModuleDescriptor)object).addConfiguration(CONF_TRANSITIVE_OPTIONAL);
        HashSet<String> hashSet = new HashSet<String>(stringArray.getExports().size());
        for (Object object32 : stringArray.getExports()) {
            ((DefaultModuleDescriptor)object).getExtraInfo().put("_osgi_export_" + ((BundleCapability)object32).getName(), ((ExportPackage)object32).getVersion().toString());
            hashSet.add(((BundleCapability)object32).getName());
            stringArray2 = new String[((ExportPackage)object32).getUses().size() + 1];
            int n = 0;
            for (Object object4 : ((ExportPackage)object32).getUses()) {
                stringArray2[n++] = "use_" + (String)object4;
            }
            stringArray2[n] = "default";
            ((DefaultModuleDescriptor)object).addConfiguration(new Configuration("use_" + ((BundleCapability)object32).getName(), Configuration.Visibility.PUBLIC, "Exported package " + ((BundleCapability)object32).getName(), stringArray2, true, null));
        }
        BundleInfoAdapter.requirementAsDependency((DefaultModuleDescriptor)object, (BundleInfo)stringArray, hashSet);
        object32 = stringArray.getUri();
        if (object32 != null) {
            if ("ivy".equals(((URI)object32).getScheme())) {
                stringArray2 = BundleInfoAdapter.decodeIvyURI((URI)object32);
            } else {
                if (!((URI)object32).isAbsolute()) {
                    object32 = ((URI)object22).resolve((URI)object32);
                }
                try {
                    stringArray2 = new DefaultArtifact(moduleRevisionId, null, stringArray.getSymbolicName(), "jar", "jar", new URL(((URI)object32).toString()), null);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Unable to make the uri into the url", malformedURLException);
                }
            }
            if (stringArray2 != null) {
                ((DefaultModuleDescriptor)object).addArtifact("default", (Artifact)stringArray2);
            }
        }
        if (executionEnvironmentProfileProvider != null) {
            for (String string : stringArray.getExecutionEnvironments()) {
                ExecutionEnvironmentProfile executionEnvironmentProfile = executionEnvironmentProfileProvider.getProfile(string);
                if (executionEnvironmentProfile == null) {
                    throw new ProfileNotFoundException("Execution environment profile " + string + " not found");
                }
                for (Object object22 : executionEnvironmentProfile.getPkgNames()) {
                    object22 = new ArtifactId(ModuleId.newInstance("bundle", (String)object22), "*", "*", "*");
                    object22 = new DefaultExcludeRule((ArtifactId)object22, ExactOrRegexpPatternMatcher.INSTANCE, null);
                    stringArray = ((DefaultModuleDescriptor)object).getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ((AbstractIncludeExcludeRule)object22).addConfiguration(stringArray[i]);
                    }
                    ((DefaultModuleDescriptor)object).addExcludeRule((ExcludeRule)object22);
                }
            }
        }
        return object;
    }

    private static DefaultArtifact decodeIvyURI(URI uRI) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = uRI.getPath();
        if (!string6.startsWith("/")) {
            throw new IllegalArgumentException("An ivy url should be of the form ivy:///org/module but was : " + uRI);
        }
        int n = string6.indexOf(47, 1);
        if (n < 0) {
            throw new IllegalArgumentException("Expecting an organisation in the ivy url: " + uRI);
        }
        String string7 = string6.substring(1, n);
        string6 = string6.substring(n + 1);
        String[] stringArray = uRI.getQuery();
        stringArray = stringArray.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (object.length() == 0) continue;
            if (((String[])(object = object.split("="))).length != 2) {
                throw new IllegalArgumentException("Malformed query string in the ivy url: " + uRI);
            }
            if (object[0].equals("branch")) {
                string = object[1];
                continue;
            }
            if (object[0].equals("rev")) {
                string2 = object[1];
                continue;
            }
            if (object[0].equals("art")) {
                string3 = object[1];
                continue;
            }
            if (object[0].equals("type")) {
                string4 = object[1];
                continue;
            }
            if (object[0].equals("ext")) {
                string5 = object[1];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized parameter '" + object[0] + " in the query string of the ivy url: " + uRI);
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string7, string6, string, string2);
        object = new DefaultArtifact(moduleRevisionId, null, string3, string4, string5);
        return object;
    }

    private static void requirementAsDependency(DefaultModuleDescriptor defaultModuleDescriptor, BundleInfo object, Set set) {
        for (BundleRequirement bundleRequirement : ((BundleInfo)object).getRequirements()) {
            String string = bundleRequirement.getType();
            String string2 = bundleRequirement.getName();
            if ("package".equals(string) && set.contains(string2)) continue;
            ExtendableItem extendableItem = BundleInfoAdapter.asMrid(string, string2, bundleRequirement.getVersion());
            extendableItem = new DefaultDependencyDescriptor((ModuleRevisionId)extendableItem, false);
            String string3 = "default";
            if ("package".equals(string)) {
                string3 = "use_" + string2;
                defaultModuleDescriptor.addConfiguration(new Configuration("use_" + string2, Configuration.Visibility.PUBLIC, "Exported package " + string2, new String[]{"default"}, true, null));
                String string4 = string3;
                ((DefaultDependencyDescriptor)extendableItem).addDependencyConfiguration(string4, string4);
            }
            if ("optional".equals(bundleRequirement.getResolution())) {
                ((DefaultDependencyDescriptor)extendableItem).addDependencyConfiguration("optional", string3);
                ((DefaultDependencyDescriptor)extendableItem).addDependencyConfiguration("transitive-optional", "transitive-optional");
            } else {
                ((DefaultDependencyDescriptor)extendableItem).addDependencyConfiguration("default", string3);
            }
            defaultModuleDescriptor.addDependency((DependencyDescriptor)extendableItem);
        }
    }

    public static ModuleRevisionId asMrid(String string, String string2, Version version) {
        return ModuleRevisionId.newInstance(string, string2, version == null ? null : version.toString());
    }

    public static ModuleRevisionId asMrid(String string, String string2, VersionRange object) {
        object = object == null ? "[0,)" : ((VersionRange)object).toIvyRevision();
        return ModuleRevisionId.newInstance(string, string2, (String)object);
    }

    public static class ProfileNotFoundException
    extends RuntimeException {
        public ProfileNotFoundException(String string) {
            super(string);
        }
    }
}

