% pdfannotations.cls
\ProvidesClass{pdfannotations}[2023/11/22 v3.1 PDF Annotations Document Class]

% This class file extends the standard 'article' class
% to integrate the 'pdfannotations' package functionalities.
% It is designed to facilitate easy annotation of PDF slides,
% inclusion of interludes, and rendering of code snippets 
% within LaTeX documents, particularly for academic and
% presentation purposes.

% Load base class (article, report, book, etc.)
% The 'article' class is chosen for its versatility and
% general applicability for a wide range of documents.
\LoadClass{article}

% Load your package
% The 'pdfannotations' package provides the core functionality
% for this document class. It should be kept up-to-date with
% the latest version of the package.
\RequirePackage{pdfannotations}

% Additional settings or modifications for the document class
% This section can be used to define class-specific settings
% such as default margins, header/footer styles, or any other
% global settings that should be applied to documents using
% this class.

% Example customization (uncomment to use):
% \setlength{\parindent}{0pt} % Remove paragraph indentation
% \setlength{\parskip}{1em}   % Add space between paragraphs

% End of pdfannotations.cls

