/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeImpl;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.JarArchiveRootProvider;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.MemoryFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Ordering;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLMapAttr;
import org.openide.filesystems.spi.ArchiveRootProvider;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class FileUtil {
    private static final RequestProcessor REFRESH_RP = new RequestProcessor("FileUtil-Refresh-All");
    private static RequestProcessor.Task refreshTask = null;
    private static final Logger LOG = Logger.getLogger(FileUtil.class.getName());
    static final Set<String> transientAttributes = new HashSet<String>();
    private static FileSystem diskFileSystem;
    private static final BiFunction<String, Object, Object> DEFAULT_ATTR_TRANSFORMER;
    private static Reference<Map<String, String>> normalizedRef;
    private static final Pattern ILLEGAL_FILENAME_CHARACTERS;
    private static volatile Iterable<? extends ArchiveRootProvider> archiveRootProviderCache;
    private static final AtomicReference<Lookup.Result<ArchiveRootProvider>> archiveRootProviders;

    static String toDebugString(File file) {
        if (file == null) {
            return "NULL-ref";
        }
        return file.getPath() + "(" + file.getClass() + ")";
    }

    static boolean assertNormalized(File file) {
        return FileUtil.assertNormalized(file, false);
    }

    static boolean assertNormalized(File file, boolean bl) {
        block2: {
            File file2;
            block3: {
                if (file == null) break block2;
                file2 = null;
                if ($assertionsDisabled || file.getClass().getName().startsWith("sun.awt.shell") || !bl && file.equals(file2 = FileUtil.normalizeFileCached(file))) break block2;
                if (!bl) break block3;
                file2 = FileUtil.normalizeFileCached(file);
                if (file.getPath().equalsIgnoreCase(file2.getPath())) break block2;
            }
            throw new AssertionError((Object)("Need to normalize " + FileUtil.toDebugString(file) + " was " + FileUtil.toDebugString(file2)));
        }
        return true;
    }

    private static FileSystem getDiskFileSystemFor(File ... fileArray) {
        FileSystem fileSystem = FileUtil.getDiskFileSystem();
        if (fileSystem == null) {
            for (File file : fileArray) {
                FileObject fileObject = FileUtil.toFileObject(file);
                fileSystem = FileUtil.getDiskFileSystem();
                if (fileSystem != null) break;
            }
        }
        return fileSystem;
    }

    private FileUtil() {
    }

    public static void refreshFor(File ... fileArray) {
        FileSystem fileSystem = FileUtil.getDiskFileSystemFor(fileArray);
        if (fileSystem != null) {
            try {
                fileSystem.getRoot().setAttribute("request_for_refreshing_files_be_aware_this_is_not_public_api", fileArray);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAll() {
        RequestProcessor.Task task;
        RequestProcessor requestProcessor = REFRESH_RP;
        synchronized (requestProcessor) {
            if (refreshTask != null) {
                refreshTask.cancel();
            } else {
                refreshTask = REFRESH_RP.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LOG.fine("refreshAll - started");
                        FileUtil.refreshFor(File.listRoots());
                        try {
                            FileUtil.getConfigRoot().getFileSystem().refresh(true);
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                        finally {
                            LOG.fine("refreshAll - finished");
                            RequestProcessor requestProcessor = REFRESH_RP;
                            synchronized (requestProcessor) {
                                refreshTask = null;
                            }
                        }
                    }
                });
            }
            task = refreshTask;
            refreshTask.schedule(0);
            LOG.fine("refreshAll - scheduled");
        }
        task.waitFinished();
        LOG.fine("refreshAll - finished");
    }

    public static void addFileChangeListener(FileChangeListener fileChangeListener) {
        FileSystem fileSystem = FileUtil.getDiskFileSystem();
        if (fileSystem == null) {
            fileSystem = FileUtil.getDiskFileSystemFor(File.listRoots());
        }
        if (fileSystem != null) {
            fileSystem.addFileChangeListener(fileChangeListener);
        }
    }

    public static void removeFileChangeListener(FileChangeListener fileChangeListener) {
        FileSystem fileSystem = FileUtil.getDiskFileSystem();
        if (fileSystem == null) {
            fileSystem = FileUtil.getDiskFileSystemFor(File.listRoots());
        }
        if (fileSystem != null) {
            fileSystem.removeFileChangeListener(fileChangeListener);
        }
    }

    public static void addFileChangeListener(FileChangeListener fileChangeListener, File file) {
        FileChangeImpl.addFileChangeListenerImpl(LOG, fileChangeListener, file);
    }

    public static void removeFileChangeListener(FileChangeListener fileChangeListener, File file) {
        FileChangeImpl.removeFileChangeListenerImpl(LOG, fileChangeListener, file);
    }

    public static void addRecursiveListener(FileChangeListener fileChangeListener, File file) {
        FileUtil.addRecursiveListener(fileChangeListener, file, null, null);
    }

    public static void addRecursiveListener(FileChangeListener fileChangeListener, File file, Callable<Boolean> callable) {
        FileUtil.addRecursiveListener(fileChangeListener, file, null, callable);
    }

    public static void addRecursiveListener(FileChangeListener fileChangeListener, File file, FileFilter fileFilter, Callable<Boolean> callable) {
        FileChangeImpl.addRecursiveListener(fileChangeListener, file, fileFilter, callable);
    }

    public static void removeRecursiveListener(FileChangeListener fileChangeListener, File file) {
        FileChangeImpl.removeRecursiveListener(fileChangeListener, file);
    }

    public static final void runAtomicAction(FileSystem.AtomicAction atomicAction) throws IOException {
        Repository.getDefault().getDefaultFileSystem().runAtomicAction(atomicAction);
    }

    public static final void runAtomicAction(final Runnable runnable) {
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            @Override
            public void run() throws IOException {
                runnable.run();
            }
        };
        try {
            FileUtil.runAtomicAction(atomicAction);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static FileObject createFolder(File file) throws IOException {
        File file2;
        for (file2 = file; file2 != null && !file2.isDirectory(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new IOException(file.getAbsolutePath());
        }
        FileObject fileObject = null;
        FileObject fileObject2 = FileUtil.toFileObject(file2);
        assert (fileObject2 != null) : file2.getAbsolutePath();
        String string = FileUtil.getRelativePath(file2, file);
        try {
            fileObject = FileUtil.createFolder(fileObject2, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject2.getFileSystem().refresh(false);
            fileObject = FileUtil.createFolder(fileObject2, string);
        }
        assert (fileObject != null);
        return fileObject;
    }

    public static FileObject createData(File file) throws IOException {
        File file2;
        for (file2 = file; file2 != null && !file2.isDirectory(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new IOException(file.getAbsolutePath());
        }
        FileObject fileObject = null;
        FileObject fileObject2 = FileUtil.toFileObject(file2);
        assert (fileObject2 != null) : file2.getAbsolutePath();
        String string = FileUtil.getRelativePath(file2, file);
        try {
            fileObject = FileUtil.createData(fileObject2, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject2.getFileSystem().refresh(false);
            fileObject = FileUtil.createData(fileObject2, string);
        }
        assert (fileObject != null);
        return fileObject;
    }

    private static String getRelativePath(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        assert (file3 != null) : file2.getAbsolutePath() + "not found in " + file.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[65536];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyFileImpl(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        FileObject fileObject3 = fileObject2.createData(string, string2);
        FileLock fileLock = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject3.lock();
            inputStream = fileObject.getInputStream();
            outputStream = fileObject3 instanceof AbstractFileObject ? ((AbstractFileObject)fileObject3).getOutputStream(fileLock, false) : fileObject3.getOutputStream(fileLock);
            FileUtil.copy(inputStream, outputStream);
            FileUtil.copyPosixPerms(fileObject, fileObject3);
            FileUtil.copyAttributes(fileObject, fileObject3);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileObject3;
    }

    static void copyPosixPerms(FileObject fileObject, FileObject fileObject2) throws IOException {
        Path path = FileUtil.toPath(fileObject);
        Path path2 = FileUtil.toPath(fileObject2);
        if (path != null && path2 != null) {
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, new LinkOption[0]);
                Files.setPosixFilePermissions(path2, set);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public static FileSystem createMemoryFileSystem() {
        return new MemoryFileSystem();
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        return fileObject.copy(fileObject2, string, string2);
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        return FileUtil.copyFile(fileObject, fileObject2, string, fileObject.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject moveFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            FileObject fileObject3 = fileObject.move(fileLock, fileObject2, string, fileObject.getExt());
            return fileObject3;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static FileObject createFolder(FileObject fileObject, String string) throws IOException {
        Serializable serializable;
        String string2 = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (string.startsWith("//") || string.startsWith("\\\\")) {
            try {
                serializable = new File("\\\\" + stringTokenizer.nextToken() + "\\" + stringTokenizer.nextToken());
                fileObject = FileUtil.toFileObject((File)serializable);
                if (fileObject == null) {
                    throw new IOException("Windows share " + ((File)serializable).getPath() + " does not exist");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("Invalid Windows share " + string);
            }
        }
        while (stringTokenizer.hasMoreElements()) {
            block8: {
                string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                serializable = fileObject.getFileObject(string);
                if (serializable == null) {
                    try {
                        LOG.finest("createFolder - before create folder if not exists.");
                        serializable = fileObject.createFolder(string);
                    }
                    catch (IOException iOException) {
                        fileObject.refresh();
                        serializable = fileObject.getFileObject(string);
                        if (serializable != null) break block8;
                        throw iOException;
                    }
                }
            }
            fileObject = serializable;
        }
        return fileObject;
    }

    public static FileObject createData(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2;
        block10: {
            String string2;
            String string3;
            String string4;
            Parameters.notNull((CharSequence)"folder", (Object)fileObject);
            Parameters.notNull((CharSequence)"name", (Object)string);
            int n = string.lastIndexOf(47);
            if (n >= string.length()) {
                throw new IOException("Wrong file name.");
            }
            if (n != -1) {
                String string5 = string.substring(0, n);
                string4 = string.substring(n + 1);
                fileObject = FileUtil.createFolder(fileObject, string5);
                assert (fileObject != null);
            } else {
                string4 = string;
            }
            if ((n = string4.lastIndexOf(46)) != -1) {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            fileObject2 = fileObject.getFileObject(string3, string2);
            if (fileObject2 == null) {
                try {
                    fileObject2 = fileObject.createData(string3, string2);
                    assert (fileObject2 != null) : "FileObject.createData cannot return null; called on " + fileObject + " + " + string3 + " + " + string2;
                }
                catch (SyncFailedException syncFailedException) {
                    fileObject.refresh();
                    fileObject2 = fileObject.getFileObject(string3, string2);
                    if (fileObject2 != null) break block10;
                    throw syncFailedException;
                }
            }
        }
        return fileObject2;
    }

    public static File toFile(FileObject fileObject) {
        File file = (File)fileObject.getAttribute("java.io.File");
        if (file == null) {
            try {
                if (fileObject.getFileSystem() instanceof JarFileSystem) {
                    return null;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
            URL uRL = URLMapper.findURL(fileObject, 0);
            if (uRL == null || !"file".equals(uRL.getProtocol())) {
                uRL = URLMapper.findURL(fileObject, 1);
            }
            if (uRL != null && "file".equals(uRL.getProtocol())) {
                file = BaseUtilities.toFile((URI)URI.create(uRL.toExternalForm()));
            }
        }
        assert (FileUtil.assertNormalized(file, BaseUtilities.isMac()));
        return file;
    }

    public static Path toPath(FileObject fileObject) {
        File file = FileUtil.toFile(fileObject);
        return file != null ? file.toPath() : null;
    }

    public static FileObject toFileObject(File file) {
        Object object;
        Serializable serializable;
        Parameters.notNull((CharSequence)"file", (Object)file);
        if (file.getPath().equals("\\\\")) {
            return null;
        }
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            serializable = FileUtil.normalizeFile(file);
            if (!file.equals(serializable)) {
                object = "Parameter file was not normalized. Was " + FileUtil.toDebugString(file) + " instead of " + FileUtil.toDebugString((File)serializable);
                LOG.log(Level.WARNING, (String)object);
                LOG.log(Level.INFO, (String)object, new IllegalArgumentException((String)object));
            }
            file = serializable;
        }
        serializable = null;
        try {
            object = BaseUtilities.toURI((File)file).toURL();
            serializable = URLMapper.findFileObject((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            serializable = null;
        }
        if (serializable != null && FileUtil.getDiskFileSystem() == null) {
            try {
                object = ((FileObject)serializable).getFileSystem();
                FileUtil.setDiskFileSystem((FileSystem)object);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        return serializable;
    }

    public static FileObject toFileObject(Path path) {
        try {
            return FileUtil.toFileObject(path.toFile());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    @Deprecated
    public static FileObject[] fromFile(File file) {
        FileObject[] fileObjectArray;
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + FileUtil.toDebugString(file) + " instead of " + FileUtil.toDebugString(FileUtil.normalizeFile(file)));
        }
        try {
            URL uRL = BaseUtilities.toURI((File)file).toURL();
            fileObjectArray = URLMapper.findFileObjects(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            fileObjectArray = null;
        }
        return fileObjectArray;
    }

    public static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileUtil.copyAttributes(fileObject, fileObject2, FileUtil.defaultAttributesTransformer());
    }

    public static BiFunction<String, Object, Object> defaultAttributesTransformer() {
        return DEFAULT_ATTR_TRANSFORMER;
    }

    public static void copyAttributes(FileObject fileObject, FileObject fileObject2, BiFunction<String, Object, Object> biFunction) throws IOException {
        Enumeration<String> enumeration = fileObject.getAttributes();
        if (biFunction == null) {
            biFunction = FileUtil.defaultAttributesTransformer();
        }
        while (enumeration.hasMoreElements()) {
            AtomicBoolean atomicBoolean;
            Object object;
            String string = enumeration.nextElement();
            if (FileUtil.isTransient(fileObject, string) || (object = XMLMapAttr.getRawAttribute(fileObject, string, atomicBoolean = new AtomicBoolean())) == null || object instanceof MultiFileObject.VoidValue) continue;
            if (biFunction != null) {
                object = biFunction.apply(string, object);
            }
            if (object == null) continue;
            if (atomicBoolean.get() && object instanceof Method) {
                fileObject2.setAttribute("methodvalue:" + string, object);
                continue;
            }
            if (atomicBoolean.get() && object instanceof Class) {
                fileObject2.setAttribute("newvalue:" + string, object);
                continue;
            }
            fileObject2.setAttribute(string, object);
        }
    }

    static boolean isTransient(FileObject fileObject, String string) {
        return XMLMapAttr.ModifiedAttribute.isTransient(fileObject, string);
    }

    @Deprecated
    public static void extractJar(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            @Override
            public void run() throws IOException {
                FileUtil.extractJarImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        Object object;
        JarEntry jarEntry;
        HashMap<Object, DefaultAttributes.Table> hashMap = new HashMap<Object, DefaultAttributes.Table>(7);
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            String string = jarEntry.getName();
            if (string.toLowerCase().startsWith("meta-inf/")) continue;
            if (jarEntry.isDirectory()) {
                FileUtil.createFolder(fileObject, string);
                continue;
            }
            if (DefaultAttributes.acceptName(string)) {
                DefaultAttributes.Table table = DefaultAttributes.loadTable(jarInputStream, string);
                hashMap.put(string, table);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData(fileObject, string);
            object = fileObject2.lock();
            try (OutputStream outputStream = fileObject2.getOutputStream((FileLock)object);){
                FileUtil.copy(jarInputStream, outputStream);
            }
            finally {
                ((FileLock)object).releaseLock();
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            int n = ((String)object).lastIndexOf(47);
            String string = n != -1 ? ((String)object).substring(0, n + 1) : "";
            String string2 = fileObject.isRoot() ? string : fileObject.getPath() + '/' + string;
            DefaultAttributes.Table table = (DefaultAttributes.Table)entry.getValue();
            for (String string3 : table.keySet()) {
                String string4 = string2 + string3;
                FileObject fileObject3 = fileObject.getFileSystem().findResource(string4);
                if (fileObject3 == null) continue;
                Enumeration<String> enumeration = table.attrs(string3);
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement();
                    Object object2 = table.getAttr(string3, string5);
                    if (object2 == null) continue;
                    fileObject3.setAttribute(string5, object2);
                }
            }
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String findFreeFileName(FileObject fileObject, String string, String string2) {
        if (FileUtil.checkFreeName(fileObject, string, string2)) {
            return string;
        }
        int n = 1;
        String string3;
        while (!FileUtil.checkFreeName(fileObject, string3 = string + "_" + n, string2)) {
            ++n;
        }
        return string3;
    }

    public static String findFreeFolderName(FileObject fileObject, String string) {
        if (FileUtil.checkFreeName(fileObject, string, null)) {
            return string;
        }
        int n = 1;
        String string2;
        while (!FileUtil.checkFreeName(fileObject, string2 = string + "_" + n, null)) {
            ++n;
        }
        return string2;
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        if (!FileUtil.isParentOf(fileObject, fileObject2) && fileObject != fileObject2) {
            return null;
        }
        String string = fileObject2.getPath().substring(fileObject.getPath().length());
        if (string.startsWith("/") && !string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    private static boolean checkFreeName(FileObject fileObject, String string, String string2) {
        if (BaseUtilities.isWindows() || BaseUtilities.getOperatingSystem() == 2048 || BaseUtilities.isMac()) {
            Enumeration<? extends FileObject> enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                fileObject = enumeration.nextElement();
                String string3 = fileObject.getName();
                String string4 = fileObject.getExt();
                if (!string3.equalsIgnoreCase(string)) continue;
                if (!(string2 != null && string2.trim().length() != 0 || string4 != null && string4.trim().length() != 0)) {
                    return fileObject.isVirtual();
                }
                if (string2 == null || string4 == null || !string2.equalsIgnoreCase(string4)) continue;
                return fileObject.isVirtual();
            }
            return true;
        }
        if (string2 == null) {
            if ((fileObject = fileObject.getFileObject(string)) == null) {
                return true;
            }
            return fileObject.isVirtual();
        }
        if ((fileObject = fileObject.getFileObject(string, string2)) == null) {
            return true;
        }
        return fileObject.isVirtual();
    }

    public static FileObject findBrother(FileObject fileObject, String string) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        return fileObject2.getFileObject(fileObject.getName(), string);
    }

    @Deprecated
    public static String getMIMEType(String string) {
        assert (false) : "FileUtil.getMIMEType(String extension) is deprecated. Please, use FileUtil.getMIMEType(FileObject).";
        if (string.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        return null;
    }

    public static String getMIMEType(FileObject fileObject) {
        return MIMESupport.findMIMEType(fileObject, new String[0]);
    }

    public static String getMIMEType(FileObject fileObject, String ... stringArray) {
        Parameters.notNull((CharSequence)"withinMIMETypes", (Object)stringArray);
        String string = MIMESupport.findMIMEType(fileObject, stringArray);
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2 == null) {
                bl = true;
                continue;
            }
            if (!string.equals(string2)) continue;
            return string2;
        }
        return bl ? null : string;
    }

    public static void setMIMEType(String string, String string2) {
        Parameters.notEmpty((CharSequence)"extension", (CharSequence)string);
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        FileObject fileObject = MIMEResolverImpl.getUserDefinedResolver();
        if (fileObject != null) {
            hashMap.putAll(MIMEResolverImpl.getMIMEToExtensions(fileObject));
            for (Set set : hashMap.values()) {
                set.remove(string);
            }
        }
        if (string2 != null) {
            Set set = (Set)hashMap.get(string2);
            if (set != null) {
                set.add(string);
            } else {
                hashMap.put(string2, Collections.singleton(string));
            }
        }
        if (MIMEResolverImpl.storeUserDefinedResolver(hashMap)) {
            MIMESupport.resetCache();
        }
        MIMESupport.freeCaches();
    }

    public static List<String> getMIMETypeExtensions(String string) {
        Parameters.notEmpty((CharSequence)"mimeType", (CharSequence)string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (FileObject object : MIMEResolverImpl.getOrderedResolvers()) {
            Map<String, Set<String>> map = MIMEResolverImpl.getMIMEToExtensions(object);
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                String string2 = entry.getKey();
                Set<String> set = entry.getValue();
                for (String string3 : set) {
                    hashMap.put(string3, string2);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!((String)entry.getValue()).equals(string)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    @Deprecated
    public static URLStreamHandler nbfsURLStreamHandler() {
        return new FileURL.Handler();
    }

    public static boolean isParentOf(FileObject fileObject, FileObject fileObject2) {
        Parameters.notNull((CharSequence)"folder", (Object)fileObject);
        Parameters.notNull((CharSequence)"fo", (Object)fileObject2);
        if (fileObject.isData()) {
            return false;
        }
        try {
            if (fileObject.getFileSystem() != fileObject2.getFileSystem()) {
                return false;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
        for (FileObject fileObject3 = fileObject2.getParent(); fileObject3 != null; fileObject3 = fileObject3.getParent()) {
            if (!fileObject3.equals(fileObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRecursiveSymbolicLink(FileObject fileObject) throws IOException {
        if (!fileObject.isFolder()) {
            return false;
        }
        if (fileObject.isSymbolicLink()) {
            FileObject fileObject2 = fileObject.getParent();
            if (fileObject2 == null) {
                return false;
            }
            FileObject fileObject3 = fileObject.readSymbolicLink();
            if (fileObject3 != null) {
                FileObject fileObject4 = fileObject2.getCanonicalFileObject();
                FileObject fileObject5 = fileObject3.getCanonicalFileObject();
                return fileObject4 != null && fileObject5 != null && (fileObject5.equals(fileObject4) || FileUtil.isParentOf(fileObject5, fileObject4));
            }
            return false;
        }
        return false;
    }

    public static FileChangeListener weakFileChangeListener(FileChangeListener fileChangeListener, Object object) {
        return (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)fileChangeListener, (Object)object);
    }

    public static FileStatusListener weakFileStatusListener(FileStatusListener fileStatusListener, Object object) {
        return (FileStatusListener)WeakListeners.create(FileStatusListener.class, (EventListener)fileStatusListener, (Object)object);
    }

    public static String getFileDisplayName(FileObject fileObject) {
        String string = null;
        File file = FileUtil.toFile(fileObject);
        if (file != null) {
            string = file.getAbsolutePath();
        } else {
            FileObject fileObject2 = FileUtil.getArchiveFile(fileObject);
            if (fileObject2 != null) {
                string = FileUtil.getArchiveDisplayName(fileObject, fileObject2);
            }
        }
        if (string == null) {
            try {
                string = fileObject.isRoot() ? fileObject.getFileSystem().getDisplayName() : NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)fileObject.getPath(), (Object)fileObject.getFileSystem().getDisplayName());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = fileObject.getPath();
            }
        }
        return string;
    }

    private static String getArchiveDisplayName(FileObject fileObject, FileObject fileObject2) {
        String string = null;
        File file = FileUtil.toFile(fileObject2);
        if (file != null) {
            String string2 = file.getAbsolutePath();
            if (fileObject.isRoot()) {
                string = string2;
            } else {
                String string3 = fileObject.getPath();
                string = NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)string3, (Object)string2);
            }
        }
        return string;
    }

    public static String normalizePath(String string) {
        Map<String, String> map = FileUtil.getNormalizedFilesMap();
        String string2 = map.get(string);
        if (string2 == null) {
            File file = FileUtil.normalizeFileImpl(new File(string));
            string2 = file.getPath();
            map.put(string, string2);
        }
        return string2;
    }

    public static File normalizeFile(File file) {
        File file2 = FileUtil.normalizeFileCached(file);
        assert (FileUtil.assertNormalized(file2));
        return file2;
    }

    private static File normalizeFileCached(File file) {
        File file2;
        String string;
        Map<String, String> map = FileUtil.getNormalizedFilesMap();
        String string2 = map.get(string = file.getPath());
        if (string2 != null && string2.equalsIgnoreCase(string) && !string2.equals(string)) {
            string2 = null;
        }
        if (string2 == null) {
            file2 = FileUtil.normalizeFileImpl(file);
            assert (!file2.getName().equals(".")) : "Original file " + file + " normalized: " + file2;
            map.put(string, file2.getPath());
        } else {
            file2 = string2.equals(string) ? file : new File(string2);
        }
        return file2;
    }

    private static File normalizeFileImpl(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        LOG.log(Level.FINE, "FileUtil.normalizeFile for {0}", file);
        long l = System.currentTimeMillis();
        File file2 = BaseUtilities.isWindows() || BaseUtilities.getOperatingSystem() == 2048 ? FileUtil.normalizeFileOnWindows(file) : (BaseUtilities.isMac() ? FileUtil.normalizeFileOnMac(file) : FileUtil.normalizeFileOnUnixAlike(file));
        File file3 = file.getPath().equals(file2.getPath()) ? file : file2;
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 500L) {
            LOG.log(Level.WARNING, "FileUtil.normalizeFile({0}) took {1} ms. Result is {2}", new Object[]{file, l2, file3});
        }
        return file3;
    }

    private static File normalizeFileOnUnixAlike(File file) {
        file = BaseUtilities.toFile((URI)BaseUtilities.normalizeURI((URI)BaseUtilities.toURI((File)file))).getAbsoluteFile();
        while (file.getAbsolutePath().startsWith("/../")) {
            file = new File(file.getAbsolutePath().substring(3));
        }
        if (file.getAbsolutePath().equals("/..")) {
            file = new File("/");
        }
        return file;
    }

    private static File normalizeFileOnMac(File file) {
        File file2 = file;
        File file3 = BaseUtilities.toFile((URI)BaseUtilities.normalizeURI((URI)BaseUtilities.toURI((File)file)));
        String string = file3.getAbsolutePath();
        if (string.equals("/..")) {
            string = "/";
            file3 = new File("/");
        }
        try {
            boolean bl;
            File file4 = file.getCanonicalFile();
            boolean bl2 = bl = !file4.getAbsolutePath().equalsIgnoreCase(string);
            file2 = bl ? FileUtil.normalizeSymLinkOnMac(file3) : file4;
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Normalization failed on file " + file, iOException);
            file2 = file3.getAbsoluteFile();
        }
        return file2;
    }

    private static File normalizeSymLinkOnMac(File file) throws IOException {
        File file2;
        File file3 = file2 = File.listRoots()[0];
        String string = File.separator + ".." + File.separator;
        Object object = file.getAbsolutePath();
        int n = ((String)object).lastIndexOf(string);
        if (n > -1) {
            object = ((String)object).substring(n + string.length());
        }
        String string2 = object;
        object = new StringTokenizer(string2, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            boolean bl;
            File file4 = new File(file3, ((StringTokenizer)object).nextToken());
            boolean bl2 = bl = !(file3 = file4.getCanonicalFile()).getAbsolutePath().equalsIgnoreCase(file4.getAbsolutePath());
            if (bl) {
                file2 = new File(file2, file4.getName());
                continue;
            }
            file2 = new File(file2, file3.getName());
        }
        return file2;
    }

    private static File normalizeFileOnWindows(File file) {
        File file2;
        block9: {
            file2 = null;
            if (file.getClass().getName().startsWith("sun.awt.shell")) {
                return file;
            }
            try {
                file2 = file.getCanonicalFile();
                if (file2.getName().equals(".")) {
                    file2 = file2.getCanonicalFile();
                }
            }
            catch (IOException iOException) {
                String string = file.getPath();
                if (!string.equals("\\\\") && !"\\\\".equals(file.getParent())) {
                    LOG.log(Level.FINE, string, iOException);
                }
                if (string.endsWith(".")) {
                    string = string.substring(0, string.length() - 1);
                    file2 = new File(string);
                }
                if (string.length() <= 3 || !string.endsWith("\\")) break block9;
                string = string.substring(0, string.length() - 1);
                file2 = new File(string);
            }
        }
        if ((BaseUtilities.getOperatingSystem() & 0x40000) != 0) {
            String string;
            if (file2 == null) {
                file2 = file.getAbsoluteFile();
            }
            if ((string = file2.getAbsolutePath()).contains(":\\Documents and Settings")) {
                string = string.replaceFirst("Documents and Settings", "Users");
                string = string.replaceFirst("My Documents", "Documents");
                string = string.replaceFirst("My Pictures", "Pictures");
                string = string.replaceFirst("My Music", "Music");
                file2 = new File(string);
            }
        }
        return file2 != null ? file2 : file.getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getNormalizedFilesMap() {
        Map<String, String> map = normalizedRef.get();
        if (map != null) return map;
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            map = normalizedRef.get();
            if (map != null) return map;
            map = new ConcurrentHashMap<String, String>();
            normalizedRef = new SoftReference<Map<String, String>>(map);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return map;
        }
    }

    static void freeCaches() {
        normalizedRef.clear();
    }

    public static FileObject getArchiveRoot(FileObject fileObject) {
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            FileObject fileObject2;
            if (!archiveRootProvider.isArchiveFile(fileObject, false) || (fileObject2 = archiveRootProvider.getArchiveRoot(fileObject)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    public static URL getArchiveRoot(URL uRL) {
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            URL uRL2;
            if (!archiveRootProvider.isArchiveFile(uRL, false) || (uRL2 = archiveRootProvider.getArchiveRoot(uRL)) == null) continue;
            return uRL2;
        }
        return FileUtil.getArchiveRootProviders().iterator().next().getArchiveRoot(uRL);
    }

    public static FileObject getArchiveFile(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            FileObject fileObject2;
            if (!archiveRootProvider.isArchiveArtifact(fileObject) || (fileObject2 = archiveRootProvider.getArchiveFile(fileObject)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    public static URL getArchiveFile(URL uRL) {
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            URL uRL2;
            if (!archiveRootProvider.isArchiveArtifact(uRL) || (uRL2 = archiveRootProvider.getArchiveFile(uRL)) == null) continue;
            return uRL2;
        }
        return null;
    }

    public static boolean isArchiveFile(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            if (!archiveRootProvider.isArchiveFile(fileObject, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchiveFile(URL uRL) {
        Parameters.notNull((CharSequence)"url", (Object)uRL);
        return FileUtil.isArchiveFileImpl(uRL, true);
    }

    public static boolean isArchiveArtifact(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            if (!archiveRootProvider.isArchiveArtifact(fileObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchiveArtifact(URL uRL) {
        Parameters.notNull((CharSequence)"url", (Object)uRL);
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            if (!archiveRootProvider.isArchiveArtifact(uRL)) continue;
            return true;
        }
        return false;
    }

    public static URL urlForArchiveOrDir(File file) {
        try {
            URL uRL;
            boolean bl;
            boolean bl2;
            do {
                bl2 = file.isDirectory();
                LOG.finest("urlForArchiveOrDir:toURI:entry");
                uRL = BaseUtilities.toURI((File)file).toURL();
            } while (bl2 ^ (bl = file.isDirectory()));
            if (FileUtil.isArchiveFileImpl(uRL, false)) {
                return FileUtil.getArchiveRoot(uRL);
            }
            if (bl) {
                assert (uRL.toExternalForm().endsWith("/"));
                return uRL;
            }
            if (!file.exists()) {
                if (!uRL.toString().endsWith("/")) {
                    uRL = new URL(uRL + "/");
                }
                return uRL;
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : malformedURLException;
            return null;
        }
    }

    public static File archiveOrDirForURL(URL uRL) {
        String string = uRL.toString();
        if (FileUtil.isArchiveArtifact(uRL)) {
            uRL = FileUtil.getArchiveFile(uRL);
            try {
                return string.endsWith("!/") && uRL != null && "file".equals(uRL.getProtocol()) ? BaseUtilities.toFile((URI)uRL.toURI()) : null;
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.log(Level.WARNING, "Invalid URI: {0} ({1})", new Object[]{uRL, uRISyntaxException.getMessage()});
                return null;
            }
        }
        if (string.startsWith("file:")) {
            return BaseUtilities.toFile((URI)URI.create(string));
        }
        return null;
    }

    @Deprecated
    public static void preventFileChooserSymlinkTraversal(JFileChooser jFileChooser, File file) {
        jFileChooser.setCurrentDirectory(file);
    }

    public static List<FileObject> getOrder(Collection<FileObject> collection, boolean bl) throws IllegalArgumentException {
        return Ordering.getOrder(collection, bl);
    }

    public static void setOrder(List<FileObject> list) throws IllegalArgumentException, IOException {
        Ordering.setOrder(list);
    }

    public static boolean affectsOrder(FileAttributeEvent fileAttributeEvent) {
        return Ordering.affectsOrder(fileAttributeEvent);
    }

    public static FileObject getConfigFile(String string) {
        Parameters.notNull((CharSequence)"path", (Object)string);
        Repository repository = Repository.getLocalRepository();
        return (repository != null ? repository : Repository.getDefault()).getDefaultFileSystem().findResource(string);
    }

    public static FileObject getSystemConfigFile(String string) {
        Parameters.notNull((CharSequence)"path", (Object)string);
        return Repository.getDefault().getDefaultFileSystem().findResource(string);
    }

    public static <T> T getConfigObject(String string, Class<T> clazz) {
        FileObject fileObject = FileUtil.getConfigFile(string);
        if (fileObject == null || fileObject.isFolder()) {
            return null;
        }
        return (T)NamedServicesProvider.getConfigObject((String)string, clazz);
    }

    public static <T> T getSystemConfigObject(String string, Class<T> clazz) {
        FileObject fileObject = FileUtil.getSystemConfigFile(string);
        if (fileObject == null || fileObject.isFolder()) {
            return null;
        }
        return (T)NamedServicesProvider.getConfigObject((String)string, clazz);
    }

    public static FileObject getConfigRoot() {
        return FileUtil.getConfigFile("");
    }

    public static FileObject getSystemConfigRoot() {
        return FileUtil.getSystemConfigFile("");
    }

    private static File wrapFileNoCanonicalize(File file) {
        if (file instanceof NonCanonicalizingFile) {
            return file;
        }
        if (file != null) {
            return new NonCanonicalizingFile(file);
        }
        return null;
    }

    private static File[] wrapFilesNoCanonicalize(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = FileUtil.wrapFileNoCanonicalize(fileArray[i]);
            }
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getDiskFileSystem() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return diskFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setDiskFileSystem(FileSystem fileSystem) {
        Object object = fileSystem.getRoot().getAttribute("SupportsRefreshForNoPublicAPI");
        if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) return;
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            diskFileSystem = fileSystem;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean isArchiveFileImpl(URL uRL, boolean bl) {
        for (ArchiveRootProvider archiveRootProvider : FileUtil.getArchiveRootProviders()) {
            if (!archiveRootProvider.isArchiveFile(uRL, bl)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<? extends ArchiveRootProvider> getArchiveRootProviders() {
        if (archiveRootProviderCache == null) {
            Lookup.Result<ArchiveRootProvider> result = archiveRootProviders.get();
            if (result == null && archiveRootProviders.compareAndSet(null, result = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)new JarArchiveRootProvider()), Lookup.getDefault()}).lookupResult(ArchiveRootProvider.class))) {
                result = archiveRootProviders.get();
                result.addLookupListener(lookupEvent -> {
                    archiveRootProviderCache = null;
                });
            }
            archiveRootProviderCache = new LinkedList<ArchiveRootProvider>(result.allInstances());
        }
        return archiveRootProviderCache;
    }

    public static boolean isValidFileName(String string) {
        if (ILLEGAL_FILENAME_CHARACTERS.matcher(string).find()) {
            return false;
        }
        try {
            Path path = Paths.get(string, new String[0]);
            return path.getNameCount() == 1;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    static {
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("templateCategory");
        transientAttributes.add("instantiatingIterator");
        transientAttributes.add("instantiatingWizardURL");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        transientAttributes.add("displayName");
        transientAttributes.add("iconBase");
        transientAttributes.add("position");
        transientAttributes.add("weight");
        DEFAULT_ATTR_TRANSFORMER = (string, object) -> transientAttributes.contains(string) ? null : object;
        normalizedRef = new SoftReference(new ConcurrentHashMap());
        ILLEGAL_FILENAME_CHARACTERS = Pattern.compile("[\\/:\"*?<>|]");
        archiveRootProviders = new AtomicReference();
    }

    private static final class NonCanonicalizingFile
    extends File {
        public NonCanonicalizingFile(File file) {
            this(file.getPath());
        }

        private NonCanonicalizingFile(String string) {
            super(string);
        }

        private NonCanonicalizingFile(URI uRI) {
            super(uRI);
        }

        @Override
        public File getCanonicalFile() throws IOException {
            return FileUtil.wrapFileNoCanonicalize(FileUtil.normalizeFile(super.getAbsoluteFile()));
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return FileUtil.normalizeFile(super.getAbsoluteFile()).getAbsolutePath();
        }

        @Override
        public File getParentFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getParentFile());
        }

        @Override
        public File getAbsoluteFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getAbsoluteFile());
        }

        @Override
        public File[] listFiles() {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles());
        }

        @Override
        public File[] listFiles(FileFilter fileFilter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(fileFilter));
        }

        @Override
        public File[] listFiles(FilenameFilter filenameFilter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(filenameFilter));
        }
    }
}

