/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActiveQueue {
    private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName());
    private static Impl activeReferenceQueue;

    private ActiveQueue() {
    }

    public static synchronized ReferenceQueue<Object> queue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new Impl();
            Daemon.ping();
        }
        return activeReferenceQueue;
    }

    private static final class Daemon
    extends Thread {
        private static boolean initialized;
        private static Daemon running;

        public Daemon() {
            super("Active Reference Queue Daemon");
        }

        static synchronized void ping() {
            if (!initialized) {
                try {
                    Daemon t = new Daemon();
                    t.setPriority(1);
                    t.setDaemon(true);
                    t.start();
                    LOGGER.fine("starting thread");
                    running = t;
                }
                catch (SecurityException ex) {
                    LOGGER.log(Level.FINE, "cannot start thread", ex);
                }
                finally {
                    initialized = true;
                }
            }
        }

        static synchronized boolean isActive() {
            return running != null;
        }

        static synchronized Impl obtainQueue() {
            return activeReferenceQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        if ((impl = Daemon.obtainQueue()) == null) {
                            return;
                        }
                        ref = impl.remove();
                        ActiveQueue.access$100().log(Level.FINE, "Got dequeued reference {0}", new Object[]{ref});
                        if (!(ref instanceof Runnable)) {
                            ActiveQueue.access$100().log(Level.WARNING, "A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): {0}", ref.getClass());
                            continue;
                        }
                        try {
                            ((Runnable)ref).run();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            ActiveQueue.access$100().log(Level.WARNING, "Cannot process " + ref, t);
                        }
                        finally {
                            ref = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var1_2) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }

    private static final class Impl
    extends ReferenceQueue<Object> {
        Impl() {
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<? extends Object> remove(long timeout) throws IllegalArgumentException, InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException("Negative timeout value");
            }
            if (Thread.currentThread() != Daemon.running) {
                throw new InterruptedException();
            }
            return super.remove(timeout);
        }

        @Override
        public Reference<? extends Object> remove() throws InterruptedException {
            if (Thread.currentThread() != Daemon.running) {
                throw new InterruptedException();
            }
            return super.remove();
        }
    }
}

