/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes.ui;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.gephi.datalab.plugin.manipulators.nodes.SetNodesSize;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.openide.util.NbBundle;

public class SetNodesSizeUI
extends JPanel
implements ManipulatorUI {
    private SetNodesSize manipulator;
    private JLabel sizeLabel;
    private JTextField sizeText;

    public SetNodesSizeUI() {
        this.initComponents();
        this.sizeText.setDocument(new FloatJTextFieldFilter());
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (SetNodesSize)m;
        this.sizeText.setText(String.valueOf(this.manipulator.getSize()));
    }

    public void unSetup() {
        this.manipulator.setSize(Float.parseFloat(this.sizeText.getText()));
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    private void initComponents() {
        this.sizeLabel = new JLabel();
        this.sizeText = new JTextField();
        this.sizeLabel.setText(NbBundle.getMessage(SetNodesSizeUI.class, (String)"SetNodesSizeUI.sizeLabel.text"));
        this.sizeText.setText(NbBundle.getMessage(SetNodesSizeUI.class, (String)"SetNodesSizeUI.sizeText.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeText, -1, 47, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    class FloatJTextFieldFilter
    extends PlainDocument {
        public static final String POSITIVE_FLOAT_ACCEPTED_CHARS = "0123456789.";

        FloatJTextFieldFilter() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            for (int i = 0; i < str.length(); ++i) {
                if (POSITIVE_FLOAT_ACCEPTED_CHARS.contains(String.valueOf(str.charAt(i)))) continue;
                return;
            }
            if (str.contains(".") && this.getText(0, this.getLength()).contains(".")) {
                return;
            }
            super.insertString(offs, str, a);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            Object str = this.getText(0, this.getLength());
            if (!((String)(str = ((String)str).substring(0, offs) + ((String)str).substring(offs + len))).equals("") && !((String)str).equals(".")) {
                super.remove(offs, len);
            }
        }
    }
}

