/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.dot.GraphvizVersionFinder;

public class GraphvizVersions {
    private static final GraphvizVersions singleton = new GraphvizVersions();
    private final Map<File, GraphvizVersion> map = new ConcurrentHashMap<File, GraphvizVersion>();

    private GraphvizVersions() {
    }

    public static GraphvizVersions getInstance() {
        return singleton;
    }

    public GraphvizVersion getVersion(File f) {
        if (f == null) {
            return null;
        }
        GraphvizVersion result = this.map.get(f);
        if (result != null) {
            return result;
        }
        result = GraphvizVersions.checkVersionSlow(f.getAbsolutePath());
        this.map.put(f, result);
        return result;
    }

    static GraphvizVersion checkVersionSlow(String pathExecutable) {
        GraphvizVersionFinder finder = new GraphvizVersionFinder(new File(pathExecutable));
        return finder.getVersion();
    }
}

