/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.WindowFunctionExpression;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class WindowOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final NamedExpression windowFunction;
    private final WindowDefinition windowDefinition;
    private final WindowFrame windowFrame;
    private final PeekingIterator<ExprValue> peekingIterator;

    public WindowOperator(PhysicalPlan input, NamedExpression windowFunction, WindowDefinition windowDefinition) {
        this.input = input;
        this.windowFunction = windowFunction;
        this.windowDefinition = windowDefinition;
        this.windowFrame = this.createWindowFrame();
        this.peekingIterator = Iterators.peekingIterator((Iterator)input);
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.peekingIterator.hasNext() || this.windowFrame.hasNext();
    }

    @Override
    public ExprValue next() {
        this.windowFrame.load(this.peekingIterator);
        return this.enrichCurrentRowByWindowFunctionResult();
    }

    private WindowFrame createWindowFrame() {
        return ((WindowFunctionExpression)this.windowFunction.getDelegated()).createWindowFrame(this.windowDefinition);
    }

    private ExprValue enrichCurrentRowByWindowFunctionResult() {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        this.preserveAllOriginalColumns((ImmutableMap.Builder<String, ExprValue>)mapBuilder);
        this.addWindowFunctionResultColumn((ImmutableMap.Builder<String, ExprValue>)mapBuilder);
        return ExprTupleValue.fromExprValueMap((Map<String, ExprValue>)mapBuilder.build());
    }

    private void preserveAllOriginalColumns(ImmutableMap.Builder<String, ExprValue> mapBuilder) {
        ExprValue inputValue = this.windowFrame.current();
        inputValue.tupleValue().forEach((arg_0, arg_1) -> mapBuilder.put(arg_0, arg_1));
    }

    private void addWindowFunctionResultColumn(ImmutableMap.Builder<String, ExprValue> mapBuilder) {
        ExprValue exprValue = this.windowFunction.valueOf(this.windowFrame);
        mapBuilder.put((Object)this.windowFunction.getName(), (Object)exprValue);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowOperator)) {
            return false;
        }
        WindowOperator other = (WindowOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        NamedExpression this$windowFunction = this.getWindowFunction();
        NamedExpression other$windowFunction = other.getWindowFunction();
        if (this$windowFunction == null ? other$windowFunction != null : !((Object)this$windowFunction).equals(other$windowFunction)) {
            return false;
        }
        WindowDefinition this$windowDefinition = this.getWindowDefinition();
        WindowDefinition other$windowDefinition = other.getWindowDefinition();
        return !(this$windowDefinition == null ? other$windowDefinition != null : !((Object)this$windowDefinition).equals(other$windowDefinition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindowOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        NamedExpression $windowFunction = this.getWindowFunction();
        result = result * 59 + ($windowFunction == null ? 43 : ((Object)$windowFunction).hashCode());
        WindowDefinition $windowDefinition = this.getWindowDefinition();
        result = result * 59 + ($windowDefinition == null ? 43 : ((Object)$windowDefinition).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WindowOperator(input=" + this.getInput() + ", windowFunction=" + this.getWindowFunction() + ", windowDefinition=" + this.getWindowDefinition() + ")";
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public NamedExpression getWindowFunction() {
        return this.windowFunction;
    }

    @Generated
    public WindowDefinition getWindowDefinition() {
        return this.windowDefinition;
    }
}

