"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const zigbee_herdsman_converters_1 = require("zigbee-herdsman-converters");
const logger_1 = __importDefault(require("../util/logger"));
const externalJS_1 = __importDefault(require("./externalJS"));
class ExternalConverters extends externalJS_1.default {
    constructor(zigbee, mqtt, state, publishEntityState, eventBus, enableDisableExtension, restartCallback, addExtension) {
        super(zigbee, mqtt, state, publishEntityState, eventBus, enableDisableExtension, restartCallback, addExtension, 'converter', 'external_converters');
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    async removeJS(name, mod) {
        (0, zigbee_herdsman_converters_1.removeExternalDefinitions)(name);
        await this.zigbee.resolveDevicesDefinitions(true);
    }
    async loadJS(name, mod, newName) {
        try {
            (0, zigbee_herdsman_converters_1.removeExternalDefinitions)(name);
            const definitions = Array.isArray(mod) ? mod : [mod];
            for (const definition of definitions) {
                definition.externalConverterName = newName ?? name;
                (0, zigbee_herdsman_converters_1.addExternalDefinition)(definition);
                logger_1.default.info(`Loaded external converter '${newName ?? name}'.`);
            }
            await this.zigbee.resolveDevicesDefinitions(true);
        }
        catch (error) {
            logger_1.default.error(
            /* v8 ignore next */
            `Failed to load external converter '${newName ?? name}'. Check the code for syntax error and make sure it is up to date with the current Zigbee2MQTT version.`);
            logger_1.default.warning(`External converters are not meant for long term usage, but for local testing after which a pull request should be created to add out-of-the-box support for the device`);
            throw error;
        }
    }
}
exports.default = ExternalConverters;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0ZXJuYWxDb252ZXJ0ZXJzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vbGliL2V4dGVuc2lvbi9leHRlcm5hbENvbnZlcnRlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSwyRUFBNEY7QUFFNUYsNERBQW9DO0FBQ3BDLDhEQUErQztBQUkvQyxNQUFxQixrQkFBbUIsU0FBUSxvQkFBNEI7SUFDeEUsWUFDSSxNQUFjLEVBQ2QsSUFBVSxFQUNWLEtBQVksRUFDWixrQkFBc0MsRUFDdEMsUUFBa0IsRUFDbEIsc0JBQXdFLEVBQ3hFLGVBQW9DLEVBQ3BDLFlBQXFEO1FBRXJELEtBQUssQ0FDRCxNQUFNLEVBQ04sSUFBSSxFQUNKLEtBQUssRUFDTCxrQkFBa0IsRUFDbEIsUUFBUSxFQUNSLHNCQUFzQixFQUN0QixlQUFlLEVBQ2YsWUFBWSxFQUNaLFdBQVcsRUFDWCxxQkFBcUIsQ0FDeEIsQ0FBQztJQUNOLENBQUM7SUFFRCw2REFBNkQ7SUFDbkQsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFZLEVBQUUsR0FBWTtRQUMvQyxJQUFBLHNEQUF5QixFQUFDLElBQUksQ0FBQyxDQUFDO1FBRWhDLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRVMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxJQUFZLEVBQUUsR0FBWSxFQUFFLE9BQWdCO1FBQy9ELElBQUksQ0FBQztZQUNELElBQUEsc0RBQXlCLEVBQUMsSUFBSSxDQUFDLENBQUM7WUFFaEMsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBRXJELEtBQUssTUFBTSxVQUFVLElBQUksV0FBVyxFQUFFLENBQUM7Z0JBQ25DLFVBQVUsQ0FBQyxxQkFBcUIsR0FBRyxPQUFPLElBQUksSUFBSSxDQUFDO2dCQUVuRCxJQUFBLGtEQUFxQixFQUFDLFVBQVUsQ0FBQyxDQUFDO2dCQUNsQyxnQkFBTSxDQUFDLElBQUksQ0FBQyw4QkFBOEIsT0FBTyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUM7WUFDbkUsQ0FBQztZQUVELE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN0RCxDQUFDO1FBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztZQUNiLGdCQUFNLENBQUMsS0FBSztZQUNSLG9CQUFvQjtZQUNwQixzQ0FBc0MsT0FBTyxJQUFJLElBQUkseUdBQXlHLENBQ2pLLENBQUM7WUFDRixnQkFBTSxDQUFDLE9BQU8sQ0FDVix3S0FBd0ssQ0FDM0ssQ0FBQztZQUVGLE1BQU0sS0FBSyxDQUFDO1FBQ2hCLENBQUM7SUFDTCxDQUFDO0NBQ0o7QUExREQscUNBMERDIn0=