/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class Altitude {
    private boolean _valid = false;
    private int _value = 0;
    private Unit _unit = null;
    private String _stringValue = null;
    public static final Altitude NONE = new Altitude(null, null);

    public Altitude(String string, Unit unit) {
        this.set(string, unit);
    }

    public Altitude(int n, Unit unit) {
        this._value = n;
        this._unit = unit;
        this._valid = true;
        this._stringValue = "" + n;
    }

    public void set(String string, Unit unit) {
        this._stringValue = string;
        this._unit = unit;
        if (string == null || string.equals("")) {
            this._valid = false;
        } else {
            try {
                double d = Double.parseDouble(string.trim());
                if (d < 2.147483647E9) {
                    this._value = (int)d;
                    this._valid = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this._valid = false;
            }
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public int getValue() {
        return this._value;
    }

    public int getValue(Unit unit) {
        if (unit == null) {
            return this.getValue();
        }
        return (int)(this.getMetricValue() * unit.getMultFactorFromStd());
    }

    public Unit getUnit() {
        return this._unit;
    }

    public double getMetricValue() {
        if (this._unit == UnitSetLibrary.UNITS_METRES || this._unit == null) {
            return this._value;
        }
        return (double)this._value / this._unit.getMultFactorFromStd();
    }

    public String getStringValue(Unit unit) {
        if (!this._valid) {
            return "";
        }
        if (!(unit != this._unit && unit != null || this._stringValue == null || this._stringValue.equals(""))) {
            return this._stringValue;
        }
        return "" + this.getValue(unit);
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, int n, int n2) {
        return Altitude.interpolate(altitude, altitude2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, double d) {
        if (altitude == null || altitude2 == null || !altitude.isValid() || !altitude2.isValid()) {
            return NONE;
        }
        Unit unit = altitude.getUnit();
        int n = altitude.getValue();
        int n2 = altitude2.getValue(unit);
        int n3 = n + (int)((double)(n2 - n) * d);
        return new Altitude(n3, unit);
    }
}

