"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationServiceMockWithoutMDSMock = exports.notificationServiceMock = exports.mainStateMock = exports.coreServicesMock = void 0;
var _services = require("../../public/services");
var _constants = require("../../common/constants");
var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const coreServicesMock = exports.coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn().mockName('addDanger'),
      addSuccess: jest.fn().mockName('addSuccess'),
      addError: jest.fn().mockName('addError')
    }
  }
};
const dataSourceIdMock = 'mockDataSourceId'; // Provide a mock dataSourceId
const multiDataSourceEnabledMock = true; // Provide a mock value for multiDataSourceEnabled

const browserServicesMock = new _services.NotificationService(_httpClientMock.default, dataSourceIdMock, multiDataSourceEnabledMock);
const browserServicesMockWithNoDataSource = new _services.NotificationService(_httpClientMock.default);
const notificationServiceMock = exports.notificationServiceMock = {
  notificationService: browserServicesMock
};
const notificationServiceMockWithoutMDSMock = exports.notificationServiceMockWithoutMDSMock = {
  notificationService: browserServicesMockWithNoDataSource
};
const mainStateMock = exports.mainStateMock = {
  availableChannels: _constants.CHANNEL_TYPE,
  availableConfigTypes: ['slack', 'chime', 'webhook', 'email', 'sns', 'smtp_account', 'ses_account', 'email_group'],
  tooltipSupport: true
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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