"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TITLES = exports.TRACE_TABLE_OPTIONS = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACES_MAX_NUM = exports.SERVICE_MAP_MAX_NODES = exports.SERVICE_MAP_MAX_EDGES = exports.JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const JAEGER_INDEX_NAME = exports.JAEGER_INDEX_NAME = '*jaeger-span-*';
const JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_SERVICE_INDEX_NAME = '*jaeger-service*';
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'otel-v1-apm-span-*';
const DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = 'otel-v1-apm-service-map*';
const TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATE_FORMAT = 'MM/DD/YYYY HH:mm:ss.SSS';
const TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = 'MMM D, YYYY HH:mm:ss.SSS';
const SERVICE_MAP_MAX_NODES = exports.SERVICE_MAP_MAX_NODES = 500;
// size limit when requesting edge related queries, not necessarily the number of edges
const SERVICE_MAP_MAX_EDGES = exports.SERVICE_MAP_MAX_EDGES = 1000;
const TRACES_MAX_NUM = exports.TRACES_MAX_NUM = 500;
const TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = 'https://opensearch.org/docs/latest/observability-plugin/trace/index/';
const TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = '/api/observability/trace_analytics/jaeger_indices';
const TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/trace_analytics/data_prepper_indices';
const TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = '/api/observability/trace_analytics/query';
const TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = 'observability:traceAnalyticsSpanIndices';
const TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = 'observability:traceAnalyticsServiceIndices';
const TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = 'observability:traceAnalyticsCustomModeDefault';
let TRACE_TABLE_TITLES = exports.TRACE_TABLE_TITLES = /*#__PURE__*/function (TRACE_TABLE_TITLES) {
  TRACE_TABLE_TITLES["all_spans"] = "All Spans";
  TRACE_TABLE_TITLES["root_spans"] = "Root Spans";
  TRACE_TABLE_TITLES["entry_spans"] = "Service Entry Spans";
  TRACE_TABLE_TITLES["traces"] = "Traces";
  return TRACE_TABLE_TITLES;
}({});
const getDescription = key => {
  const descriptions = {
    all_spans: 'Spans representing all activities in all traces across the system',
    root_spans: 'Spans marking the root or starting point of each trace',
    entry_spans: 'Spans that indicate the entry point of service-side processing',
    traces: 'Spans grouped by traceId to show a complete trace lifecycle'
  };
  return descriptions[key];
};
const TRACE_TABLE_OPTIONS = exports.TRACE_TABLE_OPTIONS = Object.entries(TRACE_TABLE_TITLES).map(([key, label]) => ({
  label,
  key,
  'aria-describedby': getDescription(key)
}));
const TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TYPE_KEY = 'TraceAnalyticsTraceTableType';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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