/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorEncoding;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.engine.qframe.QuantizationConfigParser;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.SpaceVectorValidator;
import org.opensearch.knn.index.mapper.VectorValidator;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelUtil;

public class ModelFieldMapper
extends KNNVectorFieldMapper {
    public static final int UNSET_MODEL_DIMENSION_IDENTIFIER = -1;
    private PerDimensionProcessor perDimensionProcessor;
    private PerDimensionValidator perDimensionValidator;
    private VectorValidator vectorValidator;
    private final String modelId;

    public static ModelFieldMapper createFieldMapper(String fullname, String simpleName, Map<String, String> metaValue, VectorDataType vectorDataType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, final ModelDao modelDao, Version indexCreatedVersion, final OriginalMappingParameters originalMappingParameters, KNNMethodConfigContext knnMethodConfigContext) {
        KNNMethodContext knnMethodContext = originalMappingParameters.getKnnMethodContext();
        final QuantizationConfig quantizationConfig = knnMethodContext == null ? QuantizationConfig.EMPTY : knnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext).getQuantizationConfig();
        KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(fullname, metaValue, vectorDataType, new KNNMappingConfig(){
            private Integer dimension = null;
            private Mode mode = null;
            private CompressionLevel compressionLevel = null;

            @Override
            public Optional<String> getModelId() {
                return Optional.of(originalMappingParameters.getModelId());
            }

            @Override
            public int getDimension() {
                if (this.dimension == null) {
                    this.initFromModelMetadata();
                }
                return this.dimension;
            }

            @Override
            public Mode getMode() {
                if (this.mode == null) {
                    this.initFromModelMetadata();
                }
                return this.mode;
            }

            @Override
            public CompressionLevel getCompressionLevel() {
                if (this.compressionLevel == null) {
                    this.initFromModelMetadata();
                }
                return this.compressionLevel;
            }

            @Override
            public QuantizationConfig getQuantizationConfig() {
                return quantizationConfig;
            }

            private void initFromModelMetadata() {
                ModelMetadata modelMetadata = ModelFieldMapper.getModelMetadata(modelDao, originalMappingParameters.getModelId());
                this.dimension = modelMetadata.getDimension();
                this.mode = modelMetadata.getMode();
                this.compressionLevel = modelMetadata.getCompressionLevel();
            }
        });
        return new ModelFieldMapper(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, modelDao, indexCreatedVersion, originalMappingParameters);
    }

    private ModelFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, ModelDao modelDao, Version indexCreatedVersion, OriginalMappingParameters originalMappingParameters) {
        super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, indexCreatedVersion, originalMappingParameters);
        KNNMappingConfig annConfig = mappedFieldType.getKnnMappingConfig();
        this.modelId = annConfig.getModelId().orElseThrow(() -> new IllegalArgumentException("KNN method context cannot be empty"));
        this.modelDao = modelDao;
        this.perDimensionProcessor = null;
        this.perDimensionValidator = null;
        this.vectorValidator = null;
        this.fieldType = new FieldType((IndexableFieldType)KNNVectorFieldMapper.Defaults.FIELD_TYPE);
        this.fieldType.putAttribute("model_id", this.modelId);
        this.useLuceneBasedVectorField = KNNVectorFieldMapperUtil.useLuceneKNNVectorsFormat(this.indexCreatedVersion);
    }

    @Override
    protected VectorValidator getVectorValidator() {
        this.initVectorValidator();
        return this.vectorValidator;
    }

    @Override
    protected PerDimensionValidator getPerDimensionValidator() {
        this.initPerDimensionValidator();
        return this.perDimensionValidator;
    }

    @Override
    protected PerDimensionProcessor getPerDimensionProcessor() {
        this.initPerDimensionProcessor();
        return this.perDimensionProcessor;
    }

    private void initVectorValidator() {
        if (this.vectorValidator != null) {
            return;
        }
        ModelMetadata modelMetadata = ModelFieldMapper.getModelMetadata(this.modelDao, this.modelId);
        KNNMethodContext knnMethodContext = ModelFieldMapper.getKNNMethodContextFromModelMetadata(modelMetadata);
        KNNMethodConfigContext knnMethodConfigContext = ModelFieldMapper.getKNNMethodConfigContextFromModelMetadata(modelMetadata);
        if (knnMethodContext == null || knnMethodConfigContext == null) {
            this.vectorValidator = new SpaceVectorValidator(modelMetadata.getSpaceType());
            return;
        }
        KNNLibraryIndexingContext knnLibraryIndexingContext = knnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext);
        this.vectorValidator = knnLibraryIndexingContext.getVectorValidator();
    }

    private void initPerDimensionValidator() {
        if (this.perDimensionValidator != null) {
            return;
        }
        ModelMetadata modelMetadata = ModelFieldMapper.getModelMetadata(this.modelDao, this.modelId);
        KNNMethodContext knnMethodContext = ModelFieldMapper.getKNNMethodContextFromModelMetadata(modelMetadata);
        KNNMethodConfigContext knnMethodConfigContext = ModelFieldMapper.getKNNMethodConfigContextFromModelMetadata(modelMetadata);
        if (knnMethodContext == null || knnMethodConfigContext == null) {
            this.perDimensionValidator = modelMetadata.getVectorDataType() == VectorDataType.BINARY ? PerDimensionValidator.DEFAULT_BIT_VALIDATOR : (modelMetadata.getVectorDataType() == VectorDataType.BYTE ? PerDimensionValidator.DEFAULT_BYTE_VALIDATOR : PerDimensionValidator.DEFAULT_FLOAT_VALIDATOR);
            return;
        }
        KNNLibraryIndexingContext knnLibraryIndexingContext = knnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext);
        this.perDimensionValidator = knnLibraryIndexingContext.getPerDimensionValidator();
    }

    private void initPerDimensionProcessor() {
        if (this.perDimensionProcessor != null) {
            return;
        }
        ModelMetadata modelMetadata = ModelFieldMapper.getModelMetadata(this.modelDao, this.modelId);
        KNNMethodContext knnMethodContext = ModelFieldMapper.getKNNMethodContextFromModelMetadata(modelMetadata);
        KNNMethodConfigContext knnMethodConfigContext = ModelFieldMapper.getKNNMethodConfigContextFromModelMetadata(modelMetadata);
        if (knnMethodContext == null || knnMethodConfigContext == null) {
            this.perDimensionProcessor = PerDimensionProcessor.NOOP_PROCESSOR;
            return;
        }
        KNNLibraryIndexingContext knnLibraryIndexingContext = knnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext);
        this.perDimensionProcessor = knnLibraryIndexingContext.getPerDimensionProcessor();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        KNNLibraryIndexingContext knnLibraryIndexingContext;
        QuantizationConfig quantizationConfig;
        this.validatePreparse();
        ModelMetadata modelMetadata = ModelFieldMapper.getModelMetadata(this.modelDao, this.modelId);
        if (this.useLuceneBasedVectorField) {
            int adjustedDimension = modelMetadata.getVectorDataType() == VectorDataType.BINARY ? modelMetadata.getDimension() / 8 : modelMetadata.getDimension();
            VectorEncoding encoding = modelMetadata.getVectorDataType() == VectorDataType.FLOAT ? VectorEncoding.FLOAT32 : VectorEncoding.BYTE;
            this.fieldType.setVectorAttributes(adjustedDimension, encoding, SpaceType.DEFAULT.getKnnVectorSimilarityFunction().getVectorSimilarityFunction());
        } else {
            this.fieldType.setDocValuesType(DocValuesType.BINARY);
        }
        KNNMethodContext knnMethodContext = ModelFieldMapper.getKNNMethodContextFromModelMetadata(modelMetadata);
        KNNMethodConfigContext knnMethodConfigContext = ModelFieldMapper.getKNNMethodConfigContextFromModelMetadata(modelMetadata);
        if (knnMethodContext != null && knnMethodConfigContext != null && (quantizationConfig = (knnLibraryIndexingContext = modelMetadata.getKnnEngine().getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext)).getQuantizationConfig()) != null && quantizationConfig != QuantizationConfig.EMPTY) {
            this.fieldType.putAttribute("qframe_config", QuantizationConfigParser.toCsv(quantizationConfig));
        }
        this.parseCreateField(context, modelMetadata.getDimension(), modelMetadata.getVectorDataType());
    }

    private static KNNMethodContext getKNNMethodContextFromModelMetadata(ModelMetadata modelMetadata) {
        MethodComponentContext methodComponentContext = modelMetadata.getMethodComponentContext();
        if (methodComponentContext == MethodComponentContext.EMPTY) {
            return null;
        }
        return new KNNMethodContext(modelMetadata.getKnnEngine(), modelMetadata.getSpaceType(), methodComponentContext);
    }

    private static KNNMethodConfigContext getKNNMethodConfigContextFromModelMetadata(ModelMetadata modelMetadata) {
        MethodComponentContext methodComponentContext = modelMetadata.getMethodComponentContext();
        if (methodComponentContext == MethodComponentContext.EMPTY) {
            return null;
        }
        return KNNMethodConfigContext.builder().vectorDataType(modelMetadata.getVectorDataType()).dimension(modelMetadata.getDimension()).versionCreated(modelMetadata.getModelVersion()).mode(modelMetadata.getMode()).compressionLevel(modelMetadata.getCompressionLevel()).build();
    }

    private static ModelMetadata getModelMetadata(ModelDao modelDao, String modelId) {
        ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
        if (!ModelUtil.isModelCreated(modelMetadata)) {
            throw new IllegalStateException(String.format("Model ID '%s' is not created.", modelId));
        }
        return modelMetadata;
    }
}

