/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;

public class DataSourceImpl
implements DataSource {
    private int i = 0;
    private final List<Terminated<String>> data = new ArrayList<Terminated<String>>();

    public DataSourceImpl(List<String> data) {
        Pattern2 p = MyPattern.cmpile("\\{(?:[-+^#!*/]|S-|SI|S)?");
        for (String s2 : data) {
            StringTokenizer st = new StringTokenizer(s2, "|}", true);
            while (st.hasMoreTokens()) {
                String token = StringUtils.trin(st.nextToken());
                if (token.equals("|")) continue;
                Terminator terminator = st.hasMoreTokens() ? Terminator.NEWCOL : Terminator.NEWLINE;
                Matcher2 m4 = p.matcher(token);
                boolean found = m4.find();
                if (!found) {
                    this.addInternal(token, terminator);
                    continue;
                }
                int lastStart = 0;
                int end = 0;
                do {
                    int start;
                    if ((start = m4.start()) > lastStart) {
                        this.addInternal(token.substring(lastStart, start), Terminator.NEWCOL);
                    }
                    Terminator t2 = (end = m4.end()) == token.length() ? terminator : Terminator.NEWCOL;
                    this.addInternal(token.substring(start, end), t2);
                    lastStart = end;
                } while (m4.find());
                if (end >= token.length()) continue;
                this.addInternal(token.substring(end), terminator);
            }
        }
    }

    private void addInternal(String s2, Terminator t2) {
        if ((s2 = StringUtils.trin(s2)).length() > 0) {
            this.data.add(new Terminated<String>(s2, t2));
        }
    }

    @Override
    public Terminated<String> peek(int nb) {
        return this.data.get(this.i + nb);
    }

    @Override
    public boolean hasNext() {
        return this.i < this.data.size();
    }

    @Override
    public Terminated<String> next() {
        Terminated<String> result = this.data.get(this.i);
        ++this.i;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return super.toString() + " " + (this.hasNext() ? this.peek(0) : "$$$");
    }
}

