# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_sshd_openpgp_auth_global_optspecs
	string join \n h/help V/version
end

function __fish_sshd_openpgp_auth_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_sshd_openpgp_auth_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_sshd_openpgp_auth_using_subcommand
	set -l cmd (__fish_sshd_openpgp_auth_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -s h -l help -d 'Print help'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -s V -l version -d 'Print version'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "add" -d 'Add public SSH host keys as authentication subkeys to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "export" -d 'Export OpenPGP certificates to Web Key Directory (WKD)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "extend" -d 'Extend the expiration period of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "init" -d 'Initialize a new OpenPGP certificate, that serves as trust anchor for public SSH host keys'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "list" -d 'List local OpenPGP certificates that serve as trust anchor'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "merge" -d 'Merge an OpenPGP certificate with a local trust anchor'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "revoke" -d 'Revoke subkeys of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "proof" -d 'Manages Keyoxide proofs'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s S -l ssh-dir -d 'A custom directory in which to look for SSH public keys (defaults to "/etc/ssh/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s k -l known-hosts -d 'Read the SSH public keys in known_hosts format from stdin instead of from a directory'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand export" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand export" -s O -l output-dir -d 'A custom output directory (defaults to "wkd")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand export" -s w -l wkd-type -d 'A custom WKD type to export to (defaults to "advanced")' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand export" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s e -l expiry -d 'The expiry period in days from reference time (defaults to 365)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s T -l threshold -d 'A custom threshold in days from reference time, after which expiry period is extended (defaults to 250)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand extend" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand init" -s e -l expiry -d 'The expiry period in days from reference time (defaults to 365)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand init" -s o -l openpgp-dir -d 'A custom directory into which the OpenPGP certificate is written (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand init" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand init" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand init" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand list" -s f -l filter -d 'A hostname, as fully qualified domain name (FQDN), by which to filter' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand list" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand list" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand merge" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand merge" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand merge" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand merge" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s f -l fingerprint -d 'An OpenPGP fingerprint to identify a specific certificate' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s m -l message -d 'An optional message for the revocation' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s o -l openpgp-dir -d 'A custom directory in which to look for OpenPGP certificates (defaults to "/var/lib/sshd-openpgp-auth/")' -r -F
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s r -l reason -d 'A custom revocation reason (defaults to "superseded")' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s S -l subkey-fingerprint -d 'An OpenPGP fingerprint to identify a specific subkey' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s t -l time -d 'A custom reference time formatted as an RFC3339 string (defaults to now)' -r
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s a -l all -d 'Revoke all subkeys of the chosen OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s s -l stdout -d 'Output the OpenPGP certificate to stdout instead of a file'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and not __fish_seen_subcommand_from dns help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and not __fish_seen_subcommand_from dns help" -f -a "dns" -d 'Manages DNS proofs'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and not __fish_seen_subcommand_from dns help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and __fish_seen_subcommand_from dns" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and __fish_seen_subcommand_from dns" -f -a "add" -d 'Add DNS proof to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and __fish_seen_subcommand_from dns" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and __fish_seen_subcommand_from help" -f -a "dns" -d 'Manages DNS proofs'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand proof; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "add" -d 'Add public SSH host keys as authentication subkeys to an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "export" -d 'Export OpenPGP certificates to Web Key Directory (WKD)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "extend" -d 'Extend the expiration period of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "init" -d 'Initialize a new OpenPGP certificate, that serves as trust anchor for public SSH host keys'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "list" -d 'List local OpenPGP certificates that serve as trust anchor'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "merge" -d 'Merge an OpenPGP certificate with a local trust anchor'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "revoke" -d 'Revoke subkeys of an OpenPGP certificate'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "proof" -d 'Manages Keyoxide proofs'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from add export extend init list merge revoke proof help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sshd-openpgp-auth -n "__fish_sshd_openpgp_auth_using_subcommand help; and __fish_seen_subcommand_from proof" -f -a "dns" -d 'Manages DNS proofs'
