/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.GenericGroup;
import org.apache.catalina.users.GenericRole;
import org.apache.catalina.users.GenericUser;
import org.apache.catalina.users.MemoryGroupCreationFactory;
import org.apache.catalina.users.MemoryRoleCreationFactory;
import org.apache.catalina.users.MemoryUserCreationFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class MemoryUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(MemoryUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(MemoryUserDatabase.class);
    protected final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();
    protected final String id;
    protected String pathname = "conf/tomcat-users.xml";
    protected String pathnameOld = this.pathname + ".old";
    protected String pathnameNew = this.pathname + ".new";
    protected boolean readonly = true;
    protected final Map<String, Role> roles = new ConcurrentHashMap<String, Role>();
    protected final Map<String, User> users = new ConcurrentHashMap<String, User>();
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.dbLock.readLock();
    private final Lock writeLock = this.dbLock.writeLock();
    private volatile long lastModified = 0L;
    private boolean watchSource = true;

    public MemoryUserDatabase() {
        this(null);
    }

    public MemoryUserDatabase(String string) {
        this.id = string;
    }

    @Override
    public Iterator<Group> getGroups() {
        this.readLock.lock();
        try {
            Iterator<Group> iterator = new ArrayList<Group>(this.groups.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        this.pathname = string;
        this.pathnameOld = string + ".old";
        this.pathnameNew = string + ".new";
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public boolean getWatchSource() {
        return this.watchSource;
    }

    public void setWatchSource(boolean bl) {
        this.watchSource = bl;
    }

    @Override
    public Iterator<Role> getRoles() {
        this.readLock.lock();
        try {
            Iterator<Role> iterator = new ArrayList<Role>(this.roles.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<User> getUsers() {
        this.readLock.lock();
        try {
            Iterator<User> iterator = new ArrayList<User>(this.users.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
        this.writeLock.lock();
        try {
            this.save();
            this.users.clear();
            this.groups.clear();
            this.roles.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String string, String string2) {
        if (string == null || string.isEmpty()) {
            String string3 = sm.getString("memoryUserDatabase.nullGroup");
            log.warn((Object)string3);
            throw new IllegalArgumentException(string3);
        }
        GenericGroup<MemoryUserDatabase> genericGroup = new GenericGroup<MemoryUserDatabase>(this, string, string2, null);
        this.readLock.lock();
        try {
            this.groups.put(genericGroup.getGroupname(), genericGroup);
        }
        finally {
            this.readLock.unlock();
        }
        return genericGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String string, String string2) {
        if (string == null || string.isEmpty()) {
            String string3 = sm.getString("memoryUserDatabase.nullRole");
            log.warn((Object)string3);
            throw new IllegalArgumentException(string3);
        }
        GenericRole<MemoryUserDatabase> genericRole = new GenericRole<MemoryUserDatabase>(this, string, string2);
        this.readLock.lock();
        try {
            this.roles.put(genericRole.getRolename(), genericRole);
        }
        finally {
            this.readLock.unlock();
        }
        return genericRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String string, String string2, String string3) {
        if (string == null || string.isEmpty()) {
            String string4 = sm.getString("memoryUserDatabase.nullUser");
            log.warn((Object)string4);
            throw new IllegalArgumentException(string4);
        }
        GenericUser<MemoryUserDatabase> genericUser = new GenericUser<MemoryUserDatabase>(this, string, string2, string3, null, null);
        this.readLock.lock();
        try {
            this.users.put(genericUser.getUsername(), genericUser);
        }
        finally {
            this.readLock.unlock();
        }
        return genericUser;
    }

    @Override
    public Group findGroup(String string) {
        this.readLock.lock();
        try {
            Group group = this.groups.get(string);
            return group;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Role findRole(String string) {
        this.readLock.lock();
        try {
            Role role = this.roles.get(string);
            return role;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public User findUser(String string) {
        this.readLock.lock();
        try {
            User user = this.users.get(string);
            return user;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws Exception {
        this.writeLock.lock();
        try {
            this.users.clear();
            this.groups.clear();
            this.roles.clear();
            String string = this.getPathname();
            try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(string);){
                this.lastModified = resource.getLastModified();
                Digester digester = new Digester();
                try {
                    digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                }
                catch (Exception exception) {
                    log.warn((Object)sm.getString("memoryUserDatabase.xmlFeatureEncoding"), (Throwable)exception);
                }
                digester.addFactoryCreate("tomcat-users/group", (ObjectCreationFactory)new MemoryGroupCreationFactory(this), true);
                digester.addFactoryCreate("tomcat-users/role", (ObjectCreationFactory)new MemoryRoleCreationFactory(this), true);
                digester.addFactoryCreate("tomcat-users/user", (ObjectCreationFactory)new MemoryUserCreationFactory(this), true);
                digester.parse(resource.getInputStream());
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("memoryUserDatabase.fileNotFound", new Object[]{string}));
            }
            catch (Exception exception) {
                this.users.clear();
                this.groups.clear();
                this.roles.clear();
                throw exception;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        this.readLock.lock();
        try {
            Iterator<User> iterator = this.getUsers();
            while (iterator.hasNext()) {
                User user = iterator.next();
                user.removeGroup(group);
            }
            this.groups.remove(group.getGroupname());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        this.readLock.lock();
        try {
            Object object;
            Iterator<Group> iterator = this.getGroups();
            while (iterator.hasNext()) {
                object = iterator.next();
                object.removeRole(role);
            }
            object = this.getUsers();
            while (object.hasNext()) {
                User user = (User)object.next();
                user.removeRole(role);
            }
            this.roles.remove(role.getRolename());
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeUser(User user) {
        this.readLock.lock();
        try {
            this.users.remove(user.getUsername());
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isWritable() {
        File file;
        File file2 = new File(this.pathname);
        if (!file2.isAbsolute()) {
            file2 = new File(System.getProperty("catalina.base"), this.pathname);
        }
        return (file = file2.getParentFile()).exists() && file.isDirectory() && file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        Object object;
        Object object2;
        if (this.getReadonly()) {
            log.error((Object)sm.getString("memoryUserDatabase.readOnly"));
            return;
        }
        if (!this.isWritable()) {
            log.warn((Object)sm.getString("memoryUserDatabase.notPersistable"));
            return;
        }
        File file = new File(this.pathnameNew);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathnameNew);
        }
        this.writeLock.lock();
        try {
            try {
                object2 = new FileOutputStream(file);
                try {
                    object = new OutputStreamWriter((OutputStream)object2, StandardCharsets.UTF_8);
                    try (PrintWriter printWriter = new PrintWriter((Writer)object);){
                        Principal principal;
                        Iterator<Principal> iterator;
                        Principal principal2;
                        printWriter.println("<?xml version='1.0' encoding='utf-8'?>");
                        printWriter.println("<tomcat-users xmlns=\"http://tomcat.apache.org/xml\"");
                        printWriter.print("              ");
                        printWriter.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                        printWriter.print("              ");
                        printWriter.println("xsi:schemaLocation=\"http://tomcat.apache.org/xml tomcat-users.xsd\"");
                        printWriter.println("              version=\"1.0\">");
                        Iterator<Principal> iterator2 = this.getRoles();
                        while (iterator2.hasNext()) {
                            principal2 = iterator2.next();
                            printWriter.print("  <role rolename=\"");
                            printWriter.print(Escape.xml((String)principal2.getRolename()));
                            printWriter.print("\"");
                            if (null != principal2.getDescription()) {
                                printWriter.print(" description=\"");
                                printWriter.print(Escape.xml((String)principal2.getDescription()));
                                printWriter.print("\"");
                            }
                            printWriter.println("/>");
                        }
                        iterator2 = this.getGroups();
                        while (iterator2.hasNext()) {
                            principal2 = (Group)iterator2.next();
                            printWriter.print("  <group groupname=\"");
                            printWriter.print(Escape.xml((String)principal2.getName()));
                            printWriter.print("\"");
                            if (null != principal2.getDescription()) {
                                printWriter.print(" description=\"");
                                printWriter.print(Escape.xml((String)principal2.getDescription()));
                                printWriter.print("\"");
                            }
                            printWriter.print(" roles=\"");
                            iterator = principal2.getRoles();
                            while (iterator.hasNext()) {
                                principal = iterator.next();
                                printWriter.print(Escape.xml((String)principal.getRolename()));
                                if (!iterator.hasNext()) continue;
                                printWriter.print(',');
                            }
                            printWriter.println("\"/>");
                        }
                        iterator2 = this.getUsers();
                        while (iterator2.hasNext()) {
                            principal2 = (User)iterator2.next();
                            printWriter.print("  <user username=\"");
                            printWriter.print(Escape.xml((String)principal2.getUsername()));
                            printWriter.print("\" password=\"");
                            printWriter.print(Escape.xml((String)principal2.getPassword()));
                            printWriter.print("\"");
                            if (null != principal2.getFullName()) {
                                printWriter.print(" fullName=\"");
                                printWriter.print(Escape.xml((String)principal2.getFullName()));
                                printWriter.print("\"");
                            }
                            printWriter.print(" groups=\"");
                            iterator = principal2.getGroups();
                            while (iterator.hasNext()) {
                                principal = (Group)iterator.next();
                                printWriter.print(Escape.xml((String)principal.getGroupname()));
                                if (!iterator.hasNext()) continue;
                                printWriter.print(',');
                            }
                            printWriter.print("\" roles=\"");
                            iterator = principal2.getRoles();
                            while (iterator.hasNext()) {
                                principal = (Role)iterator.next();
                                printWriter.print(Escape.xml((String)principal.getRolename()));
                                if (!iterator.hasNext()) continue;
                                printWriter.print(',');
                            }
                            printWriter.print("\"/>");
                        }
                        printWriter.println("</tomcat-users>");
                        if (printWriter.checkError()) {
                            throw new IOException(sm.getString("memoryUserDatabase.writeException", new Object[]{file.getAbsolutePath()}));
                        }
                    }
                    finally {
                        ((OutputStreamWriter)object).close();
                    }
                }
                finally {
                    ((FileOutputStream)object2).close();
                }
            }
            catch (IOException iOException) {
                if (file.exists() && !file.delete()) {
                    log.warn((Object)sm.getString("memoryUserDatabase.fileDelete", new Object[]{file}));
                }
                throw iOException;
            }
            this.lastModified = file.lastModified();
        }
        finally {
            this.writeLock.unlock();
        }
        object2 = new File(this.pathnameOld);
        if (!((File)object2).isAbsolute()) {
            object2 = new File(System.getProperty("catalina.base"), this.pathnameOld);
        }
        if (((File)object2).exists() && !((File)object2).delete()) {
            throw new IOException(sm.getString("memoryUserDatabase.fileDelete", new Object[]{object2}));
        }
        object = new File(this.pathname);
        if (!((File)object).isAbsolute()) {
            object = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (((File)object).exists() && !((File)object).renameTo((File)object2)) {
            throw new IOException(sm.getString("memoryUserDatabase.renameOld", new Object[]{((File)object2).getAbsolutePath()}));
        }
        if (!file.renameTo((File)object)) {
            if (((File)object2).exists() && !((File)object2).renameTo((File)object)) {
                log.warn((Object)sm.getString("memoryUserDatabase.restoreOrig", new Object[]{object2}));
            }
            throw new IOException(sm.getString("memoryUserDatabase.renameNew", new Object[]{((File)object).getAbsolutePath()}));
        }
        if (((File)object2).exists() && !((File)object2).delete()) {
            throw new IOException(sm.getString("memoryUserDatabase.fileDelete", new Object[]{object2}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void backgroundProcess() {
        if (!this.watchSource) {
            return;
        }
        URI uRI = ConfigFileLoader.getSource().getURI(this.getPathname());
        URLConnection uRLConnection = null;
        URL uRL = uRI.toURL();
        uRLConnection = uRL.openConnection();
        if (this.lastModified != uRLConnection.getLastModified()) {
            this.writeLock.lock();
            try {
                long l = uRLConnection.getLastModified();
                if (this.lastModified != l && l + 2000L < System.currentTimeMillis()) {
                    log.info((Object)sm.getString("memoryUserDatabase.reload", new Object[]{this.id, uRI}));
                    this.open();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (uRLConnection == null) return;
        try {
            uRLConnection.getInputStream().close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.lastModified = 0L;
            return;
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("memoryUserDatabase.fileClose", new Object[]{this.pathname}), (Throwable)iOException);
        }
        return;
        catch (Exception exception) {
            try {
                log.error((Object)sm.getString("memoryUserDatabase.reloadError", new Object[]{this.id, uRI}), (Throwable)exception);
                if (uRLConnection == null) return;
            }
            catch (Throwable throwable) {
                if (uRLConnection == null) throw throwable;
                try {
                    uRLConnection.getInputStream().close();
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.lastModified = 0L;
                    throw throwable;
                }
                catch (IOException iOException) {
                    log.warn((Object)sm.getString("memoryUserDatabase.fileClose", new Object[]{this.pathname}), (Throwable)iOException);
                }
                throw throwable;
            }
            try {
                uRLConnection.getInputStream().close();
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.lastModified = 0L;
                return;
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("memoryUserDatabase.fileClose", new Object[]{this.pathname}), (Throwable)iOException);
            }
            return;
        }
    }

    public String toString() {
        return "MemoryUserDatabase[id=" + this.id + ",pathname=" + this.pathname + ",groupCount=" + this.groups.size() + ",roleCount=" + this.roles.size() + ",userCount=" + this.users.size() + "]";
    }
}

