/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.messages;

import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.MessageDictionary;
import com.adobe.epubcheck.messages.MessageId;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class MessageDictionaryDumper {
    private final MessageDictionary dictionary;

    public MessageDictionaryDumper(MessageDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void dump(OutputStreamWriter outputStream) throws IOException {
        outputStream.write("ID\tSeverity\tMessage\tSuggestion\n");
        for (MessageId id : MessageId.values()) {
            StringBuilder sb = new StringBuilder();
            sb.append(id.toString());
            sb.append("\t");
            Message message = this.dictionary.getMessage(id);
            if (message != null) {
                sb.append((Object)message.getSeverity());
                sb.append("\t");
                sb.append(message.getMessage());
                sb.append("\t");
                sb.append(message.getSuggestion());
            } else {
                sb.append("null\tnull\tnull\tnull");
            }
            sb.append("\n");
            outputStream.write(sb.toString());
        }
    }
}

