/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.org.eclipse.sisu.BeanEntry;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.BeanCache;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.ImplicitBindings;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.QualifyingStrategy;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.RankedBindings;

final class LocatedBeans<Q extends Annotation, T>
implements Iterable<BeanEntry<Q, T>> {
    final Key<T> key;
    final RankedBindings<T> explicitBindings;
    final ImplicitBindings implicitBindings;
    final QualifyingStrategy strategy;
    final BeanCache<Q, T> beans;

    LocatedBeans(Key<T> key, RankedBindings<T> explicitBindings, ImplicitBindings implicitBindings) {
        this.key = key;
        this.explicitBindings = explicitBindings;
        this.implicitBindings = implicitBindings;
        this.strategy = QualifyingStrategy.selectFor(key);
        this.beans = explicitBindings.newBeanCache();
    }

    @Override
    public Iterator<BeanEntry<Q, T>> iterator() {
        return new Itr();
    }

    final class Itr
    implements Iterator<BeanEntry<Q, T>> {
        private final RankedBindings.Itr itr;
        private final Map<Binding<T>, BeanEntry<Q, T>> readCache;
        private boolean checkImplicitBindings;
        private BeanEntry<Q, T> nextBean;

        Itr() {
            this.itr = LocatedBeans.this.explicitBindings.iterator();
            this.readCache = LocatedBeans.this.beans.flush();
            this.checkImplicitBindings = LocatedBeans.this.implicitBindings != null;
        }

        @Override
        public boolean hasNext() {
            Binding binding;
            if (null != this.nextBean) {
                return true;
            }
            while (this.itr.hasNext()) {
                binding = this.itr.next();
                if (null != this.readCache && null != (this.nextBean = this.readCache.get(binding))) {
                    return true;
                }
                Annotation qualifier = LocatedBeans.this.strategy.qualifies(LocatedBeans.this.key, binding);
                if (null == qualifier) continue;
                this.nextBean = LocatedBeans.this.beans.create(qualifier, binding, this.itr.rank());
                return true;
            }
            if (this.checkImplicitBindings && null != (binding = LocatedBeans.this.implicitBindings.get(LocatedBeans.this.key.getTypeLiteral()))) {
                this.nextBean = LocatedBeans.this.beans.create(QualifyingStrategy.DEFAULT_QUALIFIER, binding, Integer.MIN_VALUE);
                return true;
            }
            return false;
        }

        @Override
        public BeanEntry<Q, T> next() {
            if (this.hasNext()) {
                this.checkImplicitBindings = false;
                BeanEntry bean = this.nextBean;
                this.nextBean = null;
                return bean;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

