/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.event.ActionEvent;
import net.osmand.data.LatLon;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;

public class SetCursorRadiusAction
extends OffRoadAction {
    private double mRadius;

    public SetCursorRadiusAction(OsmWindow pContext, String pName, double pRadius) {
        super(pContext, pContext.getOffRoadString(pName), null);
        this.mRadius = pRadius;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        LatLon cursorPosition = this.mContext.getCursorPosition();
        if (this.mRadius == 0.0) {
            this.mContext.getDrawPanel().setCursorRadiusEnabled(false);
        } else {
            this.mContext.getDrawPanel().setCursorRadiusEnabled(true);
            LatLon destLatLon = this.mContext.getMouseLocation();
            double distance = this.mRadius;
            if (this.mRadius == -1.0) {
                distance = MapUtils.getDistance(cursorPosition, destLatLon);
            }
            this.mContext.getDrawPanel().setCursorRadiusSizeInMeters(distance);
        }
        this.mContext.getDrawPanel().drawLater();
    }
}

