/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;

public class RandomizedTextRewriteMap
implements RewriteMap {
    protected static final StringManager sm = StringManager.getManager(RandomizedTextRewriteMap.class);
    private static final Random random = new Random();
    private final Map<String, String[]> map = new HashMap<String, String[]>();

    public RandomizedTextRewriteMap(String string, boolean bl) {
        try (ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(string);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("#") || string2.isEmpty()) continue;
                String[] stringArray = string2.split(" ", 2);
                if (stringArray.length > 1) {
                    String string3 = stringArray[0];
                    String string4 = stringArray[1];
                    String[] stringArray2 = bl && string4.contains("|") ? string4.split("\\|") : new String[]{string4};
                    this.map.put(string3, stringArray2);
                    continue;
                }
                throw new IllegalArgumentException(sm.getString("rewriteMap.txtInvalidLine", new Object[]{string2, string}));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(sm.getString("rewriteMap.txtReadError", new Object[]{string}), iOException);
        }
    }

    @Override
    public String setParameters(String string) {
        throw new IllegalArgumentException(StringManager.getManager(RewriteMap.class).getString("rewriteMap.tooManyParameters"));
    }

    @Override
    public String lookup(String string) {
        String[] stringArray = this.map.get(string);
        if (stringArray != null) {
            if (stringArray.length > 1) {
                return stringArray[random.nextInt(stringArray.length)];
            }
            return stringArray[0];
        }
        return null;
    }
}

