
use builtin;
use str;

set edit:completion:arg-completer[asciinema] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'asciinema'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'asciinema'= {
            cand --server-url 'asciinema server URL'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand rec 'Record a terminal session'
            cand play 'Replay a terminal session'
            cand stream 'Stream a terminal session'
            cand cat 'Concatenate multiple recordings'
            cand convert 'Convert a recording into another format'
            cand upload 'Upload a recording to an asciinema server'
            cand auth 'Authenticate this CLI with an asciinema server account'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'asciinema;rec'= {
            cand -f 'Recording file format [default: asciicast]'
            cand --format 'Recording file format [default: asciicast]'
            cand -c 'Command to record [default: $SHELL]'
            cand --command 'Command to record [default: $SHELL]'
            cand --filename 'Filename template, used when recording to a directory'
            cand --env 'List of env vars to save [default: TERM,SHELL]'
            cand -t 'Title of the recording'
            cand --title 'Title of the recording'
            cand -i 'Limit idle time to a given number of seconds'
            cand --idle-time-limit 'Limit idle time to a given number of seconds'
            cand --tty-size 'Override terminal size for the recorded command'
            cand --cols 'cols'
            cand --rows 'rows'
            cand --server-url 'asciinema server URL'
            cand -I 'Enable input recording'
            cand --input 'Enable input recording'
            cand -a 'Append to an existing recording file'
            cand --append 'Append to an existing recording file'
            cand --raw 'raw'
            cand --overwrite 'Overwrite target file if it already exists'
            cand --headless 'Use headless mode - don''t use TTY for input/output'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;play'= {
            cand -i 'Limit idle time to a given number of seconds'
            cand --idle-time-limit 'Limit idle time to a given number of seconds'
            cand -s 'Set playback speed'
            cand --speed 'Set playback speed'
            cand --server-url 'asciinema server URL'
            cand -l 'Loop loop loop loop'
            cand --loop 'Loop loop loop loop'
            cand -m 'Automatically pause on markers'
            cand --pause-on-markers 'Automatically pause on markers'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;stream'= {
            cand -c 'Command to stream [default: $SHELL]'
            cand --command 'Command to stream [default: $SHELL]'
            cand -s 'Serve the stream with the built-in HTTP server'
            cand --serve 'Serve the stream with the built-in HTTP server'
            cand -r 'Relay the stream via an asciinema server'
            cand --relay 'Relay the stream via an asciinema server'
            cand --tty-size 'Override terminal size for the session'
            cand --log-file 'Log file path'
            cand --server-url 'asciinema server URL'
            cand -I 'Enable input capture'
            cand --input 'Enable input capture'
            cand --headless 'Use headless mode - don''t use TTY for input/output'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;cat'= {
            cand --server-url 'asciinema server URL'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;convert'= {
            cand -f 'Output file format [default: asciicast]'
            cand --format 'Output file format [default: asciicast]'
            cand --server-url 'asciinema server URL'
            cand --overwrite 'Overwrite target file if it already exists'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;upload'= {
            cand --server-url 'asciinema server URL'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;auth'= {
            cand --server-url 'asciinema server URL'
            cand -q 'Quiet mode, i.e. suppress diagnostic messages'
            cand --quiet 'Quiet mode, i.e. suppress diagnostic messages'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'asciinema;help'= {
            cand rec 'Record a terminal session'
            cand play 'Replay a terminal session'
            cand stream 'Stream a terminal session'
            cand cat 'Concatenate multiple recordings'
            cand convert 'Convert a recording into another format'
            cand upload 'Upload a recording to an asciinema server'
            cand auth 'Authenticate this CLI with an asciinema server account'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'asciinema;help;rec'= {
        }
        &'asciinema;help;play'= {
        }
        &'asciinema;help;stream'= {
        }
        &'asciinema;help;cat'= {
        }
        &'asciinema;help;convert'= {
        }
        &'asciinema;help;upload'= {
        }
        &'asciinema;help;auth'= {
        }
        &'asciinema;help;help'= {
        }
    ]
    $completions[$command]
}
