/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.swing.ColorPickerDialog;
import com.bric.swing.ColorPickerPanel;
import com.bric.swing.ColorPickerSliderUI;
import com.bric.swing.ColorSwatch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorPicker
extends JPanel {
    private static final long serialVersionUID = 3L;
    protected static ResourceBundle strings = ResourceBundle.getBundle("com.bric.swing.resources.ColorPicker");
    public static final String SELECTED_COLOR_PROPERTY = "selected color";
    public static final String MODE_CONTROLS_VISIBLE_PROPERTY = "mode controls visible";
    public static final String OPACITY_PROPERTY = "opacity";
    public static final String MODE_PROPERTY = "mode";
    protected static final int HUE = 0;
    protected static final int BRI = 1;
    protected static final int SAT = 2;
    protected static final int RED = 3;
    protected static final int GREEN = 4;
    protected static final int BLUE = 5;
    private JSlider slider = new JSlider(1, 0, 100, 0);
    ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (ColorPicker.this.hue.contains(src) || ColorPicker.this.sat.contains(src) || ColorPicker.this.bri.contains(src)) {
                if (ColorPicker.this.adjustingSpinners > 0) {
                    return;
                }
                ColorPicker.this.setHSB(ColorPicker.this.hue.getFloatValue() / 360.0f, ColorPicker.this.sat.getFloatValue() / 100.0f, ColorPicker.this.bri.getFloatValue() / 100.0f);
            } else if (ColorPicker.this.red.contains(src) || ColorPicker.this.green.contains(src) || ColorPicker.this.blue.contains(src)) {
                if (ColorPicker.this.adjustingSpinners > 0) {
                    return;
                }
                ColorPicker.this.setRGB(ColorPicker.this.red.getIntValue(), ColorPicker.this.green.getIntValue(), ColorPicker.this.blue.getIntValue());
            } else if (src == ColorPicker.this.colorPanel) {
                if (ColorPicker.this.adjustingColorPanel > 0) {
                    return;
                }
                int mode = ColorPicker.this.getMode();
                if (mode == 0 || mode == 1 || mode == 2) {
                    float[] hsb = ColorPicker.this.colorPanel.getHSB();
                    ColorPicker.this.setHSB(hsb[0], hsb[1], hsb[2]);
                } else {
                    int[] rgb = ColorPicker.this.colorPanel.getRGB();
                    ColorPicker.this.setRGB(rgb[0], rgb[1], rgb[2]);
                }
            } else if (src == ColorPicker.this.slider) {
                if (ColorPicker.this.adjustingSlider > 0) {
                    return;
                }
                int v = ColorPicker.this.slider.getValue();
                Option option = ColorPicker.this.getSelectedOption();
                option.setValue(v);
            } else if (ColorPicker.this.alpha.contains(src)) {
                if (ColorPicker.this.adjustingOpacity > 0) {
                    return;
                }
                int v = ColorPicker.this.alpha.getIntValue();
                ColorPicker.this.setOpacity((float)v / 255.0f);
            } else if (src == ColorPicker.this.opacitySlider) {
                if (ColorPicker.this.adjustingOpacity > 0) {
                    return;
                }
                float newValue = (float)ColorPicker.this.opacitySlider.getValue() / 255.0f;
                ColorPicker.this.setOpacity(newValue);
            }
        }
    };
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == ((ColorPicker)ColorPicker.this).hue.radioButton) {
                ColorPicker.this.setMode(0);
            } else if (src == ((ColorPicker)ColorPicker.this).bri.radioButton) {
                ColorPicker.this.setMode(1);
            } else if (src == ((ColorPicker)ColorPicker.this).sat.radioButton) {
                ColorPicker.this.setMode(2);
            } else if (src == ((ColorPicker)ColorPicker.this).red.radioButton) {
                ColorPicker.this.setMode(3);
            } else if (src == ((ColorPicker)ColorPicker.this).green.radioButton) {
                ColorPicker.this.setMode(4);
            } else if (src == ((ColorPicker)ColorPicker.this).blue.radioButton) {
                ColorPicker.this.setMode(5);
            }
        }
    };
    HexDocumentListener hexDocListener = new HexDocumentListener();
    private Option alpha = new Option(strings.getObject("alphaLabel").toString(), 255);
    private Option hue = new Option(strings.getObject("hueLabel").toString(), 360);
    private Option sat = new Option(strings.getObject("saturationLabel").toString(), 100);
    private Option bri = new Option(strings.getObject("brightnessLabel").toString(), 100);
    private Option red = new Option(strings.getObject("redLabel").toString(), 255);
    private Option green = new Option(strings.getObject("greenLabel").toString(), 255);
    private Option blue = new Option(strings.getObject("blueLabel").toString(), 255);
    private ColorSwatch preview = new ColorSwatch(50);
    private JLabel hexLabel = new JLabel(strings.getObject("hexLabel").toString());
    private JTextField hexField = new JTextField("000000");
    private int adjustingSpinners = 0;
    private int adjustingSlider = 0;
    private int adjustingColorPanel = 0;
    private int adjustingHexField = 0;
    private int adjustingOpacity = 0;
    private JPanel expertControls = new JPanel(new GridBagLayout());
    private ColorPickerPanel colorPanel = new ColorPickerPanel();
    private JSlider opacitySlider = new JSlider(0, 255, 255);
    private JLabel opacityLabel = new JLabel(strings.getObject("opacityLabel").toString());
    private float lastOpacity = 1.0f;

    public static Color showDialog(Container owner, Color originalColor) {
        if (owner instanceof Window) {
            return ColorPicker.showDialog((Window)owner, originalColor);
        }
        Logger.getLogger(ColorPicker.class.getName()).log(Level.SEVERE, "Not a Window subclass: " + owner);
        Toolkit.getDefaultToolkit().beep();
        return null;
    }

    public static Color showDialog(Window owner, Color originalColor) {
        return ColorPicker.showDialog(owner, null, originalColor, false);
    }

    public static Color showDialog(Window owner, Color originalColor, boolean includeOpacity) {
        return ColorPicker.showDialog(owner, null, originalColor, includeOpacity);
    }

    public static Color showDialog(Window owner, String title, Color originalColor, boolean includeOpacity) {
        ColorPickerDialog d;
        if (owner instanceof Frame || owner == null) {
            d = new ColorPickerDialog((Frame)owner, originalColor, includeOpacity);
        } else if (owner instanceof Dialog) {
            d = new ColorPickerDialog((Dialog)owner, originalColor, includeOpacity);
        } else {
            throw new IllegalArgumentException("the owner (" + owner.getClass().getName() + ") must be a java.awt.Frame or a java.awt.Dialog");
        }
        d.setTitle(title == null ? strings.getObject("ColorPickerDialogTitle").toString() : title);
        d.pack();
        d.setVisible(true);
        d.dispose();
        return d.getColor();
    }

    private Option getSelectedOption() {
        int mode = this.getMode();
        switch (mode) {
            case 0: {
                return this.hue;
            }
            case 2: {
                return this.sat;
            }
            case 1: {
                return this.bri;
            }
            case 3: {
                return this.red;
            }
            case 4: {
                return this.green;
            }
        }
        return this.blue;
    }

    public ColorPicker() {
        this(true, false);
    }

    public ColorPicker(boolean showExpertControls, boolean includeOpacity) {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets normalInsets = new Insets(3, 3, 3, 3);
        JPanel options = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = normalInsets;
        ButtonGroup bg = new ButtonGroup();
        Option[] optionsArray = new Option[]{this.hue, this.sat, this.bri, this.red, this.green, this.blue};
        for (int a = 0; a < optionsArray.length; ++a) {
            c.insets = a == 3 || a == 6 ? new Insets(normalInsets.top + 10, normalInsets.left, normalInsets.bottom, normalInsets.right) : normalInsets;
            c.anchor = 13;
            c.fill = 0;
            options.add((Component)optionsArray[a].label, c);
            ++c.gridx;
            c.anchor = 17;
            c.fill = 2;
            if (optionsArray[a].spinner != null) {
                options.add((Component)optionsArray[a].spinner, c);
            } else {
                options.add((Component)optionsArray[a].slider, c);
            }
            ++c.gridx;
            c.fill = 0;
            options.add((Component)optionsArray[a].radioButton, c);
            ++c.gridy;
            c.gridx = 0;
            bg.add(optionsArray[a].radioButton);
        }
        c.insets = new Insets(normalInsets.top + 10, normalInsets.left, normalInsets.bottom, normalInsets.right);
        c.anchor = 13;
        c.fill = 0;
        options.add((Component)this.hexLabel, c);
        ++c.gridx;
        c.anchor = 17;
        c.fill = 2;
        options.add((Component)this.hexField, c);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 13;
        c.fill = 0;
        options.add((Component)this.alpha.label, c);
        ++c.gridx;
        c.anchor = 17;
        c.fill = 2;
        options.add((Component)this.alpha.spinner, c);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = normalInsets;
        c.gridwidth = 2;
        this.add((Component)this.colorPanel, c);
        c.gridwidth = 1;
        c.insets = normalInsets;
        c.gridx += 2;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.fill = 3;
        c.weightx = 0.0;
        this.add((Component)this.slider, c);
        ++c.gridx;
        c.fill = 3;
        c.gridheight = 0;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.expertControls, c);
        c.gridx = 0;
        c.gridheight = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = normalInsets;
        c.anchor = 10;
        this.add((Component)this.opacityLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.opacitySlider, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.weighty = 1.0;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(normalInsets.top, normalInsets.left + 8, normalInsets.bottom + 10, normalInsets.right + 8);
        this.expertControls.add((Component)this.preview, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.anchor = 10;
        c.insets = new Insets(normalInsets.top, normalInsets.left, 0, normalInsets.right);
        this.expertControls.add((Component)options, c);
        this.preview.setOpaque(true);
        this.colorPanel.setPreferredSize(new Dimension(this.expertControls.getPreferredSize().height, this.expertControls.getPreferredSize().height));
        this.slider.addChangeListener(this.changeListener);
        this.colorPanel.addChangeListener(this.changeListener);
        this.slider.setUI(new ColorPickerSliderUI(this.slider, this));
        this.hexField.getDocument().addDocumentListener(this.hexDocListener);
        this.setMode(1);
        this.setExpertControlsVisible(showExpertControls);
        this.setOpacityVisible(includeOpacity);
        this.opacitySlider.addChangeListener(this.changeListener);
        this.setOpacity(1.0f);
    }

    public void setHexControlsVisible(boolean b) {
        this.hexLabel.setVisible(b);
        this.hexField.setVisible(b);
    }

    public void setPreviewSwatchVisible(boolean b) {
        this.preview.setVisible(b);
    }

    public void setExpertControlsVisible(boolean b) {
        this.expertControls.setVisible(b);
    }

    public float[] getHSB() {
        return new float[]{this.hue.getFloatValue() / 360.0f, this.sat.getFloatValue() / 100.0f, this.bri.getFloatValue() / 100.0f};
    }

    public int[] getRGB() {
        return new int[]{this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue()};
    }

    public float getOpacity() {
        return (float)this.opacitySlider.getValue() / 255.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpacity(float v) {
        if (v < 0.0f || v > 1.0f) {
            throw new IllegalArgumentException("The opacity (" + v + ") must be between 0 and 1.");
        }
        ++this.adjustingOpacity;
        try {
            int i = (int)(255.0f * v);
            this.opacitySlider.setValue(i);
            this.alpha.spinner.setValue(i);
            if (this.lastOpacity != v) {
                this.firePropertyChange(OPACITY_PROPERTY, Float.valueOf(this.lastOpacity), Float.valueOf(i));
                Color c = this.preview.getForeground();
                this.preview.setForeground(new Color(c.getRed(), c.getGreen(), c.getBlue(), i));
            }
            this.lastOpacity = v;
        }
        finally {
            --this.adjustingOpacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (mode != 0 && mode != 2 && mode != 1 && mode != 3 && mode != 4 && mode != 5) {
            throw new IllegalArgumentException("mode must be HUE, SAT, BRI, REd, GREEN, or BLUE");
        }
        this.putClientProperty(MODE_PROPERTY, mode);
        this.hue.radioButton.setSelected(mode == 0);
        this.sat.radioButton.setSelected(mode == 2);
        this.bri.radioButton.setSelected(mode == 1);
        this.red.radioButton.setSelected(mode == 3);
        this.green.radioButton.setSelected(mode == 4);
        this.blue.radioButton.setSelected(mode == 5);
        this.colorPanel.setMode(mode);
        ++this.adjustingSlider;
        try {
            this.slider.setValue(0);
            Option option = this.getSelectedOption();
            this.slider.setInverted(mode == 0);
            int max = option.getMaximum();
            this.slider.setMaximum(max);
            this.slider.setValue(option.getIntValue());
            this.slider.repaint();
            if (mode == 0 || mode == 2 || mode == 1) {
                this.setHSB(this.hue.getFloatValue() / 360.0f, this.sat.getFloatValue() / 100.0f, this.bri.getFloatValue() / 100.0f);
            } else {
                this.setRGB(this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue());
            }
        }
        finally {
            --this.adjustingSlider;
        }
    }

    public void setModeControlsVisible(boolean b) {
        this.hue.radioButton.setVisible(b && this.hue.isVisible());
        this.sat.radioButton.setVisible(b && this.sat.isVisible());
        this.bri.radioButton.setVisible(b && this.bri.isVisible());
        this.red.radioButton.setVisible(b && this.red.isVisible());
        this.green.radioButton.setVisible(b && this.green.isVisible());
        this.blue.radioButton.setVisible(b && this.blue.isVisible());
        this.putClientProperty(MODE_CONTROLS_VISIBLE_PROPERTY, b);
    }

    public int getMode() {
        Integer i = (Integer)this.getClientProperty(MODE_PROPERTY);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setColor(Color c) {
        this.setRGB(c.getRed(), c.getGreen(), c.getBlue());
        float opacity = (float)c.getAlpha() / 255.0f;
        this.setOpacity(opacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("The red value (" + r + ") must be between [0,255].");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("The green value (" + g + ") must be between [0,255].");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("The blue value (" + b + ") must be between [0,255].");
        }
        Color lastColor = this.getColor();
        boolean updateRGBSpinners = this.adjustingSpinners == 0;
        ++this.adjustingSpinners;
        ++this.adjustingColorPanel;
        int alpha = this.alpha.getIntValue();
        try {
            if (updateRGBSpinners) {
                this.red.setValue(r);
                this.green.setValue(g);
                this.blue.setValue(b);
            }
            this.preview.setForeground(new Color(r, g, b, alpha));
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            this.hue.setValue((int)(hsb[0] * 360.0f + 0.49f));
            this.sat.setValue((int)(hsb[1] * 100.0f + 0.49f));
            this.bri.setValue((int)(hsb[2] * 100.0f + 0.49f));
            this.colorPanel.setRGB(r, g, b);
            this.updateHexField();
            this.updateSlider();
        }
        finally {
            --this.adjustingSpinners;
            --this.adjustingColorPanel;
        }
        Color newColor = this.getColor();
        if (!lastColor.equals(newColor)) {
            this.firePropertyChange(SELECTED_COLOR_PROPERTY, lastColor, newColor);
        }
    }

    public Color getColor() {
        int[] i = this.getRGB();
        return new Color(i[0], i[1], i[2], this.opacitySlider.getValue());
    }

    /*
     * Unable to fully structure code
     */
    private void updateSlider() {
        ++this.adjustingSlider;
        try {
            mode = this.getMode();
            switch (mode) {
                case 0: {
                    this.slider.setValue(this.hue.getIntValue());
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.slider.setValue(this.sat.getIntValue());
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.slider.setValue(this.bri.getIntValue());
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.slider.setValue(this.red.getIntValue());
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.slider.setValue(this.green.getIntValue());
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.slider.setValue(this.blue.getIntValue());
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                ** default:
lbl30:
                // 1 sources

                break;
            }
        }
        finally {
            --this.adjustingSlider;
        }
        this.slider.repaint();
    }

    public JPanel getExpertControls() {
        return this.expertControls;
    }

    public void setRGBControlsVisible(boolean b) {
        this.red.setVisible(b);
        this.green.setVisible(b);
        this.blue.setVisible(b);
    }

    public void setHSBControlsVisible(boolean b) {
        this.hue.setVisible(b);
        this.sat.setVisible(b);
        this.bri.setVisible(b);
    }

    public void setOpacityVisible(boolean b) {
        this.opacityLabel.setVisible(b);
        this.opacitySlider.setVisible(b);
        this.alpha.label.setVisible(b);
        this.alpha.spinner.setVisible(b);
    }

    public ColorPickerPanel getColorPanel() {
        return this.colorPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHSB(float h, float s, float b) {
        if (Float.isInfinite(h) || Float.isNaN(h)) {
            throw new IllegalArgumentException("The hue value (" + h + ") is not a valid number.");
        }
        while (h < 0.0f) {
            h += 1.0f;
        }
        while (h > 1.0f) {
            h -= 1.0f;
        }
        if (s < 0.0f || s > 1.0f) {
            throw new IllegalArgumentException("The saturation value (" + s + ") must be between [0,1]");
        }
        if (b < 0.0f || b > 1.0f) {
            throw new IllegalArgumentException("The brightness value (" + b + ") must be between [0,1]");
        }
        Color lastColor = this.getColor();
        boolean updateHSBSpinners = this.adjustingSpinners == 0;
        ++this.adjustingSpinners;
        ++this.adjustingColorPanel;
        try {
            if (updateHSBSpinners) {
                this.hue.setValue((int)(h * 360.0f + 0.49f));
                this.sat.setValue((int)(s * 100.0f + 0.49f));
                this.bri.setValue((int)(b * 100.0f + 0.49f));
            }
            Color c = new Color(Color.HSBtoRGB(h, s, b));
            int alpha = this.alpha.getIntValue();
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            this.preview.setForeground(c);
            this.red.setValue(c.getRed());
            this.green.setValue(c.getGreen());
            this.blue.setValue(c.getBlue());
            this.colorPanel.setHSB(h, s, b);
            this.updateHexField();
            this.updateSlider();
            this.slider.repaint();
        }
        finally {
            --this.adjustingSpinners;
            --this.adjustingColorPanel;
        }
        Color newColor = this.getColor();
        if (!lastColor.equals(newColor)) {
            this.firePropertyChange(SELECTED_COLOR_PROPERTY, lastColor, newColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHexField() {
        ++this.adjustingHexField;
        try {
            int r = this.red.getIntValue();
            int g = this.green.getIntValue();
            int b = this.blue.getIntValue();
            int i = (r << 16) + (g << 8) + b;
            String s = Integer.toHexString(i).toUpperCase();
            while (s.length() < 6) {
                s = "0" + s;
            }
            if (!this.hexField.getText().equalsIgnoreCase(s)) {
                this.hexField.setText(s);
            }
        }
        finally {
            --this.adjustingHexField;
        }
    }

    class Option {
        JRadioButton radioButton = new JRadioButton();
        JSpinner spinner;
        JSlider slider;
        JLabel label;

        Option(String text, int max) {
            this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, max, 5));
            this.spinner.addChangeListener(ColorPicker.this.changeListener);
            this.label = new JLabel(text);
            this.radioButton.addActionListener(ColorPicker.this.actionListener);
        }

        public void setValue(int i) {
            if (this.slider != null) {
                this.slider.setValue(i);
            }
            if (this.spinner != null) {
                this.spinner.setValue(i);
            }
        }

        public int getMaximum() {
            if (this.slider != null) {
                return this.slider.getMaximum();
            }
            return ((Number)((Object)((SpinnerNumberModel)this.spinner.getModel()).getMaximum())).intValue();
        }

        public boolean contains(Object src) {
            return src == this.slider || src == this.spinner || src == this.radioButton || src == this.label;
        }

        public float getFloatValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            if (this.slider != null) {
                return this.slider.getValue();
            }
            return ((Number)this.spinner.getValue()).intValue();
        }

        public boolean isVisible() {
            return this.label.isVisible();
        }

        public void setVisible(boolean b) {
            boolean radioButtonsAllowed = true;
            Boolean z = (Boolean)ColorPicker.this.getClientProperty(ColorPicker.MODE_CONTROLS_VISIBLE_PROPERTY);
            if (z != null) {
                radioButtonsAllowed = z;
            }
            this.radioButton.setVisible(b && radioButtonsAllowed);
            if (this.slider != null) {
                this.slider.setVisible(b);
            }
            if (this.spinner != null) {
                this.spinner.setVisible(b);
            }
            this.label.setVisible(b);
        }
    }

    class HexDocumentListener
    implements DocumentListener {
        long lastTimeStamp;

        HexDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.lastTimeStamp = System.currentTimeMillis();
            if (ColorPicker.this.adjustingHexField > 0) {
                return;
            }
            String s = ColorPicker.this.hexField.getText();
            if ((s = this.stripToHex(s)).length() == 6) {
                try {
                    int i = Integer.parseInt(s, 16);
                    ColorPicker.this.setRGB(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
                    return;
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
            HexUpdateThread thread = new HexUpdateThread(this.lastTimeStamp, s);
            thread.start();
            while (System.currentTimeMillis() - this.lastTimeStamp == 0L) {
                Thread.yield();
            }
        }

        private String stripToHex(String s) {
            s = s.toUpperCase();
            String s2 = "";
            for (int a = 0; a < s.length(); ++a) {
                char c = s.charAt(a);
                if (c != '0' && c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9' && c != '0' && c != 'A' && c != 'B' && c != 'C' && c != 'D' && c != 'E' && c != 'F') continue;
                s2 = s2 + c;
            }
            return s2;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }

    class HexUpdateThread
    extends Thread {
        long myStamp;
        String text;

        HexUpdateThread(long stamp, String s) {
            this.myStamp = stamp;
            this.text = s;
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                long WAIT = 1500L;
                while (System.currentTimeMillis() - this.myStamp < WAIT) {
                    try {
                        long delay = WAIT - (System.currentTimeMillis() - this.myStamp);
                        if (delay < 1L) {
                            delay = 1L;
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.yield();
                    }
                }
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.myStamp != ColorPicker.this.hexDocListener.lastTimeStamp) {
                return;
            }
            if (this.text.length() > 6) {
                this.text = this.text.substring(0, 6);
            }
            while (this.text.length() < 6) {
                this.text = this.text + "0";
            }
            if (ColorPicker.this.hexField.getText().equals(this.text)) {
                return;
            }
            int pos = ColorPicker.this.hexField.getCaretPosition();
            ColorPicker.this.hexField.setText(this.text);
            ColorPicker.this.hexField.setCaretPosition(pos);
        }
    }
}

