/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.preview.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.desktop.preview.propertyeditors.EdgeColorPropertyEditor;
import org.gephi.preview.types.EdgeColor;
import org.gephi.ui.components.JColorButton;
import org.jdesktop.swingx.JXHeader;
import org.openide.util.NbBundle;

public class EdgeColorPanel
extends JPanel
implements ItemListener {
    private EdgeColorPropertyEditor propertyEditor;
    private ButtonGroup buttonGroup1;
    private JButton colorButton;
    private JRadioButton customRadio;
    private JXHeader jXHeader1;
    private JRadioButton mixedRadio;
    private JRadioButton originalRadio;
    private JRadioButton sourceRadio;
    private JRadioButton targetRadio;

    public EdgeColorPanel() {
        this.initComponents();
        this.colorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color newColor = (Color)evt.getNewValue();
                EdgeColorPanel.this.propertyEditor.setValue(new EdgeColor(newColor));
            }
        });
        this.originalRadio.addItemListener(this);
        this.mixedRadio.addItemListener(this);
        this.sourceRadio.addItemListener(this);
        this.targetRadio.addItemListener(this);
        this.customRadio.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.colorButton.setEnabled(this.customRadio.isSelected());
            EdgeColor.Mode selectedMode = null;
            if (this.originalRadio.isSelected()) {
                selectedMode = EdgeColor.Mode.ORIGINAL;
            } else if (this.mixedRadio.isSelected()) {
                selectedMode = EdgeColor.Mode.MIXED;
            } else if (this.sourceRadio.isSelected()) {
                selectedMode = EdgeColor.Mode.SOURCE;
            } else if (this.targetRadio.isSelected()) {
                selectedMode = EdgeColor.Mode.TARGET;
            } else if (this.customRadio.isSelected()) {
                selectedMode = EdgeColor.Mode.CUSTOM;
            }
            this.propertyEditor.setValue(new EdgeColor(selectedMode));
        }
    }

    public void setup(EdgeColorPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        EdgeColor edgeColor = (EdgeColor)propertyEditor.getValue();
        if (edgeColor.getMode().equals((Object)EdgeColor.Mode.CUSTOM)) {
            this.customRadio.setSelected(true);
            ((JColorButton)this.colorButton).setColor(edgeColor.getCustomColor());
        } else if (edgeColor.getMode().equals((Object)EdgeColor.Mode.MIXED)) {
            this.mixedRadio.setSelected(true);
        } else if (edgeColor.getMode().equals((Object)EdgeColor.Mode.ORIGINAL)) {
            this.originalRadio.setSelected(true);
        } else if (edgeColor.getMode().equals((Object)EdgeColor.Mode.SOURCE)) {
            this.sourceRadio.setSelected(true);
        } else if (edgeColor.getMode().equals((Object)EdgeColor.Mode.TARGET)) {
            this.targetRadio.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jXHeader1 = new JXHeader();
        this.originalRadio = new JRadioButton();
        this.mixedRadio = new JRadioButton();
        this.sourceRadio = new JRadioButton();
        this.targetRadio = new JRadioButton();
        this.customRadio = new JRadioButton();
        this.colorButton = new JColorButton(Color.BLACK, false, true);
        this.jXHeader1.setDescription(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.jXHeader1.description"));
        this.jXHeader1.setTitle(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.jXHeader1.title"));
        this.buttonGroup1.add(this.originalRadio);
        this.originalRadio.setText(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.originalRadio.text"));
        this.buttonGroup1.add(this.mixedRadio);
        this.mixedRadio.setText(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.mixedRadio.text"));
        this.buttonGroup1.add(this.sourceRadio);
        this.sourceRadio.setText(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.sourceRadio.text"));
        this.buttonGroup1.add(this.targetRadio);
        this.targetRadio.setText(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.targetRadio.text"));
        this.buttonGroup1.add(this.customRadio);
        this.customRadio.setText(NbBundle.getMessage(EdgeColorPanel.class, (String)"EdgeColorPanel.customRadio.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.originalRadio).addComponent(this.mixedRadio).addComponent(this.sourceRadio).addComponent(this.targetRadio).addGroup(layout.createSequentialGroup().addComponent(this.customRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.colorButton))).addContainerGap(323, Short.MAX_VALUE)).addComponent((Component)this.jXHeader1, -1, 438, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXHeader1, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.originalRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mixedRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sourceRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.targetRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.customRadio).addComponent(this.colorButton)).addContainerGap(7, Short.MAX_VALUE)));
    }
}

