/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.merge;

import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsMergeStrategiesController;
import org.gephi.datalab.plugin.manipulators.columns.merge.ui.JoinWithSeparatorUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JoinWithSeparator
implements AttributeColumnsMergeStrategy {
    public static final String SEPARATOR_SAVED_PREFERENCES = "JoinWithSeparator_Separator";
    private static final String DEFAULT_SEPARATOR = ", ";
    private Table table;
    private Column[] columns;
    private String newColumnTitle;
    private String separator;

    public void setup(Table table, Column[] columns) {
        this.table = table;
        this.columns = columns;
        this.separator = NbPreferences.forModule(JoinWithSeparator.class).get(SEPARATOR_SAVED_PREFERENCES, DEFAULT_SEPARATOR);
    }

    public void execute() {
        NbPreferences.forModule(JoinWithSeparator.class).put(SEPARATOR_SAVED_PREFERENCES, this.separator);
        ((AttributeColumnsMergeStrategiesController)Lookup.getDefault().lookup(AttributeColumnsMergeStrategiesController.class)).joinWithSeparatorMerge(this.table, this.columns, null, this.newColumnTitle, this.separator);
    }

    public String getName() {
        return NbBundle.getMessage(JoinWithSeparator.class, (String)"JoinWithSeparator.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(JoinWithSeparator.class, (String)"JoinWithSeparator.description");
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return new JoinWithSeparatorUI();
    }

    public int getType() {
        return 0;
    }

    public int getPosition() {
        return 0;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/join.png", (boolean)false);
    }

    public String getNewColumnTitle() {
        return this.newColumnTitle;
    }

    public void setNewColumnTitle(String newColumnTitle) {
        this.newColumnTitle = newColumnTitle;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public Table getTable() {
        return this.table;
    }
}

