/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.selection.SelectionManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SelectionToolbar
extends JToolBar {
    private final ButtonGroup buttonGroup;

    public SelectionToolbar() {
        this.initDesign();
        this.buttonGroup = new ButtonGroup();
        this.initContent();
    }

    private void initContent() {
        final JToggleButton mouseButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"VisualizationImpl/mouse.png", (boolean)false));
        mouseButton.setToolTipText(NbBundle.getMessage(SelectionToolbar.class, (String)"SelectionToolbar.mouse.tooltip"));
        mouseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mouseButton.isSelected()) {
                    VizController.getInstance().getSelectionManager().setDirectMouseSelection();
                }
            }
        });
        mouseButton.setFocusPainted(false);
        this.add(mouseButton);
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"VisualizationImpl/rectangle.png", (boolean)false);
        final JToggleButton rectangleButton = new JToggleButton(icon);
        rectangleButton.setToolTipText(NbBundle.getMessage(SelectionToolbar.class, (String)"SelectionToolbar.rectangle.tooltip"));
        rectangleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (rectangleButton.isSelected()) {
                    VizController.getInstance().getSelectionManager().setRectangleSelection();
                }
            }
        });
        rectangleButton.setFocusPainted(false);
        this.add(rectangleButton);
        final JToggleButton dragButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"VisualizationImpl/hand.png", (boolean)false));
        dragButton.setToolTipText(NbBundle.getMessage(SelectionToolbar.class, (String)"SelectionToolbar.drag.tooltip"));
        dragButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dragButton.isSelected()) {
                    VizController.getInstance().getSelectionManager().setDraggingMouseSelection();
                }
            }
        });
        dragButton.setFocusPainted(false);
        this.add(dragButton);
        this.addSeparator();
        this.buttonGroup.setSelected(rectangleButton.getModel(), VizController.getInstance().getVizConfig().isRectangleSelection());
        this.buttonGroup.setSelected(mouseButton.getModel(), !VizController.getInstance().getVizConfig().isRectangleSelection());
        this.buttonGroup.setSelected(dragButton.getModel(), VizController.getInstance().getVizConfig().isDraggingEnable());
        VizController.getInstance().getSelectionManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectionManager selectionManager = VizController.getInstance().getSelectionManager();
                if (selectionManager.isBlocked()) {
                    SelectionToolbar.this.buttonGroup.clearSelection();
                } else if (!selectionManager.isSelectionEnabled()) {
                    SelectionToolbar.this.buttonGroup.clearSelection();
                } else if (selectionManager.isDirectMouseSelection()) {
                    if (!SelectionToolbar.this.buttonGroup.isSelected(mouseButton.getModel())) {
                        SelectionToolbar.this.buttonGroup.setSelected(mouseButton.getModel(), true);
                    }
                } else if (selectionManager.isRectangleSelection()) {
                    if (!SelectionToolbar.this.buttonGroup.isSelected(rectangleButton.getModel())) {
                        SelectionToolbar.this.buttonGroup.setSelected(rectangleButton.getModel(), true);
                    }
                } else if (selectionManager.isDraggingEnabled() && !SelectionToolbar.this.buttonGroup.isSelected(dragButton.getModel())) {
                    SelectionToolbar.this.buttonGroup.setSelected(dragButton.getModel(), true);
                }
            }
        });
    }

    private void initDesign() {
        this.setFloatable(false);
        this.setOrientation(1);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : SelectionToolbar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JButton) {
            UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
        }
        if (comp instanceof AbstractButton) {
            this.buttonGroup.add((AbstractButton)comp);
        }
        return super.add(comp);
    }
}

