/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.popup;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gephi.desktop.search.api.SearchResult;
import org.gephi.desktop.search.popup.EdgePopup;
import org.gephi.desktop.search.popup.NodePopup;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;

public class ActionPopup
extends MouseAdapter {
    private final JList<SearchResult> list;

    public ActionPopup(JList<SearchResult> list) {
        this.list = list;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybePopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybePopup(e);
    }

    private void maybePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            SwingUtilities.invokeLater(() -> {
                Point p = e.getPoint();
                int row = this.list.locationToIndex(e.getPoint());
                this.list.setSelectedIndex(row);
                JPopupMenu pop = this.createPopup(p);
                if (pop != null) {
                    this.showPopup(p.x, p.y, pop);
                }
            });
        }
    }

    protected JPopupMenu createPopup(Point p) {
        SearchResult result = this.list.getSelectedValue();
        if (result != null) {
            if (result.getResult() instanceof Node) {
                return NodePopup.createPopup((Node)result.getResult());
            }
            if (result.getResult() instanceof Edge) {
                return EdgePopup.createPopup((Edge)result.getResult());
            }
        }
        return null;
    }

    private void showPopup(int xpos, int ypos, JPopupMenu popup) {
        if (popup != null && popup.getSubElements().length > 0) {
            popup.show(this.list, xpos, ypos);
        }
    }
}

