/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.service;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.ICache;
import org.opensearch.common.cache.service.NodeCacheStats;
import org.opensearch.common.cache.settings.CacheSettings;
import org.opensearch.common.cache.stats.ImmutableCacheStatsHolder;
import org.opensearch.common.cache.store.config.CacheConfig;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.FeatureFlags;

@ExperimentalApi
public class CacheService {
    private final Map<String, ICache.Factory> cacheStoreTypeFactories;
    private final Settings settings;
    private Map<CacheType, ICache<?, ?>> cacheTypeMap;

    public CacheService(Map<String, ICache.Factory> cacheStoreTypeFactories, Settings settings) {
        this.cacheStoreTypeFactories = cacheStoreTypeFactories;
        this.settings = settings;
        this.cacheTypeMap = new HashMap();
    }

    public Map<CacheType, ICache<?, ?>> getCacheTypeMap() {
        return this.cacheTypeMap;
    }

    public <K, V> ICache<K, V> createCache(CacheConfig<K, V> config, CacheType cacheType) {
        Setting<String> cacheSettingForCacheType = CacheSettings.CACHE_TYPE_STORE_NAME.getConcreteSettingForNamespace(cacheType.getSettingPrefix());
        String storeName = cacheSettingForCacheType.get(this.settings);
        if (!FeatureFlags.PLUGGABLE_CACHE_SETTING.get(this.settings).booleanValue() || storeName == null || storeName.isBlank()) {
            storeName = "opensearch_onheap";
        }
        if (!this.cacheStoreTypeFactories.containsKey(storeName)) {
            throw new IllegalArgumentException("No store name: [" + storeName + "] is registered for cache type: " + cacheType);
        }
        ICache.Factory factory = this.cacheStoreTypeFactories.get(storeName);
        ICache<K, V> iCache = factory.create(config, cacheType, this.cacheStoreTypeFactories);
        this.cacheTypeMap.put(cacheType, iCache);
        return iCache;
    }

    public NodeCacheStats stats(CommonStatsFlags flags) {
        TreeMap<CacheType, ImmutableCacheStatsHolder> statsMap = new TreeMap<CacheType, ImmutableCacheStatsHolder>();
        for (CacheType type : this.cacheTypeMap.keySet()) {
            statsMap.put(type, this.cacheTypeMap.get((Object)type).stats(flags.getLevels()));
        }
        return new NodeCacheStats(statsMap, flags);
    }
}

