/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.compositeindex.datacube.Dimension;

@ExperimentalApi
public class NumericDimension
implements Dimension {
    public static final String NUMERIC = "numeric";
    private final String field;

    public NumericDimension(String field) {
        this.field = field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.field);
        builder.field("type", NUMERIC);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericDimension dimension = (NumericDimension)o;
        return Objects.equals(this.field, dimension.getField());
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }
}

