/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.builder.BaseStarTreeBuilder;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.SequentialDocValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class OnHeapStarTreeBuilder
extends BaseStarTreeBuilder {
    private final List<StarTreeDocument> starTreeDocuments = new ArrayList<StarTreeDocument>();

    public OnHeapStarTreeBuilder(IndexOutput metaOut, IndexOutput dataOut, StarTreeField starTreeField, SegmentWriteState segmentWriteState, MapperService mapperService) throws IOException {
        super(metaOut, dataOut, starTreeField, segmentWriteState, mapperService);
    }

    @Override
    public void appendStarTreeDocument(StarTreeDocument starTreeDocument) {
        this.starTreeDocuments.add(starTreeDocument);
    }

    @Override
    public StarTreeDocument getStarTreeDocument(int docId) {
        return this.starTreeDocuments.get(docId);
    }

    @Override
    public List<StarTreeDocument> getStarTreeDocuments() {
        return this.starTreeDocuments;
    }

    @Override
    public Long getDimensionValue(int docId, int dimensionId) {
        return this.starTreeDocuments.get((int)docId).dimensions[dimensionId];
    }

    @Override
    public Iterator<StarTreeDocument> sortAndAggregateSegmentDocuments(SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        StarTreeDocument[] starTreeDocuments = new StarTreeDocument[this.totalSegmentDocs];
        for (int currentDocId = 0; currentDocId < this.totalSegmentDocs; ++currentDocId) {
            starTreeDocuments[currentDocId] = this.getSegmentStarTreeDocument(currentDocId, dimensionReaders, metricReaders);
        }
        return this.sortAndAggregateStarTreeDocuments(starTreeDocuments, false);
    }

    @Override
    public void build(List<StarTreeValues> starTreeValuesSubs, AtomicInteger fieldNumberAcrossStarTrees, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        this.build(this.mergeStarTrees(starTreeValuesSubs), fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
    }

    @Override
    Iterator<StarTreeDocument> mergeStarTrees(List<StarTreeValues> starTreeValuesSubs) throws IOException {
        return this.sortAndAggregateStarTreeDocuments(this.getSegmentsStarTreeDocuments(starTreeValuesSubs), true);
    }

    StarTreeDocument[] getSegmentsStarTreeDocuments(List<StarTreeValues> starTreeValuesSubs) throws IOException {
        ArrayList<StarTreeDocument> starTreeDocuments = new ArrayList<StarTreeDocument>();
        for (StarTreeValues starTreeValues : starTreeValuesSubs) {
            List<Dimension> dimensionsSplitOrder = starTreeValues.getStarTreeField().getDimensionsOrder();
            SequentialDocValuesIterator[] dimensionReaders = new SequentialDocValuesIterator[dimensionsSplitOrder.size()];
            for (int i = 0; i < dimensionsSplitOrder.size(); ++i) {
                String dimension = dimensionsSplitOrder.get(i).getField();
                dimensionReaders[i] = new SequentialDocValuesIterator(starTreeValues.getDimensionDocIdSetIterator(dimension));
            }
            ArrayList<SequentialDocValuesIterator> metricReaders = new ArrayList<SequentialDocValuesIterator>();
            for (Metric metric : starTreeValues.getStarTreeField().getMetrics()) {
                for (MetricStat metricStat : metric.getBaseMetrics()) {
                    String metricFullName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTreeValues.getStarTreeField().getName(), metric.getField(), metricStat.getTypeName());
                    metricReaders.add(new SequentialDocValuesIterator(starTreeValues.getMetricDocIdSetIterator(metricFullName)));
                }
            }
            int numSegmentDocs = Integer.parseInt(starTreeValues.getAttributes().getOrDefault("segmentDocsCount", String.valueOf(Integer.MAX_VALUE)));
            for (int currentDocId = 0; currentDocId < numSegmentDocs; ++currentDocId) {
                starTreeDocuments.add(this.getStarTreeDocument(currentDocId, dimensionReaders, metricReaders));
            }
        }
        StarTreeDocument[] starTreeDocumentsArr = new StarTreeDocument[starTreeDocuments.size()];
        return starTreeDocuments.toArray(starTreeDocumentsArr);
    }

    Iterator<StarTreeDocument> sortAndAggregateStarTreeDocuments(StarTreeDocument[] starTreeDocuments, boolean isMerge) {
        this.sortStarTreeDocumentsFromDimensionId(starTreeDocuments, 0);
        return this.mergeStarTreeDocuments(starTreeDocuments, isMerge);
    }

    private Iterator<StarTreeDocument> mergeStarTreeDocuments(final StarTreeDocument[] starTreeDocuments, final boolean isMerge) {
        return new Iterator<StarTreeDocument>(){
            boolean hasNext = true;
            StarTreeDocument currentStarTreeDocument = starTreeDocuments[0];
            int docId = 1;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StarTreeDocument next() {
                StarTreeDocument next = OnHeapStarTreeBuilder.this.reduceSegmentStarTreeDocuments(null, this.currentStarTreeDocument, isMerge);
                while (this.docId < starTreeDocuments.length) {
                    StarTreeDocument starTreeDocument = starTreeDocuments[this.docId];
                    ++this.docId;
                    if (!Arrays.equals((Object[])starTreeDocument.dimensions, (Object[])next.dimensions)) {
                        this.currentStarTreeDocument = starTreeDocument;
                        return next;
                    }
                    next = OnHeapStarTreeBuilder.this.reduceSegmentStarTreeDocuments(next, starTreeDocument, isMerge);
                }
                this.hasNext = false;
                return next;
            }
        };
    }

    @Override
    public Iterator<StarTreeDocument> generateStarTreeDocumentsForStarNode(int startDocId, int endDocId, final int dimensionId) {
        final int numDocs = endDocId - startDocId;
        final StarTreeDocument[] starTreeDocuments = new StarTreeDocument[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            starTreeDocuments[i] = this.getStarTreeDocument(startDocId + i);
        }
        this.sortStarTreeDocumentsFromDimensionId(starTreeDocuments, dimensionId + 1);
        return new Iterator<StarTreeDocument>(){
            boolean hasNext = true;
            StarTreeDocument currentStarTreeDocument = starTreeDocuments[0];
            int docId = 1;

            private boolean hasSameDimensions(StarTreeDocument starTreeDocument1, StarTreeDocument starTreeDocument2) {
                for (int i = dimensionId + 1; i < OnHeapStarTreeBuilder.this.numDimensions; ++i) {
                    if (Objects.equals(starTreeDocument1.dimensions[i], starTreeDocument2.dimensions[i])) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StarTreeDocument next() {
                StarTreeDocument next = OnHeapStarTreeBuilder.this.reduceStarTreeDocuments(null, this.currentStarTreeDocument);
                next.dimensions[dimensionId] = BaseStarTreeBuilder.STAR_IN_DOC_VALUES_INDEX;
                while (this.docId < numDocs) {
                    StarTreeDocument starTreeDocument = starTreeDocuments[this.docId];
                    ++this.docId;
                    if (!this.hasSameDimensions(starTreeDocument, this.currentStarTreeDocument)) {
                        this.currentStarTreeDocument = starTreeDocument;
                        return next;
                    }
                    next = OnHeapStarTreeBuilder.this.reduceStarTreeDocuments(next, starTreeDocument);
                }
                this.hasNext = false;
                return next;
            }
        };
    }

    private void sortStarTreeDocumentsFromDimensionId(StarTreeDocument[] starTreeDocuments, int dimensionId) {
        Arrays.sort(starTreeDocuments, (o1, o2) -> {
            for (int i = dimensionId; i < this.numDimensions; ++i) {
                if (Objects.equals(o1.dimensions[i], o2.dimensions[i])) continue;
                if (o1.dimensions[i] == null && o2.dimensions[i] == null) {
                    return 0;
                }
                if (o1.dimensions[i] == null) {
                    return 1;
                }
                if (o2.dimensions[i] == null) {
                    return -1;
                }
                return Long.compare(o1.dimensions[i], o2.dimensions[i]);
            }
            return 0;
        });
    }
}

