/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.utils;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.common.util.ByteArrayBackedBitset;

public class StarTreeDocumentBitSetUtil {
    public static int writeBitSet(Object[] array, IndexOutput output) throws IOException {
        ByteArrayBackedBitset bitset = new ByteArrayBackedBitset(StarTreeDocumentBitSetUtil.getLength(array));
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            bitset.set(i);
        }
        return bitset.write(output);
    }

    public static int readBitSet(RandomAccessInput input, long offset, Object[] array, Function<Integer, Object> identityValueSupplier) throws IOException {
        ByteArrayBackedBitset bitset = new ByteArrayBackedBitset(input, offset, StarTreeDocumentBitSetUtil.getLength(array));
        for (int i = 0; i < array.length; ++i) {
            if (!bitset.get(i)) continue;
            array[i] = identityValueSupplier.apply(i);
        }
        return bitset.getCurrBytesRead();
    }

    private static int getLength(Object[] array) {
        return array.length / 8 + (array.length % 8 == 0 ? 0 : 1);
    }
}

