/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.Version;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.Client;
import org.opensearch.common.SetOnce;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.mapper.ConstantFieldType;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.indices.TermsLookup;

public class TermsQueryBuilder
extends AbstractQueryBuilder<TermsQueryBuilder>
implements WithFieldName {
    public static final String NAME = "terms";
    private final String fieldName;
    private final List<?> values;
    private final TermsLookup termsLookup;
    private final Supplier<List<?>> supplier;
    private static final ParseField VALUE_TYPE_FIELD = new ParseField("value_type", new String[0]);
    private ValueType valueType = ValueType.DEFAULT;
    private static final Set<Class<? extends Number>> INTEGER_TYPES = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class));
    private static final Set<Class<?>> STRING_TYPES = new HashSet<Class>(Arrays.asList(BytesRef.class, String.class));

    public TermsQueryBuilder valueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public TermsQueryBuilder(String fieldName, TermsLookup termsLookup) {
        this(fieldName, null, termsLookup);
    }

    TermsQueryBuilder(String fieldName, List<Object> values, TermsLookup termsLookup) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null && termsLookup == null) {
            throw new IllegalArgumentException("No value or termsLookup specified for terms query");
        }
        if (values != null && termsLookup != null) {
            throw new IllegalArgumentException("Both values and termsLookup specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = values == null ? null : TermsQueryBuilder.convert(values);
        this.termsLookup = termsLookup;
        this.supplier = null;
    }

    public TermsQueryBuilder(String fieldName, String ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : null);
    }

    public TermsQueryBuilder(String fieldName, int ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, long ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, float ... values) {
        this(fieldName, values != null ? (Iterable)IntStream.range(0, values.length).mapToObj(i -> Float.valueOf(values[i])).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, double ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Object ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Iterable<?> values) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No value specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = TermsQueryBuilder.convert(values);
        this.termsLookup = null;
        this.supplier = null;
    }

    private TermsQueryBuilder(String fieldName, Iterable<?> values, ValueType valueType) {
        this(fieldName, values);
        this.valueType = valueType;
    }

    private TermsQueryBuilder(String fieldName, Supplier<List<?>> supplier) {
        this.fieldName = fieldName;
        this.values = null;
        this.termsLookup = null;
        this.supplier = supplier;
    }

    private TermsQueryBuilder(String fieldName, Supplier<List<?>> supplier, ValueType valueType) {
        this(fieldName, supplier);
        this.valueType = valueType;
    }

    public TermsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.termsLookup = (TermsLookup)in.readOptionalWriteable(TermsLookup::new);
        this.values = (List)in.readGenericValue();
        this.supplier = null;
        if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.valueType = (ValueType)in.readEnum(ValueType.class);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.supplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        out.writeOptionalWriteable((Writeable)this.termsLookup);
        out.writeGenericValue(this.values);
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeEnum((Enum)this.valueType);
        }
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public List<Object> values() {
        return TermsQueryBuilder.convertBack(this.values);
    }

    public TermsLookup termsLookup() {
        return this.termsLookup;
    }

    private static List<?> convert(Iterable<?> values) {
        ArrayList list;
        if (values instanceof List) {
            list = (ArrayList)values;
        } else {
            ArrayList arrayList = new ArrayList();
            for (Object o : values) {
                arrayList.add(o);
            }
            list = arrayList;
        }
        return TermsQueryBuilder.convert(list);
    }

    static List<?> convert(List<?> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        boolean allNumbers = list.stream().allMatch(o -> o != null && INTEGER_TYPES.contains(o.getClass()));
        if (allNumbers) {
            final long[] elements = list.stream().mapToLong(o -> ((Number)o).longValue()).toArray();
            return new AbstractList<Object>(){

                @Override
                public Object get(int index) {
                    return elements[index];
                }

                @Override
                public int size() {
                    return elements.length;
                }
            };
        }
        boolean allStrings = list.stream().allMatch(o -> o != null && STRING_TYPES.contains(o.getClass()));
        if (allStrings) {
            BytesRefBuilder builder = new BytesRefBuilder();
            try (BytesStreamOutput bytesOut = new BytesStreamOutput();){
                final int[] endOffsets = new int[list.size()];
                int i = 0;
                for (Object o2 : list) {
                    BytesRef b;
                    if (o2 instanceof BytesRef) {
                        b = (BytesRef)o2;
                    } else if (o2 instanceof CharBuffer) {
                        b = new BytesRef((CharSequence)((CharBuffer)o2));
                    } else {
                        builder.copyChars((CharSequence)o2.toString());
                        b = builder.get();
                    }
                    bytesOut.writeBytes(b.bytes, b.offset, b.length);
                    if (i == 0) {
                        endOffsets[0] = b.length;
                    } else {
                        endOffsets[i] = Math.addExact(endOffsets[i - 1], b.length);
                    }
                    ++i;
                }
                final BytesReference bytes = bytesOut.bytes();
                AbstractList<Object> abstractList = new AbstractList<Object>(){

                    @Override
                    public Object get(int i) {
                        int startOffset = i == 0 ? 0 : endOffsets[i - 1];
                        int endOffset = endOffsets[i];
                        return bytes.slice(startOffset, endOffset - startOffset).toBytesRef();
                    }

                    @Override
                    public int size() {
                        return endOffsets.length;
                    }
                };
                return abstractList;
            }
        }
        return list.stream().map(o -> o instanceof String ? new BytesRef((CharSequence)o.toString()) : o).collect(Collectors.toList());
    }

    static List<Object> convertBack(final List<?> list) {
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public Object get(int index) {
                Object o = list.get(index);
                if (o instanceof BytesRef) {
                    o = ((BytesRef)o).utf8ToString();
                }
                return o;
            }
        };
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.termsLookup != null) {
            builder.startObject(this.fieldName);
            this.termsLookup.toXContent(builder, params);
            builder.endObject();
        } else {
            builder.field(this.fieldName, TermsQueryBuilder.convertBack(this.values));
        }
        this.printBoostAndQueryName(builder);
        if (this.valueType != ValueType.DEFAULT) {
            builder.field(VALUE_TYPE_FIELD.getPreferredName(), this.valueType.type);
        }
        builder.endObject();
    }

    public static TermsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        List<Object> values = null;
        TermsLookup termsLookup = null;
        String queryName = null;
        float boost = 1.0f;
        String valueTypeStr = ValueType.DEFAULT.type;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support multiple fields", new Object[0]);
                }
                fieldName = currentFieldName;
                values = TermsQueryBuilder.parseValues(parser);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support more than one field. Already got: [" + fieldName + "] but also found [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = currentFieldName;
                termsLookup = TermsLookup.parseTermsLookup(parser);
                continue;
            }
            if (token.isValue()) {
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (VALUE_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    valueTypeStr = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[terms] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldName == null) {
            throw new ParsingException(parser.getTokenLocation(), "[terms] query requires a field name, followed by array of terms or a document lookup specification", new Object[0]);
        }
        ValueType valueType = ValueType.fromString(valueTypeStr);
        if (valueType == ValueType.BITMAP) {
            if (values != null && values.size() == 1 && values.get(0) instanceof BytesRef) {
                values.set(0, new BytesArray(Base64.getDecoder().decode(((BytesRef)values.get(0)).utf8ToString())));
            } else if (termsLookup == null) {
                throw new IllegalArgumentException("Invalid value for bitmap type: Expected a single-element array with a base64 encoded serialized bitmap.");
            }
        }
        return ((TermsQueryBuilder)((TermsQueryBuilder)new TermsQueryBuilder(fieldName, values, termsLookup).boost(boost)).queryName(queryName)).valueType(valueType);
    }

    static List<Object> parseValues(XContentParser parser) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            Object value = TermsQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
            if (value == null) {
                throw new ParsingException(parser.getTokenLocation(), "No value specified for terms query", new Object[0]);
            }
            values.add(value);
        }
        return values;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.termsLookup != null || this.supplier != null || this.values == null || this.values.isEmpty()) {
            throw new UnsupportedOperationException("query must be rewritten first");
        }
        int maxTermsCount = context.getIndexSettings().getMaxTermsCount();
        if (this.values.size() > maxTermsCount) {
            throw new IllegalArgumentException("The number of terms [" + this.values.size() + "] used in the Terms Query request has exceeded the allowed maximum of [" + maxTermsCount + "]. This maximum can be set by changing the [" + IndexSettings.MAX_TERMS_COUNT_SETTING.getKey() + "] index level setting.");
        }
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            throw new IllegalStateException("Rewrite first");
        }
        if (this.valueType == ValueType.BITMAP && this.values.size() == 1 && this.values.get(0) instanceof BytesArray && fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return ((NumberFieldMapper.NumberFieldType)fieldType).bitmapQuery((BytesArray)this.values.get(0));
        }
        return fieldType.termsQuery(this.values, context);
    }

    private void fetch(TermsLookup termsLookup, Client client, ActionListener<List<Object>> actionListener) {
        GetRequest getRequest = new GetRequest(termsLookup.index(), termsLookup.id());
        getRequest.preference("_local").routing(termsLookup.routing());
        if (termsLookup.store()) {
            getRequest.storedFields(termsLookup.path());
        }
        client.get(getRequest, (ActionListener<GetResponse>)ActionListener.delegateFailure(actionListener, (delegatedListener, getResponse) -> {
            ArrayList<Object> terms = new ArrayList<Object>();
            if (termsLookup.store()) {
                List<Object> values = getResponse.getField(termsLookup.path()).getValues();
                if (values.size() != 1 && this.valueType == ValueType.BITMAP) {
                    throw new IllegalArgumentException("Invalid value for bitmap type: Expected a single base64 encoded serialized bitmap.");
                }
                terms.addAll(values);
            } else if (!getResponse.isSourceEmpty()) {
                List<Object> extractedValues = XContentMapValues.extractRawValues(termsLookup.path(), getResponse.getSourceAsMap());
                terms.addAll(extractedValues);
            }
            delegatedListener.onResponse(terms);
        }));
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.values, this.termsLookup, this.supplier, this.valueType});
    }

    @Override
    protected boolean doEquals(TermsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.values, other.values) && Objects.equals(this.termsLookup, other.termsLookup) && Objects.equals(this.supplier, other.supplier) && Objects.equals((Object)this.valueType, (Object)other.valueType);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (this.supplier != null) {
            return this.supplier.get() == null ? this : new TermsQueryBuilder(this.fieldName, (Iterable)this.supplier.get(), this.valueType);
        }
        if (this.termsLookup != null) {
            SetOnce supplier = new SetOnce();
            queryRewriteContext.registerAsyncAction((client, listener) -> this.fetch(this.termsLookup, (Client)client, (ActionListener<List<Object>>)ActionListener.map((ActionListener)listener, list -> {
                supplier.set(list);
                return null;
            })));
            return new TermsQueryBuilder(this.fieldName, () -> ((SetOnce)supplier).get(), this.valueType);
        }
        if (this.values == null || this.values.isEmpty()) {
            return new MatchNoneQueryBuilder();
        }
        QueryShardContext context = queryRewriteContext.convertToShardContext();
        if (context != null) {
            MappedFieldType fieldType = context.fieldMapper(this.fieldName);
            if (fieldType == null) {
                return new MatchNoneQueryBuilder();
            }
            if (fieldType instanceof ConstantFieldType) {
                Query query = fieldType.termsQuery(this.values, context);
                if (query instanceof MatchAllDocsQuery) {
                    return new MatchAllQueryBuilder();
                }
                if (query instanceof MatchNoDocsQuery) {
                    return new MatchNoneQueryBuilder();
                }
                assert (false) : "Constant fields must produce match-all or match-none queries, got " + query;
            }
        }
        return this;
    }

    public static enum ValueType {
        DEFAULT("default"),
        BITMAP("bitmap");

        private final String type;

        private ValueType(String type) {
            this.type = type;
        }

        static ValueType fromString(String type) {
            for (ValueType valueType : ValueType.values()) {
                if (!valueType.type.equalsIgnoreCase(type)) continue;
                return valueType;
            }
            throw new IllegalArgumentException(type + " is not valid " + VALUE_TYPE_FIELD);
        }
    }
}

