/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.search.SearchService;
import org.opensearch.tasks.CancellableTask;

public class QueryGroupTask
extends CancellableTask {
    private static final Logger logger = LogManager.getLogger(QueryGroupTask.class);
    public static final String QUERY_GROUP_ID_HEADER = "queryGroupId";
    public static final Supplier<String> DEFAULT_QUERY_GROUP_ID_SUPPLIER = () -> "DEFAULT_QUERY_GROUP";
    private String queryGroupId;

    public QueryGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, description, parentTaskId, headers, SearchService.NO_TIMEOUT);
    }

    public QueryGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        super(id, type, action, description, parentTaskId, headers, cancelAfterTimeInterval);
    }

    public final String getQueryGroupId() {
        if (this.queryGroupId == null) {
            logger.warn("QueryGroup _id can't be null, It should be set before accessing it. This is abnormal behaviour ");
        }
        return this.queryGroupId;
    }

    public final void setQueryGroupId(ThreadContext threadContext) {
        this.queryGroupId = Optional.ofNullable(threadContext).map(threadContext1 -> threadContext1.getHeader(QUERY_GROUP_ID_HEADER)).orElse(DEFAULT_QUERY_GROUP_ID_SUPPLIER.get());
    }

    @Override
    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }
}

